/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.identity.authzcache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.custos.core.identity.authzcache.AuthzCacheEntry;
import org.apache.custos.core.identity.authzcache.AuthzCacheIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AuthzCache
extends LinkedHashMap<AuthzCacheIndex, AuthzCacheEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthzCache.class);
    private final int MAX_SIZE;

    public AuthzCache(@Value(value="${custos.identity.auth.cache.size:1024}") int initialCapacity) {
        super(initialCapacity);
        this.MAX_SIZE = initialCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<AuthzCacheIndex, AuthzCacheEntry> eldest) {
        if (this.size() > this.MAX_SIZE) {
            LOGGER.info("Authz cache max size exceeded. Removing the old entries.");
        }
        return this.size() > this.MAX_SIZE;
    }
}

