/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.model.user;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Set;
import org.apache.custos.core.model.user.GroupAttribute;
import org.apache.custos.core.model.user.GroupRole;
import org.apache.custos.core.model.user.GroupToGroupMembership;
import org.apache.custos.core.model.user.UserGroupMembership;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="group_entity")
@EntityListeners(value={AuditingEntityListener.class})
public class Group {
    @Id
    private String id;
    @Column(nullable=false)
    private Long tenantId;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @CreatedDate
    private Date createdAt;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @LastModifiedDate
    private Date lastModifiedAt;
    @Column
    private String parentId;
    @Column
    private String externalId;
    @Column
    private String description;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="group", orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<GroupRole> groupRole;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="group", orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<GroupAttribute> groupAttribute;
    @OneToMany(mappedBy="group", cascade={CascadeType.ALL})
    Set<UserGroupMembership> userGroupMemberships;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    Set<GroupToGroupMembership> parentGroups;
    @OneToMany(mappedBy="child", cascade={CascadeType.ALL})
    Set<GroupToGroupMembership> childGroups;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Set<UserGroupMembership> getUserGroupMemberships() {
        return this.userGroupMemberships;
    }

    public void setUserGroupMemberships(Set<UserGroupMembership> userGroupMemberships) {
        this.userGroupMemberships = userGroupMemberships;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public void setLastModifiedAt(Date lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Set<GroupRole> getGroupRole() {
        return this.groupRole;
    }

    public void setGroupRole(Set<GroupRole> groupRole) {
        this.groupRole = groupRole;
    }

    public Set<GroupAttribute> getGroupAttribute() {
        return this.groupAttribute;
    }

    public void setGroupAttribute(Set<GroupAttribute> groupAttribute) {
        this.groupAttribute = groupAttribute;
    }

    public Set<GroupToGroupMembership> getParentGroups() {
        return this.parentGroups;
    }

    public void setParentGroups(Set<GroupToGroupMembership> parentGroups) {
        this.parentGroups = parentGroups;
    }

    public Set<GroupToGroupMembership> getChildGroups() {
        return this.childGroups;
    }

    public void setChildGroups(Set<GroupToGroupMembership> childGroups) {
        this.childGroups = childGroups;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

