---
title: "Policies"
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Policies

This page contains a list of major policies agreed upon by the Apache Beam community.

## Releases

Apache Beam makes minor releases every 6 weeks, therefore 8 releases in a 12 month period. Apache Beam has a [calendar](https://calendar.google.com/calendar/embed?src=0p73sl034k80oob7seouanigd0%40group.calendar.google.com) for cutting the next release branch. After a release branch is cut, the community works quickly to finalize that release.  We encourage you to update early and often; do not wait until the deprecation date of the version you are using.

It is up to the Apache Beam community to decide whether an identified issue is a major issue that warrants a patch release. Some examples of major issues are high severity security issues and high risk data integrity issues.


If you wish to report a security vulnerability, please contact [security@apache.org](mailto:security@apache.org). Apache Beam follows the typical [Apache vulnerability handling process](https://apache.org/security/committers.html#vulnerability-handling).
