/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.state.AttributeDisplayEventType;
import org.apache.cayenne.modeler.util.state.DataMapDisplayEventType;
import org.apache.cayenne.modeler.util.state.DataNodeDisplayEventType;
import org.apache.cayenne.modeler.util.state.DisplayEventType;
import org.apache.cayenne.modeler.util.state.DomainDisplayEventType;
import org.apache.cayenne.modeler.util.state.EmbeddableAttributeDisplayEventType;
import org.apache.cayenne.modeler.util.state.EmbeddableDisplayEventType;
import org.apache.cayenne.modeler.util.state.EntityDisplayEventType;
import org.apache.cayenne.modeler.util.state.MultipleObjectsDisplayEventType;
import org.apache.cayenne.modeler.util.state.ProcedureDisplayEventType;
import org.apache.cayenne.modeler.util.state.ProcedureParameterDisplayEventType;
import org.apache.cayenne.modeler.util.state.QueryDisplayEventType;
import org.apache.cayenne.modeler.util.state.RelationshipDisplayEventType;

public enum DisplayEventTypes {
    DomainDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new DomainDisplayEventType(controller);
        }

        public String toString() {
            return DomainDisplayEvent.class.getSimpleName();
        }
    }
    ,
    DataNodeDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new DataNodeDisplayEventType(controller);
        }

        public String toString() {
            return DataNodeDisplayEvent.class.getSimpleName();
        }
    }
    ,
    DataMapDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new DataMapDisplayEventType(controller);
        }

        public String toString() {
            return DataMapDisplayEvent.class.getSimpleName();
        }
    }
    ,
    EntityDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            if (controller.getCurrentObjAttributes().length != 0 || controller.getCurrentDbAttributes().length != 0) {
                return new AttributeDisplayEventType(controller);
            }
            if (controller.getCurrentObjRelationships().length != 0 || controller.getCurrentDbRelationships().length != 0) {
                return new RelationshipDisplayEventType(controller);
            }
            return new EntityDisplayEventType(controller);
        }

        public String toString() {
            return EntityDisplayEvent.class.getSimpleName();
        }
    }
    ,
    AttributeDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new AttributeDisplayEventType(controller);
        }

        public String toString() {
            return AttributeDisplayEvent.class.getSimpleName();
        }
    }
    ,
    RelationshipDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new RelationshipDisplayEventType(controller);
        }

        public String toString() {
            return RelationshipDisplayEvent.class.getSimpleName();
        }
    }
    ,
    EmbeddableDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            if (controller.getCurrentEmbAttributes().length != 0) {
                return new EmbeddableAttributeDisplayEventType(controller);
            }
            return new EmbeddableDisplayEventType(controller);
        }

        public String toString() {
            return EmbeddableDisplayEvent.class.getSimpleName();
        }
    }
    ,
    EmbeddableAttributeDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new EmbeddableAttributeDisplayEventType(controller);
        }

        public String toString() {
            return EmbeddableAttributeDisplayEvent.class.getSimpleName();
        }
    }
    ,
    ProcedureDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            if (controller.getCurrentProcedureParameters().length != 0) {
                return new ProcedureParameterDisplayEventType(controller);
            }
            return new ProcedureDisplayEventType(controller);
        }

        public String toString() {
            return ProcedureDisplayEvent.class.getSimpleName();
        }
    }
    ,
    ProcedureParameterDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new ProcedureParameterDisplayEventType(controller);
        }

        public String toString() {
            return ProcedureParameterDisplayEvent.class.getSimpleName();
        }
    }
    ,
    QueryDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new QueryDisplayEventType(controller);
        }

        public String toString() {
            return QueryDisplayEvent.class.getSimpleName();
        }
    }
    ,
    MultipleObjectsDisplayEvent{

        @Override
        DisplayEventType createDisplayEventType(ProjectController controller) {
            return new MultipleObjectsDisplayEventType(controller);
        }

        public String toString() {
            return MultipleObjectsDisplayEvent.class.getSimpleName();
        }
    };


    abstract DisplayEventType createDisplayEventType(ProjectController var1);
}

