/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.time.Duration;
import java.util.regex.Pattern;
import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.language.bm.BeiderMorseEncoder;
import org.apache.commons.codec.language.bm.Lang;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.Rule;
import org.apache.commons.codec.language.bm.RuleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BeiderMorseEncoderTest
extends AbstractStringEncoderTest<StringEncoder> {
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private static final char[] TEST_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'o', 'u'};

    BeiderMorseEncoderTest() {
    }

    private void assertNotEmpty(BeiderMorseEncoder bmpm, String value) throws EncoderException {
        Assertions.assertNotEquals((Object)"", (Object)bmpm.encode(value), (String)value);
    }

    private BeiderMorseEncoder createGenericApproxEncoder() {
        BeiderMorseEncoder encoder = new BeiderMorseEncoder();
        encoder.setNameType(NameType.GENERIC);
        encoder.setRuleType(RuleType.APPROX);
        return encoder;
    }

    @Override
    protected StringEncoder createStringEncoder() {
        return new BeiderMorseEncoder();
    }

    @Test
    void testAllChars() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (char c = '\u0000'; c < '\uffff'; c = (char)(c + '\u0001')) {
            bmpm.encode(Character.toString(c));
        }
    }

    @Test
    void testAsciiEncodeNotEmpty1Letter() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            String value = Character.toString(c);
            String valueU = value.toUpperCase();
            this.assertNotEmpty(bmpm, value);
            this.assertNotEmpty(bmpm, valueU);
        }
    }

    @Test
    void testAsciiEncodeNotEmpty2Letters() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (char c1 = 'a'; c1 <= 'z'; c1 = (char)((char)(c1 + 1))) {
            for (char c2 = 'a'; c2 <= 'z'; c2 = (char)((char)(c2 + 1))) {
                String value = new String(new char[]{c1, c2});
                String valueU = value.toUpperCase();
                this.assertNotEmpty(bmpm, value);
                this.assertNotEmpty(bmpm, valueU);
            }
        }
    }

    @Test
    void testEncodeAtzNotEmpty() throws EncoderException {
        String[] names;
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        for (String name : names = new String[]{"\u00e1cz", "\u00e1tz", "Ign\u00e1cz", "Ign\u00e1tz", "Ign\u00e1c"}) {
            this.assertNotEmpty(bmpm, name);
        }
    }

    @Test
    void testEncodeGna() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        bmpm.encode("gna");
    }

    @Test
    void testInvalidLangIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Rule.getInstance((NameType)NameType.GENERIC, (RuleType)RuleType.APPROX, (String)"noSuchLanguage"));
    }

    @Test
    void testInvalidLangIllegalStateException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Lang.loadFromResource((String)"thisIsAMadeUpResourceName", (Languages)Languages.getInstance((NameType)NameType.GENERIC)));
    }

    @Test
    void testInvalidLanguageIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Languages.getInstance((String)"thereIsNoSuchLanguage"));
    }

    @Test
    void testLongestEnglishSurname() {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        Assertions.assertTimeout((Duration)Duration.ofMillis(10000L), () -> bmpm.encode("MacGhilleseatheanaich"));
    }

    @Test
    void testNegativeIndexForRuleMatchIndexOutOfBoundsException() {
        Rule r = new Rule("a", "", "", (Rule.PhonemeExpr)new Rule.Phoneme((CharSequence)"", Languages.ANY_LANGUAGE));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> r.patternAndContextMatches((CharSequence)"bob", -1));
    }

    @Test
    void testOOM() throws EncoderException {
        String phrase = "200697900'-->&#1913348150;</  bceaeef >aadaabcf\"aedfbff<!--'-->?>caecfaaa><?&#<!--</script>&lang&fc;aadeaf?>>&bdquo<    cc =\"abff\"    /></   afe  ><script><!-- f(';<    cf aefbeef = \"bfabadcf\" ebbfeedd = fccabeb >";
        BeiderMorseEncoder encoder = new BeiderMorseEncoder();
        encoder.setNameType(NameType.GENERIC);
        encoder.setRuleType(RuleType.EXACT);
        encoder.setMaxPhonemes(10);
        String phonemes = encoder.encode("200697900'-->&#1913348150;</  bceaeef >aadaabcf\"aedfbff<!--'-->?>caecfaaa><?&#<!--</script>&lang&fc;aadeaf?>>&bdquo<    cc =\"abff\"    /></   afe  ><script><!-- f(';<    cf aefbeef = \"bfabadcf\" ebbfeedd = fccabeb >");
        Assertions.assertFalse((boolean)phonemes.isEmpty());
        String[] phonemeArr = PIPE_PATTERN.split(phonemes);
        Assertions.assertTrue((phonemeArr.length <= 10 ? 1 : 0) != 0);
    }

    @Test
    void testSetConcat() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        bmpm.setConcat(false);
        Assertions.assertFalse((boolean)bmpm.isConcat(), (String)"Should be able to set concat to false");
    }

    @Test
    void testSetNameTypeAsh() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        bmpm.setNameType(NameType.ASHKENAZI);
        Assertions.assertEquals((Object)NameType.ASHKENAZI, (Object)bmpm.getNameType(), (String)"Name type should have been set to ash");
    }

    @Test
    void testSetRuleTypeExact() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        bmpm.setRuleType(RuleType.EXACT);
        Assertions.assertEquals((Object)RuleType.EXACT, (Object)bmpm.getRuleType(), (String)"Rule type should have been set to exact");
    }

    @Test
    void testSetRuleTypeToRulesIllegalArgumentException() {
        BeiderMorseEncoder bmpm = new BeiderMorseEncoder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> bmpm.setRuleType(RuleType.RULES));
    }

    @Test
    void testSpeedCheck() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(TEST_CHARS[0]);
        int i = 0;
        int j = 1;
        while (i < 40) {
            if (j == TEST_CHARS.length) {
                j = 0;
            }
            bmpm.encode(stringBuffer.toString());
            stringBuffer.append(TEST_CHARS[j]);
            ++i;
            ++j;
        }
    }

    @Test
    void testSpeedCheck2() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        String phrase = "ItstheendoftheworldasweknowitandIfeelfine";
        for (int i = 1; i <= "ItstheendoftheworldasweknowitandIfeelfine".length(); ++i) {
            bmpm.encode((Object)"ItstheendoftheworldasweknowitandIfeelfine".subSequence(0, i));
        }
    }

    @Test
    void testSpeedCheck3() throws EncoderException {
        BeiderMorseEncoder bmpm = this.createGenericApproxEncoder();
        String phrase = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
        for (int i = 1; i <= "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz".length(); ++i) {
            bmpm.encode((Object)"abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz".subSequence(0, i));
        }
    }
}

