/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.FilesUncheck;
import org.apache.commons.io.file.NoopPathVisitor;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FilesUncheckTest {
    private static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTES_ARRAY = new FileAttribute[0];
    private static final Path FILE_PATH_A = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]);
    private static final Path FILE_PATH_EMPTY = Paths.get("src/test/resources/org/apache/commons/io/test-file-empty.bin", new String[0]);
    private static final Path NEW_DIR_PATH = Paths.get("target/newdir", new String[0]);
    private static final Path NEW_FILE_PATH = Paths.get("target/file.txt", new String[0]);
    private static final Path NEW_FILE_PATH_LINK = Paths.get("target/to_another_file.txt", new String[0]);
    private static final String PREFIX = "prefix";
    private static final String SUFFIX = "suffix";
    private static final Path TARGET_PATH = Paths.get("target", new String[0]);

    FilesUncheckTest() {
    }

    @BeforeEach
    @AfterEach
    public void deleteFixtures() throws IOException {
        Files.deleteIfExists(NEW_FILE_PATH);
        Files.deleteIfExists(NEW_DIR_PATH);
        Files.deleteIfExists(NEW_FILE_PATH_LINK);
    }

    @Test
    void testCopyInputStreamPathCopyOptionArray() {
        Assertions.assertEquals((long)0L, (long)FilesUncheck.copy((InputStream)new NullInputStream(), (Path)NEW_FILE_PATH, (CopyOption[])PathUtils.EMPTY_COPY_OPTIONS));
    }

    @Test
    void testCopyPathOutputStream() {
        Assertions.assertEquals((long)0L, (long)FilesUncheck.copy((Path)FILE_PATH_EMPTY, (OutputStream)NullOutputStream.INSTANCE));
    }

    @Test
    void testCopyPathPathCopyOptionArray() {
        Assertions.assertEquals((Object)NEW_FILE_PATH, (Object)FilesUncheck.copy((Path)FILE_PATH_EMPTY, (Path)NEW_FILE_PATH, (CopyOption[])PathUtils.EMPTY_COPY_OPTIONS));
    }

    @Test
    void testCreateDirectories() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.createDirectories((Path)TARGET_PATH, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY));
    }

    @Test
    void testCreateDirectory() {
        Assertions.assertEquals((Object)NEW_DIR_PATH, (Object)FilesUncheck.createDirectory((Path)NEW_DIR_PATH, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY));
    }

    @Test
    void testCreateFile() {
        Assertions.assertEquals((Object)NEW_FILE_PATH, (Object)FilesUncheck.createFile((Path)NEW_FILE_PATH, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY));
    }

    @Test
    void testCreateLink() {
        Assertions.assertEquals((Object)NEW_FILE_PATH_LINK, (Object)FilesUncheck.createLink((Path)NEW_FILE_PATH_LINK, (Path)FILE_PATH_EMPTY));
    }

    @Test
    void testCreateSymbolicLink() {
        Assertions.assertEquals((Object)NEW_FILE_PATH_LINK, (Object)FilesUncheck.createSymbolicLink((Path)NEW_FILE_PATH_LINK, (Path)FILE_PATH_EMPTY, (FileAttribute[])new FileAttribute[0]));
    }

    @Test
    void testCreateTempDirectoryPathStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.createTempDirectory((Path)TARGET_PATH, (String)PREFIX, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    void testCreateTempDirectoryStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)PathUtils.getTempDirectory(), (Object)FilesUncheck.createTempDirectory((String)PREFIX, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    void testCreateTempFilePathStringStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.createTempFile((Path)TARGET_PATH, (String)PREFIX, (String)SUFFIX, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    void testCreateTempFileStringStringFileAttributeOfQArray() {
        Assertions.assertEquals((Object)PathUtils.getTempDirectory(), (Object)FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY).getParent());
    }

    @Test
    void testDelete() {
        Assertions.assertThrows(UncheckedIOException.class, () -> FilesUncheck.delete((Path)NEW_FILE_PATH));
    }

    @Test
    void testDeleteIfExists() {
        Assertions.assertFalse((boolean)FilesUncheck.deleteIfExists((Path)NEW_FILE_PATH));
    }

    @Test
    void testFind() {
        try (Stream find = FilesUncheck.find((Path)FILE_PATH_EMPTY, (int)0, (t, u) -> false, (FileVisitOption[])new FileVisitOption[0]);){
            Assertions.assertNotNull((Object)find);
        }
    }

    @Test
    void testGetAttribute() {
        Assertions.assertEquals((Object)0L, (Object)FilesUncheck.getAttribute((Path)FILE_PATH_EMPTY, (String)"basic:size", (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
    }

    @Test
    void testGetFileStore() {
        Assertions.assertNotNull((Object)FilesUncheck.getFileStore((Path)FILE_PATH_EMPTY));
    }

    @Test
    void testGetLastModifiedTime() {
        Assertions.assertTrue((0L < FilesUncheck.getLastModifiedTime((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}).toMillis() ? 1 : 0) != 0);
    }

    @Test
    void testGetOwner() {
        Assertions.assertNotNull((Object)FilesUncheck.getOwner((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
    }

    @Test
    void testGetPosixFilePermissions() {
        Assumptions.assumeTrue((boolean)PathUtils.isPosix((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
        Assertions.assertNotNull((Object)FilesUncheck.getPosixFilePermissions((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
    }

    @Test
    void testIsHidden() {
        Assertions.assertFalse((boolean)FilesUncheck.isHidden((Path)FILE_PATH_EMPTY));
    }

    @Test
    void testIsSameFile() {
        Assertions.assertTrue((boolean)FilesUncheck.isSameFile((Path)FILE_PATH_EMPTY, (Path)FILE_PATH_EMPTY));
    }

    @Test
    void testLinesPath() {
        try (Stream stream = FilesUncheck.lines((Path)FILE_PATH_EMPTY);){
            Assertions.assertEquals((long)0L, (long)stream.count());
        }
    }

    @Test
    void testLinesPathCharset() {
        try (Stream stream = FilesUncheck.lines((Path)FILE_PATH_EMPTY, (Charset)StandardCharsets.UTF_8);){
            Assertions.assertEquals((long)0L, (long)stream.count());
        }
    }

    @Test
    void testList() {
        try (Stream stream = FilesUncheck.list((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]));){
            Assertions.assertEquals((long)1L, (long)stream.count());
        }
    }

    @Test
    void testMove() {
        Path tempFile1 = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Path tempFile2 = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile2, (Object)FilesUncheck.move((Path)tempFile1, (Path)tempFile2, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}));
        FilesUncheck.delete((Path)tempFile2);
    }

    @Test
    void testNewBufferedReaderPath() {
        Uncheck.run(() -> {
            try (BufferedReader reader = FilesUncheck.newBufferedReader((Path)FILE_PATH_EMPTY);){
                IOUtils.consume((Reader)reader);
            }
        });
    }

    @Test
    void testNewBufferedReaderPathCharset() {
        Uncheck.run(() -> {
            try (BufferedReader reader = FilesUncheck.newBufferedReader((Path)FILE_PATH_EMPTY, (Charset)StandardCharsets.UTF_8);){
                IOUtils.consume((Reader)reader);
            }
        });
    }

    @Test
    void testNewBufferedWriterPathCharsetOpenOptionArray() {
        Path tempPath = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Uncheck.run(() -> {
            try (BufferedWriter writer = FilesUncheck.newBufferedWriter((Path)tempPath, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING});){
                writer.append("test");
            }
        });
        Assertions.assertEquals((Object)"test", FilesUncheck.readAllLines((Path)tempPath, (Charset)StandardCharsets.UTF_8).get(0));
    }

    @Test
    void testNewBufferedWriterPathOpenOptionArray() {
        Path tempPath = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Uncheck.run(() -> {
            try (BufferedWriter writer = FilesUncheck.newBufferedWriter((Path)tempPath, (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING});){
                writer.append("test");
            }
        });
        Assertions.assertEquals((Object)"test", FilesUncheck.readAllLines((Path)tempPath).get(0));
    }

    @Test
    void testNewByteChannelPathOpenOptionArray() {
        Assertions.assertEquals((long)0L, (long)Uncheck.getAsLong(() -> {
            try (SeekableByteChannel c = FilesUncheck.newByteChannel((Path)FILE_PATH_EMPTY, (OpenOption[])new OpenOption[]{StandardOpenOption.READ});){
                long l = c.size();
                return l;
            }
        }));
    }

    @Test
    void testNewByteChannelPathSetOfQextendsOpenOptionFileAttributeOfQArray() {
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        options.add(StandardOpenOption.READ);
        Assertions.assertEquals((long)0L, (long)Uncheck.getAsLong(() -> {
            try (SeekableByteChannel c = FilesUncheck.newByteChannel((Path)FILE_PATH_EMPTY, (Set)options, (FileAttribute[])EMPTY_FILE_ATTRIBUTES_ARRAY);){
                long l = c.size();
                return l;
            }
        }));
    }

    @Test
    void testNewDirectoryStreamPath() {
        Uncheck.run(() -> {
            try (DirectoryStream directoryStream = FilesUncheck.newDirectoryStream((Path)TARGET_PATH);){
                directoryStream.forEach(e -> Assertions.assertEquals((Object)TARGET_PATH, (Object)e.getParent()));
            }
        });
    }

    @Test
    void testNewDirectoryStreamPathFilterOfQsuperPath() {
        Uncheck.run(() -> {
            try (DirectoryStream directoryStream = FilesUncheck.newDirectoryStream((Path)TARGET_PATH, e -> true);){
                directoryStream.forEach(e -> Assertions.assertEquals((Object)TARGET_PATH, (Object)e.getParent()));
            }
        });
    }

    @Test
    void testNewDirectoryStreamPathString() {
        Uncheck.run(() -> {
            try (DirectoryStream directoryStream = FilesUncheck.newDirectoryStream((Path)TARGET_PATH, (String)"*.xml");){
                directoryStream.forEach(e -> Assertions.assertEquals((Object)TARGET_PATH, (Object)e.getParent()));
            }
        });
    }

    @Test
    void testNewInputStream() {
        Assertions.assertEquals((int)0, (int)Uncheck.getAsInt(() -> {
            try (InputStream in = FilesUncheck.newInputStream((Path)FILE_PATH_EMPTY, (OpenOption[])new OpenOption[]{StandardOpenOption.READ});){
                int n = in.available();
                return n;
            }
        }));
    }

    @Test
    void testNewOutputStream() {
        Path tempPath = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Uncheck.run(() -> {
            try (OutputStream stream = FilesUncheck.newOutputStream((Path)tempPath, (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING});){
                stream.write("test".getBytes());
            }
        });
        Assertions.assertEquals((Object)"test", FilesUncheck.readAllLines((Path)tempPath).get(0));
    }

    @Test
    void testProbeContentType() {
        String probeContentType = FilesUncheck.probeContentType((Path)FILE_PATH_EMPTY);
        probeContentType = FilesUncheck.probeContentType((Path)Paths.get("src/test/resources/org/apache/commons/io/testfileBOM.xml", new String[0]));
    }

    @Test
    void testReadAllBytes() {
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])FilesUncheck.readAllBytes((Path)FILE_PATH_EMPTY));
        Assertions.assertArrayEquals((byte[])new byte[]{97}, (byte[])FilesUncheck.readAllBytes((Path)FILE_PATH_A));
    }

    @Test
    void testReadAllLinesPath() {
        Assertions.assertEquals(Collections.emptyList(), (Object)FilesUncheck.readAllLines((Path)FILE_PATH_EMPTY));
        Assertions.assertEquals(Arrays.asList("a"), (Object)FilesUncheck.readAllLines((Path)FILE_PATH_A));
    }

    @Test
    void testReadAllLinesPathCharset() {
        Assertions.assertEquals(Collections.emptyList(), (Object)FilesUncheck.readAllLines((Path)FILE_PATH_EMPTY, (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals(Arrays.asList("a"), (Object)FilesUncheck.readAllLines((Path)FILE_PATH_A, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    void testReadAttributesPathClassOfALinkOptionArray() {
        Assertions.assertNotNull((Object)FilesUncheck.readAttributes((Path)FILE_PATH_EMPTY, BasicFileAttributes.class, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
    }

    @Test
    void testReadAttributesPathStringLinkOptionArray() {
        Assertions.assertNotNull((Object)FilesUncheck.readAttributes((Path)FILE_PATH_EMPTY, (String)"basic:lastModifiedTime", (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
    }

    @Test
    void testReadSymbolicLink() {
        Assertions.assertThrows(UncheckedIOException.class, () -> FilesUncheck.readSymbolicLink((Path)NEW_FILE_PATH_LINK));
    }

    @Test
    void testSetAttribute() {
        FileTime ft = FilesUncheck.getLastModifiedTime((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[0]);
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setAttribute((Path)FILE_PATH_EMPTY, (String)"basic:lastModifiedTime", (Object)ft, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
    }

    @Test
    void testSetLastModifiedTime() {
        FileTime ft = FilesUncheck.getLastModifiedTime((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[0]);
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setLastModifiedTime((Path)FILE_PATH_EMPTY, (FileTime)ft));
    }

    @Test
    void testSetOwner() {
        UserPrincipal owner = FilesUncheck.getOwner((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setOwner((Path)FILE_PATH_EMPTY, (UserPrincipal)owner));
    }

    @Test
    void testSetPosixFilePermissions() {
        Assumptions.assumeTrue((boolean)PathUtils.isPosix((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS}));
        Set posixFilePermissions = FilesUncheck.getPosixFilePermissions((Path)FILE_PATH_EMPTY, (LinkOption[])new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
        Assertions.assertEquals((Object)FILE_PATH_EMPTY, (Object)FilesUncheck.setPosixFilePermissions((Path)FILE_PATH_EMPTY, (Set)posixFilePermissions));
    }

    @Test
    void testSize() {
        Assertions.assertEquals((long)0L, (long)FilesUncheck.size((Path)FILE_PATH_EMPTY));
        Assertions.assertEquals((long)1L, (long)FilesUncheck.size((Path)FILE_PATH_A));
    }

    @Test
    void testWalkFileTreePathFileVisitorOfQsuperPath() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.walkFileTree((Path)TARGET_PATH, (FileVisitor)NoopPathVisitor.INSTANCE));
    }

    @Test
    void testWalkFileTreePathSetOfFileVisitOptionIntFileVisitorOfQsuperPath() {
        Assertions.assertEquals((Object)TARGET_PATH, (Object)FilesUncheck.walkFileTree((Path)TARGET_PATH, new HashSet(), (int)1, (FileVisitor)NoopPathVisitor.INSTANCE));
    }

    @Test
    void testWalkPathFileVisitOptionArray() {
        try (Stream stream = FilesUncheck.walk((Path)TARGET_PATH, (FileVisitOption[])new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS});){
            Assertions.assertTrue((0L < stream.count() ? 1 : 0) != 0);
        }
    }

    @Test
    void testWalkPathIntFileVisitOptionArray() {
        try (Stream stream = FilesUncheck.walk((Path)TARGET_PATH, (int)0, (FileVisitOption[])new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS});){
            Assertions.assertEquals((long)1L, (long)stream.count());
        }
    }

    @Test
    void testWritePathByteArrayOpenOptionArray() {
        Path tempFile = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile, (Object)FilesUncheck.write((Path)tempFile, (byte[])"test".getBytes(), (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING}));
        FilesUncheck.delete((Path)tempFile);
    }

    @Test
    void testWritePathIterableOfQextendsCharSequenceCharsetOpenOptionArray() {
        Path tempFile = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile, (Object)FilesUncheck.write((Path)tempFile, Arrays.asList("test"), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING}));
        FilesUncheck.delete((Path)tempFile);
    }

    @Test
    void testWritePathIterableOfQextendsCharSequenceOpenOptionArray() {
        Path tempFile = FilesUncheck.createTempFile((String)PREFIX, (String)SUFFIX, (FileAttribute[])new FileAttribute[0]);
        Assertions.assertEquals((Object)tempFile, (Object)FilesUncheck.write((Path)tempFile, Arrays.asList("test"), (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING}));
        FilesUncheck.delete((Path)tempFile);
    }
}

