/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MethodCall {
    private final String name;
    private final List<Object> params;
    private Object returned;

    public MethodCall(String name) {
        this(name, null);
    }

    public MethodCall(String name, List<Object> params) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null.");
        }
        this.name = name;
        this.params = params != null ? params : Collections.emptyList();
    }

    public MethodCall(String name, Object param) {
        this(name, Collections.singletonList(param));
    }

    public MethodCall(String name, Object param1, Object param2) {
        this(name, Arrays.asList(param1, param2));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodCall that = (MethodCall)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.params, that.params)) {
            return false;
        }
        return Objects.equals(this.returned, that.returned);
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public Object getReturned() {
        return this.returned;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 29 * result + (this.returned != null ? this.returned.hashCode() : 0);
        return result;
    }

    public MethodCall returned(Object obj) {
        this.setReturned(obj);
        return this;
    }

    public void setReturned(Object returned) {
        this.returned = returned;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MethodCall");
        sb.append("{name='").append(this.name).append('\'');
        if (!this.params.isEmpty()) {
            sb.append(", params=").append(this.params);
        }
        if (this.returned != null) {
            sb.append(", returned=").append(this.returned);
        }
        sb.append('}');
        return sb.toString();
    }
}

