/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.pool2.impl.CallStack;
import org.apache.commons.pool2.impl.CallStackUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCallStackUtils {
    private static final String MESSAGE_FORMAT = "'Timestamp:' yyyy-MM-dd HH:mm:ss Z";

    private void assertNewCallStack(CallStack callStack) {
        callStack.fillInStackTrace();
        StringWriter out = new StringWriter();
        callStack.printStackTrace(new PrintWriter(out));
        Assertions.assertFalse((boolean)out.toString().isEmpty());
        callStack.clear();
        out.getBuffer().setLength(0);
        callStack.printStackTrace(new PrintWriter(out));
        Assertions.assertTrue((boolean)out.toString().isEmpty());
    }

    @Test
    public void testNewCallStack2() {
        this.assertNewCallStack(CallStackUtils.newCallStack((String)MESSAGE_FORMAT, (boolean)false));
        this.assertNewCallStack(CallStackUtils.newCallStack((String)MESSAGE_FORMAT, (boolean)true));
    }

    @Test
    public void testNewCallStack3() {
        this.assertNewCallStack(CallStackUtils.newCallStack((String)MESSAGE_FORMAT, (boolean)false, (boolean)false));
        this.assertNewCallStack(CallStackUtils.newCallStack((String)MESSAGE_FORMAT, (boolean)false, (boolean)true));
    }
}

