/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.commons.weaver.model.WeaveEnvironment;

class LocalWeaveEnvironment
extends WeaveEnvironment {
    private final File target;

    protected LocalWeaveEnvironment(File target, ClassLoader classLoader, Properties config, Logger log) {
        super(classLoader, config, log);
        Validate.notNull((Object)target, (String)"target", (Object[])new Object[0]);
        this.target = target;
    }

    @Override
    public boolean deleteResource(String name) {
        return new File(this.target, name).delete();
    }

    @Override
    protected OutputStream getOutputStream(String resourceName) throws IOException {
        File file = new File(this.target, resourceName);
        File parent = file.getParentFile();
        if (parent.exists()) {
            Validate.validState((boolean)parent.isDirectory(), (String)"Cannot write %s to non-directory parent", (Object[])new Object[]{file});
        } else {
            Validate.validState((boolean)parent.mkdirs(), (String)"Unable to create output directory %s", (Object[])new Object[]{parent});
        }
        return new FileOutputStream(file);
    }
}

