/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.statistics.derived.latency;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.shadow.org.terracotta.statistics.derived.OperationResultSampler;
import org.ehcache.shadow.org.terracotta.statistics.derived.latency.LatencyAccumulator;
import org.ehcache.shadow.org.terracotta.statistics.derived.latency.LatencyStatistic;
import org.ehcache.shadow.org.terracotta.statistics.observer.ChainedOperationObserver;

public class Jsr107LatencyMonitor<T extends Enum<T>>
implements ChainedOperationObserver<T>,
LatencyStatistic {
    private final OperationResultSampler<T> sampling;
    private final AtomicReference<LatencyAccumulator> statistic = new AtomicReference<LatencyAccumulator>(LatencyAccumulator.empty());

    public Jsr107LatencyMonitor(Set<T> targets, double sampling) {
        this.sampling = new OperationResultSampler<T>(targets, sampling, (time, latency) -> this.statistic.get().accumulate(latency));
    }

    @Override
    public void begin(long time) {
        this.sampling.begin(time);
    }

    @Override
    public void end(long time, long latency, T result) {
        this.sampling.end(time, latency, result);
    }

    @Override
    public double average() {
        LatencyAccumulator accumulator = this.statistic.get();
        long count = accumulator.count();
        if (count == 0L) {
            return 0.0;
        }
        return (double)accumulator.total() / 1000.0 / (double)count;
    }

    @Override
    public Long minimum() {
        LatencyAccumulator accumulator = this.statistic.get();
        return accumulator.isEmpty() ? 0L : accumulator.minimum() / 1000L;
    }

    @Override
    public Long maximum() {
        LatencyAccumulator accumulator = this.statistic.get();
        return accumulator.isEmpty() ? 0L : accumulator.maximum() / 1000L;
    }

    public synchronized void clear() {
        this.statistic.set(LatencyAccumulator.empty());
    }
}

