/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;
import org.apache.derbyTesting.junit.Utilities;

public class AutomaticIndexStatisticsTest
extends BaseJDBCTestCase {
    protected static final String MASTERDB = "masterDb";
    private static final String BIG_TABLE = "BIG_TABLE";
    private static final long DEFAULT_TIMEOUT = 20000L;
    private static final String[] TYPES = new String[]{"TABLE", "VIEW"};
    private static boolean dbCreated;
    private static IndexStatsUtil stats;

    public AutomaticIndexStatisticsTest(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = new BaseTestSuite(AutomaticIndexStatisticsTest.class);
        test = new CleanDatabaseTestSetup((Test)test);
        test = TestConfiguration.additionalDatabaseDecorator((Test)test, MASTERDB);
        return new TimeZoneTestSetup((Test)test, "GMT");
    }

    public void setUp() throws SQLException {
        if (stats != null) {
            stats.release();
        }
        stats = new IndexStatsUtil(this.openDefaultConnection(), 20000L);
    }

    @Override
    public void tearDown() throws Exception {
        if (stats != null) {
            stats.release();
        }
        stats = null;
        super.tearDown();
    }

    public void testStatsCreatedOnGrowthThenDeleteDb() throws SQLException {
        String db = "singleUse/newCleanDb";
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", db);
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        Connection con = ds.getConnection();
        String TAB = "TEST_GROWTH_EMPTY";
        this.createAndInsertSimple(con, TAB, 300);
        PreparedStatement ps = con.prepareStatement("select * from " + TAB + " where id = ?");
        ps.close();
        IndexStatsUtil.IdxStats[] myStats = new IndexStatsUtil(ds.getConnection(), 20000L).getStatsTable(TAB, 1);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)myStats.length);
        AutomaticIndexStatisticsTest.assertTrue((myStats[0].rows == 300L ? 1 : 0) != 0);
        JDBCDataSource.shutdownDatabase(ds);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(db));
    }

    public void testStatsUpdatedOnGrowth() throws SQLException {
        String TAB = "TEST_GROWTH";
        this.createAndInsertSimple(TAB, 10000);
        this.prepareStatement("select * from " + TAB + " where id = ?");
        IndexStatsUtil.IdxStats[] statsPre = stats.getStatsTable(TAB, 1);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)statsPre.length);
        this.setAutoCommit(false);
        this.insertSimple(TAB, 50000, 10000);
        this.forceRowCountEstimateUpdate(TAB);
        this.prepareStatement("select * from " + TAB + " where 1=1");
        IndexStatsUtil.IdxStats[] statsPost = this.getFilteredTableStats(TAB, 1, statsPre);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)statsPost.length);
        AutomaticIndexStatisticsTest.assertFalse((boolean)statsPre[0].equals(statsPost[0]));
        AutomaticIndexStatisticsTest.assertFalse((boolean)statsPre[0].after(statsPost[0]));
        this.insertSimple(TAB, 1000, 60000);
        this.forceRowCountEstimateUpdate(TAB);
        this.prepareStatement("select * from " + TAB + " where 2=2");
        Utilities.sleep(1500L);
        IndexStatsUtil.IdxStats[] statsPost1 = stats.getStatsTable(TAB, 1);
        AutomaticIndexStatisticsTest.assertTrue((boolean)statsPost[0].equals(statsPost1[0]));
        AutomaticIndexStatisticsTest.assertFalse((boolean)statsPost1[0].after(statsPost[0]));
    }

    public void testShutdownWhileScanningThenDelete() throws IOException, SQLException {
        String db = "singleUse/copyShutdown";
        this.copyDb(db);
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", db);
        Connection con = ds.getConnection();
        String TAB = BIG_TABLE;
        PreparedStatement ps = con.prepareStatement("select * from " + TAB + " where id = ?");
        ps.close();
        Utilities.sleep(150L);
        JDBCDataSource.shutdownDatabase(ds);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(db));
    }

    public void testDropWhileScanningThenDelete() throws IOException, SQLException {
        String TAB1 = BIG_TABLE;
        String TAB2 = "SECONDARY_TABLE";
        String db = "singleUse/copyDrop";
        this.copyDb(db);
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", db);
        Connection con = ds.getConnection();
        this.createAndInsertSimple(con, TAB2, 20000);
        PreparedStatement ps = con.prepareStatement("select * from " + TAB1 + " where id = ?");
        ps.close();
        Utilities.sleep(150L);
        AutomaticIndexStatisticsTest.println("dropping table...");
        Statement stmt = con.createStatement();
        stmt.executeUpdate("drop table " + TAB1);
        stmt.close();
        IndexStatsUtil myStats = new IndexStatsUtil(ds.getConnection(), 20000L);
        myStats.assertNoStatsTable(TAB2);
        con.prepareStatement("select * from " + TAB2 + " where id = ?");
        myStats.assertTableStats(TAB2, 1);
        myStats.release();
        JDBCDataSource.shutdownDatabase(ds);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(db));
    }

    public void testCompressWhileScanning() throws IOException, SQLException {
        String TAB1 = BIG_TABLE;
        String TAB2 = "SECONDARY_TABLE";
        String db = "singleUse/copyCompress";
        this.copyDb(db);
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", db);
        Connection con = ds.getConnection();
        this.createAndInsertSimple(con, TAB2, 20000);
        PreparedStatement ps = con.prepareStatement("select * from " + TAB1 + " where id = ?");
        ps.close();
        Utilities.sleep(150L);
        AutomaticIndexStatisticsTest.println("compressing table...");
        Statement stmt = con.createStatement();
        stmt.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', '" + TAB1 + "', 0)");
        stmt.close();
        IndexStatsUtil myStats = new IndexStatsUtil(ds.getConnection(), 20000L);
        myStats.assertTableStats(TAB1, 1);
        myStats.assertNoStatsTable(TAB2);
        con.prepareStatement("select * from " + TAB2 + " where id = ?");
        myStats.assertTableStats(TAB2, 1);
        myStats.release();
        JDBCDataSource.shutdownDatabase(ds);
        AutomaticIndexStatisticsTest.assertDirectoryDeleted(this.constructDbPath(db));
    }

    public void testStatisticsCorrectness() throws SQLException {
        String TAB = "STAT_CORR";
        this.dropTable(TAB);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table " + TAB + " (id1 int, id2 int, id3 int, val int, primary key (id1, id2, id3))");
        stats.assertNoStatsTable(TAB);
        PreparedStatement ps = this.prepareStatement("insert into " + TAB + " values (?,?,?,?)");
        this.setAutoCommit(false);
        int rows = 50000;
        for (int i = 1; i <= 100; ++i) {
            ps.setInt(1, i);
            for (int j = 1; j <= 50; ++j) {
                ps.setInt(2, j);
                for (int k = 1; k <= 10; ++k) {
                    ps.setInt(3, k);
                    ps.setInt(4, i * j * k % 750);
                    ps.executeUpdate();
                }
            }
        }
        this.commit();
        this.setAutoCommit(true);
        this.forceRowCountEstimateUpdate(TAB);
        JDBC.assertDrainResults(this.prepareStatement("select * from " + TAB + " where id1 = 10").executeQuery());
        IndexStatsUtil.IdxStats[] statsObj = stats.getStatsTable(TAB, 3);
        AutomaticIndexStatisticsTest.assertEquals((int)3, (int)statsObj.length);
        Timestamp now = new Timestamp(new Date().getTime());
        block13: for (int i = 0; i < statsObj.length; ++i) {
            IndexStatsUtil.IdxStats s = statsObj[i];
            AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)s.rows);
            AutomaticIndexStatisticsTest.assertFalse((String)("expected stat created in past:now = " + now + ";s.created = " + s.created), (s.created.compareTo(now) > 0 ? 1 : 0) != 0);
            switch (s.lcols) {
                case 1: {
                    AutomaticIndexStatisticsTest.assertEquals((long)100L, (long)s.card);
                    continue block13;
                }
                case 2: {
                    AutomaticIndexStatisticsTest.assertEquals((long)5000L, (long)s.card);
                    continue block13;
                }
                case 3: {
                    AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)s.card);
                    continue block13;
                }
                default: {
                    AutomaticIndexStatisticsTest.fail((String)("unexpected number of leading columns: " + s.lcols));
                }
            }
        }
        stmt.executeUpdate("create index IDXREV on " + TAB + "(id3, id2, id1)");
        statsObj = stats.getStatsIndex("IDXREV", 3);
        AutomaticIndexStatisticsTest.assertEquals((int)3, (int)statsObj.length);
        Timestamp earlier = now;
        now = new Timestamp(new Date().getTime());
        block14: for (int i = 0; i < statsObj.length; ++i) {
            IndexStatsUtil.IdxStats s = statsObj[i];
            AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)s.rows);
            AutomaticIndexStatisticsTest.assertTrue((String)("current stats created " + s.created + ", previous stats created " + earlier), (boolean)s.created.after(earlier));
            AutomaticIndexStatisticsTest.assertFalse((String)("expected stat created in past:now = " + now + ";s.created = " + s.created), (s.created.compareTo(now) > 0 ? 1 : 0) != 0);
            switch (s.lcols) {
                case 1: {
                    AutomaticIndexStatisticsTest.assertEquals((long)10L, (long)s.card);
                    continue block14;
                }
                case 2: {
                    AutomaticIndexStatisticsTest.assertEquals((long)500L, (long)s.card);
                    continue block14;
                }
                case 3: {
                    AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)s.card);
                    continue block14;
                }
                default: {
                    AutomaticIndexStatisticsTest.fail((String)("unexpected number of leading columns: " + s.lcols));
                }
            }
        }
        stmt.executeUpdate("create index IDXVAL on " + TAB + "(val)");
        ResultSet rs = stmt.executeQuery("select val from " + TAB + " order by val");
        int uniqueVals = 0;
        int prev = -1;
        while (rs.next()) {
            int curr = rs.getInt(1);
            if (curr == prev) continue;
            ++uniqueVals;
            prev = curr;
        }
        rs.close();
        IndexStatsUtil.IdxStats[] valStat = stats.getStatsIndex("IDXVAL", 1);
        AutomaticIndexStatisticsTest.assertEquals((int)1, (int)valStat.length);
        AutomaticIndexStatisticsTest.assertEquals((long)uniqueVals, (long)valStat[0].card);
        AutomaticIndexStatisticsTest.assertEquals((long)50000L, (long)valStat[0].rows);
    }

    public void testSelectFromSimpleView() throws SQLException {
        String table = "VIEW_BASE_TABLE";
        String view = "MY_VIEW";
        AutomaticIndexStatisticsTest.dropIfExists(this.getConnection(), view);
        AutomaticIndexStatisticsTest.dropIfExists(this.getConnection(), table);
        Statement s = this.createStatement();
        s.execute("create table " + table + " (id int primary key, col1 int, col2 int)");
        s.execute("create index COL2_IDX on " + table + "(col2)");
        PreparedStatement ps = this.prepareStatement("insert into " + table + " values (?,?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 30000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i % 15);
            ps.setInt(3, i % 25);
            ps.executeUpdate();
            if (i % 5000 != 0) continue;
            this.commit();
        }
        this.commit();
        this.setAutoCommit(true);
        ps.close();
        s.execute("create view " + view + "(vcol_1, vcol2) AS select id, col2 from " + table);
        stats.assertNoStatsTable(table);
        this.prepareStatement("select * from " + view + " where vcol2 = 7");
        stats.assertNoStatsTable(table);
        this.prepareStatement("select * from " + table + " where col2 = 7");
        stats.assertTableStats(table, 1);
    }

    public void testNoUpdateTriggeredBySingleColumnUniqueIndex() throws SQLException {
        String TAB = "STAT_SCUI";
        this.dropTable(TAB);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table " + TAB + " (id int primary key, val int unique not null)");
        stats.assertNoStatsTable(TAB);
        PreparedStatement ps = this.prepareStatement("insert into " + TAB + " values (?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 2000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        this.commit();
        PreparedStatement psSel1 = this.prepareStatement("select id from " + TAB + " where id = ?");
        psSel1.setInt(1, 98);
        JDBC.assertSingleValueResultSet(psSel1.executeQuery(), "98");
        PreparedStatement psSel2 = this.prepareStatement("select val from " + TAB + " where val = ?");
        psSel2.setInt(1, 1573);
        JDBC.assertSingleValueResultSet(psSel2.executeQuery(), "1573");
        Utilities.sleep(100L);
        stats.assertNoStatsTable(TAB);
        for (int i = 2000; i < 4000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        this.commit();
        this.forceRowCountEstimateUpdate(TAB);
        psSel1 = this.prepareStatement("select id from " + TAB + " where id = ?");
        psSel1.setInt(1, 117);
        JDBC.assertSingleValueResultSet(psSel1.executeQuery(), "117");
        psSel2 = this.prepareStatement("select val from " + TAB + " where val = ?");
        psSel2.setInt(1, 1);
        JDBC.assertSingleValueResultSet(psSel2.executeQuery(), "1");
        Utilities.sleep(100L);
        stats.assertNoStatsTable(TAB);
        this.dropTable(TAB);
    }

    private void copyDb(String newDbName) throws IOException, SQLException {
        if (!dbCreated) {
            this.createMasterDb();
        }
        File master = this.constructDbPath(TestConfiguration.getCurrent().getPhysicalDatabaseName(MASTERDB));
        final File dest = this.constructDbPath(newDbName);
        if (!PrivilegedFileOpsForTests.exists(dest.getParentFile())) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Assert.assertTrue((boolean)dest.getParentFile().mkdirs());
                    return null;
                }
            });
        }
        PrivilegedFileOpsForTests.copy(master, dest);
    }

    private void createMasterDb() throws SQLException {
        long start = System.currentTimeMillis();
        String table = BIG_TABLE;
        int rows = 1000000;
        DataSource ds1 = JDBCDataSource.getDataSourceLogical(MASTERDB);
        JDBCDataSource.setBeanProperty(ds1, "createDatabase", "create");
        Connection con = ds1.getConnection();
        AutomaticIndexStatisticsTest.dropIfExists(con, table);
        Statement stmt = con.createStatement();
        stmt.executeUpdate("create table " + table + "(id int primary key)");
        stmt.close();
        con.setAutoCommit(false);
        PreparedStatement ps = con.prepareStatement("insert into " + table + " values ?");
        for (int i = 0; i < rows; ++i) {
            ps.setInt(1, i);
            ps.addBatch();
            if (i % 5000 != 0) continue;
            ps.executeBatch();
            con.commit();
        }
        ps.executeBatch();
        con.commit();
        con.close();
        AutomaticIndexStatisticsTest.println("created master db with " + rows + " rows in " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        JDBCDataSource.shutdownDatabase(JDBCDataSource.getDataSourceLogical(MASTERDB));
        dbCreated = true;
    }

    private void forceRowCountEstimateUpdate(String table) throws SQLException {
        Statement stmt = this.createStatement();
        JDBC.assertDrainResults(stmt.executeQuery("select count(*) from " + table));
        stmt.execute("call SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        stmt.close();
    }

    private File constructDbPath(String relDbDirName) {
        File f = new File(AutomaticIndexStatisticsTest.getSystemProperty("derby.system.home"));
        return new File(f, relDbDirName);
    }

    private void createAndInsertSimple(String table, int rows) throws SQLException {
        this.createAndInsertSimple(null, table, rows);
    }

    private void createAndInsertSimple(Connection con, String table, int rows) throws SQLException {
        IndexStatsUtil myStats;
        Statement s;
        if (con == null) {
            con = this.getConnection();
            s = this.createStatement();
            myStats = stats;
        } else {
            s = con.createStatement();
            myStats = new IndexStatsUtil(con);
        }
        AutomaticIndexStatisticsTest.dropIfExists(con, table);
        s.executeUpdate("create table " + table + "(id int primary key, val int)");
        s.executeUpdate("create index NON_UNIQUE_INDEX_" + table + " on " + table + "(val)");
        myStats.assertNoStatsTable(table);
        long start = System.currentTimeMillis();
        AutomaticIndexStatisticsTest.println("created " + table + ", inserting " + rows + " rows");
        this.insertSimple(con, table, rows, 0);
        AutomaticIndexStatisticsTest.println("completed in " + (System.currentTimeMillis() - start) + " ms");
        myStats.assertNoStatsTable(table);
    }

    private void insertSimple(String table, int rows, int start) throws SQLException {
        this.insertSimple(this.getConnection(), table, rows, start);
    }

    private void insertSimple(Connection con, String table, int rows, int start) throws SQLException {
        PreparedStatement ps = con.prepareStatement("insert into " + table + " values (?,?)");
        boolean autoCommit = con.getAutoCommit();
        con.setAutoCommit(false);
        for (int i = start; i < start + rows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i % 20);
            ps.addBatch();
            if (i % 5000 != 0) continue;
            ps.executeBatch();
            con.commit();
        }
        ps.executeBatch();
        con.commit();
        con.setAutoCommit(autoCommit);
    }

    private IndexStatsUtil.IdxStats[] getFilteredTableStats(String table, int expectedCount, IndexStatsUtil.IdxStats[] oldStats) throws SQLException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 20000L) {
            IndexStatsUtil.IdxStats[] ret = stats.getStatsTable(table, expectedCount);
            boolean doReturn = true;
            if (oldStats != null) {
                block1: for (int i = 0; i < ret.length; ++i) {
                    for (int j = 0; j < oldStats.length; ++j) {
                        if (!ret[i].equals(oldStats[j])) continue;
                        doReturn = false;
                        continue block1;
                    }
                }
            }
            if (doReturn) {
                return ret;
            }
            Utilities.sleep(250L);
        }
        AutomaticIndexStatisticsTest.fail((String)("getting stats for table " + table + " timed out (#expected=" + expectedCount + ", #oldStats=" + (oldStats == null ? 0 : oldStats.length) + ")"));
        return null;
    }

    private static void dropIfExists(Connection con, String entity) throws SQLException {
        ResultSet tables = con.getMetaData().getTables(null, null, entity, TYPES);
        while (tables.next()) {
            String type = tables.getString(4);
            if (type.equals("TABLE")) {
                AutomaticIndexStatisticsTest.dropTable(con, entity);
                continue;
            }
            if (type.equals("VIEW")) {
                con.createStatement().executeUpdate("drop view " + entity);
                continue;
            }
            AutomaticIndexStatisticsTest.fail((String)("entity " + entity + " of unsupported type: " + type));
        }
        tables.close();
    }
}

