/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BackgroundStreamDrainer
implements Runnable {
    protected ByteArrayOutputStream data = new ByteArrayOutputStream();
    protected InputStream in;
    protected boolean finished;
    protected IOException ioe;
    protected long startTime;
    protected Thread myThread;
    protected int timeout;

    public BackgroundStreamDrainer(InputStream inputStream, String string) {
        this.in = inputStream;
        this.startTime = System.currentTimeMillis();
        if (string != null) {
            Integer n = Integer.valueOf(string);
            this.timeout = n;
        } else {
            this.timeout = 0;
        }
        this.myThread = new Thread((Runnable)this, this.getClass().getName());
        this.myThread.setPriority(1);
        this.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        if (this.in == null) {
            System.out.println("The inputstream is null");
            System.exit(1);
        }
        try {
            int n;
            object = new byte[1024];
            while ((n = this.in.read((byte[])object, 0, ((byte[])object).length)) != -1) {
                long l;
                long l2;
                int n2;
                if (this.timeout > 0 && (n2 = (int)((l2 = (l = System.currentTimeMillis()) - this.startTime) / 60000L)) > this.timeout) {
                    System.out.println("kill stderr thread...");
                    BackgroundStreamDrainer backgroundStreamDrainer = this;
                    synchronized (backgroundStreamDrainer) {
                        this.finished = true;
                        break;
                    }
                }
                this.data.write((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            this.ioe = iOException;
            System.out.println(iOException.getMessage());
        }
        BackgroundStreamDrainer backgroundStreamDrainer = this;
        object = backgroundStreamDrainer;
        synchronized (backgroundStreamDrainer) {
            this.finished = true;
            this.notifyAll();
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getData() throws IOException {
        BackgroundStreamDrainer backgroundStreamDrainer = this;
        synchronized (backgroundStreamDrainer) {
            try {
                while (!this.finished) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("IOException: " + interruptedException);
                throw new IOException(interruptedException.toString());
            }
        }
        return new ByteArrayInputStream(this.data.toByteArray());
    }
}

