/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class DropAliasNode
extends DDLStatementNode {
    private char aliasType;
    private char nameSpace;

    DropAliasNode(TableName dropAliasName, char aliasType, ContextManager cm) throws StandardException {
        super(dropAliasName, cm);
        this.aliasType = aliasType;
        switch (this.aliasType) {
            case 'G': {
                this.nameSpace = (char)71;
                break;
            }
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            case 'A': {
                this.nameSpace = (char)65;
                break;
            }
            default: {
                SanityManager.THROWASSERT("bad type to DropAliasNode: " + this.aliasType);
            }
        }
    }

    public char getAliasType() {
        return this.aliasType;
    }

    @Override
    String statementToString() {
        return "DROP ".concat(DropAliasNode.aliasTypeName(this.aliasType));
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String aliasName = this.getRelativeName();
        AliasDescriptor ad = null;
        SchemaDescriptor sd = this.getSchemaDescriptor();
        if (sd.getUUID() != null) {
            ad = dataDictionary.getAliasDescriptor(sd.getUUID().toString(), aliasName, this.nameSpace);
        }
        if (ad == null) {
            throw StandardException.newException("42Y55", this.statementToString(), aliasName);
        }
        if (ad.getSystemAlias()) {
            throw StandardException.newException("42Y71", aliasName);
        }
        this.getCompilerContext().createDependency(ad);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropAliasConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.nameSpace);
    }

    private static String aliasTypeName(char actualType) {
        String typeName = null;
        switch (actualType) {
            case 'G': {
                typeName = "DERBY AGGREGATE";
                break;
            }
            case 'P': {
                typeName = "PROCEDURE";
                break;
            }
            case 'F': {
                typeName = "FUNCTION";
                break;
            }
            case 'S': {
                typeName = "SYNONYM";
                break;
            }
            case 'A': {
                typeName = "TYPE";
            }
        }
        return typeName;
    }
}

