/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class ConcurrentImplicitCreateSchema {
    boolean passed = true;

    public static void main(String[] stringArray) {
        new ConcurrentImplicitCreateSchema().go(stringArray);
    }

    void go(String[] stringArray) {
        System.out.println("Test ConcurrentImplicitCreateSchema starting");
        try {
            int n;
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            for (int i = 0; i < 1; ++i) {
                try {
                    statement.execute("drop schema testschema" + i + " restrict");
                    continue;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("42Y07")) continue;
                    throw sQLException;
                }
            }
            Thread[] threadArray = new Thread[100];
            for (n = 0; n < 100; ++n) {
                threadArray[n] = new Thread(new CreateTable(n, n % 1, this));
            }
            for (n = 0; n < 100; ++n) {
                threadArray[n].start();
            }
            for (n = 0; n < 100; ++n) {
                threadArray[n].join();
            }
            connection.close();
            System.out.println("Closed connection");
        }
        catch (Throwable throwable) {
            System.out.println("exception thrown:");
            this.failed(throwable);
        }
        System.out.print("Test ConcurrentImplicitCreateSchema ");
        if (this.passed) {
            System.out.println("PASSED");
        } else {
            System.out.println("FAILED");
        }
    }

    void failed(Throwable throwable) {
        if (throwable instanceof SQLException) {
            this.printSQLError((SQLException)throwable);
        } else {
            throwable.printStackTrace();
        }
        this.passed = false;
    }

    void printSQLError(SQLException sQLException) {
        while (sQLException != null) {
            System.out.println(sQLException.toString());
            sQLException.printStackTrace();
            sQLException = sQLException.getNextException();
        }
    }

    class CreateTable
    implements Runnable {
        private int myId;
        private int schemaId;
        private Connection conn = null;
        private ConcurrentImplicitCreateSchema test;

        CreateTable(int n, int n2, ConcurrentImplicitCreateSchema concurrentImplicitCreateSchema2) throws SQLException, IllegalAccessException, ClassNotFoundException, InstantiationException, NoSuchMethodException, InvocationTargetException {
            this.myId = n;
            this.schemaId = n2;
            this.test = concurrentImplicitCreateSchema2;
            this.conn = ij.startJBMS();
            this.conn.setAutoCommit(false);
        }

        @Override
        public void run() {
            try {
                Statement statement = this.conn.createStatement();
                statement.execute("create table testschema" + this.schemaId + ".testtab" + this.myId + "(num int, addr varchar(40))");
                statement.execute("drop table testschema" + this.schemaId + ".testtab" + this.myId);
            }
            catch (SQLException sQLException) {
                this.test.failed(sQLException);
            }
            try {
                this.conn.commit();
                this.conn.close();
            }
            catch (SQLException sQLException) {
                this.test.failed(sQLException);
            }
        }
    }
}

