/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DSCreateShutdownDBTest
extends BaseJDBCTestCase {
    static final String[] ADDITIONAL_DBS = new String[]{"dscreateconatdb1", "dscreateshutdowndb1", "dscreateshutdowndb2", "conflict1", "conflict2", "conflict3", "conflict4", "conflict5", "conflict6", "conflict7"};
    static String DBNotFoundState;

    public DSCreateShutdownDBTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DSCreateShutdownDBTest");
        Test test = TestConfiguration.defaultSuite(DSCreateShutdownDBTest.class);
        baseTestSuite.addTest(test);
        TestSetup testSetup = TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            testSetup = TestConfiguration.additionalDatabaseDecorator((Test)testSetup, "emb" + ADDITIONAL_DBS[i]);
            testSetup = TestConfiguration.additionalDatabaseDecorator((Test)testSetup, "srv" + ADDITIONAL_DBS[i]);
        }
        return baseTestSuite;
    }

    @Override
    public void tearDown() throws Exception {
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        for (int i = 0; i < ADDITIONAL_DBS.length; ++i) {
            DSCreateShutdownDBTest.removeDirectory(testConfiguration.getDatabasePath("emb" + ADDITIONAL_DBS[i]));
            DSCreateShutdownDBTest.removeDirectory(testConfiguration.getDatabasePath("srv" + ADDITIONAL_DBS[i]));
        }
        super.tearDown();
    }

    public void testCreateAndShutdown() throws SQLException {
        DBNotFoundState = DSCreateShutdownDBTest.usingEmbedded() ? "XJ004" : "08004";
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        DSCreateShutdownDBTest.assertUpdateCount(this.createStatement(), 0, "set schema APP");
        this.assertGetNull(string);
        this.assertSetAndGet(string, "shutdownDatabase", "shutdown");
        this.assertSetAndGet(string, "createDatabase", "create");
        this.assertNotSetAndGet(string, "shutdownDatabase", "boo");
        this.assertNotSetAndGet(string, "createDatabase", "boo");
        this.assertNotSetAndGet(string, "shutdownDatabase", "false");
        this.assertNotSetAndGet(string, "createDatabase", "false");
        this.assertReset(string);
        this.assertCreateUsingConnAttrsOK(this.composeDatabaseName(ADDITIONAL_DBS[0]));
        this.assertShutdownUsingConnAttrsOK(string);
        this.getConnection();
        string = this.composeDatabaseName(ADDITIONAL_DBS[1]);
        this.assertNoDB(string);
        this.assertPositive(string);
        string = this.composeDatabaseName(ADDITIONAL_DBS[2]);
        this.assertNoDB(string);
        this.assertTwiceOK(string);
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[3]), "shutdown=true;create=true");
        this.assertShutdownAndCreateConnAttr(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[4]), "create=true;shutdown=true");
        this.assertConflictedSettersOK(this.composeDatabaseName(ADDITIONAL_DBS[5]));
        this.assertConflictedSetterConnAttrOK();
    }

    protected String composeDatabaseName(String string) {
        if (DSCreateShutdownDBTest.usingEmbedded()) {
            return "emb" + string;
        }
        return "srv" + string;
    }

    protected void assertGetNull(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical(string);
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "shutdownDatabase"));
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
    }

    protected void assertSetAndGet(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical(string);
        JDBCDataSource.setBeanProperty(dataSource, string2, string3);
        DSCreateShutdownDBTest.assertEquals((String)string3, (String)DSCreateShutdownDBTest.getBeanProperty(dataSource, string2).toString());
    }

    protected void assertNotSetAndGet(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical(string);
        JDBCDataSource.setBeanProperty(dataSource, string2, string3);
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, string2));
    }

    protected void assertReset(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical(string);
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        DSCreateShutdownDBTest.assertEquals((Object)"create", (Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "boo");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        DSCreateShutdownDBTest.assertEquals((Object)"create", (Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "false");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "create");
        DSCreateShutdownDBTest.assertEquals((Object)"create", (Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "createDatabase"));
        try {
            JDBCDataSource.setBeanProperty(dataSource, "createDatabase", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        DSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "boo");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "false");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        DSCreateShutdownDBTest.assertEquals((Object)"shutdown", (Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "shutdownDatabase"));
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "");
        DSCreateShutdownDBTest.assertNull((Object)DSCreateShutdownDBTest.getBeanProperty(dataSource, "shutdownDatabase"));
        try {
            JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Object getBeanProperty(Object object, String string) {
        String string2 = DSCreateShutdownDBTest.getGetterName(string);
        Object object2 = null;
        try {
            Method method = object.getClass().getMethod(string2, null);
            object2 = method.invoke(object, null);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
        return object2;
    }

    private static String getGetterName(String string) {
        return "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    protected void assertShutdownUsingSetOK(String string, boolean bl) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        if (bl) {
            JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", "shutdown=true");
        }
        this.assertDSConnectionFailed("08006", dataSource);
    }

    protected void assertCreateUsingConnAttrsOK(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", "create=true");
        DSCreateShutdownDBTest.assertUpdateCount(dataSource.getConnection().createStatement(), 0, "set schema APP");
        JDBCDataSource.clearStringBeanProperty(dataSource, "ConnectionAttributes");
        this.assertShutdownUsingSetOK(string, false);
    }

    protected void assertShutdownUsingConnAttrsOK(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSourceLogical(string);
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", "shutdown=true");
        this.assertDSConnectionFailed("08006", dataSource);
    }

    protected void assertShutdownAndCreateConnAttr(String string, String string2, String string3) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string2);
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", string3);
        this.assertDSConnectionFailed(string, dataSource);
    }

    protected void assertDSConnectionFailed(String string, DataSource dataSource) throws SQLException {
        try {
            dataSource.getConnection();
            DSCreateShutdownDBTest.fail((String)("expected an sqlexception " + string));
        }
        catch (SQLException sQLException) {
            DSCreateShutdownDBTest.assertSQLState(string, sQLException);
        }
    }

    protected void assertNoDB(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        this.assertDSConnectionFailed(DBNotFoundState, dataSource);
    }

    protected void assertPositive(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "CreateDatabase", "create");
        DSCreateShutdownDBTest.assertUpdateCount(dataSource.getConnection().createStatement(), 0, "set schema APP");
        JDBCDataSource.clearStringBeanProperty(dataSource, "CreateDatabase");
        this.assertShutdownUsingSetOK(string, false);
    }

    protected void assertTwiceOK(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", "create=true");
        DSCreateShutdownDBTest.assertUpdateCount(dataSource.getConnection().createStatement(), 0, "set schema APP");
        JDBCDataSource.clearStringBeanProperty(dataSource, "CreateDatabase");
        JDBCDataSource.clearStringBeanProperty(dataSource, "ConnectionAttributes");
        this.assertShutdownUsingSetOK(string, true);
    }

    protected void assertConflictedSettersOK(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string);
        JDBCDataSource.setBeanProperty(dataSource, "CreateDatabase", "create");
        JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
        try {
            dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            DSCreateShutdownDBTest.assertSQLState(DBNotFoundState, sQLException);
        }
    }

    protected void assertConflictedSetterConnAttrOK() throws SQLException {
        this.assertConSetOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[6]), "shutdown=true", "CreateDatabase", "create");
        this.assertConSetOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[7]), "create=true", "ShutdownDatabase", "shutdown");
        this.assertSetConOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[8]), "shutdown=true", "CreateDatabase", "create");
        this.assertSetConOK(DBNotFoundState, this.composeDatabaseName(ADDITIONAL_DBS[9]), "create=true", "ShutdownDatabase", "shutdown");
    }

    protected void assertConSetOK(String string, String string2, String string3, String string4, String string5) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string2);
        JDBCDataSource.setBeanProperty(dataSource, string4, string5);
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", string3);
        try {
            dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            DSCreateShutdownDBTest.assertSQLState(string, sQLException);
        }
        JDBCDataSource.clearStringBeanProperty(dataSource, string4);
        JDBCDataSource.clearStringBeanProperty(dataSource, "ConnectionAttributes");
    }

    protected void assertSetConOK(String string, String string2, String string3, String string4, String string5) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource(string2);
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", string3);
        JDBCDataSource.setBeanProperty(dataSource, string4, string5);
        try {
            dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            DSCreateShutdownDBTest.assertSQLState(string, sQLException);
        }
        JDBCDataSource.clearStringBeanProperty(dataSource, "ConnectionAttributes");
        JDBCDataSource.clearStringBeanProperty(dataSource, string4);
    }
}

