/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StreamTest
extends BaseJDBCTestCase {
    private static final String LANG_STREAM_RETRIEVED_ALREADY = "XCL18";
    private boolean didclose = false;

    public StreamTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(StreamTest.class);
    }

    public void testGetStreamTwiceSmallBlob() throws SQLException, IOException {
        this.insertBlobData(512);
        this.runGetStreamTwiceTest();
    }

    public void testGetStreamTwiceLargeBlob() throws SQLException, IOException {
        this.insertBlobData(524288);
        this.runGetStreamTwiceTest();
    }

    public void testGetReaderTwiceSmallClob() throws SQLException, IOException {
        this.insertClobData(512);
        this.runGetReaderTwiceTest();
    }

    public void testGetReaderTwiceLargeClob() throws SQLException, IOException {
        this.insertClobData(524288);
        this.runGetReaderTwiceTest();
    }

    private void insertBlobData(int n) throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE testLob  (b blob(" + n + "))");
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into testLob values(?)");
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(n);
        preparedStatement.setBinaryStream(1, (InputStream)loopingAlphabetStream, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void insertClobData(int n) throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE testLob  (c clob(" + n + "))");
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into testLob values(?)");
        LoopingAlphabetReader loopingAlphabetReader = new LoopingAlphabetReader(n);
        preparedStatement.setCharacterStream(1, (Reader)loopingAlphabetReader, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void runGetStreamTwiceTest() throws SQLException, IOException {
        InputStream inputStream = null;
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from testLob");
        StreamTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        StreamTest.println("get stream from testLob ...");
        inputStream = resultSet.getBinaryStream(1);
        inputStream.close();
        try {
            StreamTest.println("get stream from testLob again ...");
            inputStream = resultSet.getBinaryStream(1);
            StreamTest.fail((String)"FAIL - Expected exception did not happen.");
        }
        catch (SQLException sQLException) {
            StreamTest.assertSQLState(LANG_STREAM_RETRIEVED_ALREADY, sQLException);
        }
        resultSet.close();
        statement.close();
    }

    public void runGetReaderTwiceTest() throws SQLException, IOException {
        Reader reader = null;
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from testLob");
        StreamTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        StreamTest.println("get reader from testLob ...");
        reader = resultSet.getCharacterStream(1);
        reader.close();
        try {
            StreamTest.println("get reader from testLob again ...");
            reader = resultSet.getCharacterStream(1);
            StreamTest.fail((String)"FAIL - Expected exception did not happen.");
        }
        catch (SQLException sQLException) {
            StreamTest.assertSQLState(LANG_STREAM_RETRIEVED_ALREADY, sQLException);
        }
        resultSet.close();
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby4531() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table tDerby4531(c clob(200))");
        statement.close();
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("insert into tDerby4531 values (?)");
        MyLoopingAlphabetReader myLoopingAlphabetReader = new MyLoopingAlphabetReader(200);
        preparedStatement.setCharacterStream(1, (Reader)myLoopingAlphabetReader, 200);
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = null;
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MyLoopingAlphabetReader myLoopingAlphabetReader2 = myLoopingAlphabetReader;
        synchronized (myLoopingAlphabetReader2) {
            StreamTest.assertFalse((boolean)this.didclose);
        }
        this.rollback();
    }

    private class MyLoopingAlphabetReader
    extends LoopingAlphabetReader {
        public MyLoopingAlphabetReader(int n) {
            super(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            MyLoopingAlphabetReader myLoopingAlphabetReader = this;
            synchronized (myLoopingAlphabetReader) {
                StreamTest.this.didclose = true;
            }
        }
    }
}

