/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_Recovery
extends T_Generic {
    private static final String testService = "RecoveryTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_UNDO = "Lotus";
    static final String REC_NULL = "NULL";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    static final FormatableBitSet BS_COL_0 = new FormatableBitSet(1);
    private RandomAccessFile filein = null;
    private RandomAccessFile fileout = null;
    private boolean setupRecovery;
    private boolean testRecovery;
    private static final String infoPath = "extinout/T_Recovery.info";
    private static final String SETUP_RECOVERY = "SetupRecovery";
    private static final String TEST_RECOVERY = "TestRecovery";
    private static final String RECOVERY_TESTPATH = "RecoveryTestPath";
    RawStoreFactory factory;
    LockFactory lf;
    ContextService contextService;
    UUIDFactory uuidfactory;
    T_Util t_util;

    public T_Recovery() {
        BS_COL_0.set(0);
    }

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    private void getConfig() {
        String string = PropertyUtil.getSystemProperty((String)SETUP_RECOVERY);
        this.setupRecovery = Boolean.valueOf(string);
        string = PropertyUtil.getSystemProperty((String)TEST_RECOVERY);
        this.testRecovery = Boolean.valueOf(string);
    }

    @Override
    public void runTests() throws T_Fail {
        this.getConfig();
        if (!(this.setupRecovery ^ this.testRecovery)) {
            throw T_Fail.testFailMsg("One & only one of the SetupRecovery and TestRecovery properties must be set");
        }
        try {
            this.uuidfactory = T_Recovery.getMonitor().getUUIDFactory();
            if (this.uuidfactory == null) {
                throw T_Fail.testFailMsg("UUIDFactory.MODULE not found");
            }
            this.startParams = T_Util.setEncryptionParam(this.startParams);
            this.contextService = T_Recovery.getContextService();
            if (this.testRecovery) {
                if (!T_Recovery.startPersistentService(testService, this.startParams)) {
                    throw T_Fail.testFailMsg("Monitor didn't know how to restart service: RecoveryTest");
                }
                this.factory = (RawStoreFactory)T_Recovery.findService(this.getModuleToTestProtocolName(), testService);
            } else {
                if (this.startParams == null) {
                    this.startParams = new Properties();
                }
                this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
                this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
                this.startParams.put("derby.storage.keepTransactionLog", "true");
                this.factory = (RawStoreFactory)T_Recovery.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
            }
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        if (this.factory == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.lf = this.factory.getLockFactory();
        if (this.lf == null) {
            throw T_Fail.testFailMsg("LockFactory.MODULE not found");
        }
        this.t_util = new T_Util(this.factory, this.lf, this.contextService);
        try {
            if (this.setupRecovery) {
                this.S001();
                this.S002();
                this.S003();
                this.S004();
                this.S005();
                this.S006();
                this.S007();
                this.S008();
                this.S009();
                this.S010();
                this.S011();
                this.S012();
                this.S020();
                this.S022();
                this.S100();
                this.S101();
                this.S200();
                this.S201();
                this.S202();
                this.S203();
                this.S204();
                this.S300();
                this.S301();
                this.S302();
                this.S303();
                this.S304();
            }
            if (this.testRecovery || this.setupRecovery) {
                this.R001();
                this.R002();
                this.R003();
                this.R004();
                this.R005();
                this.R006();
                this.R007();
                this.R008();
                this.R009();
                this.R010();
                this.R011();
                this.R012();
                this.R020();
                this.R022();
                this.R100();
                this.R101();
                this.R302();
                if (this.testRecovery) {
                    this.R200();
                    this.R201();
                    this.R202();
                    this.R203();
                    this.R204();
                    this.R300();
                    this.R301();
                    this.R303();
                    this.R304();
                    this.R999();
                }
            }
            if (this.setupRecovery) {
                this.S999();
            }
            if (this.fileout != null) {
                this.fileout.close();
                this.fileout = null;
            }
            if (this.filein != null) {
                this.filein.close();
                this.filein = null;
            }
        }
        catch (Throwable throwable) {
            SanityManager.showTrace((Throwable)throwable);
            System.out.println("caught exception t " + String.valueOf(throwable));
            throwable.printStackTrace();
            System.exit(0);
        }
    }

    private long find(long l) throws T_Fail {
        try {
            if (this.filein == null) {
                File file = new File(infoPath);
                if (file.exists()) {
                    try {
                        this.filein = new RandomAccessFile(file, "r");
                    }
                    catch (IOException iOException) {
                        System.out.println("Cannot write to temporary file extinout/T_Recovery.info.  Please make sure it is correct, if not, please set the property RecoveryTestPath=<where temp files should go>");
                        throw T_Fail.exceptionFail(iOException);
                    }
                } else {
                    return -1L;
                }
            }
            this.filein.seek(0L);
            while (true) {
                long l2;
                if ((l2 = this.filein.readLong()) == l) {
                    long l3 = this.filein.readLong();
                    return l3;
                }
                this.filein.readLong();
            }
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private long key(int n, int n2) {
        long l = n;
        return (l << 32) + (long)n2;
    }

    private void register(long l, long l2) throws T_Fail {
        try {
            if (this.fileout == null) {
                File file;
                File file2 = new File(infoPath);
                if (file2.exists()) {
                    file2.delete();
                }
                if (!(file = new File("extinout")).exists()) {
                    file.mkdirs();
                }
                this.fileout = new RandomAccessFile(infoPath, "rw");
            }
            this.fileout.writeLong(l);
            this.fileout.writeLong(l2);
        }
        catch (IOException iOException) {
            T_Fail.exceptionFail(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S001() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            page.unlatch();
            containerHandle.close();
            this.register(this.key(1, 1), l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.REPORT("setup S001: " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R001() throws T_Fail, StandardException {
        long l = this.find(this.key(1, 1));
        if (l < 0L) {
            this.REPORT("R001 not run");
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFieldCount(page, 0, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R001: containerId " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S002() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        try {
            RecordHandle recordHandle;
            RecordHandle recordHandle2;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            RecordHandle recordHandle4 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
            RecordHandle recordHandle5 = recordHandle4 == null ? recordHandle4 : (recordHandle2 = T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3));
            RecordHandle recordHandle6 = recordHandle2 == null ? recordHandle2 : (recordHandle = T_Util.t_insertAtSlot(page, 3, t_RawStoreRow4));
            RecordHandle recordHandle7 = recordHandle == null ? recordHandle : T_Util.t_insertAtSlot(page, 4, t_RawStoreRow5);
            this.REPORT("setup S002: containerId " + l + " recordCount " + page.recordCount());
            this.register(this.key(2, 1), l);
            this.register(this.key(2, 2), page.recordCount());
            page.unlatch();
            containerHandle.close();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R002() throws T_Fail, StandardException {
        long l = this.find(this.key(2, 1));
        if (l < 0L) {
            this.REPORT("R002 not run");
            return;
        }
        int n = (int)this.find(this.key(2, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, n, n);
            switch (n) {
                case 5: {
                    T_Util.t_checkFetchBySlot(page, 4, REC_005, false, false);
                }
                case 4: {
                    T_Util.t_checkFetchBySlot(page, 3, REC_004, false, false);
                }
                case 3: {
                    T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
                }
                case 2: {
                    T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
                }
                case 1: {
                    T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
                }
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R002: containerId " + l + " recordCount " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S003() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(3);
            t_RawStoreRow2.setColumn(0, (String)null);
            t_RawStoreRow2.setColumn(1, REC_003);
            t_RawStoreRow2.setColumn(2, REC_004);
            recordHandle = page.updateAtSlot(0, (Object[])t_RawStoreRow2.getRow(), (FormatableBitSet)null);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(3);
            t_RawStoreRow3.setColumn(0, REC_001);
            t_RawStoreRow3.setColumn(1, REC_002);
            t_RawStoreRow3.setColumn(2, REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_005);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow3);
            if (recordHandle2 != null) {
                recordHandle2 = page.updateAtSlot(1, (Object[])t_RawStoreRow4.getRow(), (FormatableBitSet)null);
            }
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
            SQLChar sQLChar = new SQLChar();
            T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, true, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, true, REC_003);
            T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, true, REC_004);
            if (recordHandle2 != null) {
                T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow4);
                T_Util.t_checkFetchColFromSlot(page, 1, 0, (DataValueDescriptor)sQLChar, true, REC_005);
            }
            this.REPORT("setup S003: containerId " + l + " recordCount " + page.recordCount());
            this.register(this.key(3, 1), l);
            this.register(this.key(3, 2), page.recordCount());
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R003() throws T_Fail, StandardException {
        long l = this.find(this.key(3, 1));
        if (l < 0L) {
            this.REPORT("R003 not run");
            return;
        }
        int n = (int)this.find(this.key(3, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, n, n);
            T_Util.t_checkFieldCount(page, 0, 3);
            SQLChar sQLChar = new SQLChar();
            T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_003);
            T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, REC_004);
            if (n == 2) {
                T_Util.t_checkFieldCount(page, 1, 1);
                T_Util.t_checkFetchColFromSlot(page, 1, 0, (DataValueDescriptor)sQLChar, false, REC_005);
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R003: containerId " + l + " recordCount " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S004() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            Page page;
            long l;
            block7: {
                block6: {
                    l = this.t_util.t_addContainer(transaction, 0L);
                    this.t_util.t_commit(transaction);
                    ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                    page = this.t_util.t_getPage(containerHandle, 1L);
                    T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(5);
                    t_RawStoreRow.setColumn(0, (String)null);
                    t_RawStoreRow.setColumn(1, REC_004);
                    t_RawStoreRow.setColumn(2, (String)null);
                    t_RawStoreRow.setColumn(3, REC_005);
                    t_RawStoreRow.setColumn(4, REC_005);
                    RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                    SQLChar sQLChar = new SQLChar((String)null);
                    SQLChar sQLChar2 = new SQLChar(REC_001);
                    SQLChar sQLChar3 = new SQLChar(REC_002);
                    SQLChar sQLChar4 = new SQLChar((String)null);
                    if (page.updateFieldAtSlot(0, 0, (Object)sQLChar, null) == null) break block6;
                    if (page.updateFieldAtSlot(0, 1, (Object)sQLChar2, null) == null) break block6;
                    if (page.updateFieldAtSlot(0, 2, (Object)sQLChar3, null) == null) break block6;
                    if (page.updateFieldAtSlot(0, 3, (Object)sQLChar4, null) != null) break block7;
                }
                throw T_Fail.testFailMsg("Failed to update field");
            }
            page.unlatch();
            this.REPORT("setup S004: containerId " + l);
            this.register(this.key(4, 1), l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R004() throws T_Fail, StandardException {
        long l = this.find(this.key(4, 1));
        if (l < 0L) {
            this.REPORT("R004 not run");
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            SQLChar sQLChar = new SQLChar();
            T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_001);
            T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, REC_002);
            T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)sQLChar, false, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)sQLChar, false, REC_005);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R004: containerId " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S005() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            RecordHandle recordHandle;
            RecordHandle recordHandle2;
            RecordHandle recordHandle3;
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            long l2 = 0L;
            RecordHandle recordHandle4 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            page.purgeAtSlot(0, 1, true);
            ++l2;
            RecordHandle recordHandle5 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2);
            if (recordHandle5 != null) {
                page.deleteAtSlot(0, true, null);
            }
            RecordHandle recordHandle6 = recordHandle5 == null ? recordHandle5 : (recordHandle3 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow3));
            if (recordHandle3 != null) {
                page.deleteAtSlot(1, true, null);
            }
            RecordHandle recordHandle7 = recordHandle3 == null ? recordHandle3 : (recordHandle2 = T_Util.t_insertAtSlot(page, 2, t_RawStoreRow4));
            RecordHandle recordHandle8 = recordHandle2 == null ? recordHandle2 : (recordHandle = T_Util.t_insertAtSlot(page, 3, t_RawStoreRow5));
            if (recordHandle != null) {
                page.purgeAtSlot(1, 2, true);
                l2 += 2L;
            }
            this.REPORT("setup S005: containerId " + l + " recordCount " + page.recordCount() + " numPurges " + l2);
            this.register(this.key(5, 1), l);
            this.register(this.key(5, 2), page.recordCount());
            this.register(this.key(5, 3), l2);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R005() throws T_Fail, StandardException {
        long l = this.find(this.key(5, 1));
        if (l < 0L) {
            this.REPORT("R005 not run");
            return;
        }
        int n = (int)this.find(this.key(5, 2));
        int n2 = (int)this.find(this.key(5, 3));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, n, 1);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            if (n2 == 1) {
                switch (n) {
                    case 3: {
                        T_Util.t_checkFetchBySlot(page, 2, REC_004, false, false);
                    }
                    case 2: {
                        T_Util.t_checkFetchBySlot(page, 1, REC_003, true, false);
                    }
                    case 1: {
                        T_Util.t_checkFetchBySlot(page, 0, REC_002, true, false);
                    }
                }
            } else {
                switch (n) {
                    case 2: {
                        T_Util.t_checkFetchBySlot(page, 1, REC_005, false, false);
                    }
                    case 1: {
                        T_Util.t_checkFetchBySlot(page, 0, REC_002, true, false);
                        if (page.isDeletedAtSlot(0)) break;
                        throw T_Fail.testFailMsg("record should be deleted");
                    }
                }
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R005: containerId " + l + " recordCount " + n + " numPurges " + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S006() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            long l2 = page.getPageNumber();
            page.unlatch();
            page = this.t_util.t_addPage(containerHandle);
            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2);
            long l3 = page.getPageNumber();
            page.unlatch();
            page = this.t_util.t_addPage(containerHandle);
            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow3);
            long l4 = page.getPageNumber();
            page.unlatch();
            if (l2 == l3 || l2 == l4 || l3 == l4) {
                throw T_Fail.testFailMsg("not getting new pages");
            }
            this.REPORT("setup S006: containerId " + l);
            this.register(this.key(6, 1), l);
            this.register(this.key(6, 2), l2);
            this.register(this.key(6, 3), l3);
            this.register(this.key(6, 4), l4);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R006() throws T_Fail, StandardException {
        long l = this.find(this.key(6, 1));
        if (l < 0L) {
            this.REPORT("R006 not run");
            return;
        }
        long l2 = this.find(this.key(6, 2));
        long l3 = this.find(this.key(6, 3));
        long l4 = this.find(this.key(6, 4));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            if (l2 != 1L) {
                throw T_Fail.testFailMsg("first page != container first page");
            }
            Page page = this.t_util.t_getPage(containerHandle, l2);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            page.unlatch();
            page = this.t_util.t_getPage(containerHandle, l3);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_002, false, false);
            page.unlatch();
            page = this.t_util.t_getPage(containerHandle, l4);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_003, false, false);
            page.unlatch();
            page = this.t_util.t_getLastPage(containerHandle);
            T_Util.t_checkPageNumber(page, l4);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R006: containerId " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S007() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            long l2 = page.getPageNumber();
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            Page page3 = this.t_util.t_addPage(containerHandle);
            long l4 = page3.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_removePage(containerHandle, page3);
            this.t_util.t_removePage(containerHandle, page);
            if (page.isLatched()) {
                throw T_Fail.testFailMsg("page is still latched after remove");
            }
            if (page2.isLatched()) {
                throw T_Fail.testFailMsg("page is still latched after remove");
            }
            if (page3.isLatched()) {
                throw T_Fail.testFailMsg("page is still latched after remove");
            }
            this.register(this.key(7, 0), l);
            this.register(this.key(7, 1), l2);
            this.register(this.key(7, 2), l3);
            this.register(this.key(7, 3), l4);
            this.REPORT("setup S007: containerId " + l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R007() throws T_Fail, StandardException {
        long l = this.find(this.key(7, 0));
        if (l < 0L) {
            this.REPORT("R007 not run");
            return;
        }
        long l2 = this.find(this.key(7, 1));
        long l3 = this.find(this.key(7, 2));
        long l4 = this.find(this.key(7, 3));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = containerHandle.getPage(l2);
            if (page != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + l2);
            }
            page = containerHandle.getPage(l3);
            if (page != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + l3);
            }
            page = containerHandle.getPage(l4);
            if (page != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + l4);
            }
            page = containerHandle.getPage(l4 + 1L);
            if (page != null) {
                throw T_Fail.testFailMsg("got a non-existant page " + l4 + "100");
            }
            page = containerHandle.getFirstPage();
            if (page != null) {
                throw T_Fail.testFailMsg("got a non-existant first page ");
            }
            page = this.t_util.t_getLastPage(containerHandle);
            if (page != null) {
                throw T_Fail.testFailMsg("got a non-existant last page ");
            }
            this.PASS("R007: containerId " + l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S008() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            long l2 = page.getPageNumber();
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            Page page3 = this.t_util.t_addPage(containerHandle);
            long l4 = page3.getPageNumber();
            Page page4 = this.t_util.t_addPage(containerHandle);
            long l5 = page4.getPageNumber();
            Page page5 = this.t_util.t_addPage(containerHandle);
            long l6 = page5.getPageNumber();
            this.t_util.t_removePage(containerHandle, page);
            this.t_util.t_removePage(containerHandle, page3);
            this.t_util.t_removePage(containerHandle, page5);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page3 = this.t_util.t_getPage(containerHandle, l3);
            page = this.t_util.t_getPage(containerHandle, l5);
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_removePage(containerHandle, page4);
            this.register(this.key(8, 0), l);
            this.register(this.key(8, 1), l2);
            this.register(this.key(8, 2), l3);
            this.register(this.key(8, 3), l4);
            this.register(this.key(8, 4), l5);
            this.register(this.key(8, 5), l6);
            this.REPORT("setup S008: containerId " + l);
        }
        finally {
            this.t_util.t_abort(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R008() throws T_Fail, StandardException {
        long l = this.find(this.key(8, 0));
        if (l < 0L) {
            this.REPORT("R008 not run");
            return;
        }
        long l2 = this.find(this.key(8, 1));
        long l3 = this.find(this.key(8, 2));
        long l4 = this.find(this.key(8, 3));
        long l5 = this.find(this.key(8, 4));
        long l6 = this.find(this.key(8, 5));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = containerHandle.getPage(l2);
            if (page != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + l2);
            }
            page = this.t_util.t_getPage(containerHandle, l3);
            page.unlatch();
            page = containerHandle.getPage(l4);
            if (page != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + l4);
            }
            page = this.t_util.t_getPage(containerHandle, l5);
            page.unlatch();
            page = containerHandle.getPage(l6);
            if (page != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + l6);
            }
            page = containerHandle.getPage(l6 + 1L);
            if (page != null) {
                throw T_Fail.testFailMsg("got a non-existant page " + l6 + "1");
            }
            page = containerHandle.getFirstPage();
            if (page == null || page.getPageNumber() != l3) {
                throw T_Fail.testFailMsg("get first page failed");
            }
            page.unlatch();
            page = containerHandle.getNextPage(l3);
            if (page == null || page.getPageNumber() != l5) {
                throw T_Fail.testFailMsg("get next page failed");
            }
            page.unlatch();
            page = containerHandle.getNextPage(l5);
            if (page != null) {
                page.unlatch();
                throw T_Fail.testFailMsg("get next page failed to terminate");
            }
            page = this.t_util.t_getLastPage(containerHandle);
            if (page == null || page.getPageNumber() != l5) {
                throw T_Fail.testFailMsg("getLastPage failed");
            }
            page.unlatch();
            this.PASS("R008: containerId " + l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S009() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n;
            int n2;
            int n3;
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            int n4 = 10;
            Page[] pageArray = new Page[n4];
            int[] nArray = new int[n4];
            long[] lArray = new long[n4];
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            for (n3 = 0; n3 < n4; ++n3) {
                pageArray[n3] = n3 == 0 ? this.t_util.t_getPage(containerHandle, 1L) : this.t_util.t_addPage(containerHandle);
                nArray[n3] = T_Util.t_insert(pageArray[n3], t_RawStoreRow).getId();
                lArray[n3] = pageArray[n3].getPageNumber();
                this.t_util.t_removePage(containerHandle, pageArray[n3]);
            }
            this.t_util.t_commit(transaction);
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                for (int i = n3 + 1; i < n4; ++i) {
                    if (lArray[n3] != lArray[i]) continue;
                    throw T_Fail.testFailMsg("page reused before transaction is committed");
                }
            }
            this.register(this.key(9, 0), l);
            this.register(this.key(9, 1), n4);
            for (n3 = 0; n3 < n4; ++n3) {
                this.register(this.key(9, n3 + 10), lArray[n3]);
                this.register(this.key(9, n3 + n4 + 10), nArray[n3]);
            }
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page[] pageArray2 = new Page[n4];
            int[] nArray2 = new int[n4];
            long[] lArray2 = new long[n4];
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            for (n2 = 0; n2 < n4; ++n2) {
                pageArray2[n2] = this.t_util.t_addPage(containerHandle);
                lArray2[n2] = pageArray2[n2].getPageNumber();
                nArray2[n2] = T_Util.t_insert(pageArray2[n2], t_RawStoreRow2).getId();
            }
            n2 = 0;
            block8: for (n = 0; n < n4; ++n) {
                for (int i = 0; i < n4; ++i) {
                    if (lArray[n] != lArray2[i]) continue;
                    ++n2;
                    if (nArray[n] != nArray2[i]) continue block8;
                    throw T_Fail.testFailMsg("resued page rid is not preserved");
                }
            }
            for (n = 0; n < n4; ++n) {
                this.register(this.key(9, n + 100), lArray2[n]);
                this.register(this.key(9, n + n4 + 100), nArray2[n]);
            }
            this.REPORT("setup S009: containerId " + l + " of " + n4 + " original pages," + n2 + " pages were reused.");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R009() throws T_Fail, StandardException {
        long l = this.find(this.key(9, 0));
        if (l < 0L) {
            this.REPORT("R009 not run");
            return;
        }
        int n = (int)this.find(this.key(9, 1));
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        Page[] pageArray = new Page[n];
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            for (int i = 0; i < n; ++i) {
                nArray[i] = (int)this.find(this.key(9, i + n + 100));
                lArray[i] = this.find(this.key(9, i + 100));
                pageArray[i] = this.t_util.t_getPage(containerHandle, lArray[i]);
                T_Util.t_checkRecordCount(pageArray[i], 1, 1);
                RecordHandle recordHandle = T_Util.t_checkFetchFirst(pageArray[i], REC_002);
                if (recordHandle.getId() == nArray[i]) continue;
                throw T_Fail.testFailMsg("recordId not match");
            }
            this.REPORT("R009: containerId " + l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S010() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n;
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            int n2 = 10;
            Page[] pageArray = new Page[n2];
            long[] lArray = new long[n2];
            RecordHandle[] recordHandleArray = new RecordHandle[n2];
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            for (int i = 0; i < n2; ++i) {
                pageArray[i] = i == 0 ? this.t_util.t_getPage(containerHandle, 1L) : this.t_util.t_addPage(containerHandle);
                lArray[i] = pageArray[i].getPageNumber();
                if (i < 2 || i == n2 - 1) {
                    T_Util.t_checkEmptyPage(pageArray[i]);
                    this.t_util.t_removePage(containerHandle, pageArray[i]);
                    continue;
                }
                recordHandleArray[i] = T_Util.t_insert(pageArray[i], t_RawStoreRow);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = containerHandle.getFirstPage();
            if (page.getPageNumber() != lArray[2]) {
                throw T_Fail.testFailMsg("first page expected to be page " + lArray[2] + ", got " + page.getPageNumber() + " instead");
            }
            page.unlatch();
            page = this.t_util.t_getLastPage(containerHandle);
            if (page.getPageNumber() != lArray[n2 - 2]) {
                throw T_Fail.testFailMsg("last page expected to be page " + lArray[n2 - 2] + ", got " + page.getPageNumber() + " instead");
            }
            page.unlatch();
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(String.valueOf(new char[1500]));
            this.REPORT("start reusing pages hopefully");
            for (n = 2; n < n2 - 1; ++n) {
                T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_002);
                page = this.t_util.t_getPage(containerHandle, lArray[n]);
                while (page.spaceForInsert((Object[])t_RawStoreRow3.getRow(), (FormatableBitSet)null, 100)) {
                    T_Util.t_insert(page, t_RawStoreRow3);
                }
                RecordHandle recordHandle = page.fetchFromSlot((RecordHandle)null, 0, (Object[])t_RawStoreRow3.getRow(), (FetchDescriptor)null, true);
                int n3 = page.getSlotNumber(recordHandle);
                page.updateAtSlot(n3, (Object[])t_RawStoreRow2.getRow(), null);
                page.unlatch();
            }
            this.register(this.key(10, 1), l);
            this.register(this.key(10, 2), n2);
            for (n = 0; n < n2; ++n) {
                this.register(this.key(10, 10 + n), lArray[n]);
            }
            this.REPORT("setup S010");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R010() throws T_Fail, StandardException {
        long l = this.find(this.key(10, 1));
        if (l < 0L) {
            this.REPORT("R010 not run");
            return;
        }
        int n = (int)this.find(this.key(10, 2));
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.find(this.key(10, 10 + i));
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = containerHandle.getPage(lArray[0]);
            if (page.recordCount() == 0) {
                page.unlatch();
                throw T_Fail.testFailMsg("first page failed to get any overflow records");
            }
            page.unlatch();
            page = containerHandle.getPage(lArray[1]);
            if (page.recordCount() == 0) {
                page.unlatch();
                throw T_Fail.testFailMsg("second page failed to get any overflow records");
            }
            page.unlatch();
            page = containerHandle.getPage(lArray[n - 1]);
            if (page.recordCount() == 0) {
                page.unlatch();
                throw T_Fail.testFailMsg("last page failed to get any overflow records");
            }
            page.unlatch();
            page = containerHandle.getFirstPage();
            if (page.getPageNumber() != lArray[2]) {
                throw T_Fail.testFailMsg("first page expected to be page " + lArray[2] + ", got " + page.getPageNumber() + " instead");
            }
            long l2 = page.getPageNumber();
            this.t_util.t_checkStringLengthFetch(page, 0, 1500);
            page.unlatch();
            int n2 = 3;
            while ((page = containerHandle.getNextPage(l2)) != null) {
                l2 = page.getPageNumber();
                if (l2 != lArray[n2]) {
                    throw T_Fail.testFailMsg("expect page " + lArray[n2] + " get page " + l2);
                }
                this.t_util.t_checkStringLengthFetch(page, 0, 1500);
                page.unlatch();
                ++n2;
            }
            if (n2 != n - 1) {
                throw T_Fail.testFailMsg("expect last head page to be " + (n - 2) + " got " + n2 + " page instead");
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S011() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        int n = 10000;
        try {
            long l = this.t_util.t_addContainer(transaction, 0L, 4096);
            this.t_util.t_commit(transaction);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_insert(page, t_RawStoreRow);
            page.unlatch();
            long l2 = 1L;
            long l3 = -1L;
            for (int i = 1; i <= n; ++i) {
                page = this.t_util.t_addPage(containerHandle);
                if (page.getPageNumber() != l2 + 1L) {
                    this.REPORT("S011: skipping " + (l2 + 1L) + " going to " + page.getPageNumber());
                }
                l2 = page.getPageNumber();
                T_Util.t_insert(page, t_RawStoreRow);
                if (i == n) {
                    l3 = page.getPageNumber();
                    this.REPORT("S011: Last page number is " + l3);
                }
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = containerHandle.getFirstPage();
            if (page == null || page.getPageNumber() != 1L) {
                throw T_Fail.testFailMsg("first page not where it is expected");
            }
            page.unlatch();
            page = this.t_util.t_getLastPage(containerHandle);
            if (page == null || page.getPageNumber() != l3) {
                throw T_Fail.testFailMsg("last page not where it is expected");
            }
            page.unlatch();
            this.register(this.key(11, 1), l);
            this.register(this.key(11, 2), l3);
            this.register(this.key(11, 3), n);
            this.REPORT("setup S011, container id = " + l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R011() throws T_Fail, StandardException {
        long l = this.find(this.key(11, 1));
        if (l < 0L) {
            this.REPORT("R011 not run");
            return;
        }
        this.REPORT("R011 container id = " + l);
        long l2 = this.find(this.key(11, 2));
        int n = (int)this.find(this.key(11, 3));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l3;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = containerHandle.getFirstPage();
            if (page == null || page.getPageNumber() != 1L) {
                throw T_Fail.testFailMsg("first page not where it is expected");
            }
            page.unlatch();
            long l4 = l3 = 1L;
            int n2 = 1;
            while ((page = containerHandle.getNextPage(l3)) != null) {
                T_Util.t_checkFetchFirst(page, REC_001);
                l3 = page.getPageNumber();
                if (l3 != l4 + 1L) {
                    this.REPORT("R011: skipping " + (l4 + 1L) + " going to " + l3);
                }
                l4 = l3;
                ++n2;
                page.unlatch();
            }
            if (n2 != n + 1) {
                throw T_Fail.testFailMsg("expect to see " + (n + 1) + " pages, got: " + n2 + " last page number is " + l3);
            }
            page = this.t_util.t_getLastPage(containerHandle);
            if (page.getPageNumber() != l2) {
                throw T_Fail.testFailMsg("expect last page num to be " + l2 + " , instead got " + page.getPageNumber());
            }
            this.REPORT("Last page pagenumber is " + page.getPageNumber() + ", it is the last page of " + (n + 1) + " user pages");
            page.unlatch();
            this.PASS("R011");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S012() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L, 4096);
        this.t_util.t_commit(transaction);
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            if (containerHandle.getEstimatedPageCount(0) != 1L) {
                throw T_Fail.testFailMsg("Expect 2 user page, got " + containerHandle.getEstimatedPageCount(0));
            }
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_Util.t_insert(page, t_RawStoreRow);
            page.unlatch();
            for (int i = 2; i <= 30; ++i) {
                page = this.t_util.t_addPage(containerHandle);
                T_Util.t_insert(page, t_RawStoreRow);
                page.unlatch();
            }
            this.register(this.key(12, 1), l);
            this.REPORT("Setup S012");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R012() throws T_Fail, StandardException {
        long l = this.find(this.key(12, 1));
        if (l < 0L) {
            this.REPORT("R012 not run");
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            if (containerHandle.getEstimatedPageCount(0) != 30L) {
                throw T_Fail.testFailMsg("expect 30 pages, got " + containerHandle.getEstimatedPageCount(0));
            }
            this.PASS("R012");
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S020() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            page.unlatch();
            long l2 = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
            long l3 = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle3 = this.t_util.t_openContainer(transaction, 0L, l3, true);
            page = this.t_util.t_getPage(containerHandle2, 1L);
            page.unlatch();
            page = this.t_util.t_addPage(containerHandle2);
            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2);
            long l4 = page.getPageNumber();
            page.unlatch();
            page = this.t_util.t_getPage(containerHandle3, 1L);
            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow3);
            page.unlatch();
            this.REPORT("setup S020: container1 " + l + " container2 " + l2 + " container3 " + l3 + " page " + l4);
            this.register(this.key(20, 1), l);
            this.register(this.key(20, 2), l2);
            this.register(this.key(20, 3), l3);
            this.register(this.key(20, 4), l4);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R020() throws T_Fail, StandardException {
        long l = this.find(this.key(20, 1));
        if (l < 0L) {
            this.REPORT("R020 not run");
            return;
        }
        long l2 = this.find(this.key(20, 2));
        long l3 = this.find(this.key(20, 3));
        long l4 = this.find(this.key(20, 4));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            page.unlatch();
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l2, false);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = this.t_util.t_getPage(containerHandle, l4);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_002, false, false);
            page.unlatch();
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l3, false);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_003, false, false);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R020 container1 " + l + " container2 " + l2 + " container3 " + l3 + " page " + l4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S022() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            this.t_util.t_openContainer(transaction, 0L, l, true);
            this.t_util.t_dropContainer(transaction, 0L, l);
            this.t_util.t_abort(transaction);
            this.t_util.t_openContainer(transaction, 0L, l, true);
            this.REPORT("rollback of drop container tested");
            transaction.dropContainer(new ContainerKey(0L, l));
            transaction.commit();
            this.REPORT("setup S022: containerId " + l);
            this.register(this.key(22, 1), l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R022() throws T_Fail, StandardException {
        long l = this.find(this.key(22, 1));
        if (l < 0L) {
            this.REPORT("R022 not run");
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerKey containerKey = new ContainerKey(0L, l);
            ContainerHandle containerHandle = transaction.openContainer(containerKey, 8);
            if (containerHandle != null) {
                throw T_Fail.testFailMsg("dropped container should fail to open");
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R022 : containerId " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S100() throws T_Fail, StandardException {
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        T_TWC t_TWC2 = this.t_util.t_startTransactionWithContext();
        try {
            long l = this.t_util.t_addContainer(t_TWC, 0L);
            long l2 = this.t_util.t_addContainer(t_TWC, 0L);
            this.t_util.t_commit(t_TWC);
            long l3 = this.t_util.t_addContainer(t_TWC2, 0L);
            long l4 = this.t_util.t_addContainer(t_TWC2, 0L);
            this.t_util.t_commit(t_TWC2);
            ContainerHandle containerHandle = this.t_util.t_openContainer(t_TWC, 0L, l, true);
            ContainerHandle containerHandle2 = this.t_util.t_openContainer(t_TWC, 0L, l2, true);
            ContainerHandle containerHandle3 = this.t_util.t_openContainer(t_TWC2, 0L, l3, true);
            ContainerHandle containerHandle4 = this.t_util.t_openContainer(t_TWC2, 0L, l4, true);
            t_TWC.switchTransactionContext();
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            Page page2 = this.t_util.t_getPage(containerHandle2, 1L);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            Page page3 = this.t_util.t_getPage(containerHandle3, 1L);
            Page page4 = this.t_util.t_getPage(containerHandle4, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(3);
            t_RawStoreRow.setColumn(0, REC_001);
            t_RawStoreRow.setColumn(1, REC_002);
            t_RawStoreRow.setColumn(2, (String)null);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(2);
            t_RawStoreRow2.setColumn(0, REC_003);
            t_RawStoreRow2.setColumn(1, REC_004);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(1);
            t_RawStoreRow3.setColumn(0, REC_005);
            t_TWC2.resetContext();
            t_TWC.switchTransactionContext();
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page2, 0, t_RawStoreRow);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page3, 0, t_RawStoreRow);
            RecordHandle recordHandle4 = T_Util.t_insertAtSlot(page4, 0, t_RawStoreRow);
            t_TWC2.resetContext();
            t_TWC.switchTransactionContext();
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), null);
            int n2 = page2.getSlotNumber(recordHandle2);
            page2.updateAtSlot(n2, (Object[])t_RawStoreRow2.getRow(), null);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            int n3 = page3.getSlotNumber(recordHandle3);
            page3.updateAtSlot(n3, (Object[])t_RawStoreRow2.getRow(), null);
            int n4 = page4.getSlotNumber(recordHandle4);
            page4.updateAtSlot(n4, (Object[])t_RawStoreRow2.getRow(), null);
            t_TWC2.resetContext();
            t_TWC.switchTransactionContext();
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            n2 = page2.getSlotNumber(recordHandle2);
            page2.updateAtSlot(n2, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            page.unlatch();
            page2.unlatch();
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            n3 = page3.getSlotNumber(recordHandle3);
            page3.updateAtSlot(n3, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            n4 = page4.getSlotNumber(recordHandle4);
            page4.updateAtSlot(n4, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            page4.deleteAtSlot(n4, true, null);
            page3.unlatch();
            page4.unlatch();
            t_TWC2.resetContext();
            this.REPORT("setup S100: container1 " + l + " container2 " + l2 + " container3 " + l3 + " container4 " + l4);
            this.register(this.key(100, 1), l);
            this.register(this.key(100, 2), l2);
            this.register(this.key(100, 3), l3);
            this.register(this.key(100, 4), l4);
        }
        finally {
            this.t_util.t_commit(t_TWC);
            this.t_util.t_close(t_TWC);
            this.t_util.t_commit(t_TWC2);
            this.t_util.t_close(t_TWC2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R100() throws T_Fail, StandardException {
        long[] lArray = new long[4];
        lArray[0] = this.find(this.key(100, 1));
        if (lArray[0] < 0L) {
            this.REPORT("R100 not run");
            return;
        }
        lArray[1] = this.find(this.key(100, 2));
        lArray[2] = this.find(this.key(100, 3));
        lArray[3] = this.find(this.key(100, 4));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            for (int i = 0; i < 4; ++i) {
                ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, lArray[i], false);
                Page page = this.t_util.t_getPage(containerHandle, 1L);
                if (i == 3) {
                    T_Util.t_checkRecordCount(page, 1, 0);
                } else {
                    T_Util.t_checkRecordCount(page, 1, 1);
                }
                T_Util.t_checkFieldCount(page, 0, 2);
                SQLChar sQLChar = new SQLChar();
                T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, REC_005);
                T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_004);
                page.unlatch();
            }
            this.PASS("R100 passed: container1 " + lArray[0] + " container2 " + lArray[1] + " container3 " + lArray[2] + " container4 " + lArray[3]);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S101() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2) == null) {
                return;
            }
            T_Util.t_checkRecordCount(page, 2, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            transaction.setSavePoint(SP1, null);
            if (T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3) == null) {
                return;
            }
            page.purgeAtSlot(1, 1, true);
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow4) == null) {
                return;
            }
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            transaction.setSavePoint(SP2, null);
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow5.getRow(), null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            page.unlatch();
            transaction.rollbackToSavePoint(SP2, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow5.getRow(), null);
            page.deleteAtSlot(0, true, (LogicalUndo)null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            page.deleteAtSlot(2, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 0);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, true, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, true, false);
            page.unlatch();
            transaction.rollbackToSavePoint(SP1, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 4, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 3, REC_003, true, false);
            if (page.spaceForInsert()) {
                T_Util.t_insertAtSlot(page, 3, t_RawStoreRow5);
            }
            this.REPORT("setup S101: containerId " + l + " recordCount " + page.recordCount());
            this.register(this.key(101, 1), l);
            this.register(this.key(101, 2), page.recordCount());
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R101() throws T_Fail, StandardException {
        long l = this.find(this.key(101, 1));
        if (l < 0L) {
            this.REPORT("R101 not run");
            return;
        }
        int n = (int)this.find(this.key(101, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, n, n - 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, false);
            if (n == 5) {
                T_Util.t_checkFetchBySlot(page, 3, REC_005, false, false);
                T_Util.t_checkFetchBySlot(page, 4, REC_003, true, false);
            } else {
                T_Util.t_checkFetchBySlot(page, 3, REC_003, true, false);
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R101: containerId " + l + " recordCount " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S200() throws T_Fail, StandardException {
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        Transaction transaction = t_TWC.tran;
        Page page = null;
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            t_TWC.switchTransactionContext();
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            int n = 0;
            while (page.spaceForInsert()) {
                if (T_Util.t_insertAtSlot(page, 0, t_RawStoreRow) == null) continue;
                ++n;
            }
            T_Util.t_checkRecordCount(page, n, n);
            for (int i = 0; i < n; ++i) {
                T_Util.t_checkFetchBySlot(page, i, REC_001, false, false);
            }
            this.REPORT("setup S200: containerId " + l + " recordCount " + n);
            this.register(this.key(200, 1), l);
            this.register(this.key(200, 2), n);
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            t_TWC.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R200() throws T_Fail, StandardException {
        long l = this.find(this.key(200, 1));
        if (l < 0L) {
            this.REPORT("R200 not run");
            return;
        }
        int n = (int)this.find(this.key(200, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, n, 0);
            for (int i = 0; i < n; ++i) {
                T_Util.t_checkFetchBySlot(page, i, REC_001, true, false);
            }
            page.unlatch();
            this.PASS("R200: containerId " + l + " recordCount " + n);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S201() throws T_Fail, StandardException {
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        T_TWC t_TWC2 = this.t_util.t_startTransactionWithContext();
        Page page = null;
        Page page2 = null;
        Page page3 = null;
        Page page4 = null;
        try {
            long l = this.t_util.t_addContainer(t_TWC, 0L);
            long l2 = this.t_util.t_addContainer(t_TWC, 0L);
            long l3 = this.t_util.t_addContainer(t_TWC2, 0L);
            long l4 = this.t_util.t_addContainer(t_TWC2, 0L);
            this.t_util.t_commit(t_TWC);
            this.t_util.t_commit(t_TWC2);
            ContainerHandle containerHandle = this.t_util.t_openContainer(t_TWC, 0L, l, true);
            ContainerHandle containerHandle2 = this.t_util.t_openContainer(t_TWC, 0L, l2, true);
            ContainerHandle containerHandle3 = this.t_util.t_openContainer(t_TWC2, 0L, l3, true);
            ContainerHandle containerHandle4 = this.t_util.t_openContainer(t_TWC2, 0L, l4, true);
            t_TWC.switchTransactionContext();
            page4 = this.t_util.t_getPage(containerHandle, 1L);
            page3 = this.t_util.t_getPage(containerHandle2, 1L);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            page2 = this.t_util.t_getPage(containerHandle3, 1L);
            page = this.t_util.t_getPage(containerHandle4, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(3);
            t_RawStoreRow.setColumn(0, REC_001);
            t_RawStoreRow.setColumn(1, REC_002);
            t_RawStoreRow.setColumn(2, (String)null);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(2);
            t_RawStoreRow2.setColumn(0, REC_003);
            t_RawStoreRow2.setColumn(1, REC_004);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(1);
            t_RawStoreRow3.setColumn(0, REC_005);
            t_TWC2.resetContext();
            t_TWC.switchTransactionContext();
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page4, 0, t_RawStoreRow);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page3, 0, t_RawStoreRow);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page2, 0, t_RawStoreRow);
            RecordHandle recordHandle4 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            t_TWC2.resetContext();
            t_TWC.switchTransactionContext();
            int n = page4.getSlotNumber(recordHandle);
            page4.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), null);
            int n2 = page3.getSlotNumber(recordHandle2);
            page3.updateAtSlot(n2, (Object[])t_RawStoreRow2.getRow(), null);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            int n3 = page2.getSlotNumber(recordHandle3);
            page2.updateAtSlot(n3, (Object[])t_RawStoreRow2.getRow(), null);
            int n4 = page.getSlotNumber(recordHandle4);
            page.updateAtSlot(n4, (Object[])t_RawStoreRow2.getRow(), null);
            t_TWC2.resetContext();
            t_TWC.switchTransactionContext();
            n = page4.getSlotNumber(recordHandle);
            page4.updateAtSlot(n, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            n2 = page3.getSlotNumber(recordHandle2);
            page3.updateAtSlot(n2, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            n3 = page2.getSlotNumber(recordHandle3);
            page2.updateAtSlot(n3, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            n4 = page.getSlotNumber(recordHandle4);
            page.updateAtSlot(n4, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
            page.deleteAtSlot(n4, true, null);
            t_TWC2.resetContext();
            this.REPORT("setup S201: container1 " + l + " container2 " + l2 + " container3 " + l3 + " container4 " + l4);
            this.register(this.key(201, 1), l);
            this.register(this.key(201, 2), l2);
            this.register(this.key(201, 3), l3);
            this.register(this.key(201, 4), l4);
        }
        finally {
            if (page4 != null && page4.isLatched()) {
                page4.unlatch();
            }
            if (page3 != null && page3.isLatched()) {
                page3.unlatch();
            }
            if (page2 != null && page2.isLatched()) {
                page2.unlatch();
            }
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R201() throws T_Fail, StandardException {
        long[] lArray = new long[4];
        lArray[0] = this.find(this.key(201, 1));
        if (lArray[0] < 0L) {
            this.REPORT("R201 not run");
            return;
        }
        lArray[1] = this.find(this.key(201, 2));
        lArray[2] = this.find(this.key(201, 3));
        lArray[3] = this.find(this.key(201, 4));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            for (int i = 0; i < 4; ++i) {
                ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, lArray[i], false);
                Page page = this.t_util.t_getPage(containerHandle, 1L);
                T_Util.t_checkRecordCount(page, 1, 0);
                SQLChar sQLChar = new SQLChar();
                T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, REC_001);
                T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_002);
                T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, null);
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R201 passed:  container1 " + lArray[0] + " container2 " + lArray[1] + " container3 " + lArray[2] + " container4 " + lArray[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S202() throws T_Fail, StandardException {
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        Transaction transaction = t_TWC.tran;
        Page page = null;
        t_TWC.switchTransactionContext();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2) == null) {
                page.unlatch();
                this.t_util.t_abort(transaction);
                transaction.close();
                return;
            }
            transaction.setSavePoint(SP1, null);
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow5.getRow(), null);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            page.unlatch();
            transaction.rollbackToSavePoint(SP1, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            if (T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3) == null) {
                page.unlatch();
                this.t_util.t_abort(transaction);
                transaction.close();
                return;
            }
            page.purgeAtSlot(1, 1, true);
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow4) == null) {
                page.unlatch();
                this.t_util.t_abort(transaction);
                transaction.close();
                return;
            }
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            transaction.setSavePoint(SP2, null);
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow5.getRow(), null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            page.unlatch();
            transaction.rollbackToSavePoint(SP2, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow5.getRow(), null);
            page.deleteAtSlot(0, true, (LogicalUndo)null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            page.deleteAtSlot(2, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 0);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, true, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, true, false);
            page.unlatch();
            transaction.rollbackToSavePoint(SP1, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 4, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 3, REC_003, true, false);
            if (page.spaceForInsert()) {
                T_Util.t_insertAtSlot(page, 3, t_RawStoreRow5);
            }
            this.REPORT("setup S202: containerId " + l + " recordCount " + page.recordCount());
            this.register(this.key(202, 1), l);
            this.register(this.key(202, 2), page.recordCount());
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            t_TWC.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R202() throws T_Fail, StandardException {
        long l = this.find(this.key(202, 1));
        if (l < 0L) {
            this.REPORT("R202 not run");
            return;
        }
        int n = (int)this.find(this.key(202, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        Page page = null;
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, n, 0);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, true, true);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, true, true);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, true);
            if (n == 5) {
                T_Util.t_checkFetchBySlot(page, 3, REC_005, true, true);
                T_Util.t_checkFetchBySlot(page, 4, REC_003, true, true);
            } else {
                T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
            }
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R202: containerId " + l + " recordCount " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S203() throws T_Fail, StandardException {
        int n;
        int n2;
        int n3 = 5;
        int n4 = 2;
        T_TWC[] t_TWCArray = new T_TWC[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            t_TWCArray[n2] = this.t_util.t_startTransactionWithContext();
        }
        Page[][] pageArray = null;
        try {
            long[] lArray = new long[n3];
            ContainerHandle[] containerHandleArray = new ContainerHandle[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = this.t_util.t_addContainer(t_TWCArray[n2], 0L);
                this.t_util.t_commit(t_TWCArray[n2]);
                containerHandleArray[n2] = this.t_util.t_openContainer(t_TWCArray[n2], 0L, lArray[n2], true);
            }
            pageArray = new Page[n3][n4];
            long[][] lArray2 = new long[n3][n4];
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    t_TWCArray[n2].switchTransactionContext();
                    pageArray[n2][n] = this.t_util.t_addPage(containerHandleArray[n2]);
                    lArray2[n2][n] = pageArray[n2][n].getPageNumber();
                    t_TWCArray[n2].resetContext();
                }
            }
            RecordHandle[][] recordHandleArray = new RecordHandle[n3][n4];
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    t_TWCArray[n2].switchTransactionContext();
                    recordHandleArray[n2][n] = T_Util.t_insert(pageArray[n2][n], t_RawStoreRow);
                    t_TWCArray[n2].resetContext();
                }
            }
            t_TWCArray[0].switchTransactionContext();
            t_TWCArray[0].setSavePoint(SP1, null);
            t_TWCArray[0].resetContext();
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    t_TWCArray[n2].switchTransactionContext();
                    int n5 = pageArray[n2][n].getSlotNumber(recordHandleArray[n2][n]);
                    pageArray[n2][n].updateAtSlot(n5, (Object[])t_RawStoreRow2.getRow(), null);
                    t_TWCArray[n2].resetContext();
                }
            }
            for (n2 = 1; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                t_TWCArray[n2].setSavePoint(SP1, null);
                t_TWCArray[n2].resetContext();
            }
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    int n6 = pageArray[n2][n].getSlotNumber(recordHandleArray[n2][n]);
                    pageArray[n2][n].updateAtSlot(n6, (Object[])t_RawStoreRow3.getRow(), null);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                t_TWCArray[n2].setSavePoint(SP2, null);
            }
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            for (n2 = 0; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    int n7 = pageArray[n2][n].getSlotNumber(recordHandleArray[n2][n]);
                    pageArray[n2][n].updateAtSlot(n7, (Object[])t_RawStoreRow4.getRow(), null);
                }
                t_TWCArray[n2].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n = 0; n < n4; ++n) {
                pageArray[0][n].unlatch();
            }
            t_TWCArray[0].rollbackToSavePoint(SP1, null);
            for (n = 0; n < n4; ++n) {
                pageArray[0][n] = this.t_util.t_getPage(containerHandleArray[0], lArray2[0][n]);
            }
            t_TWCArray[0].resetContext();
            for (n2 = 1; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    T_Util.t_checkFetch(pageArray[n2][n], recordHandleArray[n2][n], REC_004);
                }
                t_TWCArray[n2].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n = 0; n < n4; ++n) {
                T_Util.t_checkFetch(pageArray[0][n], recordHandleArray[0][n], REC_001);
            }
            t_TWCArray[0].resetContext();
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            for (n2 = 0; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    int n8 = pageArray[n2][n].getSlotNumber(recordHandleArray[n2][n]);
                    pageArray[n2][n].updateAtSlot(n8, (Object[])t_RawStoreRow5.getRow(), null);
                }
                t_TWCArray[n2].resetContext();
            }
            for (n2 = 1; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    pageArray[n2][n].unlatch();
                }
                t_TWCArray[n2].rollbackToSavePoint(SP2, null);
                for (n = 0; n < n4; ++n) {
                    pageArray[n2][n] = this.t_util.t_getPage(containerHandleArray[n2], lArray2[n2][n]);
                }
                t_TWCArray[n2].resetContext();
            }
            for (n2 = 1; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    T_Util.t_checkFetch(pageArray[n2][n], recordHandleArray[n2][n], REC_003);
                }
                t_TWCArray[n2].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n = 0; n < n4; ++n) {
                T_Util.t_checkFetch(pageArray[0][n], recordHandleArray[0][n], REC_005);
            }
            t_TWCArray[0].resetContext();
            T_RawStoreRow t_RawStoreRow6 = new T_RawStoreRow(REC_006);
            for (n2 = 0; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    int n9 = pageArray[n2][n].getSlotNumber(recordHandleArray[n2][n]);
                    pageArray[n2][n].updateAtSlot(n9, (Object[])t_RawStoreRow6.getRow(), null);
                }
                t_TWCArray[n2].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n = 0; n < n4; ++n) {
                pageArray[0][n].unlatch();
            }
            t_TWCArray[0].rollbackToSavePoint(SP1, null);
            for (n = 0; n < n4; ++n) {
                pageArray[0][n] = this.t_util.t_getPage(containerHandleArray[0], lArray2[0][n]);
            }
            t_TWCArray[0].resetContext();
            for (n2 = 1; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    T_Util.t_checkFetch(pageArray[n2][n], recordHandleArray[n2][n], REC_006);
                    T_Util.t_checkRecordCount(pageArray[n2][n], 1, 1);
                }
                t_TWCArray[n2].resetContext();
            }
            t_TWCArray[0].switchTransactionContext();
            for (n = 0; n < n4; ++n) {
                T_Util.t_checkFetch(pageArray[0][n], recordHandleArray[0][n], REC_001);
                T_Util.t_checkRecordCount(pageArray[0][n], 1, 1);
            }
            t_TWCArray[0].resetContext();
            for (n2 = 0; n2 < n3; ++n2) {
                t_TWCArray[n2].switchTransactionContext();
                for (n = 0; n < n4; ++n) {
                    pageArray[n2][n].unlatch();
                }
                t_TWCArray[n2].resetContext();
            }
            this.t_util.t_abort(t_TWCArray[1]);
            this.t_util.t_commit(t_TWCArray[2]);
            this.t_util.t_commit(t_TWCArray[4]);
            containerHandleArray[1] = this.t_util.t_openContainer(t_TWCArray[1], 0L, lArray[1], false);
            containerHandleArray[2] = this.t_util.t_openContainer(t_TWCArray[2], 0L, lArray[2], false);
            containerHandleArray[4] = this.t_util.t_openContainer(t_TWCArray[4], 0L, lArray[4], false);
            for (n = 0; n < n4; ++n) {
                t_TWCArray[0].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[0], recordHandleArray[0][n], REC_001);
                t_TWCArray[0].resetContext();
                t_TWCArray[1].switchTransactionContext();
                pageArray[1][n] = this.t_util.t_getPage(containerHandleArray[1], lArray2[1][n]);
                T_Util.t_checkRecordCount(pageArray[1][n], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[1][n], 0, REC_001, true, false);
                pageArray[1][n].unlatch();
                t_TWCArray[1].resetContext();
                t_TWCArray[2].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[2], recordHandleArray[2][n], REC_006);
                t_TWCArray[2].resetContext();
                t_TWCArray[3].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[3], recordHandleArray[3][n], REC_006);
                t_TWCArray[3].resetContext();
                t_TWCArray[4].switchTransactionContext();
                this.t_util.t_checkFetch(containerHandleArray[4], recordHandleArray[4][n], REC_006);
                t_TWCArray[4].resetContext();
            }
            this.REPORT("setup S203: numtrans " + n3 + " numpages " + n4);
            for (n2 = 0; n2 < n3; ++n2) {
                String string = "container " + n2 + ":" + lArray[n2] + " pages: ";
                this.register(this.key(203, n2 + 10), lArray[n2]);
                for (n = 0; n < n4; ++n) {
                    string = string + lArray2[n2][n] + " ";
                    this.register(this.key(203, (n2 + 1) * 1000 + n), lArray2[n2][n]);
                }
                this.REPORT("\t" + string);
            }
            this.register(this.key(203, 1), n3);
            this.register(this.key(203, 2), n4);
        }
        finally {
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    if (pageArray == null || pageArray[n2][n] == null || !pageArray[n2][n].isLatched()) continue;
                    pageArray[n2][n].unlatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R203() throws T_Fail, StandardException {
        int n = (int)this.find(this.key(203, 1));
        int n2 = (int)this.find(this.key(203, 2));
        if (n < 5 || n2 < 1) {
            this.REPORT("R203 not run");
            return;
        }
        this.REPORT("R203 started, numtrans " + n + " numpages " + n2);
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n3;
            int n4;
            long[] lArray = new long[n];
            ContainerHandle[] containerHandleArray = new ContainerHandle[n];
            long[][] lArray2 = new long[n][n2];
            Page[][] pageArray = new Page[n][n2];
            for (n4 = 0; n4 < n; ++n4) {
                lArray[n4] = this.find(this.key(203, n4 + 10));
                containerHandleArray[n4] = this.t_util.t_openContainer(transaction, 0L, lArray[n4], true);
                for (n3 = 0; n3 < n2; ++n3) {
                    lArray2[n4][n3] = this.find(this.key(203, (n4 + 1) * 1000 + n3));
                    pageArray[n4][n3] = this.t_util.t_getPage(containerHandleArray[n4], lArray2[n4][n3]);
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                T_Util.t_checkRecordCount(pageArray[0][n3], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[0][n3], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[1][n3], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[1][n3], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[2][n3], 1, 1);
                T_Util.t_checkFetchBySlot(pageArray[2][n3], 0, REC_006, false, true);
                T_Util.t_checkRecordCount(pageArray[3][n3], 1, 0);
                T_Util.t_checkFetchBySlot(pageArray[3][n3], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(pageArray[4][n3], 1, 1);
                T_Util.t_checkFetchBySlot(pageArray[4][n3], 0, REC_006, false, true);
            }
            for (n4 = 0; n4 < n; ++n4) {
                String string = "container " + n4 + ":" + lArray[n4] + " pages: ";
                for (n3 = 0; n3 < n2; ++n3) {
                    string = string + lArray2[n4][n3] + " ";
                }
                this.REPORT("\t" + string);
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R203: numtrans " + n + " numpages " + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S204() throws T_Fail, StandardException {
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        T_TWC t_TWC2 = this.t_util.t_startTransactionWithContext();
        Page page = null;
        Page page2 = null;
        Page page3 = null;
        Page page4 = null;
        Page page5 = null;
        try {
            long l = this.t_util.t_addContainer(t_TWC, 0L);
            long l2 = this.t_util.t_addContainer(t_TWC, 0L);
            this.t_util.t_commit(t_TWC);
            long l3 = this.t_util.t_addContainer(t_TWC2, 0L);
            long l4 = this.t_util.t_addContainer(t_TWC2, 0L);
            this.t_util.t_commit(t_TWC2);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            t_TWC.switchTransactionContext();
            ContainerHandle containerHandle = this.t_util.t_openContainer(t_TWC, 0L, l, true);
            page5 = this.t_util.t_addPage(containerHandle);
            RecordHandle recordHandle = T_Util.t_insert(page5, t_RawStoreRow);
            Transaction transaction = this.t_util.t_startInternalTransaction();
            ContainerHandle containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
            page4 = this.t_util.t_addPage(containerHandle2);
            RecordHandle recordHandle2 = T_Util.t_insert(page4, t_RawStoreRow);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            ContainerHandle containerHandle3 = this.t_util.t_openContainer(t_TWC2, 0L, l3, true);
            page3 = this.t_util.t_addPage(containerHandle3);
            RecordHandle recordHandle3 = T_Util.t_insert(page3, t_RawStoreRow);
            Transaction transaction2 = this.t_util.t_startInternalTransaction();
            ContainerHandle containerHandle4 = this.t_util.t_openContainer(transaction2, 0L, l4, true);
            page2 = this.t_util.t_addPage(containerHandle4);
            RecordHandle recordHandle4 = T_Util.t_insert(page2, t_RawStoreRow);
            t_TWC2.resetContext();
            t_TWC.switchTransactionContext();
            transaction.commit();
            T_Util.t_checkFetch(page4, recordHandle2, REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            RecordHandle recordHandle5 = T_Util.t_insert(page4, t_RawStoreRow2);
            T_Util.t_checkFetch(page4, recordHandle5, REC_002);
            t_TWC.resetContext();
            t_TWC2.switchTransactionContext();
            transaction2.abort();
            containerHandle4 = this.t_util.t_openContainer(transaction2, 0L, l4, true);
            page2 = this.t_util.t_getLastPage(containerHandle4);
            RecordHandle recordHandle6 = T_Util.t_insert(page2, t_RawStoreRow2);
            t_TWC2.resetContext();
            T_TWC t_TWC3 = this.t_util.t_startTransactionWithContext();
            long l5 = this.t_util.t_addContainer(t_TWC3, 0L);
            this.t_util.t_commit(t_TWC3);
            ContainerHandle containerHandle5 = this.t_util.t_openContainer(t_TWC3, 0L, l5, true);
            t_TWC3.switchTransactionContext();
            page = this.t_util.t_addPage(containerHandle5);
            RecordHandle recordHandle7 = T_Util.t_insert(page, t_RawStoreRow);
            t_TWC3.resetContext();
            this.register(this.key(204, 10), l);
            this.register(this.key(204, 11), l2);
            this.register(this.key(204, 20), l3);
            this.register(this.key(204, 21), l4);
            this.register(this.key(204, 30), l5);
            this.REPORT("setup S204: cid10 " + l + ", cid11 " + l2 + ", cid20 " + l3 + ", cid21 " + l4 + ", cid30 " + l5);
        }
        finally {
            if (page5 != null && page5.isLatched()) {
                page5.unlatch();
            }
            if (page4 != null && page4.isLatched()) {
                page4.unlatch();
            }
            if (page3 != null && page3.isLatched()) {
                page3.unlatch();
            }
            if (page2 != null && page2.isLatched()) {
                page2.unlatch();
            }
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R204() throws T_Fail, StandardException {
        long l = this.find(this.key(204, 10));
        if (l < 0L) {
            this.REPORT("R204 not run");
            return;
        }
        long l2 = this.find(this.key(204, 11));
        long l3 = this.find(this.key(204, 20));
        long l4 = this.find(this.key(204, 21));
        long l5 = this.find(this.key(204, 30));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getLastPage(containerHandle);
            T_Util.t_checkRecordCount(page, 1, 0);
            page.unlatch();
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l2, false);
            page = this.t_util.t_getLastPage(containerHandle);
            T_Util.t_checkRecordCount(page, 2, 1);
            page.unlatch();
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l3, false);
            page = this.t_util.t_getLastPage(containerHandle);
            T_Util.t_checkRecordCount(page, 1, 0);
            page.unlatch();
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l4, false);
            page = this.t_util.t_getLastPage(containerHandle);
            T_Util.t_checkRecordCount(page, 2, 0);
            page.unlatch();
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l5, false);
            page = this.t_util.t_getLastPage(containerHandle);
            T_Util.t_checkRecordCount(page, 1, 0);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R204 passed: cid10 " + l + ", cid11 " + l2 + ", cid20 " + l3 + ", cid21 " + l4 + ", cid30 " + l5);
    }

    protected void S300() throws T_Fail, StandardException {
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        Transaction transaction = t_TWC.tran;
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            this.t_util.t_openContainer(transaction, 0L, l, true);
            this.t_util.t_dropContainer(transaction, 0L, l);
            this.REPORT("setup S300: containerId " + l);
            this.register(this.key(300, 1), l);
        }
        catch (StandardException standardException) {
            this.t_util.t_abort(transaction);
            transaction.close();
            throw standardException;
        }
        catch (T_Fail t_Fail) {
            this.t_util.t_abort(transaction);
            transaction.close();
            throw t_Fail;
        }
    }

    protected void R300() throws T_Fail, StandardException {
        long l = this.find(this.key(300, 1));
        if (l < 0L) {
            this.REPORT("R300 not run");
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        this.t_util.t_openContainer(transaction, 0L, l, true);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("R300 : containerId " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S301() throws T_Fail, StandardException {
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        Transaction transaction = t_TWC.tran;
        Page page = null;
        t_TWC.switchTransactionContext();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_addPage(containerHandle);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            transaction.abort();
            ContainerKey containerKey = new ContainerKey(0L, l);
            containerHandle = transaction.openContainer(containerKey, 8);
            if (containerHandle != null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            LockingPolicy lockingPolicy = transaction.newLockingPolicy(0, 0, false);
            RawContainerHandle rawContainerHandle = ((RawTransaction)transaction).openDroppedContainer(new ContainerKey(0L, l), lockingPolicy);
            if (rawContainerHandle != null && rawContainerHandle.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
            long l2 = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
            page = this.t_util.t_addPage(containerHandle2);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            RecordHandle recordHandle2 = T_Util.t_insert(page, t_RawStoreRow2);
            this.REPORT("setup S301: cid1 " + l + " cid2 " + l2);
            this.register(this.key(301, 1), l);
            this.register(this.key(301, 2), l2);
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            t_TWC.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R301() throws T_Fail, StandardException {
        long l = this.find(this.key(301, 1));
        if (l < 0L) {
            this.REPORT("R301 not run");
            return;
        }
        long l2 = this.find(this.key(301, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            LockingPolicy lockingPolicy = transaction.newLockingPolicy(0, 0, false);
            ContainerKey containerKey = new ContainerKey(0L, l);
            ContainerHandle containerHandle = transaction.openContainer(containerKey, 8);
            if (containerHandle != null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            RawContainerHandle rawContainerHandle = ((RawTransaction)transaction).openDroppedContainer(containerKey, lockingPolicy);
            if (rawContainerHandle != null && rawContainerHandle.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
            ContainerKey containerKey2 = new ContainerKey(0L, l2);
            containerHandle = transaction.openContainer(containerKey2, 8);
            if (containerHandle != null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            rawContainerHandle = ((RawTransaction)transaction).openDroppedContainer(containerKey2, lockingPolicy);
            if (rawContainerHandle != null && rawContainerHandle.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R301 : cid1 " + l + " cid2 " + l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S302() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            RecordHandle recordHandle;
            RecordHandle recordHandle2;
            RecordHandle recordHandle3;
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            long l2 = 0L;
            RecordHandle recordHandle4 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            RecordHandle recordHandle5 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
            RecordHandle recordHandle6 = recordHandle5 == null ? recordHandle5 : (recordHandle3 = T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3));
            RecordHandle recordHandle7 = recordHandle3 == null ? recordHandle3 : (recordHandle2 = T_Util.t_insertAtSlot(page, 3, t_RawStoreRow4));
            RecordHandle recordHandle8 = recordHandle2 == null ? recordHandle2 : (recordHandle = T_Util.t_insertAtSlot(page, 4, t_RawStoreRow5));
            if (recordHandle != null) {
                int n = page.getSlotNumber(recordHandle);
                page.deleteAtSlot(n, true, null);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            page.purgeAtSlot(0, 1, false);
            page.purgeAtSlot(0, 3, false);
            this.t_util.t_abort(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            page.purgeAtSlot(0, 1, false);
            ++l2;
            if (recordHandle != null) {
                page.purgeAtSlot(0, 2, false);
                l2 += 2L;
            }
            this.REPORT("setup S302: containerId " + l + " recordCount " + page.recordCount() + " numPurges " + l2);
            this.register(this.key(302, 1), l);
            this.register(this.key(302, 2), page.recordCount());
            this.register(this.key(302, 3), l2);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R302() throws T_Fail, StandardException {
        long l = this.find(this.key(302, 1));
        if (l < 0L) {
            this.REPORT("R302 not run");
            return;
        }
        int n = (int)this.find(this.key(302, 2));
        int n2 = (int)this.find(this.key(302, 3));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, n, 1);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
            T_Util.t_checkFetchBySlot(page, 1, REC_005, true, false);
            if (!page.isDeletedAtSlot(1)) {
                throw T_Fail.testFailMsg("record should be deleted");
            }
            T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, false);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R302: containerId " + l + " recordCount " + n + " numPurges " + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S303() throws StandardException, T_Fail {
        this.REPORT("START S303");
        long l = 0L;
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        Transaction transaction = t_TWC.tran;
        t_TWC.switchTransactionContext();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(1);
            t_RawStoreRow.setColumn(0, 5000, REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(6);
            t_RawStoreRow2.setColumn(0, 1600, REC_001);
            t_RawStoreRow2.setColumn(1, 4000, REC_002);
            t_RawStoreRow2.setColumn(2, 1600, REC_001);
            t_RawStoreRow2.setColumn(3, 4000, REC_002);
            t_RawStoreRow2.setColumn(4, 1600, REC_001);
            t_RawStoreRow2.setColumn(5, 4000, REC_002);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)n);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            if (recordHandle3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.REPORT("S303 - Nextpage is " + l3);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, false);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_abort(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            int n2 = page.getSlotNumber(recordHandle);
            int n3 = page.getSlotNumber(recordHandle2);
            page.purgeAtSlot(0, 2, false);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.REPORT("S303 - Purged Slots" + n2 + "," + n3);
            this.register(this.key(303, 1), l2);
            this.register(this.key(303, 2), n2);
            this.register(this.key(303, 3), n3);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            t_TWC.resetContext();
        }
        this.PASS("S303");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R303() throws T_Fail, StandardException {
        long l = this.find(this.key(303, 1));
        if (l < 0L) {
            this.REPORT("R303 not run");
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            int n = (int)this.find(this.key(303, 2));
            int n2 = (int)this.find(this.key(303, 3));
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(1);
            t_RawStoreRow.setColumn(0, 5000, REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(6);
            t_RawStoreRow2.setColumn(0, 4, REC_NULL);
            t_RawStoreRow2.setColumn(1, 4000, REC_002);
            t_RawStoreRow2.setColumn(2, 1600, REC_001);
            t_RawStoreRow2.setColumn(3, 4000, REC_002);
            t_RawStoreRow2.setColumn(4, 1600, REC_001);
            t_RawStoreRow2.setColumn(5, 4000, REC_002);
            RecordHandle recordHandle = page.getRecordHandleAtSlot(n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            RecordHandle recordHandle2 = page.getRecordHandleAtSlot(n2);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            page.purgeAtSlot(0, 2, false);
            page.unlatch();
            page = null;
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R303");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S304() throws StandardException, T_Fail {
        long l = 0L;
        T_TWC t_TWC = this.t_util.t_startTransactionWithContext();
        Transaction transaction = t_TWC.tran;
        t_TWC.switchTransactionContext();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(100);
            for (int i = 0; i < 100; ++i) {
                t_RawStoreRow.setColumn(i, 100 + i, REC_001);
            }
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, false);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.register(this.key(304, 1), l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            t_TWC.resetContext();
        }
        this.PASS("S304");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R304() throws T_Fail, StandardException {
        long l = this.find(this.key(304, 1));
        if (l < 0L) {
            this.REPORT("R304 not run");
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            int n;
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(100);
            for (n = 0; n < 18; ++n) {
                t_RawStoreRow.setColumn(n, 4, REC_NULL);
            }
            for (n = 18; n < 100; ++n) {
                t_RawStoreRow.setColumn(n, 100 + n, REC_001);
            }
            RecordHandle recordHandle = page.getRecordHandleAtSlot(0);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            page.purgeAtSlot(0, 1, false);
            page.unlatch();
            page = null;
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R304");
    }

    protected void S999() throws T_Fail, StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R999() throws StandardException, T_Fail {
        long l = this.find(this.key(999, 1));
        if (l < 0L) {
            this.REPORT("R999 not run");
            return;
        }
        long l2 = this.find(this.key(999, 2));
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_getPage(containerHandle, l2);
            T_Util.t_checkRecordCount(page, 2, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, true, false);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("R999: cid " + l + " page " + l2);
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object findService(String string, String string2) {
        return Monitor.findService((String)string, (String)string2);
    }

    private static boolean startPersistentService(String string, Properties properties) throws StandardException {
        return Monitor.startPersistentService((String)string, (Properties)properties);
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }
}

