/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ReadMeFilesTest
extends BaseJDBCTestCase {
    private static final String DB_README_FILE_NAME = "README_DO_NOT_TOUCH_FILES.txt";
    static String logDir = BaseTestCase.getSystemProperty("derby.system.home") + File.separator + "abcs";

    public ReadMeFilesTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ReadMeFilesTest");
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(TestConfiguration.embeddedSuite(ReadMeFilesTest.class)));
        logDir = BaseTestCase.getSystemProperty("derby.system.home") + File.separator + "abcs";
        suite.addTest(Decorator.logDeviceAttributeDatabase(TestConfiguration.embeddedSuite(ReadMeFilesTest.class), logDir));
        return suite;
    }

    public void testReadMeFilesExist() throws IOException, SQLException {
        this.getConnection();
        TestConfiguration currentConfig = TestConfiguration.getCurrent();
        String dbPath = currentConfig.getDatabasePath(currentConfig.getDefaultDatabaseName());
        this.lookForReadmeFile(dbPath);
        this.lookForReadmeFile(dbPath + File.separator + "seg0");
        String logDevice = currentConfig.getConnectionAttributes().getProperty("logDevice");
        if (logDevice != null) {
            this.lookForReadmeFile(logDir + File.separator + "log");
        } else {
            this.lookForReadmeFile(dbPath + File.separator + "log");
        }
    }

    private void lookForReadmeFile(String path) throws IOException {
        File readmeFile = new File(path, DB_README_FILE_NAME);
        ReadMeFilesTest.assertTrue((String)(String.valueOf(readmeFile) + "doesn't exist"), (boolean)PrivilegedFileOpsForTests.exists(readmeFile));
    }
}

