/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.dubbo.rpc.protocol.dubbo.decode;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;

import java.net.InetSocketAddress;
import java.util.function.Consumer;

public class MockChannel implements Channel {
    private Consumer consumer;

    public MockChannel() {}

    public MockChannel(Consumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(NetUtils.getAvailablePort());
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public boolean hasAttribute(String key) {
        return false;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {}

    @Override
    public void removeAttribute(String key) {}

    @Override
    public URL getUrl() {
        return new ServiceConfigURL("dubbo", "localhost", 20880);
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return null;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(20883);
    }

    @Override
    public void send(Object message) throws RemotingException {
        if (consumer != null) {
            consumer.accept(message);
        }
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {}

    @Override
    public void close() {}

    @Override
    public void close(int timeout) {}

    @Override
    public void startClose() {}

    @Override
    public boolean isClosed() {
        return false;
    }
}
