/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class NumberCompiledPattern
extends CompiledPattern {
    private final Function<ZonedDateTime, Integer> dateTimeToIntConverter;
    private final Function<Integer, Integer> valueAdjuster;
    private final int minCharacters;
    private final int maxCharacters;
    private final int minValue;
    private final int maxValue;
    private final String pattern;

    public NumberCompiledPattern(ChronoUnitEnum chronoUnit, Function<ZonedDateTime, Integer> dateTimeToIntConverter, Function<Integer, Integer> valueAdjuster, int minCharacters, int maxCharacters, int minValue, int maxValue, String pattern, Set<PatternModifier> modifiers) {
        super(chronoUnit, modifiers);
        this.dateTimeToIntConverter = dateTimeToIntConverter;
        this.valueAdjuster = valueAdjuster;
        this.minCharacters = minCharacters;
        this.maxCharacters = maxCharacters;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.pattern = pattern;
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        long intValue = this.dateTimeToIntConverter.apply(dateTime).intValue();
        String signPrefix = intValue < 0L ? "-" : "";
        String stringValue = !this.modifiers.contains((Object)PatternModifier.FM) && this.minCharacters > 0 ? String.format(Locale.ROOT, signPrefix + "%0" + this.minCharacters + "d", Math.abs(intValue)) : Long.toString(intValue);
        if (this.maxCharacters > 0 && stringValue.length() - signPrefix.length() > this.maxCharacters) {
            stringValue = stringValue.substring(stringValue.length() - this.maxCharacters);
        }
        if (this.modifiers.contains((Object)PatternModifier.TH_UPPER)) {
            return stringValue + this.getOrdinalSuffix(stringValue).toUpperCase(Locale.ROOT);
        }
        if (this.modifiers.contains((Object)PatternModifier.TH_LOWER)) {
            return stringValue + this.getOrdinalSuffix(stringValue);
        }
        return stringValue;
    }

    private String getOrdinalSuffix(String stringValue) {
        if (stringValue.length() >= 2 && stringValue.charAt(stringValue.length() - 2) == '1') {
            return "th";
        }
        switch (stringValue.charAt(stringValue.length() - 1)) {
            case '1': {
                return "st";
            }
            case '2': {
                return "nd";
            }
            case '3': {
                return "rd";
            }
        }
        return "th";
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        int endIndex;
        for (endIndex = inputPosition.getIndex(); !(endIndex >= input.length() || input.charAt(endIndex) < '0' || input.charAt(endIndex) > '9' || enforceLength && endIndex == inputPosition.getIndex() + this.minCharacters); ++endIndex) {
        }
        if (this.modifiers.contains((Object)PatternModifier.TH_UPPER) || this.modifiers.contains((Object)PatternModifier.TH_LOWER)) {
            if (endIndex < input.length() - 1) {
                endIndex += 2;
            } else if (endIndex < input.length()) {
                ++endIndex;
            }
        }
        if (endIndex == inputPosition.getIndex()) {
            throw new ParseException("Unable to parse value", inputPosition.getIndex());
        }
        int value = Integer.parseInt(input.substring(inputPosition.getIndex(), endIndex));
        if (value < this.minValue || value > this.maxValue) {
            throw new ParseException("Parsed value outside of valid range", inputPosition.getIndex());
        }
        value = this.valueAdjuster.apply(value);
        inputPosition.setIndex(endIndex);
        return value;
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return this.pattern.length();
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

