/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.internal.misc.Signal;
import org.apache.ignite.IgniteServer;
import org.apache.ignite.internal.app.EnvironmentDefaultValueProvider;
import picocli.CommandLine;

@CommandLine.Command(name="runner")
public class IgniteRunner
implements Callable<IgniteServer> {
    @CommandLine.Option(names={"--config-path"}, description={"Path to node configuration file in HOCON format."}, required=true)
    private Path configPath;
    @CommandLine.Option(names={"--work-dir"}, description={"Path to node working directory."}, required=true)
    private Path workDir;
    @CommandLine.Option(names={"--node-name"}, description={"Node name."}, required=true)
    private String nodeName;

    @Override
    public IgniteServer call() throws Exception {
        return IgniteServer.start(this.nodeName, this.configPath.toAbsolutePath(), this.workDir);
    }

    public static IgniteServer start(String ... args) {
        CommandLine commandLine = new CommandLine((Object)new IgniteRunner());
        commandLine.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new EnvironmentDefaultValueProvider());
        int exitCode = commandLine.execute(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        return (IgniteServer)commandLine.getExecutionResult();
    }

    public static void main(String[] args) {
        block2: {
            IgniteServer server = IgniteRunner.start(args);
            AtomicBoolean shutdown = new AtomicBoolean(false);
            Signal.Handler handler = sig -> {
                try {
                    System.out.println("Ignite node shutting down...");
                    shutdown.set(true);
                    server.shutdown();
                }
                catch (Throwable t) {
                    System.out.println("Failed to shutdown: " + t.getMessage());
                    t.printStackTrace(System.out);
                }
                System.exit(sig.getNumber() + 128);
            };
            Signal.handle(new Signal("INT"), handler);
            Signal.handle(new Signal("TERM"), handler);
            try {
                server.waitForInitAsync().get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (shutdown.get()) break block2;
                System.out.println("Error when starting the node: " + e.getMessage());
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
    }
}

