/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.WriteContext;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.TupleStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.lang.IgniteTriConsumer;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientRecordBinaryView
extends AbstractClientView<Tuple>
implements RecordView<Tuple> {
    private final ClientTupleSerializer ser;

    ClientRecordBinaryView(ClientTable tbl, ClientSql sql) {
        super(tbl, sql);
        this.ser = new ClientTupleSerializer(tbl.tableId());
    }

    public Tuple get(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    public List<Tuple> getAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    public CompletableFuture<List<Tuple>> getAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, (String)"keyRecs", (String)"key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(15, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuplesNullable(s, r.in()), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keyRecs, ClientTupleSerializer.getPartitionAwarenessProvider(keyRecs.iterator().next()));
        }
        return this.tbl.split(tx, keyRecs, clo, ClientTupleSerializer::getColocationHash);
    }

    public boolean contains(@Nullable Transaction tx, Tuple key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, Tuple key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(key), tx);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<Tuple> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<Tuple> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutOpAsync(67, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keys, ClientTupleSerializer.getPartitionAwarenessProvider(keys.iterator().next()));
        }
        return this.tbl.split(tx, keys, clo, Boolean.TRUE, (agg, cur) -> agg != false && cur != false, ClientTupleSerializer::getColocationHash);
    }

    public void upsert(@Nullable Transaction tx, Tuple rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n)), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public void upsertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutOpAsync(13, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> null, (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()));
        }
        return this.tbl.split(tx, recs, clo, null, (agg, cur) -> null, ClientTupleSerializer::getColocationHash);
    }

    public Tuple getAndUpsert(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public boolean insert(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.insertAsync(tx, rec));
    }

    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public List<Tuple> insertAll(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> insertAllAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        ViewUtils.checkCollectionForNulls(recs, (String)"recs", (String)"rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(20, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()));
        }
        return this.tbl.split(tx, recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public boolean replace(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, Tuple oldRec, Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> {
            this.ser.writeTuple(tx, oldRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false, false);
            this.ser.writeTuple(tx, newRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false, true);
        }), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(oldRec), tx);
    }

    public Tuple getAndReplace(@Nullable Transaction tx, Tuple rec) {
        return (Tuple)ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public boolean delete(@Nullable Transaction tx, Tuple keyRec) {
        return (Boolean)ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    public boolean deleteExact(@Nullable Transaction tx, Tuple rec) {
        return (Boolean)ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, Tuple rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, rec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(rec), tx);
    }

    public Tuple getAndDelete(@Nullable Transaction tx, Tuple keyRec) {
        return (Tuple)ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuple(tx, keyRec, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuple(s, r.in(), false), null, ClientTupleSerializer.getPartitionAwarenessProvider(keyRec), tx);
    }

    public List<Tuple> deleteAll(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        return (List)ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    public void deleteAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.deleteAllAsync(tx));
    }

    public CompletableFuture<List<Tuple>> deleteAllAsync(@Nullable Transaction tx, Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(29, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, true)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in(), true), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(keyRecs, ClientTupleSerializer.getPartitionAwarenessProvider(keyRecs.iterator().next()));
        }
        return this.tbl.split(tx, keyRecs, clo, new ArrayList(keyRecs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name(), new Object[0]).thenApply(r -> null);
    }

    public List<Tuple> deleteAllExact(@Nullable Transaction tx, Collection<Tuple> recs) {
        return (List)ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    public CompletableFuture<List<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        BiFunction clo = (batch, provider) -> this.tbl.doSchemaOutInOpAsync(31, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeTuples(tx, (Collection<Tuple>)batch, (ClientSchema)s, (PayloadOutputChannel)w, (WriteContext)n, false)), (s, r) -> ClientTupleSerializer.readTuples(s, r.in()), Collections.emptyList(), (PartitionAwarenessProvider)provider, tx);
        if (tx == null) {
            return clo.apply(recs, ClientTupleSerializer.getPartitionAwarenessProvider(recs.iterator().next()));
        }
        return this.tbl.split(tx, recs, clo, new ArrayList(recs.size()), (agg, cur) -> {
            agg.addAll(cur);
            return agg;
        }, ClientTupleSerializer::getColocationHash);
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Tuple>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        TupleStreamerPartitionAwarenessProvider provider = new TupleStreamerPartitionAwarenessProvider(this.tbl);
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (IgniteTriConsumer<ClientSchema, PayloadOutputChannel, WriteContext>)((IgniteTriConsumer)(s, w, n) -> this.ser.writeStreamerTuples((int)partitionId, items, deleted, (ClientSchema)s, (PayloadOutputChannel)w)), r -> null, PartitionAwarenessProvider.of(partitionId), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, Tuple> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new TupleStreamerPartitionAwarenessProvider(this.tbl), this.tbl, resultSubscriber, receiver, receiverArg);
    }
}

