/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare.pruning;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongList;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.TimestampString;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningColumns;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.TemporalNativeType;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public final class PartitionPruningPredicate {
    private static final ZoneId ZONE_ID_UTC = ZoneId.of("UTC");

    private PartitionPruningPredicate() {
    }

    public static ColocationGroup prunePartitions(long sourceId, IgniteTable table, PartitionPruningColumns pruningColumns, Object[] dynamicParameters, ColocationGroup colocationGroup) {
        assert (table.partitions() == colocationGroup.assignments().size()) : "Number of partitions does not match";
        IntSet remainingPartitions = PartitionPruningPredicate.computeRemainingPartitions(table, pruningColumns, dynamicParameters);
        if (remainingPartitions == null) {
            return colocationGroup;
        }
        HashMap<String, List<PartitionWithConsistencyToken>> partitionsPerNode = IgniteUtils.newHashMap(colocationGroup.nodeNames().size());
        HashSet<String> newNodes = new HashSet<String>();
        Int2ObjectOpenHashMap newAssignments = new Int2ObjectOpenHashMap(remainingPartitions.size());
        for (int p = 0; p < colocationGroup.assignments().size(); ++p) {
            NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(p);
            if (!remainingPartitions.contains(p)) continue;
            newAssignments.put(p, (Object)nodeWithConsistencyToken);
        }
        for (String nodeName : colocationGroup.nodeNames()) {
            ArrayList<PartitionWithConsistencyToken> partsWithConsistencyTokens = new ArrayList<PartitionWithConsistencyToken>();
            for (int p = 0; p < colocationGroup.assignments().size(); ++p) {
                NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(p);
                if (!remainingPartitions.contains(p) || !Objects.equals(nodeName, nodeWithConsistencyToken.name())) continue;
                long t = nodeWithConsistencyToken.enlistmentConsistencyToken();
                partsWithConsistencyTokens.add(new PartitionWithConsistencyToken(p, t));
                newNodes.add(nodeName);
            }
            if (partsWithConsistencyTokens.isEmpty()) continue;
            partitionsPerNode.put(nodeName, partsWithConsistencyTokens);
        }
        return new ColocationGroup(LongList.of((long)sourceId), List.copyOf(newNodes), (Int2ObjectMap<NodeWithConsistencyToken>)newAssignments, partitionsPerNode);
    }

    public static <RowT> List<PartitionWithConsistencyToken> prunePartitions(ExecutionContext<RowT> context, PartitionPruningColumns pruningColumns, IgniteTable table, ExpressionFactory<RowT> expressionFactory, Int2ObjectMap<NodeWithConsistencyToken> assignments, String nodeName) {
        ImmutableIntList keys = table.distribution().getKeys();
        PartitionCalculator partitionCalculator = table.partitionCalculator().get();
        ArrayList<PartitionWithConsistencyToken> result = new ArrayList<PartitionWithConsistencyToken>();
        for (Int2ObjectMap<RexNode> columns : pruningColumns.columns()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                RexNode node = (RexNode)columns.get(key);
                ColumnDescriptor descriptor = table.descriptor().columnDescriptor(key);
                NativeType physicalType = descriptor.physicalType();
                Object valueInInternalForm = expressionFactory.scalar(node).get(context);
                Object value = valueInInternalForm == null ? null : TypeUtils.fromInternal(valueInInternalForm, physicalType.spec());
                partitionCalculator.append(value);
            }
            int p = partitionCalculator.partition();
            NodeWithConsistencyToken token = (NodeWithConsistencyToken)assignments.get(p);
            if (!nodeName.equals(token.name())) continue;
            result.add(new PartitionWithConsistencyToken(p, token.enlistmentConsistencyToken()));
        }
        return result;
    }

    @Nullable
    private static IntSet computeRemainingPartitions(IgniteTable table, PartitionPruningColumns pruningColumns, Object[] dynamicParameters) {
        ImmutableIntList keys = table.distribution().getKeys();
        IntArraySet remainingPartitions = new IntArraySet(pruningColumns.columns().size());
        PartitionCalculator partitionCalculator = table.partitionCalculator().get();
        for (Int2ObjectMap<RexNode> columns : pruningColumns.columns()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                TemporalNativeType temporalNativeType;
                int key = (Integer)iterator.next();
                RexNode node = (RexNode)columns.get(key);
                NativeType physicalType = table.descriptor().columnDescriptor(key).physicalType();
                ColumnType columnType = physicalType.spec();
                Object val = PartitionPruningPredicate.getNodeValue(physicalType, node, dynamicParameters);
                if ((columnType == ColumnType.TIME || columnType == ColumnType.DATETIME || columnType == ColumnType.TIMESTAMP) && (temporalNativeType = (TemporalNativeType)physicalType).precision() > 3) {
                    return null;
                }
                partitionCalculator.append(val);
            }
            int p = partitionCalculator.partition();
            remainingPartitions.add(p);
        }
        return remainingPartitions;
    }

    @Nullable
    private static Object getNodeValue(NativeType physicalType, RexNode node, Object[] dynamicParameters) {
        Object val;
        if (node instanceof RexLiteral) {
            val = PartitionPruningPredicate.getValueFromLiteral(physicalType, (RexLiteral)node);
        } else if (node instanceof RexDynamicParam) {
            RexDynamicParam dynamicParam = (RexDynamicParam)node;
            val = dynamicParameters[dynamicParam.getIndex()];
        } else {
            throw new IllegalArgumentException("Unexpected column value node: " + node);
        }
        return val;
    }

    @Nullable
    private static Object getValueFromLiteral(NativeType physicalType, RexLiteral lit) {
        if (physicalType.spec() == ColumnType.DATE) {
            Calendar calendar = (Calendar)lit.getValueAs(Calendar.class);
            Instant instant = calendar.toInstant();
            return LocalDate.ofInstant(instant, ZONE_ID_UTC);
        }
        if (physicalType.spec() == ColumnType.TIME) {
            Calendar calendar = (Calendar)lit.getValueAs(Calendar.class);
            Instant instant = calendar.toInstant();
            return LocalTime.ofInstant(instant, ZONE_ID_UTC);
        }
        if (physicalType.spec() == ColumnType.TIMESTAMP) {
            TimestampString timestampString = (TimestampString)lit.getValueAs(TimestampString.class);
            assert (timestampString != null);
            return Instant.ofEpochMilli(timestampString.getMillisSinceEpoch());
        }
        if (physicalType.spec() == ColumnType.DATETIME) {
            TimestampString timestampString = (TimestampString)lit.getValueAs(TimestampString.class);
            assert (timestampString != null);
            Instant instant = Instant.ofEpochMilli(timestampString.getMillisSinceEpoch());
            return LocalDateTime.ofInstant(instant, ZONE_ID_UTC);
        }
        Class<?> javaClass = physicalType.spec().javaClass();
        return lit.getValueAs(javaClass);
    }
}

