/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.logging.LogManager;
import org.apache.ignite.migrationtools.cli.TopLevelCliCommand;
import org.apache.ignite3.internal.cli.config.CachedConfigManagerProvider;
import org.apache.ignite3.internal.cli.config.ConfigDefaultValueProvider;
import org.apache.ignite3.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite3.internal.cli.core.exception.handler.PicocliExecutionExceptionHandler;
import picocli.CommandLine;

public class Main {
    private static final String LOGS_DIR_ENV = "IGNITE_MIGRATION_TOOLS_LOGS_DIR";
    private static final String LOCAL_FOLDER = ".ignite-migration-tools";

    public static void main(String[] args) {
        Main.initJavaLoggerProps();
        int exitCode = 0;
        try {
            exitCode = Main.executeCommand(args);
        }
        catch (Exception e) {
            System.err.println("Error occurred during command execution");
        }
        System.exit(exitCode);
    }

    public static int executeCommand(String[] args) {
        CommandLine cmd = new CommandLine(TopLevelCliCommand.class);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PicocliExecutionExceptionHandler());
        cmd.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new ConfigDefaultValueProvider((ConfigManagerProvider)new CachedConfigManagerProvider()));
        cmd.setTrimQuotes(true);
        cmd.setCaseInsensitiveEnumValuesAllowed(true);
        return cmd.execute(args);
    }

    private static void initJavaLoggerProps() {
        try (InputStream propsFile = Main.class.getResourceAsStream("/cli.java.util.logging.properties");){
            if (propsFile != null) {
                LogManager.getLogManager().updateConfiguration(propsFile, configurationKey -> {
                    if (configurationKey.equals("java.util.logging.FileHandler.pattern")) {
                        return (oldConfigValue, newConfigValue) -> {
                            if (newConfigValue == null) {
                                return oldConfigValue;
                            }
                            try {
                                return Main.getLogsDir() + "/" + newConfigValue;
                            }
                            catch (IOException e) {
                                return newConfigValue;
                            }
                        };
                    }
                    if (configurationKey.equals("java.util.logging.FileHandler.formatter")) {
                        return (oldConfigValue, newConfigValue) -> {
                            String target;
                            String pkgName = "org.apache.ignite";
                            String string = target = newConfigValue == null ? oldConfigValue : newConfigValue;
                            if (target.startsWith(pkgName)) {
                                return pkgName + "3" + target.substring(pkgName.length());
                            }
                            return target;
                        };
                    }
                    return (o, n) -> n == null ? o : n;
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getLogsDir() throws IOException {
        String envLogsDir = System.getenv(LOGS_DIR_ENV);
        Path logsDir = envLogsDir != null ? Path.of(envLogsDir, new String[0]) : Path.of(System.getProperty("user.home"), LOCAL_FOLDER, "logs");
        File logsDirFile = logsDir.toFile();
        if (!logsDirFile.exists() && !logsDirFile.mkdirs()) {
            throw new IOException("Failed to create directory " + logsDir);
        }
        if (logsDirFile.isDirectory()) {
            return logsDir.toAbsolutePath().toString();
        }
        throw new IOException(logsDir + " is not a directory");
    }
}

