/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.template.TemplateInfoResp;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.state.schema.SetTemplateState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIncompatibleException;
import org.apache.iotdb.db.exception.metadata.template.UndefinedTemplateException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUtil;
import org.apache.iotdb.mpp.rpc.thrift.TCheckTimeSeriesExistenceReq;
import org.apache.iotdb.mpp.rpc.thrift.TCheckTimeSeriesExistenceResp;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTemplateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, SetTemplateState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetTemplateProcedure.class);
    private String queryId;
    private String templateName;
    private String templateSetPath;
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";

    public SetTemplateProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public SetTemplateProcedure(String queryId, String templateName, String templateSetPath, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.queryId = queryId;
        this.templateName = templateName;
        this.templateSetPath = templateSetPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, SetTemplateState state) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case VALIDATE_TEMPLATE_EXISTENCE: {
                    LOGGER.info("Check template existence set on path {} when try setting template {}", (Object)this.templateSetPath, (Object)this.templateName);
                    this.validateTemplateExistence(env);
                    break;
                }
                case PRE_SET: {
                    LOGGER.info("Pre set schemaengine template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.preSetTemplate(env);
                    break;
                }
                case PRE_RELEASE: {
                    LOGGER.info("Pre release schemaengine template {} set on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.preReleaseTemplate(env);
                    break;
                }
                case VALIDATE_TIMESERIES_EXISTENCE: {
                    LOGGER.info("Check timeseries existence under path {} when try setting template {}", (Object)this.templateSetPath, (Object)this.templateName);
                    this.validateTimeSeriesExistence(env);
                    break;
                }
                case COMMIT_SET: {
                    LOGGER.info("Commit set schemaengine template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.commitSetTemplate(env);
                    this.setNextState(SetTemplateState.COMMIT_RELEASE);
                    break;
                }
                case COMMIT_RELEASE: {
                    LOGGER.info("Commit release schemaengine template {} set on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.commitReleaseTemplate(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                default: {
                    this.setFailure(new ProcedureException("Unrecognized SetTemplateState " + (Object)((Object)state)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("SetSchemaTemplate-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void validateTemplateExistence(ConfigNodeProcedureEnv env) {
        TemplateInfoResp resp;
        CheckTemplateSettablePlan checkTemplateSettablePlan = new CheckTemplateSettablePlan(this.templateName, this.templateSetPath);
        try {
            resp = (TemplateInfoResp)env.getConfigManager().getConsensusManager().read(checkTemplateSettablePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            resp = new TemplateInfoResp();
            resp.setStatus(res);
        }
        if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(SetTemplateState.PRE_SET);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(resp.getStatus().getMessage(), resp.getStatus().getCode())));
        }
    }

    private void preSetTemplate(ConfigNodeProcedureEnv env) {
        TSStatus status;
        PreSetSchemaTemplatePlan preSetSchemaTemplatePlan = new PreSetSchemaTemplatePlan(this.templateName, this.templateSetPath);
        try {
            status = env.getConfigManager().getConsensusManager().write(preSetSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(SetTemplateState.PRE_RELEASE);
        } else {
            LOGGER.warn("Failed to pre set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void preReleaseTemplate(ConfigNodeProcedureEnv env) {
        Template template = this.getTemplate(env);
        if (template == null) {
            return;
        }
        TUpdateTemplateReq req = new TUpdateTemplateReq();
        req.setType(TemplateInternalRPCUpdateType.ADD_TEMPLATE_PRE_SET_INFO.toByte());
        req.setTemplateInfo(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes((Template)template, (String)this.templateSetPath));
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TEMPLATE, req, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.warn("Failed to sync template {} pre-set info on path {} to DataNode {}", new Object[]{this.templateName, this.templateSetPath, dataNodeLocationMap.get(entry.getKey())});
            this.setFailure(new ProcedureException(new MetadataException("Pre set template failed")));
            return;
        }
        this.setNextState(SetTemplateState.VALIDATE_TIMESERIES_EXISTENCE);
    }

    private Template getTemplate(ConfigNodeProcedureEnv env) {
        TemplateInfoResp templateResp;
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(this.templateName);
        try {
            templateResp = (TemplateInfoResp)env.getConfigManager().getConsensusManager().read(getSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the read API executing the consensus layer due to: ", (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            templateResp = new TemplateInfoResp();
            templateResp.setStatus(res);
        }
        if (templateResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(templateResp.getStatus().getMessage(), templateResp.getStatus().getCode())));
            return null;
        }
        if (templateResp.getTemplateList() == null || templateResp.getTemplateList().isEmpty()) {
            this.setFailure(new ProcedureException((Throwable)new UndefinedTemplateException(this.templateName)));
            return null;
        }
        return templateResp.getTemplateList().get(0);
    }

    private void validateTimeSeriesExistence(ConfigNodeProcedureEnv env) {
        PathPatternTree patternTree = new PathPatternTree();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        PartialPath path = null;
        try {
            path = new PartialPath(this.templateSetPath);
            patternTree.appendPathPattern(path);
            patternTree.appendPathPattern(path.concatNode("**"));
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException | IllegalPathException throwable) {
            // empty catch block
        }
        ByteBuffer patternTreeBytes = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(patternTree);
        final ArrayList respList = new ArrayList();
        DataNodeRegionTaskExecutor<TCheckTimeSeriesExistenceReq, TCheckTimeSeriesExistenceResp> regionTask = new DataNodeRegionTaskExecutor<TCheckTimeSeriesExistenceReq, TCheckTimeSeriesExistenceResp>(env, relatedSchemaRegionGroup, false, CnToDnAsyncRequestType.CHECK_TIMESERIES_EXISTENCE, (dataNodeLocation, consensusGroupIdList) -> new TCheckTimeSeriesExistenceReq(patternTreeBytes, consensusGroupIdList)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TCheckTimeSeriesExistenceResp response) {
                respList.add(response);
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return failedRegionList;
                }
                if (response.getStatus().getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatus = response.getStatus().getSubStatus();
                    for (int i = 0; i < subStatus.size(); ++i) {
                        if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) continue;
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                SetTemplateProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Set template %s to %s failed when [check time series existence on DataNode] because failed to check time series existence in all replicaset of schemaRegion %s. Failure nodes: %s", SetTemplateProcedure.this.templateName, SetTemplateProcedure.this.templateSetPath, consensusGroupId.id, dataNodeLocationSet))));
                this.interruptTask();
            }
        };
        regionTask.execute();
        if (this.isFailed()) {
            return;
        }
        for (TCheckTimeSeriesExistenceResp resp : respList) {
            if (!resp.isExists()) continue;
            this.setFailure(new ProcedureException((Throwable)new TemplateIncompatibleException(this.templateName, path)));
        }
        this.setNextState(SetTemplateState.COMMIT_SET);
    }

    private void commitSetTemplate(ConfigNodeProcedureEnv env) {
        TSStatus status;
        CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan = new CommitSetSchemaTemplatePlan(this.templateName, this.templateSetPath);
        try {
            status = env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(commitSetSchemaTemplatePlan) : commitSetSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(SetTemplateState.COMMIT_RELEASE);
        } else {
            LOGGER.warn("Failed to commit set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void commitReleaseTemplate(ConfigNodeProcedureEnv env) {
        Template template = this.getTemplate(env);
        if (template == null) {
            return;
        }
        TUpdateTemplateReq req = new TUpdateTemplateReq();
        req.setType(TemplateInternalRPCUpdateType.COMMIT_TEMPLATE_SET_INFO.toByte());
        req.setTemplateInfo(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes((Template)template, (String)this.templateSetPath));
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TEMPLATE, req, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.warn("Failed to sync template {} commit-set info on path {} to DataNode {}", new Object[]{this.templateName, this.templateSetPath, dataNodeLocationMap.get(entry.getKey())});
            this.setFailure(new ProcedureException(new MetadataException(String.format("Failed to set schemaengine template %s on path %s because there's failure on DataNode %s", this.templateName, this.templateSetPath, dataNodeLocationMap.get(entry.getKey())))));
            return;
        }
    }

    private void submitTemplateMaintainTask(TDataNodeLocation dataNodeLocation) {
    }

    @Override
    protected boolean isRollbackSupported(SetTemplateState setTemplateState) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, SetTemplateState state) throws IOException, InterruptedException, ProcedureException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case PRE_SET: {
                    LOGGER.info("Start rollback pre set schemaengine template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.rollbackPreSet(env);
                    return;
                }
                case PRE_RELEASE: {
                    LOGGER.info("Start rollback pre release schemaengine template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.rollbackPreRelease(env);
                    return;
                }
                case COMMIT_SET: {
                    LOGGER.info("Start rollback commit set schemaengine template {} on path {}", (Object)this.templateName, (Object)this.templateSetPath);
                    this.rollbackCommitSet(env);
                    return;
                }
            }
            return;
        }
        finally {
            LOGGER.info("Rollback SetTemplate-{} costs {}ms.", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void rollbackPreSet(ConfigNodeProcedureEnv env) {
        TSStatus status;
        PreSetSchemaTemplatePlan preSetSchemaTemplatePlan = new PreSetSchemaTemplatePlan(this.templateName, this.templateSetPath, true);
        try {
            status = env.getConfigManager().getConsensusManager().write(preSetSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to rollback pre set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void rollbackPreRelease(ConfigNodeProcedureEnv env) {
        Template template = this.getTemplate(env);
        if (template == null) {
            return;
        }
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        TUpdateTemplateReq invalidateTemplateSetInfoReq = new TUpdateTemplateReq();
        invalidateTemplateSetInfoReq.setType(TemplateInternalRPCUpdateType.INVALIDATE_TEMPLATE_SET_INFO.toByte());
        invalidateTemplateSetInfoReq.setTemplateInfo(TemplateInternalRPCUtil.generateInvalidateTemplateSetInfoBytes((int)template.getId(), (String)this.templateSetPath));
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TEMPLATE, invalidateTemplateSetInfoReq, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to rollback pre release template info of template {} set on path {} on DataNode {}", new Object[]{template.getName(), this.templateSetPath, dataNodeLocationMap.get(entry.getKey())});
            this.setFailure(new ProcedureException(new MetadataException("Rollback pre release template failed")));
        }
    }

    private void rollbackCommitSet(ConfigNodeProcedureEnv env) {
        TSStatus status;
        CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan = new CommitSetSchemaTemplatePlan(this.templateName, this.templateSetPath, true);
        try {
            status = env.getConfigManager().getConsensusManager().write(commitSetSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to rollback commit set template {} on path {} due to {}", new Object[]{this.templateName, this.templateSetPath, status.getMessage()});
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected SetTemplateState getState(int stateId) {
        return SetTemplateState.values()[stateId];
    }

    @Override
    protected int getStateId(SetTemplateState state) {
        return state.ordinal();
    }

    @Override
    protected SetTemplateState getInitialState() {
        return SetTemplateState.VALIDATE_TEMPLATE_EXISTENCE;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateSetPath() {
        return this.templateSetPath;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_SET_TEMPLATE_PROCEDURE.getTypeCode() : ProcedureType.SET_TEMPLATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.templateName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.templateSetPath, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.templateName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.templateSetPath = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTemplateProcedure that = (SetTemplateProcedure)o;
        return Objects.equals(this.getProcId(), that.getProcId()) && Objects.equals(this.getCurrentState(), that.getCurrentState()) && Objects.equals(this.getCycles(), that.getCycles()) && Objects.equals(this.isGeneratedByPipe, that.isGeneratedByPipe) && Objects.equals(this.templateName, that.templateName) && Objects.equals(this.templateSetPath, that.templateSetPath);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.templateName, this.templateSetPath);
    }
}

