/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.model;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.iotdb.commons.model.ModelStatus;
import org.apache.iotdb.commons.model.ModelType;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ModelInformation {
    ModelType modelType;
    private final String modelName;
    private final int[] inputShape;
    private final int[] outputShape;
    private TSDataType[] inputDataType;
    private TSDataType[] outputDataType;
    private ModelStatus status = ModelStatus.INACTIVE;
    String attribute = "";

    public ModelInformation(ModelType modelType, String modelName, int[] inputShape, int[] outputShape, TSDataType[] inputDataType, TSDataType[] outputDataType, String attribute, ModelStatus status) {
        this.modelType = modelType;
        this.modelName = modelName;
        this.inputShape = inputShape;
        this.outputShape = outputShape;
        this.inputDataType = inputDataType;
        this.outputDataType = outputDataType;
        this.attribute = attribute;
        this.status = status;
    }

    public ModelInformation(String modelName, int[] inputShape, int[] outputShape, TSDataType[] inputDataType, TSDataType[] outputDataType, String attribute) {
        this.modelType = ModelType.USER_DEFINED;
        this.modelName = modelName;
        this.inputShape = inputShape;
        this.outputShape = outputShape;
        this.inputDataType = inputDataType;
        this.outputDataType = outputDataType;
        this.attribute = attribute;
    }

    public ModelInformation(String modelName, ModelStatus status) {
        this.modelType = ModelType.USER_DEFINED;
        this.modelName = modelName;
        this.inputShape = new int[0];
        this.outputShape = new int[0];
        this.outputDataType = new TSDataType[0];
        this.inputDataType = new TSDataType[0];
        this.status = status;
    }

    public ModelInformation(ModelType modelType, String modelName) {
        this.modelType = modelType;
        this.modelName = modelName;
        this.inputShape = new int[2];
        this.outputShape = new int[2];
        this.inputDataType = new TSDataType[0];
        this.outputDataType = new TSDataType[0];
        this.status = ModelStatus.ACTIVE;
    }

    public boolean isBuiltIn() {
        return this.modelType != ModelType.USER_DEFINED;
    }

    public boolean available() {
        return this.status == ModelStatus.ACTIVE;
    }

    public void updateStatus(ModelStatus status) {
        this.status = status;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setInputColumnSize(int size) {
        this.inputShape[1] = size;
        if (this.modelType == ModelType.BUILT_IN_FORECAST) {
            this.outputShape[1] = size;
        } else if (this.modelType == ModelType.BUILT_IN_ANOMALY_DETECTION) {
            this.outputShape[1] = 1;
        }
        if (this.modelType == ModelType.BUILT_IN_FORECAST) {
            this.buildOutputDataTypeForBuiltInModel(TSDataType.DOUBLE, this.outputShape[1]);
        } else if (this.modelType == ModelType.BUILT_IN_ANOMALY_DETECTION) {
            this.buildOutputDataTypeForBuiltInModel(TSDataType.INT32, this.outputShape[1]);
        }
    }

    public void setInputDataType(TSDataType[] inputDataType) {
        this.inputDataType = inputDataType;
    }

    private void buildOutputDataTypeForBuiltInModel(TSDataType tsDataType, int num) {
        this.outputDataType = new TSDataType[num];
        for (int i = 0; i < num; ++i) {
            this.outputDataType[i] = tsDataType;
        }
    }

    public int[] getInputShape() {
        return this.inputShape;
    }

    public int[] getOutputShape() {
        return this.outputShape;
    }

    public TSDataType[] getInputDataType() {
        return this.inputDataType;
    }

    public TSDataType[] getOutputDataType() {
        return this.outputDataType;
    }

    public ModelStatus getStatus() {
        return this.status;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.modelType.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.status.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
        if (this.status == ModelStatus.UNAVAILABLE) {
            return;
        }
        for (int shape : this.inputShape) {
            ReadWriteIOUtils.write((int)shape, (OutputStream)stream);
        }
        for (int shape : this.outputShape) {
            ReadWriteIOUtils.write((int)shape, (OutputStream)stream);
        }
        for (TSDataType type : this.inputDataType) {
            ReadWriteIOUtils.write((byte)type.serialize(), (OutputStream)stream);
        }
        for (TSDataType type : this.outputDataType) {
            ReadWriteIOUtils.write((byte)type.serialize(), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((String)this.attribute, (OutputStream)stream);
    }

    public void serialize(FileOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.modelType.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.status.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
        if (this.status == ModelStatus.UNAVAILABLE) {
            return;
        }
        for (int shape : this.inputShape) {
            ReadWriteIOUtils.write((int)shape, (OutputStream)stream);
        }
        for (int shape : this.outputShape) {
            ReadWriteIOUtils.write((int)shape, (OutputStream)stream);
        }
        for (TSDataType type : this.inputDataType) {
            ReadWriteIOUtils.write((byte)type.serialize(), (OutputStream)stream);
        }
        for (TSDataType type : this.outputDataType) {
            ReadWriteIOUtils.write((byte)type.serialize(), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((String)this.attribute, (OutputStream)stream);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.modelType.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.status.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.modelName, (ByteBuffer)byteBuffer);
        if (this.status == ModelStatus.UNAVAILABLE) {
            return;
        }
        for (int shape : this.inputShape) {
            ReadWriteIOUtils.write((int)shape, (ByteBuffer)byteBuffer);
        }
        for (int shape : this.outputShape) {
            ReadWriteIOUtils.write((int)shape, (ByteBuffer)byteBuffer);
        }
        for (TSDataType type : this.inputDataType) {
            ReadWriteIOUtils.write((byte)type.serialize(), (ByteBuffer)byteBuffer);
        }
        for (TSDataType type : this.outputDataType) {
            ReadWriteIOUtils.write((byte)type.serialize(), (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((String)this.attribute, (ByteBuffer)byteBuffer);
    }

    public static ModelInformation deserialize(ByteBuffer buffer) {
        ModelType modelType = ModelType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        ModelStatus status = ModelStatus.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        String modelName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        if (status == ModelStatus.UNAVAILABLE) {
            return new ModelInformation(modelName, status);
        }
        int[] inputShape = new int[2];
        for (int i = 0; i < inputShape.length; ++i) {
            inputShape[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        }
        int[] outputShape = new int[2];
        for (int i = 0; i < outputShape.length; ++i) {
            outputShape[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        }
        TSDataType[] inputDataType = new TSDataType[inputShape[1]];
        for (int i = 0; i < inputDataType.length; ++i) {
            inputDataType[i] = TSDataType.deserializeFrom((ByteBuffer)buffer);
        }
        TSDataType[] outputDataType = new TSDataType[outputShape[1]];
        for (int i = 0; i < outputDataType.length; ++i) {
            outputDataType[i] = TSDataType.deserializeFrom((ByteBuffer)buffer);
        }
        String attribute = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        return new ModelInformation(modelType, modelName, inputShape, outputShape, inputDataType, outputDataType, attribute, status);
    }

    public static ModelInformation deserialize(InputStream stream) throws IOException {
        ModelType modelType = ModelType.values()[ReadWriteIOUtils.readInt((InputStream)stream)];
        ModelStatus status = ModelStatus.values()[ReadWriteIOUtils.readInt((InputStream)stream)];
        String modelName = ReadWriteIOUtils.readString((InputStream)stream);
        if (status == ModelStatus.UNAVAILABLE) {
            return new ModelInformation(modelName, status);
        }
        int[] inputShape = new int[2];
        for (int i = 0; i < inputShape.length; ++i) {
            inputShape[i] = ReadWriteIOUtils.readInt((InputStream)stream);
        }
        int[] outputShape = new int[2];
        for (int i = 0; i < outputShape.length; ++i) {
            outputShape[i] = ReadWriteIOUtils.readInt((InputStream)stream);
        }
        TSDataType[] inputDataType = new TSDataType[inputShape[1]];
        for (int i = 0; i < inputDataType.length; ++i) {
            inputDataType[i] = TSDataType.deserializeFrom((InputStream)stream);
        }
        TSDataType[] outputDataType = new TSDataType[outputShape[1]];
        for (int i = 0; i < outputDataType.length; ++i) {
            outputDataType[i] = TSDataType.deserializeFrom((InputStream)stream);
        }
        String attribute = ReadWriteIOUtils.readString((InputStream)stream);
        return new ModelInformation(modelType, modelName, inputShape, outputShape, inputDataType, outputDataType, attribute, status);
    }

    public ByteBuffer serializeShowModelResult() throws IOException {
        PublicBAOS buffer = new PublicBAOS();
        DataOutputStream stream = new DataOutputStream((OutputStream)buffer);
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelType.toString(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.status.toString(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)Arrays.toString(this.inputShape), (OutputStream)stream);
        ReadWriteIOUtils.write((String)Arrays.toString(this.outputShape), (OutputStream)stream);
        ReadWriteIOUtils.write((String)Arrays.toString(this.inputDataType), (OutputStream)stream);
        ReadWriteIOUtils.write((String)Arrays.toString(this.outputDataType), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.attribute, (OutputStream)stream);
        ReadWriteIOUtils.write((String)" ", (OutputStream)stream);
        return ByteBuffer.wrap(buffer.getBuf(), 0, buffer.size());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelInformation) {
            ModelInformation other = (ModelInformation)obj;
            return this.modelName.equals(other.modelName) && this.modelType.equals((Object)other.modelType) && Arrays.equals(this.inputShape, other.inputShape) && Arrays.equals(this.outputShape, other.outputShape) && Arrays.equals(this.inputDataType, other.inputDataType) && Arrays.equals(this.outputDataType, other.outputDataType) && this.status.equals((Object)other.status) && this.attribute.equals(other.attribute);
        }
        return false;
    }
}

