/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.config.store.ConfigFileStore;
import org.apache.juneau.config.store.ConfigStoreBuilder;
import org.apache.juneau.config.store.WatcherSensitivity;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.svl.VarResolverSession;

public class ConfigFileStoreBuilder
extends ConfigStoreBuilder {
    public ConfigFileStoreBuilder() {
    }

    public ConfigFileStoreBuilder(PropertyStore ps) {
        super(ps);
    }

    @Override
    public ConfigFileStore build() {
        return new ConfigFileStore(this.getPropertyStore());
    }

    public ConfigFileStoreBuilder directory(String value) {
        super.set("ConfigFileStore.directory.s", value);
        return this;
    }

    public ConfigFileStoreBuilder directory(File value) {
        super.set("ConfigFileStore.directory.s", value);
        return this;
    }

    public ConfigFileStoreBuilder charset(String value) {
        super.set("ConfigFileStore.charset.s", value);
        return this;
    }

    public ConfigFileStoreBuilder charset(Charset value) {
        super.set("ConfigFileStore.charset.s", value);
        return this;
    }

    public ConfigFileStoreBuilder useWatcher() {
        super.set("ConfigFileStore.useWatcher.s", true);
        return this;
    }

    public ConfigFileStoreBuilder watcherSensitivity(WatcherSensitivity value) {
        super.set("ConfigFileStore.watcherSensitivity.s", (Object)value);
        return this;
    }

    public ConfigFileStoreBuilder updateOnWrite() {
        super.set("ConfigFileStore.updateOnWrite.b", true);
        return this;
    }

    public ConfigFileStoreBuilder watcherSensitivity(String value) {
        super.set("ConfigFileStore.watcherSensitivity.s", value);
        return this;
    }

    public ConfigFileStoreBuilder extensions(String value) {
        super.set("ConfigFileStore.extensions.s", value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public ConfigFileStoreBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public ConfigFileStoreBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }
}

