/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;

public final class ASortedSet<T>
extends TreeSet<T> {
    private static final long serialVersionUID = 1L;

    public ASortedSet() {
    }

    public ASortedSet(Comparator<T> c) {
        super(c);
    }

    public ASortedSet(Collection<T> c) {
        super(c == null ? Collections.emptySet() : c);
    }

    @SafeVarargs
    public static <T> ASortedSet<T> of(T ... t) {
        return new ASortedSet<T>().a(t);
    }

    public ASortedSet<T> a(T t) {
        this.add(t);
        return this;
    }

    public ASortedSet<T> a(T ... t) {
        Collections.addAll(this, t);
        return this;
    }

    public ASortedSet<T> aa(Collection<T> c) {
        if (c != null) {
            this.addAll(c);
        }
        return this;
    }

    public ASortedSet<T> aif(boolean b, T t) {
        if (b) {
            this.a(t);
        }
        return this;
    }

    public ASortedSet<T> aifnn(T ... t) {
        for (T o2 : t) {
            if (o2 == null) continue;
            this.a(o2);
        }
        return this;
    }

    public SortedSet<T> unmodifiable() {
        return this.isEmpty() ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(this);
    }

    public <T2> T2[] asArrayOf(Class<T2> c) {
        return this.toArray((Object[])Array.newInstance(c, this.size()));
    }

    public String asString(WriterSerializer ws) {
        return ws.toString(this);
    }

    public String asString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    @Override
    public String toString() {
        return this.asString(SimpleJsonSerializer.DEFAULT);
    }
}

