/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.juneau.BasicIllegalArgumentException;
import org.apache.juneau.BeanContextBuilder;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.Visibility;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.ConfigBuilder;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.cp.ResourceManager;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConfigAnnotationFilter;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.BasicRestLogger;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallLogger;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestChild;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestContextProperties;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StaticFileMapping;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.reshandlers.DefaultHandler;
import org.apache.juneau.rest.reshandlers.InputStreamHandler;
import org.apache.juneau.rest.reshandlers.ReaderHandler;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanInterceptor;
import org.apache.juneau.utils.Tuple2;

@FluentSetters(ignore={"set"})
public class RestContextBuilder
extends BeanContextBuilder
implements ServletConfig {
    final ServletConfig inner;
    Class<?> resourceClass;
    Object resource;
    ServletContext servletContext;
    RestContext parentContext;
    RestContextProperties properties;
    Config config;
    VarResolverBuilder varResolverBuilder;

    RestContextBuilder(ServletConfig servletConfig, Class<?> resourceClass, RestContext parentContext) throws ServletException {
        this.inner = servletConfig;
        this.resourceClass = resourceClass;
        this.parentContext = parentContext;
        this.properties = new RestContextProperties();
        ClassInfo rci = ClassInfo.of(resourceClass);
        this.logger(BasicRestLogger.class);
        this.partSerializer(OpenApiSerializer.class);
        this.partParser(OpenApiParser.class);
        this.staticFileResponseHeader("Cache-Control", "max-age=86400, public");
        this.encoders(IdentityEncoder.INSTANCE);
        this.responseHandlers(ReaderHandler.class, InputStreamHandler.class, DefaultHandler.class);
        try {
            Annotation r;
            this.varResolverBuilder = new VarResolverBuilder().defaultVars().vars(ConfigVar.class).vars(FileVar.class).contextObject("crm", new ResourceManager(resourceClass));
            VarResolver vr = this.varResolverBuilder.build();
            List<AnnotationInfo<RestResource>> restResourceAnnotationsParentFirst = rci.getAnnotationInfos(RestResource.class);
            List<AnnotationInfo<Rest>> restAnnotationsParentFirst = rci.getAnnotationInfos(Rest.class);
            String configPath = "";
            for (AnnotationInfo<RestResource> annotationInfo : restResourceAnnotationsParentFirst) {
                if (annotationInfo.getAnnotation().config().isEmpty()) continue;
                configPath = annotationInfo.getAnnotation().config();
            }
            for (AnnotationInfo<Annotation> annotationInfo : restAnnotationsParentFirst) {
                if (((Rest)annotationInfo.getAnnotation()).config().isEmpty()) continue;
                configPath = ((Rest)annotationInfo.getAnnotation()).config();
            }
            String cf = vr.resolve(configPath);
            if ("SYSTEM_DEFAULT".equals(cf)) {
                this.config = Config.getSystemDefault();
            }
            if (this.config == null) {
                ConfigBuilder configBuilder = Config.create().varResolver(vr);
                if (!cf.isEmpty()) {
                    configBuilder.name(cf);
                }
                this.config = configBuilder.build();
            }
            this.varResolverBuilder.contextObject("config", this.config);
            vr = this.varResolverBuilder.build();
            if (servletConfig != null) {
                Enumeration enumeration = servletConfig.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String initParam = servletConfig.getInitParameter(string);
                    this.set(vr.resolve(string), vr.resolve(initParam));
                }
            }
            this.applyAnnotations(rci.getAnnotationList(ConfigAnnotationFilter.INSTANCE), vr.createSession());
            for (AnnotationInfo<RestResource> annotationInfo : restResourceAnnotationsParentFirst) {
                r = annotationInfo.getAnnotation();
                for (Property property : r.properties()) {
                    this.set(vr.resolve(property.name()), vr.resolve(property.value()));
                }
                for (String string : r.flags()) {
                    this.set(string, true);
                }
            }
            for (AnnotationInfo<Rest> annotationInfo : restAnnotationsParentFirst) {
                r = annotationInfo.getAnnotation();
                for (Property property : r.properties()) {
                    this.set(vr.resolve(property.name()), vr.resolve(property.value()));
                }
                for (String string : r.flags()) {
                    this.set(string, true);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public RestContext build() {
        try {
            PropertyStore ps = this.getPropertyStore();
            Class<RestContext> c = ps.getClassProperty("RestContext.context.c", RestContext.class, RestContext.class);
            ConstructorInfo ci = ClassInfo.of(c).getConstructor(Visibility.PUBLIC, RestContextBuilder.class);
            if (ci == null) {
                throw new InternalServerError("Invalid class specified for REST_context.  Must extend from RestContext and provide a public constructor of the form T(RestContextBuilder).");
            }
            return (RestContext)ci.invoke(this);
        }
        catch (Exception e) {
            throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
        }
    }

    RestContextBuilder init(Object resource) throws ServletException {
        this.resource = resource;
        ClassInfo rci = ClassInfo.of(resource).resolved();
        LinkedHashMap<String, MethodInfo> map = new LinkedHashMap<String, MethodInfo>();
        for (MethodInfo m : rci.getAllMethodsParentFirst()) {
            if (!m.hasAnnotation(RestHook.class) || m.getLastAnnotation(RestHook.class).value() != HookEvent.INIT) continue;
            m.setAccessible();
            String sig = m.getSignature();
            if (map.containsKey(sig)) continue;
            map.put(sig, m);
        }
        for (MethodInfo m : map.values()) {
            RestContextBuilder.assertArgsOnlyOfType(m, RestContextBuilder.class, ServletConfig.class);
            Class[] pt = (Class[])m.getRawParamTypes().toArray();
            Object[] args = new Object[pt.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = pt[i] == RestContextBuilder.class ? this : this.inner;
            }
            try {
                m.invoke(resource, args);
            }
            catch (Exception e) {
                throw new RestServletException(e, "Exception thrown from @RestHook(INIT) method {0}.{0}.", m.getDeclaringClass().getSimpleName(), m.getSignature());
            }
        }
        return this;
    }

    private static void assertArgsOnlyOfType(MethodInfo m, Class<?> ... args) {
        if (!m.argsOnlyOfType(args)) {
            throw new BasicIllegalArgumentException("Invalid arguments passed to method {0}.  Only arguments of type {1} are allowed.", m, args);
        }
    }

    RestContextBuilder servletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        return this;
    }

    public RestContextBuilder vars(Class<?> ... vars) {
        this.varResolverBuilder.vars(vars);
        return this;
    }

    public RestContextBuilder varContextObject(String name, Object object) {
        this.varResolverBuilder.contextObject(name, object);
        return this;
    }

    public RestContextBuilder config(Config config) {
        this.config = config;
        return this;
    }

    protected PropertyStoreBuilder createPropertyStore() {
        return PropertyStore.create().add(this.properties);
    }

    public Config getConfig() {
        return this.config;
    }

    public RestContextProperties getProperties() {
        return this.properties;
    }

    public VarResolverBuilder getVarResolverBuilder() {
        return this.varResolverBuilder;
    }

    public String getPath() {
        Object p = this.peek("RestContext.path.s");
        return p == null ? "" : p.toString();
    }

    @FluentSetter
    public RestContextBuilder allowBodyParam(boolean value) {
        return this.set("RestContext.allowBodyParam.b", value);
    }

    @FluentSetter
    public RestContextBuilder dontAllowBodyParam() {
        return this.set("RestContext.allowBodyParam.b", false);
    }

    @FluentSetter
    public RestContextBuilder allowedHeaderParams(String value) {
        return this.set("RestContext.allowedHeaderParams.s", value);
    }

    @FluentSetter
    public RestContextBuilder allowedMethodHeaders(String value) {
        return this.set("RestContext.allowedMethodHeaders.s", value);
    }

    @FluentSetter
    public RestContextBuilder allowedMethodParams(String value) {
        return this.set("RestContext.allowedMethodParams.s", value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder allowHeaderParams(boolean value) {
        return this.set("RestContext.allowedHeaderParams.s", value ? "*" : null);
    }

    @FluentSetter
    @Deprecated
    public RestContextBuilder callHandler(Class<? extends RestCallHandler> value) {
        return this.set("RestContext.callHandler.o", value);
    }

    @FluentSetter
    @Deprecated
    public RestContextBuilder callHandler(RestCallHandler value) {
        return this.set("RestContext.callHandler.o", value);
    }

    @FluentSetter
    public RestContextBuilder callLogger(Class<? extends RestCallLogger> value) {
        return this.set("RestContext.callLogger.o", value);
    }

    @FluentSetter
    public RestContextBuilder callLogger(RestCallLogger value) {
        return this.set("RestContext.callLogger.o", value);
    }

    @FluentSetter
    public RestContextBuilder callLoggerConfig(RestCallLoggerConfig value) {
        return this.set("RestContext.callLoggerConfig.o", value);
    }

    @FluentSetter
    public RestContextBuilder children(Class<?> ... values) {
        return this.prependTo("RestContext.children.lo", values);
    }

    @FluentSetter
    public RestContextBuilder children(Object ... values) {
        return this.prependTo("RestContext.children.lo", values);
    }

    @FluentSetter
    public RestContextBuilder child(String path, Object child) {
        return this.prependTo("RestContext.children.lo", new RestChild(path, child));
    }

    @FluentSetter
    public RestContextBuilder classpathResourceFinder(Class<? extends ResourceFinder> value) {
        return this.set("RestContext.classpathResourceFinder.o", value);
    }

    @FluentSetter
    public RestContextBuilder classpathResourceFinder(ResourceFinder value) {
        return this.set("RestContext.classpathResourceFinder.o", value);
    }

    @FluentSetter
    public RestContextBuilder clientVersionHeader(String value) {
        return this.set("RestContext.clientVersionHeader.s", value);
    }

    @FluentSetter
    public RestContextBuilder context(Class<? extends RestContext> value) {
        return this.set("RestContext.context.c", value);
    }

    @FluentSetter
    public RestContextBuilder converters(Class<?> ... values) {
        return this.prependTo("RestContext.converters.lo", values);
    }

    @FluentSetter
    public RestContextBuilder converters(RestConverter ... values) {
        return this.prependTo("RestContext.converters.lo", values);
    }

    @FluentSetter
    public RestContextBuilder debug(Enablement value) {
        return this.set("RestContext.debug.s", (Object)value);
    }

    @FluentSetter
    public RestContextBuilder debugOn(String value) {
        return this.set("RestContext.debugOn.s", value);
    }

    @FluentSetter
    public RestContextBuilder defaultCharset(String value) {
        return this.set("RestContext.defaultCharset.s", value);
    }

    @FluentSetter
    public RestContextBuilder defaultCharset(Charset value) {
        return this.set("RestContext.defaultCharset.s", value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder attrs(String ... values) throws RestServletException {
        return this.reqAttrs(values);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder defaultRequestHeaders(String ... headers) throws RestServletException {
        return this.reqHeaders(headers);
    }

    @FluentSetter
    public RestContextBuilder defaultAccept(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.reqHeader("Accept", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder defaultContentType(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.reqHeader("Content-Type", value);
        }
        return this;
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder attr(String name, Object value) {
        return this.reqAttr(name, value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder defaultRequestHeader(String name, Object value) {
        return this.reqHeader(name, value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder defaultResponseHeaders(String ... headers) throws RestServletException {
        return this.resHeaders(headers);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder defaultResponseHeader(String name, Object value) {
        return this.resHeader(name, value);
    }

    @FluentSetter
    public RestContextBuilder encoders(Class<?> ... values) {
        return this.prependTo("RestContext.encoders.lo", values);
    }

    @FluentSetter
    public RestContextBuilder encoders(Encoder ... values) {
        return this.prependTo("RestContext.encoders.lo", values);
    }

    @FluentSetter
    public RestContextBuilder guards(Class<?> ... values) {
        return this.prependTo("RestContext.guards.lo", values);
    }

    @FluentSetter
    public RestContextBuilder guards(RestGuard ... values) {
        return this.prependTo("RestContext.guards.lo", values);
    }

    @FluentSetter
    public RestContextBuilder infoProvider(Class<? extends RestInfoProvider> value) {
        return this.set("RestContext.infoProvider.o", value);
    }

    @FluentSetter
    public RestContextBuilder infoProvider(RestInfoProvider value) {
        return this.set("RestContext.infoProvider.o", value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder logger(Class<? extends RestLogger> value) {
        return this.set("RestContext.logger.o", value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder logger(RestLogger value) {
        return this.set("RestContext.logger.o", value);
    }

    @FluentSetter
    public RestContextBuilder maxInput(String value) {
        return this.set("RestContext.maxInput.s", value);
    }

    @FluentSetter
    public RestContextBuilder messages(Class<?> baseClass, String bundlePath) {
        return this.prependTo("RestContext.messages.lo", Tuple2.of(baseClass, bundlePath));
    }

    @FluentSetter
    public RestContextBuilder messages(String bundlePath) {
        return this.prependTo("RestContext.messages.lo", Tuple2.of(null, bundlePath));
    }

    @FluentSetter
    public RestContextBuilder mimeTypes(String ... values) {
        return this.addTo("RestContext.mimeTypes.ss", values);
    }

    @FluentSetter
    public RestContextBuilder paramResolvers(Class<? extends RestMethodParam> ... values) {
        return this.prependTo("RestContext.paramResolvers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder paramResolvers(RestMethodParam ... values) {
        return this.prependTo("RestContext.paramResolvers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder parserListener(Class<? extends ParserListener> value) {
        if (value != ParserListener.Null.class) {
            this.set("Parser.listener.c", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder parsers(Class<?> ... values) {
        return this.prependTo("RestContext.parsers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder parsers(Object ... values) {
        return this.prependTo("RestContext.parsers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder parsersReplace(Object ... values) {
        return this.set("RestContext.parsers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder partParser(Class<? extends HttpPartParser> value) {
        if (value != HttpPartParser.Null.class) {
            this.set("RestContext.partParser.o", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder partParser(HttpPartParser value) {
        return this.set("RestContext.partParser.o", value);
    }

    @FluentSetter
    public RestContextBuilder partSerializer(Class<? extends HttpPartSerializer> value) {
        if (value != HttpPartSerializer.Null.class) {
            this.set("RestContext.partSerializer.o", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder partSerializer(HttpPartSerializer value) {
        return this.set("RestContext.partSerializer.o", value);
    }

    @FluentSetter
    public RestContextBuilder path(String value) {
        if (StringUtils.startsWith(value, '/')) {
            value = value.substring(1);
        }
        this.set("RestContext.path.s", value);
        return this;
    }

    @FluentSetter
    public RestContextBuilder renderResponseStackTraces(boolean value) {
        return this.set("RestContext.renderResponseStackTraces.b", value);
    }

    @FluentSetter
    public RestContextBuilder renderResponseStackTraces() {
        return this.set("RestContext.renderResponseStackTraces.b", true);
    }

    @FluentSetter
    public RestContextBuilder reqAttr(String name, Object value) {
        return this.putTo("RestContext.reqAttrs.smo", name, value);
    }

    @FluentSetter
    public RestContextBuilder reqAttrs(String ... values) throws RestServletException {
        for (String v : values) {
            String[] p = RestUtils.parseKeyValuePair(v);
            if (p == null) {
                throw new RestServletException("Invalid default request attribute specified: ''{0}''.  Must be in the format: ''Name: value''", v);
            }
            this.reqHeader(p[0], p[1]);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder reqHeader(String name, Object value) {
        return this.putTo("RestContext.reqHeaders.smo", name, value);
    }

    @FluentSetter
    public RestContextBuilder reqHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default request header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.reqHeader(h[0], h[1]);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder resHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid default response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.resHeader(h[0], h[1]);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder resHeader(String name, Object value) {
        return this.putTo("RestContext.resHeaders.omo", name, value);
    }

    @FluentSetter
    public RestContextBuilder resourceResolver(Class<? extends RestResourceResolver> value) {
        return this.set("RestContext.resourceResolver.o", value);
    }

    @FluentSetter
    public RestContextBuilder resourceResolver(RestResourceResolver value) {
        return this.set("RestContext.resourceResolver.o", value);
    }

    @FluentSetter
    public RestContextBuilder responseHandlers(Class<?> ... values) {
        return this.prependTo("RestContext.responseHandlers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder responseHandlers(ResponseHandler ... values) {
        return this.prependTo("RestContext.responseHandlers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder rolesDeclared(String ... values) {
        return this.addTo("RestContext.rolesDeclared.ss", values);
    }

    @FluentSetter
    public RestContextBuilder roleGuard(String value) {
        return this.addTo("RestContext.roleGuard.ss", value);
    }

    @FluentSetter
    public RestContextBuilder serializerListener(Class<? extends SerializerListener> value) {
        if (value != SerializerListener.Null.class) {
            this.set("Serializer.listener.c", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder serializers(Class<?> ... values) {
        return this.prependTo("RestContext.serializers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder serializersReplace(Class<?> ... values) {
        return this.prependTo("RestContext.serializers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder serializers(Object ... values) {
        return this.prependTo("RestContext.serializers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder serializersReplace(Object ... values) {
        return this.set("RestContext.serializers.lo", values);
    }

    @FluentSetter
    public RestContextBuilder staticFileResponseHeaders(Map<String, String> headers) {
        return this.putAllTo("RestContext.staticFileResponseHeaders.omo", headers);
    }

    @FluentSetter
    public RestContextBuilder staticFileResponseHeadersReplace(Map<String, String> headers) {
        return this.set("RestContext.staticFileResponseHeaders.omo", headers);
    }

    @FluentSetter
    public RestContextBuilder staticFileResponseHeaders(String ... headers) throws RestServletException {
        for (String header : headers) {
            String[] h = RestUtils.parseHeader(header);
            if (h == null) {
                throw new RestServletException("Invalid static file response header specified: ''{0}''.  Must be in the format: ''Header-Name: header-value''", header);
            }
            this.staticFileResponseHeader(h[0], h[1]);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder staticFileResponseHeader(String name, String value) {
        return this.putTo("RestContext.staticFileResponseHeaders.omo", name, value);
    }

    @FluentSetter
    public RestContextBuilder staticFiles(StaticFileMapping ... values) {
        return this.prependTo("RestContext.staticFiles.lo", values);
    }

    @FluentSetter
    public RestContextBuilder staticFiles(String mappingString) throws ParseException {
        for (StaticFileMapping sfm : StaticFileMapping.parse(this.resourceClass, mappingString).riterable()) {
            this.staticFiles(sfm);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder staticFiles(Class<?> baseClass, String mappingString) throws ParseException {
        for (StaticFileMapping sfm : StaticFileMapping.parse(baseClass, mappingString).riterable()) {
            this.staticFiles(sfm);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder staticFiles(String path, String location) {
        return this.staticFiles(new StaticFileMapping(this.resourceClass, path, location, null));
    }

    @FluentSetter
    public RestContextBuilder staticFiles(Class<?> baseClass, String path, String location) {
        return this.staticFiles(new StaticFileMapping(baseClass, path, location, null));
    }

    @FluentSetter
    public RestContextBuilder produces(String ... values) {
        return this.prependTo("RestContext.produces.ls", values);
    }

    @FluentSetter
    public RestContextBuilder producesReplace(String ... values) {
        return this.set("RestContext.produces.ls", values);
    }

    @FluentSetter
    public RestContextBuilder produces(MediaType ... values) {
        return this.prependTo("RestContext.produces.ls", values);
    }

    @FluentSetter
    public RestContextBuilder producesReplace(MediaType ... values) {
        return this.set("RestContext.produces.ls", values);
    }

    @FluentSetter
    public RestContextBuilder consumes(String ... values) {
        return this.prependTo("RestContext.consumes.ls", values);
    }

    @FluentSetter
    public RestContextBuilder consumesReplace(String ... values) {
        return this.set("RestContext.consumes.ls", values);
    }

    @FluentSetter
    public RestContextBuilder consumes(MediaType ... values) {
        return this.prependTo("RestContext.consumes.ls", values);
    }

    @FluentSetter
    public RestContextBuilder consumesReplace(MediaType ... values) {
        return this.set("RestContext.consumes.ls", values);
    }

    @FluentSetter
    public RestContextBuilder properties(Map<String, Object> values) {
        return this.putAllTo("RestContext.properties.sms", values);
    }

    @FluentSetter
    public RestContextBuilder property(String name, Object value) {
        return this.putTo("RestContext.properties.sms", name, value);
    }

    @FluentSetter
    public RestContextBuilder uriAuthority(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriAuthority.s", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder uriContext(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriContext.s", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder uriRelativity(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriRelativity.s", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder uriResolution(String value) {
        if (!value.isEmpty()) {
            this.set("RestContext.uriResolution.s", value);
        }
        return this;
    }

    @FluentSetter
    public RestContextBuilder useClasspathResourceCaching(boolean value) {
        return this.set("RestContext.useClasspathResourceCaching.b", value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder useStackTraceHashes(boolean value) {
        return this.set("RestContext.useStackTraceHashes.b", value);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder widgets(Class<? extends Widget> ... values) {
        return this.prependTo("RestContext.widgets.lo", values);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder widgetsReplace(Class<? extends Widget> ... values) {
        return this.set("RestContext.widgets.lo", values);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder widgets(Widget ... values) {
        return this.prependTo("RestContext.widgets.lo", values);
    }

    @Deprecated
    @FluentSetter
    public RestContextBuilder widgetsReplace(Widget ... values) {
        return this.set("RestContext.widgets.lo", values);
    }

    @Override
    public RestContextBuilder set(String name, Object value) {
        super.set(name, value);
        this.properties.put(name, value);
        this.putTo("RestContext.properties.sms", name, value);
        return this;
    }

    @Override
    public RestContextBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        this.properties.clear();
        this.properties.putAll(properties);
        this.putAllTo("RestContext.properties.sms", properties);
        return this;
    }

    @Override
    public RestContextBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public RestContextBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public RestContextBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    @Override
    public RestContextBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public RestContextBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public RestContextBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    @Override
    public RestContextBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    @Override
    public RestContextBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public RestContextBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public RestContextBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public RestContextBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    @Override
    public RestContextBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    @Override
    public RestContextBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    @Override
    public RestContextBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public RestContextBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public RestContextBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    @Override
    public RestContextBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
        super.beanInterceptor(on, value);
        return this;
    }

    @Override
    public RestContextBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    @Override
    public RestContextBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public RestContextBuilder beansDontRequireSomeProperties() {
        super.beansDontRequireSomeProperties();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public RestContextBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public RestContextBuilder bpi(Map<String, Object> values) {
        super.bpi(values);
        return this;
    }

    @Override
    public RestContextBuilder bpi(Class<?> beanClass, String properties) {
        super.bpi(beanClass, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpi(String beanClassName, String properties) {
        super.bpi(beanClassName, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpro(Map<String, Object> values) {
        super.bpro(values);
        return this;
    }

    @Override
    public RestContextBuilder bpro(Class<?> beanClass, String properties) {
        super.bpro(beanClass, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpro(String beanClassName, String properties) {
        super.bpro(beanClassName, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpwo(Map<String, Object> values) {
        super.bpwo(values);
        return this;
    }

    @Override
    public RestContextBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo(beanClass, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpwo(String beanClassName, String properties) {
        super.bpwo(beanClassName, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpx(Map<String, Object> values) {
        super.bpx(values);
        return this;
    }

    @Override
    public RestContextBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx(beanClass, properties);
        return this;
    }

    @Override
    public RestContextBuilder bpx(String beanClassName, String properties) {
        super.bpx(beanClassName, properties);
        return this;
    }

    @Override
    public RestContextBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public RestContextBuilder dictionaryOn(Class<?> on, Class<?> ... values) {
        super.dictionaryOn(on, values);
        return this;
    }

    @Override
    public RestContextBuilder dontIgnorePropertiesWithoutSetters() {
        super.dontIgnorePropertiesWithoutSetters();
        return this;
    }

    @Override
    public RestContextBuilder dontIgnoreTransientFields() {
        super.dontIgnoreTransientFields();
        return this;
    }

    @Override
    public RestContextBuilder dontIgnoreUnknownNullBeanProperties() {
        super.dontIgnoreUnknownNullBeanProperties();
        return this;
    }

    @Override
    public RestContextBuilder dontUseInterfaceProxies() {
        super.dontUseInterfaceProxies();
        return this;
    }

    @Override
    public <T> RestContextBuilder example(Class<T> pojoClass, T o) {
        super.example(pojoClass, o);
        return this;
    }

    @Override
    public <T> RestContextBuilder exampleJson(Class<T> pojoClass, String json) {
        super.exampleJson(pojoClass, json);
        return this;
    }

    @Override
    public RestContextBuilder fluentSetters() {
        super.fluentSetters();
        return this;
    }

    @Override
    public RestContextBuilder fluentSetters(Class<?> on) {
        super.fluentSetters(on);
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public RestContextBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public RestContextBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public RestContextBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    @Override
    public RestContextBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder interfaceClass(Class<?> on, Class<?> value) {
        super.interfaceClass(on, value);
        return this;
    }

    @Override
    public RestContextBuilder interfaces(Class<?> ... value) {
        super.interfaces(value);
        return this;
    }

    @Override
    public RestContextBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public RestContextBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public RestContextBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        super.propertyNamer(value);
        return this;
    }

    @Override
    public RestContextBuilder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
        super.propertyNamer(on, value);
        return this;
    }

    @Override
    public RestContextBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public RestContextBuilder sortProperties(Class<?> ... on) {
        super.sortProperties(on);
        return this;
    }

    @Override
    public RestContextBuilder stopClass(Class<?> on, Class<?> value) {
        super.stopClass(on, value);
        return this;
    }

    @Override
    public RestContextBuilder swaps(Object ... values) {
        super.swaps(values);
        return this;
    }

    @Override
    public RestContextBuilder typeName(Class<?> on, String value) {
        super.typeName(on, value);
        return this;
    }

    @Override
    public RestContextBuilder typePropertyName(String value) {
        super.typePropertyName(value);
        return this;
    }

    @Override
    public RestContextBuilder typePropertyName(Class<?> on, String value) {
        super.typePropertyName(on, value);
        return this;
    }

    @Override
    public RestContextBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public RestContextBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    public String getInitParameter(String name) {
        return this.inner.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.inner.getInitParameterNames();
    }

    public ServletContext getServletContext() {
        return this.inner.getServletContext();
    }

    public String getServletName() {
        return this.inner.getServletName();
    }
}

