/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.NoCloseOutputStream;
import org.apache.juneau.internal.NoCloseWriter;
import org.apache.juneau.internal.StringBuilderWriter;
import org.apache.juneau.serializer.SerializeException;

public final class SerializerPipe
implements Closeable {
    private final Object output;
    private final boolean autoClose;
    private OutputStream outputStream;
    private Writer writer;
    private Charset charset;

    SerializerPipe(Object output, Charset streamCharset, Charset fileCharset) {
        Charset cs;
        boolean isFile = output instanceof File;
        this.output = output;
        this.autoClose = isFile;
        Charset charset = cs = isFile ? fileCharset : streamCharset;
        if (cs == null) {
            cs = isFile ? Charset.defaultCharset() : IOUtils.UTF8;
        }
        this.charset = cs;
    }

    SerializerPipe(Object output) {
        this.output = output;
        this.autoClose = false;
        this.charset = null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            throw new IOException("Output cannot be null.");
        }
        if (this.output instanceof OutputStream) {
            this.outputStream = (OutputStream)this.output;
        } else if (this.output instanceof File) {
            this.outputStream = new BufferedOutputStream(new FileOutputStream((File)this.output));
        } else {
            throw new IOException("Cannot convert object of type " + ClassUtils.className(this.output) + " to an OutputStream.");
        }
        return new NoCloseOutputStream(this.outputStream);
    }

    public Writer getWriter() throws SerializeException {
        block7: {
            if (this.output == null) {
                throw new SerializeException("Output cannot be null.", new Object[0]);
            }
            try {
                if (this.output instanceof Writer) {
                    this.writer = (Writer)this.output;
                    break block7;
                }
                if (this.output instanceof OutputStream) {
                    this.writer = new OutputStreamWriter((OutputStream)this.output, this.charset);
                    break block7;
                }
                if (this.output instanceof File) {
                    this.writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream((File)this.output)));
                    break block7;
                }
                if (this.output instanceof StringBuilder) {
                    this.writer = new StringBuilderWriter((StringBuilder)this.output);
                    break block7;
                }
                throw new SerializeException("Cannot convert object of type " + ClassUtils.className(this.output) + " to a Writer.", new Object[0]);
            }
            catch (FileNotFoundException e) {
                throw ThrowableUtils.cast(SerializeException.class, e);
            }
        }
        return new NoCloseWriter(this.writer);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public Object getRawOutput() {
        return this.output;
    }

    @Override
    public void close() {
        try {
            IOUtils.flush(this.writer, this.outputStream);
            if (this.autoClose) {
                IOUtils.close(this.writer, this.outputStream);
            }
        }
        catch (IOException e) {
            throw new BeanRuntimeException(e);
        }
    }
}

