/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.processor.Throttler;
import org.apache.camel.reifier.ExpressionReifier;

public class ThrottleReifier
extends ExpressionReifier<ThrottleDefinition> {
    public ThrottleReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ThrottleDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean async = this.parseBoolean(((ThrottleDefinition)this.definition).getAsyncDelayed(), false);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), true);
        ScheduledExecutorService threadPool = this.getConfiguredScheduledExecutorService("Throttle", (ExecutorServiceAwareDefinition)((Object)this.definition), true);
        long period = ((ThrottleDefinition)this.definition).getTimePeriodMillis() != null ? this.parseDuration(((ThrottleDefinition)this.definition).getTimePeriodMillis()) : 1000L;
        Expression maxRequestsExpression = this.createMaxRequestsPerPeriodExpression();
        if (maxRequestsExpression == null) {
            throw new IllegalArgumentException("MaxRequestsPerPeriod expression must be provided on " + this);
        }
        Expression correlation = null;
        if (((ThrottleDefinition)this.definition).getCorrelationExpression() != null) {
            correlation = this.createExpression(((ThrottleDefinition)this.definition).getCorrelationExpression());
        }
        boolean reject = this.parseBoolean(((ThrottleDefinition)this.definition).getRejectExecution(), false);
        Throttler answer = new Throttler(this.camelContext, maxRequestsExpression, period, threadPool, shutdownThreadPool, reject, correlation);
        answer.setAsyncDelayed(async);
        answer.setCallerRunsWhenRejected(this.parseBoolean(((ThrottleDefinition)this.definition).getCallerRunsWhenRejected(), true));
        return answer;
    }

    private Expression createMaxRequestsPerPeriodExpression() {
        return ((ThrottleDefinition)this.definition).getExpression() != null ? this.createExpression(((ThrottleDefinition)this.definition).getExpression()) : null;
    }
}

