/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.resolution.typeinference.BoundSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.ConstraintFormula;
import com.github.javaparser.symbolsolver.resolution.typeinference.ControlFlowLogic;
import com.github.javaparser.symbolsolver.resolution.typeinference.InferenceVariable;
import com.github.javaparser.symbolsolver.resolution.typeinference.MethodType;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeInference;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeInferenceCache;
import com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas.TypeCompatibleWithType;
import com.github.javaparser.utils.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExpressionCompatibleWithType
extends ConstraintFormula {
    private TypeSolver typeSolver;
    private Expression expression;
    private ResolvedType T;

    public ExpressionCompatibleWithType(TypeSolver typeSolver, Expression expression, ResolvedType T) {
        this.typeSolver = typeSolver;
        this.expression = expression;
        this.T = T;
    }

    @Override
    public ConstraintFormula.ReductionResult reduce(BoundSet currentBoundSet) {
        if (TypeHelper.isProperType(this.T)) {
            if (TypeHelper.isCompatibleInALooseInvocationContext(this.typeSolver, this.expression, this.T)) {
                return ConstraintFormula.ReductionResult.trueResult();
            }
            return ConstraintFormula.ReductionResult.falseResult();
        }
        if (this.expression.isStandaloneExpression()) {
            ResolvedType s = JavaParserFacade.get(this.typeSolver).getType((Node)this.expression, false);
            return ConstraintFormula.ReductionResult.empty().withConstraint(new TypeCompatibleWithType(this.typeSolver, s, this.T));
        }
        if (this.expression.isPolyExpression()) {
            if (this.expression.isEnclosedExpr()) {
                EnclosedExpr enclosedExpr = this.expression.asEnclosedExpr();
                return ConstraintFormula.ReductionResult.oneConstraint(new ExpressionCompatibleWithType(this.typeSolver, enclosedExpr.getInner(), this.T));
            }
            if (this.expression.isObjectCreationExpr()) {
                BoundSet B3 = new TypeInference(this.typeSolver).invocationTypeInferenceBoundsSetB3();
                return ConstraintFormula.ReductionResult.bounds(B3);
            }
            if (this.expression.isMethodCallExpr()) {
                throw new UnsupportedOperationException();
            }
            if (this.expression.isConditionalExpr()) {
                ConditionalExpr conditionalExpr = this.expression.asConditionalExpr();
                return ConstraintFormula.ReductionResult.withConstraints(new ExpressionCompatibleWithType(this.typeSolver, conditionalExpr.getThenExpr(), this.T), new ExpressionCompatibleWithType(this.typeSolver, conditionalExpr.getElseExpr(), this.T));
            }
            if (this.expression.isLambdaExpr()) {
                LambdaExpr lambdaExpr = this.expression.asLambdaExpr();
                if (!FunctionalInterfaceLogic.isFunctionalInterfaceType((ResolvedType)this.T)) {
                    return ConstraintFormula.ReductionResult.falseResult();
                }
                Pair<ResolvedType, Boolean> result = TypeHelper.groundTargetTypeOfLambda(lambdaExpr, this.T, this.typeSolver);
                ResolvedType TFirst = (ResolvedType)result.a;
                MethodType targetFunctionType = TypeHelper.getFunctionType(TFirst);
                targetFunctionType = this.replaceTypeVariablesWithInferenceVariables(targetFunctionType);
                if (((Boolean)result.b).booleanValue()) {
                    throw new UnsupportedOperationException();
                }
                if (targetFunctionType.getFormalArgumentTypes().size() != lambdaExpr.getParameters().size()) {
                    return ConstraintFormula.ReductionResult.falseResult();
                }
                if (targetFunctionType.getReturnType().isVoid()) {
                    throw new UnsupportedOperationException();
                }
                if (!targetFunctionType.getReturnType().isVoid() && lambdaExpr.getBody().isBlockStmt() && !this.isValueCompatibleBlock(lambdaExpr.getBody())) {
                    return ConstraintFormula.ReductionResult.falseResult();
                }
                LinkedList<ConstraintFormula> constraints = new LinkedList<ConstraintFormula>();
                boolean hasExplicitlyDeclaredTypes = lambdaExpr.getParameters().stream().anyMatch(p -> !p.getType().isUnknownType());
                if (hasExplicitlyDeclaredTypes) {
                    throw new UnsupportedOperationException();
                }
                if (!targetFunctionType.getReturnType().isVoid()) {
                    ResolvedType R = targetFunctionType.getReturnType();
                    if (TypeHelper.isProperType(R)) {
                        if (lambdaExpr.getBody().isBlockStmt()) {
                            List<Expression> resultExpressions = this.getResultExpressions(lambdaExpr.getBody().asBlockStmt());
                            for (Expression e2 : resultExpressions) {
                                if (this.isCompatibleInAssignmentContext(e2, R, this.typeSolver)) continue;
                                return ConstraintFormula.ReductionResult.falseResult();
                            }
                        } else {
                            Expression e3 = lambdaExpr.getBody().asExpressionStmt().getExpression();
                            if (!this.isCompatibleInAssignmentContext(e3, R, this.typeSolver)) {
                                return ConstraintFormula.ReductionResult.falseResult();
                            }
                        }
                    } else if (lambdaExpr.getBody().isBlockStmt()) {
                        this.getAllReturnExpressions(lambdaExpr.getBody().asBlockStmt()).forEach(e -> constraints.add(new ExpressionCompatibleWithType(this.typeSolver, (Expression)e, R)));
                    } else {
                        for (int i = 0; i < lambdaExpr.getParameters().size(); ++i) {
                            ResolvedType paramType = targetFunctionType.getFormalArgumentTypes().get(i);
                            TypeInferenceCache.addRecord(this.typeSolver, lambdaExpr, lambdaExpr.getParameter(i).getNameAsString(), paramType);
                        }
                        Expression e4 = lambdaExpr.getBody().asExpressionStmt().getExpression();
                        constraints.add(new ExpressionCompatibleWithType(this.typeSolver, e4, R));
                    }
                }
                return ConstraintFormula.ReductionResult.withConstraints(constraints);
            }
            if (this.expression.isMethodReferenceExpr()) {
                throw new UnsupportedOperationException();
            }
            throw new RuntimeException("This should not happen");
        }
        throw new RuntimeException("This should not happen");
    }

    private List<Expression> getResultExpressions(BlockStmt blockStmt) {
        throw new UnsupportedOperationException();
    }

    private boolean isCompatibleInAssignmentContext(Expression expression, ResolvedType type, TypeSolver typeSolver) {
        return type.isAssignableBy(JavaParserFacade.get(typeSolver).getType((Node)expression, false));
    }

    private List<Expression> getAllReturnExpressions(BlockStmt blockStmt) {
        return blockStmt.findAll(ReturnStmt.class).stream().filter(r -> r.getExpression().isPresent()).map(r -> (Expression)r.getExpression().get()).collect(Collectors.toList());
    }

    private boolean isValueCompatibleBlock(Statement statement) {
        if (statement.isBlockStmt()) {
            if (!ControlFlowLogic.getInstance().canCompleteNormally(statement)) {
                return true;
            }
            List returnStmts = statement.findAll(ReturnStmt.class);
            return returnStmts.stream().allMatch(r -> r.getExpression().isPresent());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibleWithType that = (ExpressionCompatibleWithType)o;
        if (!this.typeSolver.equals(that.typeSolver)) {
            return false;
        }
        if (!this.expression.equals((Object)that.expression)) {
            return false;
        }
        return this.T.equals(that.T);
    }

    public int hashCode() {
        int result = this.typeSolver.hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.T.hashCode();
        return result;
    }

    public String toString() {
        return "ExpressionCompatibleWithType{typeSolver=" + this.typeSolver + ", expression=" + this.expression + ", T=" + this.T + '}';
    }

    private MethodType replaceTypeVariablesWithInferenceVariables(MethodType methodType) {
        HashMap<ResolvedTypeVariable, InferenceVariable> correspondences = new HashMap<ResolvedTypeVariable, InferenceVariable>();
        LinkedList<ResolvedType> newFormalArgumentTypes = new LinkedList<ResolvedType>();
        for (ResolvedType formalArg : methodType.getFormalArgumentTypes()) {
            newFormalArgumentTypes.add(this.replaceTypeVariablesWithInferenceVariables(formalArg, correspondences));
        }
        ResolvedType newReturnType = this.replaceTypeVariablesWithInferenceVariables(methodType.getReturnType(), correspondences);
        return new MethodType(methodType.getTypeParameters(), newFormalArgumentTypes, newReturnType, methodType.getExceptionTypes());
    }

    private ResolvedType replaceTypeVariablesWithInferenceVariables(ResolvedType originalType, Map<ResolvedTypeVariable, InferenceVariable> correspondences) {
        if (originalType.isTypeVariable()) {
            if (!correspondences.containsKey(originalType.asTypeVariable())) {
                correspondences.put(originalType.asTypeVariable(), InferenceVariable.unnamed(originalType.asTypeVariable().asTypeParameter()));
            }
            return correspondences.get(originalType.asTypeVariable());
        }
        if (originalType.isPrimitive()) {
            return originalType;
        }
        throw new UnsupportedOperationException(originalType.toString());
    }
}

