/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.impl.ints;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.util.Arrays;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.AbstractPrimitiveReaders;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.PrimitiveArrayBuilderWrapper;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.repeated.RepeatedReadSchemas;

public class IntRepeatedReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor, AbstractPrimitiveReaders<int[], Integer> readers) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (int[].class.equals((Object)javaType.getRawClass())) {
            return new IntPrimitiveArraySchema(protoField, propertyDescriptor, readers);
        }
        return RepeatedReadSchemas.create(protoField, propertyDescriptor, readers);
    }

    static class IntPrimitiveArraySchema<T>
    extends FieldSchema<T> {
        private final Getter<T, int[]> getter;
        private final Setter<T, int[]> setter;
        private final AbstractPrimitiveReaders<int[], Integer> readers;

        public IntPrimitiveArraySchema(Field protoField, PropertyDescriptor propertyDescriptor, AbstractPrimitiveReaders<int[], Integer> readers) {
            super(protoField, propertyDescriptor.getJavaType());
            this.getter = (Getter)propertyDescriptor.getGetter();
            this.setter = (Setter)propertyDescriptor.getSetter();
            this.readers = readers;
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            PrimitiveArrayBuilderWrapper builderWrapper = new PrimitiveArrayBuilderWrapper(input.getArrayBuilders().getIntBuilder());
            int fieldNumber = this.readers.primitiveArrayReader.read(input, builderWrapper);
            int[] newValue = (int[])builderWrapper.getArray();
            newValue = this.mergeArray((int[])this.getter.get(message), newValue);
            this.setter.set(message, (Object)newValue);
            return fieldNumber;
        }

        public int[] mergeArray(int[] oldValue, int[] newValue) {
            if (oldValue == null || oldValue.length == 0) {
                return newValue;
            }
            return this.concatArray(oldValue, newValue);
        }

        private int[] concatArray(int[] oldValue, int[] newValue) {
            int len1 = oldValue.length;
            int len2 = newValue.length;
            int[] result = Arrays.copyOf(oldValue, len1 + len2);
            System.arraycopy(newValue, 0, result, len1, len2);
            return result;
        }
    }
}

