/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(AdminPermissionChecker.class);
    private static final String ADMIN_USER = "admin";
    private static final String SYSTEM_USER = "system";
    private static final String ADMINISTRATORS_GROUP = "administrators";
    public static final ComparableVersion VERSION_OAK_140 = new ComparableVersion("1.40");

    private AdminPermissionChecker() {
    }

    public static boolean hasAdministrativePermissions(@NotNull Session session, String ... additionalAdminAuthorizableIdsOrPrincipalNames) throws RepositoryException {
        String userId;
        JackrabbitSession jackrabbitSession;
        List<String> additionalAdminIdsOrPrincipalNames = Arrays.asList(Optional.ofNullable(additionalAdminAuthorizableIdsOrPrincipalNames).orElse(new String[0]));
        if (session instanceof JackrabbitSession) {
            jackrabbitSession = (JackrabbitSession)session;
            if (AdminPermissionChecker.isOakVersionExposingBoundPrincipals(session.getRepository()) && AdminPermissionChecker.hasAdministrativePermissionsWithPrincipals(jackrabbitSession, additionalAdminIdsOrPrincipalNames)) {
                return true;
            }
        } else {
            jackrabbitSession = null;
        }
        if (AdminPermissionChecker.hasAdministrativePermissionsWithAuthorizableId(userId = session.getUserID(), additionalAdminIdsOrPrincipalNames)) {
            return true;
        }
        if (jackrabbitSession != null) {
            Authorizable authorizable = jackrabbitSession.getUserManager().getAuthorizable(userId);
            if (authorizable == null) {
                return false;
            }
            Iterator<Group> groupIterator = authorizable.memberOf();
            while (groupIterator.hasNext()) {
                String groupId = groupIterator.next().getID();
                if (!AdminPermissionChecker.hasAdministrativePermissionsWithAuthorizableId(groupId, additionalAdminIdsOrPrincipalNames)) continue;
                return true;
            }
        } else {
            log.warn("could not evaluate group permissions but just user name");
        }
        return false;
    }

    static boolean hasAdministrativePermissionsWithPrincipals(@NotNull Session session, List<String> additionalAdminPrincipalNames) {
        Set boundPrincipals = (Set)session.getAttribute("oak.bound-principals");
        if (boundPrincipals != null) {
            for (Principal principal : boundPrincipals) {
                if (!additionalAdminPrincipalNames.contains(principal.getName())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean hasAdministrativePermissionsWithAuthorizableId(@NotNull String authorizableId, List<String> additionalAdminIds) {
        if (ADMIN_USER.equals(authorizableId) || SYSTEM_USER.equals(authorizableId) || ADMINISTRATORS_GROUP.equals(authorizableId)) {
            return true;
        }
        return additionalAdminIds.contains(authorizableId);
    }

    static boolean isOakVersionExposingBoundPrincipals(@NotNull Repository repository) {
        if (!"Apache Jackrabbit Oak".equals(repository.getDescriptor("jcr.repository.name"))) {
            return false;
        }
        String version = repository.getDescriptor("jcr.repository.version");
        if (version == null) {
            return false;
        }
        return new ComparableVersion(version).compareTo(VERSION_OAK_140) >= 0;
    }
}

