/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.AbstractConfigTypeReflectionProvider;
import org.apache.sling.testing.mock.osgi.config.AnnotationTypedConfig;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeContext;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigCollection;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigType;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;

@ConfigType(type=ServiceRanking.class, lenient=true)
public class AnnotationTypedConfigTest {
    private TestOsgiContext context;
    private ConfigTypeContext configTypeContext;

    @Before
    public void setUp() throws Exception {
        this.context = new TestOsgiContext();
        this.context.setUpContext();
        this.configTypeContext = new ConfigTypeContext((OsgiContextImpl)this.context);
    }

    @After
    public void tearDown() throws Exception {
        this.context.tearDownContext();
    }

    @Test
    public void testNewInstance() {
        ConfigType annotation = this.getClass().getAnnotation(ConfigType.class);
        ServiceRanking config = (ServiceRanking)this.configTypeContext.constructConfigType(annotation);
        AnnotationTypedConfig typedConfig = AnnotationTypedConfig.newInstance(ServiceRanking.class, (Object)config, (Annotation)annotation);
        Assert.assertSame(ServiceRanking.class, (Object)typedConfig.getType());
        Assert.assertSame((Object)config, (Object)typedConfig.getConfig());
        Assert.assertEquals((long)0L, (long)typedConfig.stream(ServiceVendor.class).count());
    }

    @Test
    public void testNewInstanceUsingConfigAsAnnotation() {
        ConfigType annotation = this.getClass().getAnnotation(ConfigType.class);
        ServiceRanking config = (ServiceRanking)this.configTypeContext.constructConfigType(annotation);
        AnnotationTypedConfig typedConfig = AnnotationTypedConfig.newInstance(ServiceRanking.class, (Object)config, (Annotation)config);
        Assert.assertSame(ServiceRanking.class, (Object)typedConfig.getType());
        Assert.assertSame((Object)config, (Object)typedConfig.getConfig());
        Assert.assertEquals((long)0L, (long)typedConfig.stream(ServiceVendor.class).count());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTypeCastMismatch() throws Exception {
        ConfigType annotation = this.getClass().getAnnotation(ConfigType.class);
        ServiceRanking config = (ServiceRanking)this.configTypeContext.constructConfigType(annotation);
        AnnotationTypedConfig.newInstance(ServiceVendor.class, (Object)config, (Annotation)annotation);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTypeAnnotationMismatch() throws Exception {
        ConfigType annotation = this.getClass().getAnnotation(ConfigType.class);
        ServiceRanking config = (ServiceRanking)this.configTypeContext.constructConfigType(annotation);
        ConfigType wrongAnnotation = TestOsgiContext.class.getAnnotation(ConfigType.class);
        AnnotationTypedConfig.newInstance(ServiceRanking.class, (Object)config, (Annotation)wrongAnnotation);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTypeAnnotationMismatchUsingConfigAsAnnotation() throws Exception {
        ConfigType annotation = this.getClass().getAnnotation(ConfigType.class);
        ServiceRanking config = (ServiceRanking)this.configTypeContext.constructConfigType(annotation);
        ConfigType wrongAnnotation = TestOsgiContext.class.getAnnotation(ConfigType.class);
        ServiceVendor wrongAnnotationConfig = (ServiceVendor)this.configTypeContext.constructConfigType(wrongAnnotation);
        AnnotationTypedConfig.newInstance(ServiceRanking.class, (Object)config, (Annotation)wrongAnnotationConfig);
    }

    @Test
    public void testGetConfigMap() {
        ConfigType annotation = this.getClass().getAnnotation(ConfigType.class);
        Assert.assertEquals(Map.of("service.ranking", 0), (Object)this.configTypeContext.newTypedConfig((Annotation)annotation).getConfigMap());
        ConfigType wrongAnnotation = TestOsgiContext.class.getAnnotation(ConfigType.class);
        ServiceVendor wrongAnnotationConfig = (ServiceVendor)this.configTypeContext.constructConfigType(wrongAnnotation);
        Assert.assertTrue((boolean)AbstractConfigTypeReflectionProvider.getInstance((Class)annotation.type()).getPropertyMap((Object)wrongAnnotationConfig).isEmpty());
        ConfigCollection collection = (ConfigCollection)Mockito.mock(ConfigCollection.class);
        ((ConfigCollection)Mockito.doCallRealMethod().when((Object)collection)).stream((Class)ArgumentMatchers.any(Class.class));
        ((ConfigCollection)Mockito.doCallRealMethod().when((Object)collection)).firstConfigMap((Class)ArgumentMatchers.any(Class.class));
        ((ConfigCollection)Mockito.doAnswer(call -> Stream.of(this.configTypeContext.newTypedConfig((Annotation)annotation))).when((Object)collection)).stream();
        Assert.assertEquals(Map.of("service.ranking", 0), (Object)collection.firstConfigMap(ServiceRanking.class));
    }

    @ConfigType(type=ServiceVendor.class, lenient=true)
    static class TestOsgiContext
    extends OsgiContextImpl {
        TestOsgiContext() {
        }

        void setUpContext() {
            this.setUp();
        }

        void tearDownContext() {
            this.tearDown();
        }
    }
}

