/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Timer;
import groovy.lang.GroovyRuntimeException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.groovy.jsr223.TimedInterruptTimeoutException;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.JavaTranslator;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Failure;
import org.apache.tinkerpop.gremlin.process.traversal.GraphOp;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.util.BytecodeHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.handler.Frame;
import org.apache.tinkerpop.gremlin.server.handler.Session;
import org.apache.tinkerpop.gremlin.server.handler.SessionException;
import org.apache.tinkerpop.gremlin.server.handler.SessionTask;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.AbstractOpProcessor;
import org.apache.tinkerpop.gremlin.server.util.TraverserIterator;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.TemporaryException;
import org.apache.tinkerpop.gremlin.util.ExceptionHelper;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.util.ser.MessageTextSerializer;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession
implements Session,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSession.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    private final boolean sessionIdOnRequest;
    private final Channel initialChannel;
    private final boolean transactionManaged;
    private final String sessionId;
    private final AtomicReference<ScheduledFuture<?>> sessionCancelFuture = new AtomicReference();
    private final AtomicReference<Future<?>> sessionFuture = new AtomicReference();
    private long actualTimeoutLengthWhenClosed = 0L;
    protected Thread sessionThread;
    protected final boolean maintainStateAfterException;
    protected final AtomicReference<CloseReason> closeReason = new AtomicReference();
    protected final GraphManager graphManager;
    protected final ConcurrentMap<String, Session> sessions;
    protected final Set<String> aliasesUsedBySession = new HashSet<String>();
    protected final AtomicBoolean sessionTaskStarted = new AtomicBoolean(false);

    AbstractSession(SessionTask sessionTask, String sessionId, boolean transactionManaged, ConcurrentMap<String, Session> sessions) {
        this.maintainStateAfterException = sessionTask.getRequestMessage().optionalArgs("maintainStateAfterException").orElse(false);
        this.sessionIdOnRequest = sessionTask.getRequestMessage().optionalArgs("session").isPresent();
        this.transactionManaged = transactionManaged;
        this.sessionId = sessionId;
        this.initialChannel = sessionTask.getChannelHandlerContext().channel();
        this.initialChannel.closeFuture().addListener(f -> {
            if (this.closeReason.compareAndSet(null, CloseReason.CHANNEL_CLOSED)) {
                this.close();
            }
        });
        this.sessions = sessions;
        this.graphManager = sessionTask.getGraphManager();
    }

    protected synchronized void cancel(boolean mayInterruptIfRunning) {
        FutureTask sf = (FutureTask)this.sessionFuture.get();
        if (sf != null && !sf.isDone()) {
            sf.cancel(mayInterruptIfRunning);
            if (!this.sessionTaskStarted.get()) {
                this.sendTimeoutResponseForUncommencedTask();
            }
        }
    }

    public boolean isTransactionManaged() {
        return this.transactionManaged;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isBoundTo(Channel channel) {
        return channel == this.initialChannel;
    }

    public long getActualTimeoutLengthWhenClosed() {
        return this.actualTimeoutLengthWhenClosed;
    }

    public Optional<CloseReason> getCloseReason() {
        return Optional.ofNullable(this.closeReason.get());
    }

    public GremlinScriptEngine getScriptEngine(SessionTask sessionTask, String language) {
        return sessionTask.getGremlinExecutor().getScriptEngineManager().getEngineByName(language);
    }

    protected abstract void sendTimeoutResponseForUncommencedTask();

    @Override
    public void setSessionCancelFuture(ScheduledFuture<?> f) {
        if (!this.sessionCancelFuture.compareAndSet(null, f)) {
            throw new IllegalStateException("Session cancellation future is already set");
        }
    }

    @Override
    public void setSessionFuture(Future<?> f) {
        if (!this.sessionFuture.compareAndSet(null, f)) {
            throw new IllegalStateException("Session future is already set");
        }
    }

    @Override
    public synchronized void triggerTimeout(long timeout, boolean causedBySession) {
        Future<?> f = this.sessionFuture.get();
        if (f != null && !f.isDone() && this.closeReason.compareAndSet(null, causedBySession ? CloseReason.SESSION_TIMEOUT : CloseReason.REQUEST_TIMEOUT)) {
            this.actualTimeoutLengthWhenClosed = timeout;
            if (causedBySession || !this.sessionIdOnRequest) {
                this.cancel(true);
            } else if (this.sessionThread != null) {
                this.sessionThread.interrupt();
            } else {
                logger.debug("{} is a {} which cannot be interrupted as the thread running the session has not been set - please check the implementation if this is not desirable", (Object)this.sessionId, (Object)this.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(SessionTask sessionTask) throws SessionException {
        RequestMessage msg = sessionTask.getRequestMessage();
        Map args = msg.getArgs();
        Object gremlinToExecute = args.get("gremlin");
        if (sessionTask.getSettings().strictTransactionManagement) {
            msg.optionalArgs("aliases").ifPresent(m -> this.aliasesUsedBySession.addAll(((Map)m).values()));
        }
        Timer.Context timer = this.getMetricsTimer(sessionTask);
        try {
            Optional<Iterator<?>> itty = gremlinToExecute instanceof Bytecode ? this.fromBytecode(sessionTask, (Bytecode)gremlinToExecute) : Optional.of(this.fromScript(sessionTask, (String)gremlinToExecute));
            this.processAuditLog(sessionTask.getSettings(), sessionTask.getChannelHandlerContext(), gremlinToExecute);
            if (itty.isPresent()) {
                this.handleIterator(sessionTask, itty.get());
            }
        }
        catch (Throwable t) {
            this.handleException(sessionTask, t);
        }
        finally {
            timer.stop();
        }
    }

    protected void handleException(SessionTask sessionTask, Throwable t) throws SessionException {
        if (t instanceof SessionException) {
            throw (SessionException)t;
        }
        Optional<Throwable> possibleSpecialException = AbstractSession.determineIfSpecialException(t);
        if (possibleSpecialException.isPresent()) {
            Throwable special = possibleSpecialException.get();
            ResponseMessage.Builder specialResponseMsg = ResponseMessage.build((RequestMessage)sessionTask.getRequestMessage()).statusMessage(special.getMessage()).statusAttributeException(special);
            if (special instanceof TemporaryException) {
                specialResponseMsg.code(ResponseStatusCode.SERVER_ERROR_TEMPORARY);
            } else if (special instanceof Failure) {
                Failure failure = (Failure)special;
                specialResponseMsg.code(ResponseStatusCode.SERVER_ERROR_FAIL_STEP).statusAttribute("failStepMessage", (Object)failure.format());
            }
            throw new SessionException(special.getMessage(), specialResponseMsg.create());
        }
        Throwable root = ExceptionHelper.getRootCause((Throwable)t);
        if (root instanceof TimedInterruptTimeoutException) {
            String msg = String.format("A timeout occurred within the script during evaluation of [%s] - consider increasing the limit given to TimedInterruptCustomizerProvider", sessionTask.getRequestMessage().getRequestId());
            throw new SessionException(msg, root, ResponseMessage.build((RequestMessage)sessionTask.getRequestMessage()).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage("Timeout during script evaluation triggered by TimedInterruptCustomizerProvider").create());
        }
        if (root instanceof TimeoutException) {
            String errorMessage = String.format("Script evaluation exceeded the configured threshold for request [%s]", sessionTask.getRequestMessage().getRequestId());
            throw new SessionException(errorMessage, root, ResponseMessage.build((RequestMessage)sessionTask.getRequestMessage()).code(ResponseStatusCode.SERVER_ERROR_TIMEOUT).statusMessage(t.getMessage()).create());
        }
        if (root instanceof InterruptedException || root instanceof TraversalInterruptedException || root instanceof InterruptedIOException) {
            String msg = "Processing interrupted but the reason why was not known";
            switch (this.closeReason.get()) {
                case CHANNEL_CLOSED: {
                    msg = "Processing interrupted because the channel was closed";
                    break;
                }
                case SESSION_TIMEOUT: {
                    msg = String.format("Session closed - %s - sessionLifetimeTimeout of %s ms exceeded", this.sessionId, this.actualTimeoutLengthWhenClosed);
                    break;
                }
                case REQUEST_TIMEOUT: {
                    msg = String.format("Evaluation exceeded timeout threshold of %s ms", this.actualTimeoutLengthWhenClosed);
                }
            }
            ResponseStatusCode code = this.closeReason.get() == CloseReason.SESSION_TIMEOUT || this.closeReason.get() == CloseReason.REQUEST_TIMEOUT ? ResponseStatusCode.SERVER_ERROR_TIMEOUT : ResponseStatusCode.SERVER_ERROR;
            throw new SessionException(msg, root, ResponseMessage.build((RequestMessage)sessionTask.getRequestMessage()).code(code).statusMessage(msg).create());
        }
        if (root instanceof MultipleCompilationErrorsException && root.getMessage().contains("Method too large") && ((MultipleCompilationErrorsException)root).getErrorCollector().getErrorCount() == 1) {
            String errorMessage = String.format("The Gremlin statement that was submitted exceeds the maximum compilation size allowed by the JVM, please split it into multiple smaller statements - %s", this.trimMessage(sessionTask.getRequestMessage()));
            logger.warn(errorMessage);
            throw new SessionException(errorMessage, root, ResponseMessage.build((RequestMessage)sessionTask.getRequestMessage()).code(ResponseStatusCode.SERVER_ERROR_EVALUATION).statusMessage(errorMessage).statusAttributeException(root).create());
        }
        if (root instanceof GroovyRuntimeException || root instanceof VerificationException || root instanceof ScriptException) {
            throw new SessionException(root.getMessage(), root, ResponseMessage.build((RequestMessage)sessionTask.getRequestMessage()).code(ResponseStatusCode.SERVER_ERROR_EVALUATION).statusMessage(root.getMessage()).statusAttributeException(root).create());
        }
        throw new SessionException(root.getClass().getSimpleName() + ": " + root.getMessage(), root, ResponseMessage.build((RequestMessage)sessionTask.getRequestMessage()).code(ResponseStatusCode.SERVER_ERROR).statusAttributeException(root).statusMessage(root.getMessage()).create());
    }

    private RequestMessage trimMessage(RequestMessage msg) {
        RequestMessage trimmedMsg = RequestMessage.from((RequestMessage)msg).create();
        if (trimmedMsg.getArgs().containsKey("gremlin")) {
            trimmedMsg.getArgs().put("gremlin", trimmedMsg.getArgs().get("gremlin").toString().substring(0, 1021) + "...");
        }
        return trimmedMsg;
    }

    protected static Optional<Throwable> determineIfSpecialException(Throwable ex) {
        return Stream.of(ExceptionUtils.getThrowables((Throwable)ex)).filter(i -> i instanceof TemporaryException || i instanceof Failure).findFirst();
    }

    @Override
    public synchronized void close() {
        ScheduledFuture<?> f;
        if (!this.sessions.containsKey(this.sessionId)) {
            return;
        }
        this.sessions.remove(this.sessionId);
        if (this.sessionCancelFuture.get() != null && !(f = this.sessionCancelFuture.get()).isDone()) {
            f.cancel(true);
        }
    }

    protected Iterator<?> fromScript(SessionTask sessionTask, String script) throws Exception {
        RequestMessage msg = sessionTask.getRequestMessage();
        Map args = msg.getArgs();
        String language = args.containsKey("language") ? (String)args.get("language") : "gremlin-groovy";
        return IteratorUtils.asIterator((Object)this.getScriptEngine(sessionTask, language).eval(script, this.mergeBindingsFromRequest(sessionTask, this.getWorkerBindings())));
    }

    protected Optional<Iterator<?>> fromBytecode(SessionTask sessionTask, Bytecode bytecode) throws Exception {
        Traversal.Admin traversal;
        RequestMessage msg = sessionTask.getRequestMessage();
        Map aliases = (Map)msg.optionalArgs("aliases").get();
        GraphManager graphManager = sessionTask.getGraphManager();
        String traversalSourceName = (String)aliases.entrySet().iterator().next().getValue();
        TraversalSource g = graphManager.getTraversalSource(traversalSourceName);
        if (BytecodeHelper.isGraphOperation((Bytecode)bytecode)) {
            this.handleGraphOperation(sessionTask, bytecode, g.getGraph());
            return Optional.empty();
        }
        Optional lambdaLanguage = BytecodeHelper.getLambdaLanguage((Bytecode)bytecode);
        if (!lambdaLanguage.isPresent()) {
            traversal = JavaTranslator.of((TraversalSource)g).translate(bytecode);
        } else {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(traversalSourceName, (Object)g);
            traversal = sessionTask.getGremlinExecutor().getScriptEngineManager().getEngineByName((String)lambdaLanguage.get()).eval(bytecode, (Bindings)bindings, traversalSourceName);
        }
        traversal.applyStrategies();
        return Optional.of(new TraverserIterator(traversal));
    }

    protected Bindings getWorkerBindings() throws SessionException {
        return new SimpleBindings(this.graphManager.getAsBindings());
    }

    protected Bindings mergeBindingsFromRequest(SessionTask sessionTask, Bindings bindings) throws SessionException {
        RequestMessage msg = sessionTask.getRequestMessage();
        if (msg.getArgs().containsKey("aliases")) {
            Map aliases = (Map)msg.getArgs().get("aliases");
            for (Map.Entry aliasKv : aliases.entrySet()) {
                TraversalSource ts;
                boolean found = false;
                Graph graph = sessionTask.getGraphManager().getGraph((String)aliasKv.getValue());
                if (null != graph) {
                    bindings.put((String)aliasKv.getKey(), (Object)graph);
                    found = true;
                }
                if (!found && null != (ts = sessionTask.getGraphManager().getTraversalSource((String)aliasKv.getValue()))) {
                    bindings.put((String)aliasKv.getKey(), (Object)ts);
                    found = true;
                }
                if (found) continue;
                String error = String.format("Could not alias [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", aliasKv.getKey(), aliasKv.getValue(), aliasKv.getValue());
                throw new SessionException(error, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(error).create());
            }
        } else if (sessionTask.getSettings().strictTransactionManagement) {
            String error = "Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided";
            throw new SessionException("Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage("Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided").create());
        }
        Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
        return bindings;
    }

    protected void handleIterator(SessionTask sessionTask, Iterator<?> itty) throws InterruptedException {
        boolean managedTransactionsForRequest;
        ChannelHandlerContext nettyContext = sessionTask.getChannelHandlerContext();
        RequestMessage msg = sessionTask.getRequestMessage();
        Settings settings = sessionTask.getSettings();
        long lastWarningTime = 0L;
        int warnCounter = 0;
        boolean bl = managedTransactionsForRequest = this.transactionManaged ? true : msg.getArgs().getOrDefault("manageTransaction", false);
        if (!itty.hasNext()) {
            Map<String, Object> attributes = this.generateStatusAttributes(sessionTask, ResponseStatusCode.NO_CONTENT, itty);
            if (managedTransactionsForRequest) {
                this.closeTransaction(sessionTask, Transaction.Status.COMMIT);
            }
            sessionTask.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).statusAttributes(attributes).create());
            return;
        }
        int resultIterationBatchSize = msg.optionalArgs("batchSize").orElse(settings.resultIterationBatchSize);
        ArrayList<Object> aggregate = new ArrayList<Object>(resultIterationBatchSize);
        boolean hasMore = itty.hasNext();
        while (hasMore) {
            long interval;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean forceFlush = false;
            if (aggregate.size() < resultIterationBatchSize && itty.hasNext()) {
                aggregate.add(itty.next());
            }
            if (nettyContext.channel().isActive() && nettyContext.channel().isWritable()) {
                if (aggregate.size() != resultIterationBatchSize && itty.hasNext()) continue;
                ResponseStatusCode code = itty.hasNext() ? ResponseStatusCode.PARTIAL_CONTENT : ResponseStatusCode.SUCCESS;
                Frame frame = null;
                try {
                    frame = this.makeFrame(sessionTask, aggregate, code, itty);
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    if (!managedTransactionsForRequest) break;
                    this.closeTransaction(sessionTask, Transaction.Status.ROLLBACK);
                    break;
                }
                boolean moreInIterator = itty.hasNext();
                try {
                    if (moreInIterator) {
                        aggregate = new ArrayList(resultIterationBatchSize);
                    } else {
                        if (managedTransactionsForRequest) {
                            this.closeTransaction(sessionTask, Transaction.Status.COMMIT);
                        }
                        hasMore = false;
                    }
                }
                catch (Exception ex) {
                    if (frame != null) {
                        frame.tryRelease();
                    }
                    throw ex;
                }
                if (!moreInIterator) {
                    this.iterateComplete(sessionTask, itty);
                }
                sessionTask.writeAndFlush(code, frame);
                continue;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastWarningTime >= (interval = (long)Math.pow(2.0, warnCounter) * 1000L)) {
                Channel ch = nettyContext.channel();
                logger.warn("Warning {}: Outbound buffer size={}, pausing response writing as writeBufferHighWaterMark exceeded on request {} for channel {} - writing will continue once client has caught up", new Object[]{warnCounter, ch.unsafe().outboundBuffer().totalPendingWriteBytes(), msg.getRequestId(), ch.id()});
                lastWarningTime = currentTime;
                ++warnCounter;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
            AbstractOpProcessor.writePausesMeter.mark();
        }
    }

    protected void handleGraphOperation(SessionTask sessionTask, Bytecode bytecode, Graph graph) throws Exception {
        RequestMessage msg = sessionTask.getRequestMessage();
        if (graph.features().graph().supportsTransactions()) {
            if (!GraphOp.TX_COMMIT.equals(bytecode) && !GraphOp.TX_ROLLBACK.equals(bytecode)) {
                throw new IllegalStateException(String.format("Bytecode in request is not a recognized graph operation: %s", bytecode.toString()));
            }
        } else {
            throw Graph.Exceptions.transactionsNotSupported();
        }
        boolean commit = GraphOp.TX_COMMIT.equals(bytecode);
        this.closeTransaction(sessionTask, commit ? Transaction.Status.COMMIT : Transaction.Status.ROLLBACK);
        Map<String, Object> attributes = this.generateStatusAttributes(sessionTask, ResponseStatusCode.NO_CONTENT, Collections.emptyIterator());
        sessionTask.writeAndFlush(ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.NO_CONTENT).statusAttributes(attributes).create());
    }

    protected void iterateComplete(SessionTask sessionTask, Iterator<?> itty) {
    }

    protected Map<String, Object> generateStatusAttributes(SessionTask sessionTask, ResponseStatusCode code, Iterator<?> itty) {
        if (itty.hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("host", sessionTask.getChannelHandlerContext().channel().remoteAddress().toString());
        return metaData;
    }

    protected Map<String, Object> generateResponseMetaData(SessionTask sessionTask, ResponseStatusCode code, Iterator<?> itty) {
        return Collections.emptyMap();
    }

    protected Frame makeFrame(SessionTask sessionTask, List<Object> aggregate, ResponseStatusCode code, Iterator<?> itty) throws Exception {
        RequestMessage msg = sessionTask.getRequestMessage();
        ChannelHandlerContext nettyContext = sessionTask.getChannelHandlerContext();
        MessageSerializer serializer = (MessageSerializer)nettyContext.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)nettyContext.channel().attr(StateKey.USE_BINARY).get();
        Map<String, Object> responseMetaData = this.generateResponseMetaData(sessionTask, code, itty);
        Map<String, Object> statusAttributes = this.generateStatusAttributes(sessionTask, code, itty);
        try {
            sessionTask.handleDetachment(aggregate);
            if (useBinary) {
                return new Frame(serializer.serializeResponseAsBinary(ResponseMessage.build((RequestMessage)msg).code(code).statusAttributes(statusAttributes).responseMetaData(responseMetaData).result(aggregate).create(), nettyContext.alloc()));
            }
            MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
            return new Frame(textSerializer.serializeResponseAsString(ResponseMessage.build((RequestMessage)msg).code(code).statusAttributes(statusAttributes).responseMetaData(responseMetaData).result(aggregate).create(), nettyContext.alloc()));
        }
        catch (Exception ex) {
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{aggregate, msg.getRequestId(), ex});
            String errorMessage = String.format("Error during serialization: %s", ExceptionHelper.getMessageFromExceptionOrCause((Throwable)ex));
            ResponseMessage error = ResponseMessage.build((UUID)msg.getRequestId()).statusMessage(errorMessage).statusAttributeException((Throwable)ex).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).create();
            sessionTask.writeAndFlush(error);
            throw ex;
        }
    }

    protected void startTransaction(SessionTask sessionTask) {
        if (this.graphManager.hasAnyOpenTransactions()) {
            throw new IllegalStateException(String.format("Attempted to start transaction for %s but the transaction was already open", sessionTask.getRequestMessage().getRequestId()));
        }
    }

    protected void closeTransaction(Transaction.Status status) {
        this.closeTransaction(null, status);
    }

    protected void closeTransactionSafely(Transaction.Status status) {
        this.closeTransactionSafely(null, status);
    }

    protected void closeTransactionSafely(SessionTask sessionTask, Transaction.Status status) {
        try {
            this.closeTransaction(sessionTask, status);
        }
        catch (Exception ex) {
            logger.error("Failed to close transaction", (Throwable)ex);
        }
    }

    private void processAuditLog(Settings settings, ChannelHandlerContext ctx, Object gremlinToExecute) {
        if (settings.enableAuditLog.booleanValue()) {
            String address;
            AuthenticatedUser user = (AuthenticatedUser)ctx.channel().attr(StateKey.AUTHENTICATED_USER).get();
            if (null == user) {
                user = AuthenticatedUser.ANONYMOUS_USER;
            }
            if ((address = ctx.channel().remoteAddress().toString()).startsWith("/") && address.length() > 1) {
                address = address.substring(1);
            }
            auditLogger.info("User {} with address {} requested: {}", new Object[]{user.getName(), address, gremlinToExecute});
        }
    }

    protected void closeTransaction(SessionTask sessionTask, Transaction.Status status) {
        boolean strict;
        if (status != Transaction.Status.COMMIT && status != Transaction.Status.ROLLBACK) {
            throw new IllegalStateException(String.format("Transaction.Status not supported: %s", status));
        }
        boolean commit = status == Transaction.Status.COMMIT;
        boolean bl = strict = sessionTask != null && sessionTask.getSettings().strictTransactionManagement;
        if (strict) {
            if (commit) {
                this.graphManager.commit(new HashSet<String>(this.aliasesUsedBySession));
            } else {
                this.graphManager.rollback(new HashSet<String>(this.aliasesUsedBySession));
            }
        } else if (commit) {
            this.graphManager.commitAll();
        } else {
            this.graphManager.rollbackAll();
        }
    }

    private Timer.Context getMetricsTimer(SessionTask sessionTask) {
        switch (sessionTask.getRequestContentType()) {
            case BYTECODE: {
                return Session.traversalOpTimer.time();
            }
            case SCRIPT: {
                return Session.evalOpTimer.time();
            }
        }
        throw new IllegalStateException("Unrecognized content of the 'gremlin' argument in the request");
    }

    protected static enum CloseReason {
        EXIT_PROCESSING,
        CHANNEL_CLOSED,
        PROCESSING_EXCEPTION,
        SESSION_TIMEOUT,
        REQUEST_TIMEOUT;

    }
}

