/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.CompareCallback;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DateStringValidator;
import org.apache.fulcrum.intake.validator.FieldReference;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.ValidationException;

public class DateRangeValidator
extends DateStringValidator {
    List<FieldReference> fieldReferences;
    CompareCallback<Date> compareCallback;

    @Override
    public void init(Map<String, ? extends Constraint> paramMap) throws InvalidMaskException {
        super.init(paramMap);
        this.compareCallback = new CompareCallback<Date>(){

            @Override
            public boolean compareValues(FieldReference.Comparison compare, Date thisValue, Date refValue) {
                boolean result = true;
                switch (compare) {
                    case LT: {
                        result = thisValue.before(refValue);
                        break;
                    }
                    case LTE: {
                        result = !thisValue.after(refValue);
                        break;
                    }
                    case GT: {
                        result = thisValue.after(refValue);
                        break;
                    }
                    case GTE: {
                        result = !thisValue.before(refValue);
                    }
                }
                return result;
            }
        };
        this.fieldReferences = new ArrayList<FieldReference>(10);
        for (Map.Entry<String, ? extends Constraint> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            Constraint constraint = entry.getValue();
            FieldReference.Comparison compare = FieldReference.getComparisonType(key);
            if (compare == null) continue;
            FieldReference fieldref = new FieldReference();
            fieldref.setComparison(compare);
            fieldref.setFieldName(constraint.getValue());
            fieldref.setMessage(constraint.getMessage());
            this.fieldReferences.add(fieldref);
        }
        if (this.fieldReferences.isEmpty()) {
            this.log.warn("No reference field rules have been found.");
        }
    }

    @Override
    public void assertValidity(Field<Date> testField) throws ValidationException {
        super.assertValidity(testField);
        Group thisGroup = testField.getGroup();
        if (testField.isMultiValued()) {
            String[] stringValues = (String[])testField.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], thisGroup);
            }
        } else {
            String testValue = (String)testField.getTestValue();
            this.assertValidity(testValue, thisGroup);
        }
    }

    public void assertValidity(String testValue, Group group) throws ValidationException {
        if (this.required || StringUtils.isNotEmpty((CharSequence)testValue)) {
            Date testDate = null;
            try {
                testDate = this.parse(testValue);
            }
            catch (ParseException e) {
                this.errorMessage = this.getDateFormatMessage();
                throw new ValidationException(this.errorMessage);
            }
            try {
                FieldReference.checkReferences(this.fieldReferences, this.compareCallback, testDate, group);
            }
            catch (ValidationException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
    }
}

