/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.utils.update;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.ui.wizards.RutaProjectCreationWizard;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateProjectHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        new ConverterHandlerJob(event).schedule();
        return Status.OK_STATUS;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    private static List<File> getFiles(File dir) {
        ArrayList<File> result = new ArrayList<File>();
        for (File each : dir.listFiles()) {
            if (each.isHidden()) continue;
            if (each.getName().endsWith(".tm")) {
                result.add(each);
            }
            if (!each.isDirectory()) continue;
            result.addAll(UpdateProjectHandler.getFiles(each));
        }
        return result;
    }

    private class ConverterHandlerJob
    extends Job {
        ExecutionEvent event;

        ConverterHandlerJob(ExecutionEvent event) {
            super("Updating...");
            this.event = event;
            this.setUser(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)this.event);
            if (currentSelection instanceof IStructuredSelection) {
                StructuredSelection selection = (StructuredSelection)currentSelection;
                for (Object object : selection) {
                    if (object instanceof IScriptProject) {
                        IScriptProject p = (IScriptProject)object;
                        projects.add(p.getProject());
                        continue;
                    }
                    if (!(object instanceof IProject)) continue;
                    projects.add((IProject)object);
                }
            }
            monitor.beginTask("Updating UIMA Ruta project...", projects.size());
            for (IProject each : projects) {
                try {
                    IProjectDescription description = each.getDescription();
                    String[] natureIds = description.getNatureIds();
                    int counter = 0;
                    boolean oldProject = false;
                    for (String string : Arrays.asList(natureIds)) {
                        if (string.equals("org.apache.uima.textmarker.ide.nature")) {
                            natureIds[counter] = "org.apache.uima.ruta.ide.nature";
                            oldProject = true;
                        }
                        ++counter;
                    }
                    if (oldProject) {
                        description.setNatureIds(natureIds);
                        each.setDescription(description, monitor);
                        List files = UpdateProjectHandler.getFiles(new File(each.getLocation().toPortableString()));
                        for (File file : files) {
                            String absolutePath = file.getAbsolutePath();
                            if (!file.getName().endsWith(".tm")) continue;
                            File newFile = new File(absolutePath.substring(0, absolutePath.length() - 3) + ".ruta");
                            file.renameTo(newFile);
                        }
                        IScriptProject iScriptProject = DLTKCore.create((IProject)each);
                        List scriptFolders = RutaProjectUtils.getScriptFolders((IScriptProject)iScriptProject);
                        for (IFolder iFolder : scriptFolders) {
                            iFolder.refreshLocal(2, monitor);
                        }
                    }
                }
                catch (CoreException e) {
                    RutaAddonsPlugin.error(e);
                }
                try {
                    List descriptorFolders;
                    IProjectNature nature = each.getNature("org.apache.uima.ruta.ide.nature");
                    if (nature != null && (descriptorFolders = RutaProjectUtils.getDescriptorFolders((IProject)each)) != null && !descriptorFolders.isEmpty()) {
                        IFolder descFolder = (IFolder)descriptorFolders.get(0);
                        RutaProjectCreationWizard.copyDescriptors((IFolder)descFolder);
                        descFolder.refreshLocal(2, monitor);
                    }
                }
                catch (CoreException e) {
                    RutaAddonsPlugin.error(e);
                }
                monitor.worked(1);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

