/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal.page;

import org.apache.uima.aae.deployment.AEDeploymentDescription;
import org.apache.uima.dde.internal.DeploymentDescriptorEditor;
import org.apache.uima.dde.internal.Messages;
import org.apache.uima.dde.internal.details.DetailsPageProvider;
import org.apache.uima.dde.internal.hover.DDEInformationControl;
import org.apache.uima.dde.internal.hover.HoverManager;
import org.apache.uima.dde.internal.page.AbstractHeaderPage;
import org.apache.uima.dde.internal.provider.DDTreeContentProvider;
import org.apache.uima.dde.internal.provider.DDTreeLabelProvider;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.tools.internal.ui.forms.FormSection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MasterDetails
extends MasterDetailsBlock {
    private AEDeploymentDescription aeDD;
    private TreeViewer aeConfigViewer;
    private DeploymentDescriptorEditor multiPageEditor;
    private IManagedForm managedForm = null;
    private ScrolledForm form;
    private SectionPart spart;

    public MasterDetails(DeploymentDescriptorEditor editor, IManagedForm managedForm, IWorkbenchPartSite workbenchPartSite) {
        this.multiPageEditor = editor;
        this.managedForm = managedForm;
        this.form = managedForm.getForm();
        this.aeDD = this.multiPageEditor.getAEDeploymentDescription();
    }

    public void refresh() {
        TreeItem selectedItem = null;
        TreeItem[] selection = this.aeConfigViewer.getTree().getSelection();
        if (selection.length > 0) {
            selectedItem = selection[0];
        } else {
            this.selectFirstElement();
        }
        this.aeConfigViewer.getTree().setRedraw(false);
        this.aeConfigViewer.refresh();
        if (selectedItem != null) {
            this.aeConfigViewer.setSelection((ISelection)new StructuredSelection(selectedItem.getData()));
            selection = this.aeConfigViewer.getTree().getSelection();
            if (selection != null) {
                selection[0].setExpanded(true);
            }
            this.aeConfigViewer.refresh();
        }
        this.aeConfigViewer.getTree().setRedraw(true);
    }

    public void setInput(Object input) {
        if (input instanceof AEDeploymentDescription) {
            this.aeDD = (AEDeploymentDescription)input;
            this.aeConfigViewer.setInput((Object)this.aeDD);
            this.refresh();
        }
    }

    public void init() {
        this.selectFirstElement();
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parentSashForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        toolkit.paintBordersFor(body);
        ScrolledForm form = managedForm.getForm();
        FormColors colors = toolkit.getColors();
        colors.initializeSectionToolBarColors();
        Color gbg = colors.getColor("org.eclipse.ui.forms.TB_GBG");
        Color bg = colors.getBackground();
        form.getForm().setTextBackground(new Color[]{bg, gbg}, new int[]{100}, true);
        this.createAEConfigSection(parentSashForm, toolkit);
        this.sashForm.setBackground(this.sashForm.getDisplay().getSystemColor(15));
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action("hor", 8){

            public void run() {
                MasterDetails.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText("Horizontal Orientation");
        haction.setImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_horizontal.gif"));
        haction.setDisabledImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_horizontal.gif"));
        Action vaction = new Action("ver", 8){

            public void run() {
                MasterDetails.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText("Vertical Orientation");
        vaction.setImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_vertical.gif"));
        vaction.setDisabledImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_vertical.gif"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
        form.updateToolBar();
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageLimit(10);
        detailsPart.setPageProvider((IDetailsPageProvider)new DetailsPageProvider(this.multiPageEditor, this.managedForm, this, detailsPart));
    }

    private Section createAEConfigSection(Composite parent, FormToolkit toolkit) {
        Section section = FormSection.createGridDataSection(toolkit, parent, 0, Messages.DDE_AEConfigPage_AEConfigTree_Section_Title, Messages.DDE_AEConfigPage_AEConfigTree_Section_Description, 10, 10, 1810, 1, 1);
        section.clientVerticalSpacing = 10;
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                MasterDetails.this.form.reflow(true);
            }
        });
        this.spart = new SectionPart(section);
        this.managedForm.addPart((IFormPart)this.spart);
        Composite sectionToolbarComposite = FormSection.createGridLayoutContainer(toolkit, (Composite)section, 4, 0, 0);
        section.setTextClient((Control)sectionToolbarComposite);
        toolkit.createCompositeSeparator((Composite)section);
        Composite sectionClient = toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        sectionClient.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        sectionClient.setLayoutData((Object)gd);
        toolkit.paintBordersFor(sectionClient);
        Tree tree = toolkit.createTree(sectionClient, 770);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gd);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        String[] headers = new String[]{"Element", "Remote", "Instances"};
        TreeColumn[] columns = new TreeColumn[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            int style = i == 0 ? 0 : 0x1000000;
            TreeColumn tc = new TreeColumn(tree, style, i);
            tc.setResizable(true);
            tc.setText(headers[i]);
            if (i == 0) {
                tc.setWidth(200);
            }
            columns[i] = tc;
            if (i != 1 && i != 2) continue;
            tc.pack();
        }
        this.aeConfigViewer = new TreeViewer(tree);
        DDTreeContentProvider contentProvider = new DDTreeContentProvider();
        DDTreeLabelProvider labelProvider = new DDTreeLabelProvider();
        this.aeConfigViewer.setContentProvider((IContentProvider)contentProvider);
        this.aeConfigViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.aeConfigViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel;
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection) || (ssel = (IStructuredSelection)selection).size() > 0) {
                    // empty if block
                }
                MasterDetails.this.managedForm.fireSelectionChanged((IFormPart)MasterDetails.this.spart, event.getSelection());
            }
        });
        AbstractHeaderPage.createExpandOrCollapseAllMenu(toolkit, section, sectionToolbarComposite, this.aeConfigViewer, true);
        AbstractHeaderPage.createExpandOrCollapseAllMenu(toolkit, section, sectionToolbarComposite, this.aeConfigViewer, false);
        HoverManager hover = new HoverManager(this.aeConfigViewer, this.getPresenterControlCreator("commandId"));
        hover.install((Control)this.aeConfigViewer.getTree());
        if (this.aeDD != null) {
            this.aeConfigViewer.setInput((Object)this.aeDD);
        }
        return section;
    }

    private IInformationControlCreator getPresenterControlCreator(String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DDEInformationControl(parent, 12, 0);
            }
        };
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        Composite buttonContainer = toolkit.createComposite(parent);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        toolkit.paintBordersFor(buttonContainer);
        this.createVerticalSpace(toolkit, buttonContainer, 1, 24);
        this.createButton(toolkit, buttonContainer, "Add...", 1);
        this.createButton(toolkit, buttonContainer, "Remove", 2);
    }

    protected Button createButton(FormToolkit toolkit, Composite parent, String label, int index) {
        Button button;
        if (toolkit != null) {
            button = toolkit.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.setData((Object)index);
        return button;
    }

    protected Label createVerticalSpace(FormToolkit toolkit, Composite parent, int span, int spacing) {
        Label label = toolkit != null ? toolkit.createLabel(parent, null) : new Label(parent, 0);
        GridData gd = new GridData(2);
        gd.verticalIndent = spacing;
        gd.horizontalSpan = span;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void selectFirstElement() {
        Tree tree = this.aeConfigViewer.getTree();
        TreeItem[] items = tree.getItems();
        if (items.length == 0) {
            this.detailsPart.selectionChanged((IFormPart)this.spart, (ISelection)new StructuredSelection((Object)this.aeConfigViewer));
            return;
        }
        TreeItem firstItem = items[0];
        Object obj = firstItem.getData();
        this.aeConfigViewer.setSelection((ISelection)new StructuredSelection(obj));
    }

    void fireSelection() {
        this.aeConfigViewer.setSelection(this.aeConfigViewer.getSelection());
    }
}

