/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.command;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.instance.core.Instance;
import org.apache.karaf.instance.core.InstanceService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;

public abstract class InstanceCommandSupport
implements Action {
    @Reference
    private InstanceService instanceService;

    public InstanceService getInstanceService() {
        return this.instanceService;
    }

    public void setInstanceService(InstanceService instanceService) {
        this.instanceService = instanceService;
    }

    protected Instance getExistingInstance(String name) {
        Instance i = this.instanceService.getInstance(name);
        if (i == null) {
            throw new IllegalArgumentException("Instances '" + name + "' does not exist");
        }
        return i;
    }

    protected List<Instance> getMatchingInstances(List<String> patterns) {
        Instance[] allInstances;
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (Instance instance : allInstances = this.instanceService.getInstances()) {
            if (!this.match(instance.getName(), patterns)) continue;
            instances.add(instance);
        }
        if (instances.isEmpty()) {
            throw new IllegalArgumentException("No matching instances");
        }
        return instances;
    }

    protected static Map<String, URL> getResources(List<String> resources) throws MalformedURLException {
        HashMap<String, URL> result = new HashMap<String, URL>();
        if (resources != null) {
            for (String resource : resources) {
                String path = resource.substring(0, resource.indexOf("="));
                String location = resource.substring(path.length() + 1);
                URL url = new URL(location);
                result.put(path, url);
            }
        }
        return result;
    }

    private boolean match(String name, List<String> patterns) {
        for (String pattern : patterns) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public Object execute() throws Exception {
        return this.doExecute();
    }

    protected abstract Object doExecute() throws Exception;
}

