/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryContents;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JELIB1
extends LibraryFiles {
    private static final String[] revisions = new String[]{"8.01az"};
    private static final String[] NULL_STRINGS_ARRAY = new String[0];
    private static final LibraryContents.NodeContents[] NULL_NODES_ARRAY = new LibraryContents.NodeContents[0];
    private static final LibraryContents.ArcContents[] NULL_ARCS_ARRAY = new LibraryContents.ArcContents[0];
    private static final LibraryContents.ExportContents[] NULL_EXPORTS_ARRAY = new LibraryContents.ExportContents[0];
    private LibraryContents libraryContents;
    private HashMap cellToContents = new HashMap();
    private Version version;
    private int revision;
    private LibraryContents.CellContents currentCellContents;
    private int lineNumber;
    private List stringPieces = new ArrayList();
    private int curPiece;
    private static int numProcessed;
    private static int numToProcess;

    JELIB1() {
    }

    public static synchronized void convertLibrary(URL fileURL, String outFilePath) {
        errorLogger = ErrorLogger.newInstance("Library Convert");
        try {
            JELIB1 in = new JELIB1();
            if (in.openTextInput(fileURL)) {
                return;
            }
            boolean error = in.readTheLibrary();
            in.closeInput();
            errorLogger.termLogging(true);
            if (error) {
                System.out.println("Error reading library " + fileURL);
                if (in.topLevelLibrary) {
                    mainLibDirectory = null;
                }
                return;
            }
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(outFilePath)));
            in.libraryContents.printJelib(printWriter);
            printWriter.close();
            System.out.println("Written " + outFilePath);
        }
        catch (IOException e) {
            System.out.println("Error opening " + outFilePath);
        }
    }

    protected boolean readLib() {
        try {
            if (this.readTheLibrary()) {
                return true;
            }
            List cellContentses = this.libraryContents.checkTheLibrary(this.lib, this.topLevelLibrary);
            if (cellContentses == null) {
                return true;
            }
            this.nodeProtoCount = cellContentses.size();
            this.nodeProtoList = new Cell[this.nodeProtoCount];
            this.cellLambda = new double[this.nodeProtoCount];
            for (int i = 0; i < this.nodeProtoCount; ++i) {
                Cell cell;
                LibraryContents.CellContents cc = (LibraryContents.CellContents)cellContentses.get(i);
                if (cc == null) continue;
                this.nodeProtoList[i] = cell = cc.getCell();
                this.cellToContents.put(cell, cc);
            }
            return false;
        }
        catch (IOException e) {
            Input.errorLogger.logError("End of file reached while reading " + this.filePath, null, -1);
            return true;
        }
    }

    private LibraryContents.TechnologyRef getTechnologyRef(String techName) {
        return this.libraryContents.getTechnologyRef(techName);
    }

    private LibraryContents.PrimitiveNodeRef getPrimitiveNodeRef(LibraryContents.TechnologyRef techRef, String name) {
        return this.libraryContents.getPrimitiveNodeRef(techRef, name);
    }

    private LibraryContents.ArcProtoRef getArcProtoRef(LibraryContents.TechnologyRef techRef, String name) {
        return this.libraryContents.getArcProtoRef(techRef, name);
    }

    private LibraryContents.LibraryRef getLibraryRef(String libName) {
        return this.libraryContents.getLibraryRef(libName);
    }

    private LibraryContents.CellRef getCellRef(String name) {
        return this.libraryContents.getCellRef(name);
    }

    private boolean readTheLibrary() throws IOException {
        String line;
        this.revision = revisions.length;
        LibraryContents.LibraryRef curExternalLib = null;
        LibraryContents.TechnologyRef curTech = null;
        LibraryContents.PrimitiveNodeRef curPrim = null;
        while ((line = this.lineReader.readLine()) != null) {
            char first;
            if (line.length() == 0 || (first = line.charAt(0)) == '#') continue;
            if (this.libraryContents == null && first != 'H') {
                this.logError("Header line is omitted. Stop reading");
                return true;
            }
            if (curExternalLib != null && first != 'R') {
                curExternalLib = null;
            }
            if (curTech != null && first != 'D' && first != 'P' && first != 'W') {
                curTech = null;
            }
            if (curPrim != null && first != 'D') {
                curPrim = null;
            }
            if (first == 'C') {
                if (this.parseLine(line, "QssQsss")) continue;
                String baseName = this.nextPiece();
                String abbrev = this.nextPiece();
                String version = this.nextPiece();
                String name = baseName + ";" + version + "{" + abbrev + "}";
                LibraryContents.TechnologyRef techRef = this.getTechnologyRef(this.nextPiece());
                long creationDate = Long.parseLong(this.nextPiece());
                long revisionDate = Long.parseLong(this.nextPiece());
                LibraryContents.CellContents cc = this.libraryContents.newCellContents(name, creationDate, revisionDate);
                cc.setTechRef(techRef);
                cc.setLineNumber(this.lineReader.getLineNumber() + 1);
                String stateInfo = this.nextPiece();
                boolean expanded = false;
                boolean allLocked = false;
                boolean instLocked = false;
                boolean cellLib = false;
                boolean techLib = false;
                for (int i = 0; i < stateInfo.length(); ++i) {
                    char chr = stateInfo.charAt(i);
                    if (chr == 'E') {
                        cc.setWantExpanded(true);
                        continue;
                    }
                    if (chr == 'L') {
                        cc.setAllLocked(true);
                        continue;
                    }
                    if (chr == 'I') {
                        cc.setInstancesLocked(true);
                        continue;
                    }
                    if (chr == 'C') {
                        cc.setInCellLibrary(true);
                        continue;
                    }
                    if (chr != 'T') continue;
                    cc.setInTechnologyLibrary(true);
                }
                cc.setVars(this.varPieces());
                this.readCellContents(cc);
                continue;
            }
            if (first == 'L') {
                if (this.parseLine(line, "QQ")) continue;
                String libName = this.nextPiece();
                String fileName = this.nextPiece();
                if (libName.equals("")) {
                    this.logError("No library name in " + line);
                    continue;
                }
                if (libName.indexOf(58) >= 0) {
                    this.logError("Library name " + libName + " contains semicolon");
                    continue;
                }
                if (fileName.equals("")) {
                    fileName = libName;
                }
                curExternalLib = this.libraryContents.newLibraryRef(libName, fileName);
                continue;
            }
            if (first == 'R') {
                if (this.parseLine(line, "Sssss")) continue;
                String cellName = this.convertCellName(this.nextPiece());
                double lowX = TextUtils.atof(this.nextPiece());
                double highX = TextUtils.atof(this.nextPiece());
                double lowY = TextUtils.atof(this.nextPiece());
                double highY = TextUtils.atof(this.nextPiece());
                if (curExternalLib == null) {
                    this.logError("External cell " + cellName + " has no library before it");
                    continue;
                }
                curExternalLib.newExternalCellRef(cellName, lowX, lowY, highX, highY);
                continue;
            }
            if (first == 'H') {
                if (this.parseLine(line, "Qs")) continue;
                if (this.libraryContents != null) {
                    this.logError("Second header line ignored " + line);
                    continue;
                }
                String curLibName = this.nextPiece();
                String versionString = this.nextPiece();
                if (curLibName.equals("")) {
                    this.logError("No library name in Header line " + line);
                    return true;
                }
                if (curLibName.indexOf(58) >= 0) {
                    this.logError("Library name " + curLibName + " contains semicolon");
                    return true;
                }
                this.version = Version.parseVersion(versionString);
                if (this.version != null) {
                    if (this.version.compareTo(Version.getVersion()) > 0) {
                        this.logWarning("Library " + curLibName + " comes from a NEWER version of Electric (" + this.version + ")");
                    }
                    this.revision = 0;
                    while (this.revision < revisions.length && this.version.compareTo(Version.parseVersion(revisions[this.revision])) >= 0) {
                        ++this.revision;
                    }
                } else {
                    this.logError("Badly formed version: " + versionString);
                }
                this.libraryContents = new LibraryContents(curLibName, this);
                this.libraryContents.setVars(this.varPieces());
                this.libraryContents.setVersion(this.version);
                continue;
            }
            if (first == 'O') {
                if (this.parseLine(line, "Q")) continue;
                String toolName = this.nextPiece();
                LibraryContents.ToolRef toolRef = this.libraryContents.newToolRef(toolName);
                toolRef.setVars(this.varPieces());
                continue;
            }
            if (first == 'V') {
                if (this.parseLine(line, "QQ")) continue;
                String viewFullName = this.nextPiece();
                String viewAbbr = this.nextPiece();
                this.libraryContents.newViewRef(viewAbbr, viewFullName);
                continue;
            }
            if (first == 'T') {
                if (this.parseLine(line, "Q")) continue;
                String techName = this.nextPiece();
                curTech = this.libraryContents.newTechnologyRef(techName);
                curTech.setVars(this.varPieces());
                continue;
            }
            if (first == 'D' && this.revision < 1) {
                if (this.parseLine(line, "Q")) continue;
                String primName = this.nextPiece();
                if (curTech == null) {
                    this.logError("Primitive node " + primName + " has no technology before it");
                    continue;
                }
                curPrim = curTech.newPrimitiveNodeRef(primName);
                curPrim.setVars(this.varPieces());
                continue;
            }
            if (first == 'P' && this.revision < 1) {
                if (this.parseLine(line, "Q")) continue;
                String primPortName = this.nextPiece();
                if (curPrim == null) {
                    this.logError("Primitive port " + primPortName + " has no primitive node before it");
                    continue;
                }
                curPrim.newPrimitivePortRef(primPortName);
                curPrim.setVars(this.varPieces());
                continue;
            }
            if (first == 'W' && this.revision < 1) {
                if (this.parseLine(line, "Q")) continue;
                String arcName = this.nextPiece();
                if (curTech == null) {
                    this.logError("Primitive arc " + arcName + " has no technology before it");
                    continue;
                }
                LibraryContents.ArcProtoRef apRef = curTech.newArcProtoRef(arcName);
                apRef.setVars(this.varPieces());
                continue;
            }
            if (first == 'G') {
                if (this.parseLine(line, "")) continue;
                String[] pieces = this.stringPieces();
                LibraryContents.CellRef[] cellRefs = new LibraryContents.CellRef[pieces.length];
                for (int i = 0; i < pieces.length; ++i) {
                    if (pieces[i].equals("")) continue;
                    cellRefs[i] = this.libraryContents.getCellRef(pieces[i]);
                }
                this.libraryContents.addCellGroup(cellRefs);
                continue;
            }
            this.logError("Unrecognized line: " + line);
        }
        return this.errorCount != 0;
    }

    private void readCellContents(LibraryContents.CellContents cc) throws IOException {
        String nodeName;
        String protoName;
        this.currentCellContents = cc;
        HashMap<String, LibraryContents.NodeContents> diskName = new HashMap<String, LibraryContents.NodeContents>();
        String line = this.lineReader.readLine();
        ArrayList<LibraryContents.NodeContents> nodes = new ArrayList<LibraryContents.NodeContents>();
        while (line != null) {
            char first;
            if (line.length() != 0 && (first = line.charAt(0)) != '#') {
                if (first != 'N' && first != 'I') break;
                String format = this.revision >= 1 ? (first == 'N' ? "QQsssssss" : "QQssssss") : "QQssssssss";
                if (!this.parseLine(line, format)) {
                    int lastQuote;
                    protoName = this.nextPiece();
                    LibraryContents.NodeProtoRef protoRef = first == 'I' ? this.getCellRef(protoName) : (this.revision >= 1 ? this.getPrimitiveNodeRef(cc.techRef, protoName) : (protoName.indexOf(58) >= 0 && Cell.findNodeProto(protoName) == null ? this.getCellRef(protoName) : this.getPrimitiveNodeRef(null, protoName)));
                    String diskNodeName = this.nextPiece();
                    nodeName = diskNodeName;
                    if (nodeName.charAt(0) == '\"' && (lastQuote = nodeName.lastIndexOf(34)) > 1) {
                        nodeName = nodeName.substring(1, lastQuote);
                    }
                    String textDescriptorInfo = this.nextPiece();
                    double x = TextUtils.atof(this.nextPiece());
                    double y = TextUtils.atof(this.nextPiece());
                    LibraryContents.NodeContents nc = cc.newNodeContents(protoRef, nodeName, textDescriptorInfo, x, y);
                    nodes.add(nc);
                    nc.setJelibName(diskNodeName);
                    nc.setLineNumber(this.lineReader.getLineNumber(), first);
                    if (first == 'N' || this.revision < 1) {
                        double hei;
                        double wid = TextUtils.atof(this.nextPiece());
                        if (wid < 0.0 && this.revision >= 1) {
                            this.logError("Negative width " + wid + " of cell instance");
                        }
                        if ((hei = TextUtils.atof(this.nextPiece())) < 0.0 && this.revision >= 1) {
                            this.logError("Negative height " + hei + " of cell instance");
                        }
                        nc.setSize(wid, hei);
                    }
                    String orientString = this.nextPiece();
                    boolean mirX = false;
                    boolean mirY = false;
                    int angle = 0;
                    for (int i = 0; i < orientString.length(); ++i) {
                        char ch = orientString.charAt(i);
                        if (ch == 'X') {
                            mirX = !mirX;
                            continue;
                        }
                        if (ch == 'Y') {
                            mirY = !mirY;
                            continue;
                        }
                        if (ch == 'R') {
                            angle += 900;
                            continue;
                        }
                        angle += TextUtils.atoi(orientString.substring(i));
                        break;
                    }
                    nc.setOrientation(mirX, mirY, angle);
                    String stateInfo = this.nextPiece();
                    for (int i = 0; i < stateInfo.length(); ++i) {
                        char chr = stateInfo.charAt(i);
                        if (chr == 'E') {
                            nc.setExpanded(true);
                            continue;
                        }
                        if (chr == 'L') {
                            nc.setLocked(true);
                            continue;
                        }
                        if (chr == 'S') {
                            nc.setShortened(true);
                            continue;
                        }
                        if (chr == 'V') {
                            nc.setVisInside(true);
                            continue;
                        }
                        if (chr == 'W') {
                            nc.setWiped(true);
                            continue;
                        }
                        if (chr == 'A') {
                            nc.setHardSelect(true);
                            continue;
                        }
                        if (!TextUtils.isDigit(chr)) continue;
                        nc.setTechSpecific(TextUtils.atoi(stateInfo.substring(i)));
                        break;
                    }
                    if (first == 'I' || this.revision < 1) {
                        nc.setProtoTextDescriptor(this.nextPiece());
                    }
                    nc.setVars(this.varPieces());
                    diskName.put(diskNodeName, nc);
                }
            }
            line = this.lineReader.readLine();
        }
        cc.nodes = nodes.toArray(NULL_NODES_ARRAY);
        ArrayList<LibraryContents.ArcContents> arcs = new ArrayList<LibraryContents.ArcContents>();
        while (line != null) {
            block47: {
                char first;
                if (line.length() != 0 && (first = line.charAt(0)) != '#') {
                    if (first != 'A') break;
                    if (!this.parseLine(line, "QQsssQQssQQss")) {
                        int i;
                        protoName = this.nextPiece();
                        LibraryContents.ArcProtoRef apRef = this.getArcProtoRef(cc.techRef, protoName);
                        String arcName = this.nextPiece();
                        String textDescriptorInfo = this.nextPiece();
                        double wid = TextUtils.atof(this.nextPiece());
                        LibraryContents.ArcContents ac = cc.newArcContents(apRef, arcName, textDescriptorInfo, wid);
                        ac.setLineNumber(this.lineReader.getLineNumber());
                        String stateInfo = this.nextPiece();
                        ac.setFixedAngle(true);
                        ac.setExtended(true);
                        for (i = 0; i < stateInfo.length(); ++i) {
                            char chr = stateInfo.charAt(i);
                            if (chr == 'R') {
                                ac.setRigid(true);
                                continue;
                            }
                            if (chr == 'F') {
                                ac.setFixedAngle(false);
                                continue;
                            }
                            if (chr == 'S') {
                                ac.setSlidable(true);
                                continue;
                            }
                            if (chr == 'E') {
                                ac.setExtended(false);
                                continue;
                            }
                            if (chr == 'D') {
                                ac.setDirectional(true);
                                continue;
                            }
                            if (chr == 'V') {
                                ac.setReverseEnds(true);
                                continue;
                            }
                            if (chr == 'A') {
                                ac.setHardSelect(true);
                                continue;
                            }
                            if (chr == 'H') {
                                ac.setSkipHead(true);
                                continue;
                            }
                            if (chr == 'T') {
                                ac.setSkipTail(true);
                                continue;
                            }
                            if (chr == 'N') {
                                ac.setTailNegated(true);
                                continue;
                            }
                            if (chr == 'G') {
                                ac.setHeadNegated(true);
                                continue;
                            }
                            if (!TextUtils.isDigit(chr)) continue;
                            ac.setAngle(TextUtils.atoi(stateInfo.substring(i)));
                            break;
                        }
                        for (i = 0; i < 2; ++i) {
                            String nodeName2 = this.nextPiece();
                            LibraryContents.NodeContents node = (LibraryContents.NodeContents)diskName.get(nodeName2);
                            if (node == null) {
                                this.logError("cannot find node " + nodeName2);
                                break block47;
                            }
                            String portName = this.nextPiece();
                            LibraryContents.PortProtoRef portProtoRef = node.getNodeProtoRef().getPortProtoRef(portName);
                            double x = TextUtils.atof(this.nextPiece());
                            double y = TextUtils.atof(this.nextPiece());
                            ac.setEnd(i != 0, node, portProtoRef, x, y);
                        }
                        ac.setVars(this.varPieces());
                        arcs.add(ac);
                    }
                }
            }
            line = this.lineReader.readLine();
        }
        cc.arcs = arcs.toArray(NULL_ARCS_ARRAY);
        ArrayList<LibraryContents.ExportContents> exports = new ArrayList<LibraryContents.ExportContents>();
        while (line != null) {
            char first;
            if (line.length() != 0 && (first = line.charAt(0)) != '#') {
                if (first != 'E') break;
                if (!this.parseLine(line, "QsQQsss")) {
                    String exportName = this.nextPiece();
                    String textDescriptorInfo = this.nextPiece();
                    nodeName = this.nextPiece();
                    LibraryContents.NodeContents node = (LibraryContents.NodeContents)diskName.get(nodeName);
                    if (node == null) {
                        this.logError("cannot find node " + nodeName);
                    } else {
                        String portName = this.nextPiece();
                        LibraryContents.PortProtoRef portProtoRef = node.getNodeProtoRef().getPortProtoRef(portName);
                        double x = TextUtils.atof(this.nextPiece());
                        double y = TextUtils.atof(this.nextPiece());
                        LibraryContents.ExportContents ec = cc.newExportContents(exportName, textDescriptorInfo, node, portProtoRef, x, y);
                        ec.setLineNumber(this.lineReader.getLineNumber());
                        String stateInfo = this.nextPiece();
                        int slashPos = stateInfo.indexOf(47);
                        if (slashPos >= 0) {
                            String extras = stateInfo.substring(slashPos);
                            stateInfo = stateInfo.substring(0, slashPos);
                            while (extras.length() > 0) {
                                if (extras.charAt(1) == 'A') {
                                    ec.setAlwaysDrawn(true);
                                } else if (extras.charAt(1) == 'B') {
                                    ec.setBodyOnly(true);
                                }
                                extras = extras.substring(2);
                            }
                        }
                        ec.setCharacteristic(PortCharacteristic.findCharacteristicShort(stateInfo));
                        ec.setVars(this.varPieces());
                        exports.add(ec);
                    }
                }
            }
            line = this.lineReader.readLine();
        }
        cc.exports = exports.toArray(NULL_EXPORTS_ARRAY);
        if (line != null && line.charAt(0) != 'X') {
            this.logError("unrecognized line type " + line.charAt(0));
        }
        this.currentCellContents = null;
    }

    protected void realizeCellsRecursively(Cell cell, FlagSet recursiveSetupFlag, String scaledCellName, double scaleX, double scaleY) {
        if (cell.getLibrary() != this.lib) {
            return;
        }
        LibraryContents.CellContents cc = (LibraryContents.CellContents)this.cellToContents.get(cell);
        if (cc == null || cc.isFilledIn()) {
            return;
        }
        if (scaledCellName != null) {
            return;
        }
        NodeProto[] npList = new NodeProto[cc.nodes.length];
        for (int i = 0; i < cc.nodes.length; ++i) {
            LibraryContents.NodeContents nc = cc.nodes[i];
            if (nc == null) continue;
            npList[i] = nc.getNodeProtoRef().getNodeProto();
        }
        this.scanNodesForRecursion(cell, recursiveSetupFlag, npList, 0, npList.length);
        progress.setProgress(++cellsConstructed * 100 / totalCells);
        cc.instantiate();
    }

    boolean parseLine(String line, String format) {
        this.stringPieces.clear();
        this.curPiece = 0;
        int len = line.length();
        int pos = 1;
        StringBuffer sb = new StringBuffer();
        boolean inQuote = false;
        while (pos < len) {
            char chr;
            if ((chr = line.charAt(pos++)) == '^') {
                sb.append(chr);
                sb.append(line.charAt(pos++));
                continue;
            }
            if (chr == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (chr == '|' && !inQuote) {
                String piece = sb.toString();
                if (this.stringPieces.size() < format.length() && format.charAt(this.stringPieces.size()) == 'Q' || line.charAt(0) == 'G') {
                    piece = this.unQuote(piece);
                }
                this.stringPieces.add(piece);
                sb = new StringBuffer();
                continue;
            }
            sb.append(chr);
        }
        String piece = sb.toString();
        if (this.stringPieces.size() < format.length() && format.charAt(this.stringPieces.size()) == 'Q' || line.charAt(0) == 'G') {
            piece = this.unQuote(piece);
        }
        this.stringPieces.add(piece);
        if (this.stringPieces.size() < format.length()) {
            this.logError("Declaration '" + line.charAt(0) + "' needs " + format.length() + " fields: " + line);
            return true;
        }
        return false;
    }

    private String nextPiece() {
        if (this.curPiece >= this.stringPieces.size()) {
            return null;
        }
        return (String)this.stringPieces.get(this.curPiece++);
    }

    private LibraryContents.VariableContents[] varPieces() {
        if (this.curPiece >= this.stringPieces.size()) {
            return LibraryContents.NULL_VARS_ARRAY;
        }
        LibraryContents.VariableContents[] vars = new LibraryContents.VariableContents[this.stringPieces.size() - this.curPiece];
        block3: for (int i = 0; i < vars.length; ++i) {
            Object[] obj;
            int openPos;
            String piece = (String)this.stringPieces.get(this.curPiece + i);
            for (openPos = 0; openPos < piece.length(); ++openPos) {
                char chr = piece.charAt(openPos);
                if (chr == '^') {
                    ++openPos;
                    continue;
                }
                if (chr == '(') break;
            }
            if (openPos >= piece.length()) {
                this.logError("Badly formed variable (no open parenthesis): " + piece);
                continue;
            }
            String varName = piece.substring(0, openPos);
            int closePos = piece.indexOf(41, openPos);
            if (closePos < 0) {
                this.logError("Badly formed variable (no close parenthesis): " + piece);
                continue;
            }
            String varBits = piece.substring(openPos + 1, closePos);
            int objectPos = closePos + 1;
            if (objectPos >= piece.length()) {
                this.logError("Variable type missing: " + piece);
                continue;
            }
            char varType = piece.charAt(objectPos++);
            switch (varType) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'O': 
                case 'P': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Y': {
                    break;
                }
                default: {
                    this.logError("Variable type invalid: " + piece);
                    continue block3;
                }
            }
            if (objectPos >= piece.length()) {
                this.logError("Variable value missing: " + piece);
                continue;
            }
            if (piece.charAt(objectPos) == '[') {
                ArrayList<Object> objList = new ArrayList<Object>();
                ++objectPos;
                while (objectPos < piece.length()) {
                    int start = objectPos;
                    boolean inQuote = false;
                    while (objectPos < piece.length()) {
                        if (inQuote) {
                            if (piece.charAt(objectPos) == '^') {
                                ++objectPos;
                            } else if (piece.charAt(objectPos) == '\"') {
                                inQuote = false;
                            }
                            ++objectPos;
                            continue;
                        }
                        if (piece.charAt(objectPos) == ',' || piece.charAt(objectPos) == ']') break;
                        if (piece.charAt(objectPos) == '\"') {
                            inQuote = true;
                        }
                        ++objectPos;
                    }
                    Object oneObj = this.getVariableValue(piece.substring(start, objectPos), 0, varType);
                    objList.add(oneObj);
                    if (piece.charAt(objectPos) == ']') break;
                    ++objectPos;
                }
                if (objectPos >= piece.length()) {
                    this.logError("Badly formed array (no closed bracket): " + piece);
                    continue;
                }
                if (objectPos < piece.length() - 1) {
                    this.logError("Badly formed array (extra characters after closed bracket): " + piece);
                    continue;
                }
                int limit = objList.size();
                Object[] objArray = new Object[limit];
                for (int j = 0; j < limit; ++j) {
                    objArray[j] = objList.get(j);
                }
                obj = objArray;
            } else {
                obj = this.getVariableValue(piece, objectPos, varType);
            }
            vars[i] = this.libraryContents.newVariableContents(this.libraryContents.getVariableKeyRef(varName), varBits, varType, obj);
        }
        this.curPiece = this.stringPieces.size();
        return vars;
    }

    private Object getVariableValue(String piece, int objectPos, char varType) {
        switch (varType) {
            case 'B': {
                return new Boolean(piece.charAt(objectPos) == 'T');
            }
            case 'C': {
                LibraryContents.CellRef cellRef;
                int colonPos = piece.indexOf(58, objectPos);
                if (colonPos < 0) {
                    this.logError("Badly formed ArcProto (missing colon): " + piece);
                    break;
                }
                String libName = piece.substring(objectPos, colonPos);
                LibraryContents.LibraryRef libRef = this.libraryContents.getLibraryRef(libName);
                if (libRef == null) {
                    this.logError("Unknown library: " + libName);
                    break;
                }
                String cellName = piece.substring(colonPos + 1);
                int commaPos = cellName.indexOf(44);
                if (commaPos >= 0) {
                    cellName = cellName.substring(0, commaPos);
                }
                if ((cellRef = libRef.getCellRef(cellName)) == null) {
                    this.logError("Unknown Cell: " + piece);
                }
                return cellRef;
            }
            case 'D': {
                return new Double(TextUtils.atof(piece.substring(objectPos)));
            }
            case 'E': {
                int colonPos = piece.indexOf(58, objectPos);
                if (colonPos < 0) {
                    this.logError("Badly formed Export (missing library colon): " + piece);
                    break;
                }
                String libName = piece.substring(objectPos, colonPos);
                LibraryContents.LibraryRef libRef = this.libraryContents.getLibraryRef(libName);
                if (libRef == null) {
                    this.logError("Unknown library: " + libName);
                    break;
                }
                int secondColonPos = piece.indexOf(58, colonPos + 1);
                if (secondColonPos < 0) {
                    this.logError("Badly formed Export (missing cell colon): " + piece);
                    break;
                }
                String cellName = piece.substring(colonPos + 1, secondColonPos);
                LibraryContents.CellRef cellRef = libRef.getCellRef(cellName);
                if (cellRef == null) {
                    this.logError("Unknown Cell: " + piece);
                    break;
                }
                String exportName = piece.substring(secondColonPos + 1);
                int commaPos = exportName.indexOf(44);
                if (commaPos >= 0) {
                    exportName = exportName.substring(0, commaPos);
                }
                return cellRef.getPortProtoRef(exportName);
            }
            case 'F': {
                return new Float((float)TextUtils.atof(piece.substring(objectPos)));
            }
            case 'G': {
                return new Long(TextUtils.atoi(piece.substring(objectPos)));
            }
            case 'H': {
                return new Short((short)TextUtils.atoi(piece.substring(objectPos)));
            }
            case 'I': {
                return new Integer(TextUtils.atoi(piece.substring(objectPos)));
            }
            case 'L': {
                String libName = piece.substring(objectPos);
                int commaPos = libName.indexOf(44);
                if (commaPos >= 0) {
                    libName = libName.substring(0, commaPos);
                }
                LibraryContents.LibraryRef libRef = this.getLibraryRef(libName);
                return libRef;
            }
            case 'O': {
                String toolName = piece.substring(objectPos);
                int commaPos = toolName.indexOf(44);
                if (commaPos >= 0) {
                    toolName = toolName.substring(0, commaPos);
                }
                return this.libraryContents.getToolRef(toolName);
            }
            case 'P': {
                String pnName = piece.substring(objectPos);
                int commaPos = pnName.indexOf(44);
                if (commaPos >= 0) {
                    pnName = pnName.substring(0, commaPos);
                }
                return this.getPrimitiveNodeRef(null, pnName);
            }
            case 'R': {
                String apName = piece.substring(objectPos);
                int commaPos = apName.indexOf(44);
                if (commaPos >= 0) {
                    apName = apName.substring(0, commaPos);
                }
                return this.getArcProtoRef(null, apName);
            }
            case 'S': {
                if (piece.charAt(objectPos) != '\"') {
                    this.logError("Badly formed string variable (missing open quote): " + piece);
                    break;
                }
                StringBuffer sb = new StringBuffer();
                int len = piece.length();
                while (objectPos < len && piece.charAt(++objectPos) != '\"') {
                    if (piece.charAt(objectPos) == '^' && ++objectPos <= len - 2 && piece.charAt(objectPos) == '\\' && piece.charAt(objectPos + 1) == 'n') {
                        sb.append('\n');
                        ++objectPos;
                        continue;
                    }
                    sb.append(piece.charAt(objectPos));
                }
                return sb.toString();
            }
            case 'T': {
                String techName = piece.substring(objectPos);
                int commaPos = techName.indexOf(44);
                if (commaPos >= 0) {
                    techName = techName.substring(0, commaPos);
                }
                return this.getTechnologyRef(techName);
            }
            case 'V': {
                double x = TextUtils.atof(piece.substring(objectPos));
                int slashPos = piece.indexOf(47, objectPos);
                if (slashPos < 0) {
                    this.logError("Badly formed Point2D variable (missing slash): " + piece);
                    break;
                }
                double y = TextUtils.atof(piece.substring(slashPos + 1));
                return new Point2D.Double(x, y);
            }
            case 'Y': {
                return new Byte((byte)TextUtils.atoi(piece.substring(objectPos)));
            }
        }
        return null;
    }

    private String[] stringPieces() {
        if (this.curPiece >= this.stringPieces.size()) {
            return NULL_STRINGS_ARRAY;
        }
        String[] pieces = new String[this.stringPieces.size() - this.curPiece];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[i] = (String)this.stringPieces.get(this.curPiece + i);
        }
        this.curPiece = this.stringPieces.size();
        return pieces;
    }

    void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    ErrorLogger.MessageLog logError(String message) {
        String prefix;
        if (this.lineReader != null) {
            this.lineNumber = this.lineReader.getLineNumber();
        }
        Cell cell = null;
        if (this.currentCellContents != null) {
            cell = this.currentCellContents.getCell();
            prefix = this.filePath + ", line " + this.lineNumber + " (cell " + this.currentCellContents.getName() + ") ";
        } else {
            prefix = this.filePath + ", line " + this.lineNumber + ", ";
        }
        return errorLogger.logError(prefix + message, cell, -1);
    }

    ErrorLogger.MessageLog logWarning(String message) {
        String prefix;
        if (this.lineReader != null) {
            this.lineNumber = this.lineReader.getLineNumber();
        }
        Cell cell = null;
        if (this.currentCellContents != null) {
            cell = this.currentCellContents.getCell();
            prefix = this.filePath + ", line " + this.lineNumber + " (cell " + this.currentCellContents.getName() + ") ";
        } else {
            prefix = this.filePath + ", line " + this.lineNumber + ", ";
        }
        return errorLogger.logWarning(prefix + message, cell, -1);
    }

    void setupProgress(int numToProcess) {
        JELIB1.numToProcess = numToProcess;
        numProcessed = 0;
    }

    void showProgress(int lineNumber) {
        if (++numProcessed % 100 == 0) {
            progress.setProgress(numProcessed * 100 / numToProcess);
        }
        this.setLineNumber(lineNumber);
    }

    private String unQuote(String line) {
        if (line.indexOf(94) < 0) {
            return line;
        }
        StringBuffer sb = new StringBuffer();
        int len = line.length();
        for (int i = 0; i < len; ++i) {
            char chr = line.charAt(i);
            if (chr == '^') {
                if (++i >= len) break;
                chr = line.charAt(i);
            }
            sb.append(chr);
        }
        return sb.toString();
    }
}

