/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CrossLibCopy
extends EDialog {
    private List libList;
    private List cellListLeft;
    private List cellListRight;
    private JList listLeft;
    private JList listRight;
    private JList listCenter;
    private DefaultListModel modelLeft;
    private DefaultListModel modelRight;
    private DefaultListModel modelCenter;
    private static Library curLibLeft = null;
    private static Library curLibRight = null;
    private static boolean lastDeleteAfterCopy = false;
    private static boolean lastCopyRelated = false;
    private static boolean lastCopySubcells = false;
    private static boolean lastUseExisting = true;
    private JPanel Bottom;
    private JPanel BottomCenter;
    private JPanel BottomLeft;
    private JPanel BottomRight;
    private JPanel Top;
    private JScrollPane cellsLeft;
    private JScrollPane cellsRight;
    private JScrollPane center;
    private JLabel centerLabel;
    private JCheckBox compareContent;
    private JCheckBox compareQuite;
    private JButton copyLeft;
    private JCheckBox copyRelatedViews;
    private JButton copyRight;
    private JCheckBox copySubcells;
    private JCheckBox deleteAfterCopy;
    private JButton done;
    private JButton examineContents;
    private JComboBox librariesLeft;
    private JComboBox librariesRight;
    private JCheckBox useExistingSubcells;

    public CrossLibCopy(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.libList = Library.getVisibleLibraries();
        if (curLibLeft == null) {
            curLibLeft = Library.getCurrent();
        }
        if (curLibRight == null) {
            curLibRight = Library.getCurrent();
        }
        if (curLibLeft == curLibRight) {
            Iterator it = this.libList.iterator();
            while (it.hasNext()) {
                Library lib = (Library)it.next();
                if (lib == curLibLeft) continue;
                curLibRight = lib;
                break;
            }
        }
        Library saveLeft = curLibLeft;
        Library saveRight = curLibRight;
        Iterator it = this.libList.iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            this.librariesLeft.addItem(lib.getName());
            this.librariesRight.addItem(lib.getName());
        }
        int curIndex = this.libList.indexOf(saveLeft);
        if (curIndex >= 0) {
            this.librariesLeft.setSelectedIndex(curIndex);
        }
        if ((curIndex = this.libList.indexOf(saveRight)) >= 0) {
            this.librariesRight.setSelectedIndex(curIndex);
        }
        this.modelLeft = new DefaultListModel();
        this.listLeft = new JList(this.modelLeft);
        this.listLeft.setSelectionMode(0);
        this.cellsLeft.setViewportView(this.listLeft);
        this.listLeft.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrossLibCopy.this.leftListClick(evt);
            }
        });
        this.modelRight = new DefaultListModel();
        this.listRight = new JList(this.modelRight);
        this.listRight.setSelectionMode(0);
        this.cellsRight.setViewportView(this.listRight);
        this.listRight.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrossLibCopy.this.rightListClick(evt);
            }
        });
        this.modelCenter = new DefaultListModel();
        this.listCenter = new JList(this.modelCenter);
        this.listCenter.setSelectionMode(0);
        this.center.setViewportView(this.listCenter);
        this.listCenter.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrossLibCopy.this.centerListClick(evt);
            }
        });
        this.showCells(false, false);
        if (lastCopySubcells) {
            lastUseExisting = true;
            this.useExistingSubcells.setEnabled(false);
        }
        this.deleteAfterCopy.setSelected(lastDeleteAfterCopy);
        this.copyRelatedViews.setSelected(lastCopyRelated);
        this.copySubcells.setSelected(lastCopySubcells);
        this.useExistingSubcells.setSelected(lastUseExisting);
        JScrollBar[] scrollArray1 = new JScrollBar[]{this.cellsRight.getVerticalScrollBar(), this.center.getVerticalScrollBar()};
        this.cellsLeft.getVerticalScrollBar().getModel().addChangeListener(new CrossLibScrollBarListener(scrollArray1));
        JScrollBar[] scrollArray2 = new JScrollBar[]{this.cellsLeft.getVerticalScrollBar(), this.center.getVerticalScrollBar()};
        this.cellsRight.getVerticalScrollBar().getModel().addChangeListener(new CrossLibScrollBarListener(scrollArray2));
        JScrollBar[] scrollArray3 = new JScrollBar[]{this.cellsLeft.getVerticalScrollBar(), this.cellsRight.getVerticalScrollBar()};
        this.center.getVerticalScrollBar().getModel().addChangeListener(new CrossLibScrollBarListener(scrollArray3));
        this.finishInitialization();
    }

    private void leftListClick(MouseEvent evt) {
        int index = this.listLeft.getSelectedIndex();
        this.listRight.setSelectedIndex(index);
        this.listCenter.setSelectedIndex(index);
    }

    private void rightListClick(MouseEvent evt) {
        int index = this.listRight.getSelectedIndex();
        this.listLeft.setSelectedIndex(index);
        this.listCenter.setSelectedIndex(index);
    }

    private void centerListClick(MouseEvent evt) {
        int index = this.listCenter.getSelectedIndex();
        this.listLeft.setSelectedIndex(index);
        this.listRight.setSelectedIndex(index);
    }

    private void showCells(boolean report, boolean examineContents) {
        if (this.modelLeft == null || this.modelRight == null || this.modelCenter == null) {
            return;
        }
        this.cellListLeft = new ArrayList();
        Iterator it = curLibLeft.getCells();
        while (it.hasNext()) {
            this.cellListLeft.add(it.next());
        }
        this.cellListRight = new ArrayList();
        it = curLibRight.getCells();
        while (it.hasNext()) {
            this.cellListRight.add(it.next());
        }
        this.modelLeft.clear();
        this.modelRight.clear();
        this.modelCenter.clear();
        int leftPos = 0;
        int rightPos = 0;
        int leftCount = this.cellListLeft.size();
        int rightCount = this.cellListRight.size();
        while (leftPos < leftCount || rightPos < rightCount) {
            int op;
            if (leftPos >= leftCount) {
                op = 2;
            } else if (rightPos >= rightCount) {
                op = 1;
            } else {
                Cell leftCell = (Cell)this.cellListLeft.get(leftPos);
                Cell rightCell = (Cell)this.cellListRight.get(rightPos);
                int j = TextUtils.nameSameNumeric(leftCell.noLibDescribe(), rightCell.noLibDescribe());
                op = j < 0 ? 1 : (j > 0 ? 2 : 3);
            }
            String leftName = " ";
            Cell leftCell = null;
            if (op == 1 || op == 3) {
                leftCell = (Cell)this.cellListLeft.get(leftPos++);
                leftName = leftCell.noLibDescribe();
            }
            this.modelLeft.addElement(leftName);
            String rightName = " ";
            Cell rightCell = null;
            if (op == 2 || op == 3) {
                rightCell = (Cell)this.cellListRight.get(rightPos++);
                rightName = rightCell.noLibDescribe();
            }
            this.modelRight.addElement(rightName);
            String pt = " ";
            if (op == 3) {
                String message;
                int compare = leftCell.getRevisionDate().compareTo(rightCell.getRevisionDate());
                StringBuffer buffer = null;
                boolean result = true;
                if (examineContents) {
                    if (report) {
                        buffer = new StringBuffer("\n");
                    }
                    result = leftCell.compare(rightCell, buffer);
                }
                String string = message = result ? "(but contents are the same)" : "(and contents are different)";
                if (compare > 0) {
                    String string2 = pt = result ? "<-OLD" : "<-OLD/DIFF";
                    if (report) {
                        System.out.println(curLibLeft.getName() + ":" + leftName + " OLDER THAN " + curLibRight.getName() + ":" + rightName + message + ":" + (buffer != null ? buffer.toString() : "\n"));
                    }
                } else if (compare < 0) {
                    String string3 = pt = result ? "  OLD->" : " DIFF/OLD->";
                    if (report) {
                        System.out.println(curLibRight.getName() + ":" + rightName + " OLDER THAN " + curLibLeft.getName() + ":" + leftName + message + ":" + (buffer != null ? buffer.toString() : "\n"));
                    }
                } else {
                    String string4 = pt = result ? "-SAME-" : "-DIFF -";
                    if (!result && report) {
                        System.out.println(curLibLeft.getName() + ":" + leftName + " DIFFERS FROM " + curLibRight.getName() + ":" + rightName + ":" + (buffer != null ? buffer.toString() : "\n"));
                    }
                }
            }
            this.modelCenter.addElement(pt);
        }
    }

    private void initComponents() {
        this.Top = new JPanel();
        this.librariesLeft = new JComboBox();
        this.librariesRight = new JComboBox();
        this.copyLeft = new JButton();
        this.copyRight = new JButton();
        this.done = new JButton();
        this.cellsLeft = new JScrollPane();
        this.center = new JScrollPane();
        this.cellsRight = new JScrollPane();
        this.centerLabel = new JLabel();
        this.Bottom = new JPanel();
        this.BottomLeft = new JPanel();
        this.compareContent = new JCheckBox();
        this.compareQuite = new JCheckBox();
        this.BottomCenter = new JPanel();
        this.examineContents = new JButton();
        this.BottomRight = new JPanel();
        this.deleteAfterCopy = new JCheckBox();
        this.copySubcells = new JCheckBox();
        this.useExistingSubcells = new JCheckBox();
        this.copyRelatedViews = new JCheckBox();
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.setTitle("Cross Library Copy");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CrossLibCopy.this.closeDialog(evt);
            }
        });
        this.Top.setLayout(new GridBagLayout());
        this.librariesLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.librariesLeftActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.Top.add((Component)this.librariesLeft, gridBagConstraints);
        this.librariesRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.librariesRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.Top.add((Component)this.librariesRight, gridBagConstraints);
        this.copyLeft.setText("<< Copy");
        this.copyLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.copyLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.copyLeft, gridBagConstraints);
        this.copyRight.setText("Copy >>");
        this.copyRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.copyRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.copyRight, gridBagConstraints);
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.done, gridBagConstraints);
        this.cellsLeft.setPreferredSize(new Dimension(200, 350));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.cellsLeft, gridBagConstraints);
        this.center.setMinimumSize(new Dimension(22, 200));
        this.center.setPreferredSize(new Dimension(22, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.Top.add((Component)this.center, gridBagConstraints);
        this.cellsRight.setPreferredSize(new Dimension(200, 350));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.cellsRight, gridBagConstraints);
        this.centerLabel.setText("Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.Top.add((Component)this.centerLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.Top, "Center");
        this.BottomLeft.setLayout(new GridBagLayout());
        this.compareContent.setText("Date and content");
        this.compareContent.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CrossLibCopy.this.compareContentItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.BottomLeft.add((Component)this.compareContent, gridBagConstraints);
        this.compareQuite.setSelected(true);
        this.compareQuite.setText("Examine quietly");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.BottomLeft.add((Component)this.compareQuite, gridBagConstraints);
        this.Bottom.add(this.BottomLeft);
        this.BottomCenter.setLayout(new GridBagLayout());
        this.examineContents.setText("Compare");
        this.examineContents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.examineContentsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BottomCenter.add((Component)this.examineContents, gridBagConstraints);
        this.Bottom.add(this.BottomCenter);
        this.BottomRight.setLayout(new GridBagLayout());
        this.deleteAfterCopy.setText("Delete after copy");
        this.deleteAfterCopy.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CrossLibCopy.this.deleteAfterCopyItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.BottomRight.add((Component)this.deleteAfterCopy, gridBagConstraints);
        this.copySubcells.setText("Copy subcells");
        this.copySubcells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.copySubcellsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.BottomRight.add((Component)this.copySubcells, gridBagConstraints);
        this.useExistingSubcells.setText("Use existing subcells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.BottomRight.add((Component)this.useExistingSubcells, gridBagConstraints);
        this.copyRelatedViews.setText("Copy all related views");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.BottomRight.add((Component)this.copyRelatedViews, gridBagConstraints);
        this.Bottom.add(this.BottomRight);
        this.getContentPane().add((Component)this.Bottom, "South");
        this.pack();
    }

    private void copySubcellsActionPerformed(ActionEvent evt) {
        if (this.copySubcells.isSelected()) {
            this.useExistingSubcells.setSelected(true);
            this.useExistingSubcells.setEnabled(false);
        } else {
            this.useExistingSubcells.setEnabled(true);
        }
    }

    private void compareContentItemStateChanged(ItemEvent evt) {
        if (this.compareContent.isSelected()) {
            this.centerLabel.setText("Date/Content");
        } else {
            this.centerLabel.setText("Date");
        }
        this.modelCenter.clear();
    }

    private void deleteAfterCopyItemStateChanged(ItemEvent evt) {
        if (this.deleteAfterCopy.isSelected()) {
            this.copyLeft.setText("<< Move");
            this.copyRight.setText("Move >>");
        } else {
            this.copyLeft.setText("<< Copy");
            this.copyRight.setText("Copy >>");
        }
    }

    private void librariesRightActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        int index = cb.getSelectedIndex();
        curLibRight = (Library)this.libList.get(index);
        this.showCells(false, false);
    }

    private void librariesLeftActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        int index = cb.getSelectedIndex();
        curLibLeft = (Library)this.libList.get(index);
        this.showCells(false, false);
    }

    private void examineContentsActionPerformed(ActionEvent evt) {
        this.showCells(!this.compareQuite.isSelected(), this.compareContent.isSelected());
    }

    private void copyRightActionPerformed(ActionEvent evt) {
        String cellName = (String)this.listLeft.getSelectedValue();
        Cell fromCell = curLibLeft.findNodeProto(cellName);
        if (fromCell == null) {
            return;
        }
        CrossLibraryCopyJob job = new CrossLibraryCopyJob(fromCell, curLibRight, this);
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void copyLeftActionPerformed(ActionEvent evt) {
        String cellName = (String)this.listRight.getSelectedValue();
        Cell fromCell = curLibRight.findNodeProto(cellName);
        if (fromCell == null) {
            return;
        }
        CrossLibraryCopyJob job = new CrossLibraryCopyJob(fromCell, curLibLeft, this);
    }

    private void closeDialog(WindowEvent evt) {
        lastDeleteAfterCopy = this.deleteAfterCopy.isSelected();
        lastCopyRelated = this.copyRelatedViews.isSelected();
        lastCopySubcells = this.copySubcells.isSelected();
        lastUseExisting = this.useExistingSubcells.isSelected();
        this.setVisible(false);
        this.dispose();
    }

    private static class CrossLibraryCopyJob
    extends Job {
        Cell fromCell;
        Library toLibrary;
        CrossLibCopy dialog;

        protected CrossLibraryCopyJob(Cell fromCell, Library toLibrary, CrossLibCopy dialog) {
            super("Cross-Library copy", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fromCell = fromCell;
            this.toLibrary = toLibrary;
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            int index = this.dialog.listLeft.getSelectedIndex();
            boolean deleteAfter = this.dialog.deleteAfterCopy.isSelected();
            boolean copyRelated = this.dialog.copyRelatedViews.isSelected();
            boolean copySubs = this.dialog.copySubcells.isSelected();
            boolean useExisting = this.dialog.useExistingSubcells.isSelected();
            CircuitChanges.copyRecursively(this.fromCell, this.fromCell.getName(), this.toLibrary, this.fromCell.getView(), true, deleteAfter, "", true, copyRelated, copyRelated, copySubs, useExisting, new HashSet());
            SwingUtilities.invokeLater(new DoneCopying(this.dialog, index));
            return true;
        }
    }

    private static class CrossLibraryExamineJob
    extends Job {
        Cell leftC;
        Cell rightC;
        boolean reportResults;
        boolean result;
        StringBuffer buffer;

        protected CrossLibraryExamineJob(Cell left, Cell right, boolean report) {
            super("Cross-Library examine", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.leftC = left;
            this.rightC = right;
            this.reportResults = report;
            this.startJob();
        }

        public boolean doIt() {
            if (this.reportResults) {
                this.buffer = new StringBuffer("Cells '" + this.leftC.libDescribe() + "' and '" + this.rightC.libDescribe() + ":");
            }
            boolean bl = this.result = this.leftC != null && this.leftC.compare(this.rightC, this.buffer);
            if (this.reportResults) {
                if (this.result) {
                    this.buffer.append("Do not differ");
                }
                System.out.println(this.buffer);
            }
            return true;
        }

        public boolean getResult() {
            return this.result;
        }

        public StringBuffer getDifference() {
            return this.buffer;
        }
    }

    private static class DoneCopying
    implements Runnable {
        CrossLibCopy dialog;
        int index;

        DoneCopying(CrossLibCopy dialog, int index) {
            this.dialog = dialog;
            this.index = index;
        }

        public void run() {
            this.dialog.showCells(false, false);
            this.dialog.listLeft.setSelectedIndex(this.index);
            this.dialog.listRight.setSelectedIndex(this.index);
            this.dialog.listCenter.setSelectedIndex(this.index);
        }
    }

    private class CrossLibScrollBarListener
    implements ChangeListener {
        private JScrollBar[] scrollBarList = new JScrollBar[2];
        protected boolean blocked = false;

        public CrossLibScrollBarListener(JScrollBar[] bars) {
            System.arraycopy(bars, 0, this.scrollBarList, 0, bars.length);
        }

        public void stateChanged(ChangeEvent evt) {
            if (this.blocked) {
                return;
            }
            this.blocked = true;
            BoundedRangeModel sourceScroll = (BoundedRangeModel)evt.getSource();
            int iSMin = sourceScroll.getMinimum();
            int iSMax = sourceScroll.getMaximum();
            int iSDiff = iSMax - iSMin;
            int iSVal = sourceScroll.getValue();
            int iDMin = CrossLibCopy.this.cellsLeft.getVerticalScrollBar().getMinimum();
            int iDMax = CrossLibCopy.this.cellsLeft.getVerticalScrollBar().getMaximum();
            int iDDiff = iDMax - iDMin;
            int iDVal = iSDiff == iDDiff ? iSVal : iDDiff * iSVal / iSDiff;
            for (int i = 0; i < this.scrollBarList.length; ++i) {
                this.scrollBarList[i].setValue(iDVal);
            }
            this.blocked = false;
        }
    }
}

