/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.help;

import com.sun.electric.Main;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ManualViewer
extends EDialog {
    private JScrollPane rightHalf;
    private JEditorPane editorPane;
    private JSplitPane splitPane;
    private JTextField searchField;
    private JTree optionTree;
    private DefaultMutableTreeNode rootNode;
    private List pageSequence;
    private int currentIndex;
    private boolean menubarShown = false;
    private static int lastPageVisited = 0;
    private static HashMap menuMap = null;
    private static HashMap preferenceMap = null;
    private List history = new ArrayList();
    private static ManualViewer theManual = null;

    public static void userManualCommand() {
        if (theManual == null) {
            theManual = new ManualViewer(TopLevel.getCurrentJFrame());
            theManual.loadPointers();
        }
        theManual.setVisible(true);
    }

    public static void showPreferenceHelp(String preference) {
        if (theManual == null) {
            theManual = new ManualViewer(TopLevel.getCurrentJFrame());
            theManual.loadPointers();
        }
        theManual.setVisible(true);
        String fileName = (String)preferenceMap.get(preference);
        if (fileName == null) {
            System.out.println("No help for preference " + preference);
        } else {
            for (int i = 0; i < ManualViewer.theManual.pageSequence.size(); ++i) {
                PageInfo pi = (PageInfo)ManualViewer.theManual.pageSequence.get(i);
                if (!pi.fileName.equals(fileName)) continue;
                theManual.loadPage(i);
                break;
            }
        }
    }

    public static void open3DSample() {
        Class plugin3D;
        Library library = Library.findLibrary("samples");
        if (library == null) {
            System.out.println("Load first samples");
            return;
        }
        Cell cell = library.findNodeProto("tech-MOSISCMOS");
        if (cell == null) {
            System.out.println("Cell 'tech-MOSISCMOS' not found");
            return;
        }
        if (cell != WindowFrame.getCurrentCell()) {
            WindowFrame.createEditWindow(cell);
        }
        if ((plugin3D = Resources.get3DClass("ui.J3DMenu")) != null) {
            try {
                Method createMethod = plugin3D.getDeclaredMethod("create3DViewCommand", Boolean.class);
                createMethod.invoke((Object)plugin3D, new Boolean(false));
            }
            catch (Exception e) {
                System.out.println("Can't open 3D view: " + e.getMessage());
                ActivityLogger.logException(e);
            }
        }
    }

    public static void animate3DSample() {
        URL url = ManualViewer.class.getResource("helphtml/demo.j3d");
        if (url == null) {
            System.out.println("Can't open 3D demo file 'helphtml/demo.j3d'");
            return;
        }
        Class plugin3D = Resources.get3DClass("ui.J3DDemoDialog");
        if (plugin3D != null) {
            try {
                Method createMethod = plugin3D.getDeclaredMethod("create3DDemoDialog", Frame.class, String.class);
                createMethod.invoke((Object)plugin3D, TopLevel.getCurrentJFrame(), url.getFile());
            }
            catch (Exception e) {
                System.out.println("Can't open 3D demo dialog: " + e.getMessage());
                ActivityLogger.logException(e);
            }
        }
    }

    public static void loadSamplesLibrary() {
        if (Library.findLibrary("samples") != null) {
            return;
        }
        URL url = ManualViewer.class.getResource("helphtml/samples.jelib");
        FileMenu.ReadLibrary job = new FileMenu.ReadLibrary(url, FileType.JELIB, null);
    }

    private ManualViewer(Frame parent) {
        super(parent, false);
        String line;
        this.setTitle("User's Manual");
        this.init();
        URL url = ManualViewer.class.getResource("helphtml/toc.txt");
        InputStream stream = TextUtils.getURLStream(url, null);
        InputStreamReader is = new InputStreamReader(stream);
        this.pageSequence = new ArrayList();
        DefaultMutableTreeNode[] stack = new DefaultMutableTreeNode[20];
        stack[0] = this.rootNode;
        boolean newAtLevel = false;
        String chapterName = null;
        int chapterNumber = 0;
        int[] sectionNumbers = new int[5];
        sectionNumbers[0] = -1;
        this.currentIndex = lastPageVisited;
        while ((line = this.getLine(is)) != null) {
            int indent;
            if (line.length() == 0) continue;
            for (indent = 0; indent < line.length() && line.charAt(indent) == ' '; ++indent) {
            }
            int titleStart = indent;
            int titleEnd = line.indexOf(61, titleStart);
            String fileName = null;
            if (titleEnd < 0) {
                titleEnd = line.length();
            } else {
                fileName = line.substring(titleEnd + 1).trim();
            }
            String title = line.substring(titleStart, titleEnd).trim();
            if (fileName == null) {
                if (indent == 0) {
                    chapterName = ++chapterNumber + ": " + title;
                }
                int n = indent;
                sectionNumbers[n] = sectionNumbers[n] + 1;
                stack[indent + 1] = new DefaultMutableTreeNode(sectionNumbers[indent] + ": " + title);
                stack[indent].add(stack[indent + 1]);
                sectionNumbers[indent + 1] = 0;
                newAtLevel = true;
                continue;
            }
            PageInfo pi = new PageInfo();
            pi.fileName = fileName;
            pi.title = title;
            pi.chapterName = chapterName;
            pi.chapterNumber = chapterNumber;
            int n = indent;
            int n2 = sectionNumbers[n] + 1;
            sectionNumbers[n] = n2;
            pi.sectionNumber = n2;
            pi.fullChapterNumber = "";
            for (int i = 0; i < indent; ++i) {
                pi.fullChapterNumber = pi.fullChapterNumber + sectionNumbers[i] + "-";
            }
            pi.fullChapterNumber = pi.fullChapterNumber + sectionNumbers[indent];
            pi.level = indent;
            pi.newAtLevel = newAtLevel;
            pi.url = (class$com$sun$electric$tool$user$help$ManualViewer == null ? ManualViewer.class$("com.sun.electric.tool.user.help.ManualViewer") : class$com$sun$electric$tool$user$help$ManualViewer).getResource("helphtml/" + fileName + ".html");
            if (pi.url == null) {
                System.out.println("NULL URL to " + fileName);
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new Integer(this.pageSequence.size()));
            stack[indent].add(node);
            this.pageSequence.add(pi);
            newAtLevel = false;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing file");
        }
        TreePath topPath = this.optionTree.getPathForRow(0);
        this.optionTree.expandPath(topPath);
        topPath = this.optionTree.getPathForRow(1);
        this.optionTree.expandPath(topPath);
        this.loadPage(this.currentIndex);
    }

    private void loadMenuBar() {
        if (this.menubarShown) {
            return;
        }
        this.menubarShown = true;
        JMenuBar helpMenuBar = new JMenuBar();
        TopLevel top = TopLevel.getCurrentJFrame();
        MenuBar menuBar = top.getTheMenuBar();
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            MenuBar.Menu menu = (MenuBar.Menu)menuBar.getMenu(i);
            JMenu helpMenu = new JMenu(menu.getText());
            helpMenuBar.add(helpMenu);
            this.addMenu(menu, helpMenu, menu.getText() + "/");
        }
        this.setJMenuBar(helpMenuBar);
        this.pack();
        StringBuffer sb = new StringBuffer();
        sb.append("<CENTER><H1>HELP MENU ENABLED</H1></CENTER>\n");
        sb.append("The menu bar at the top of <I>this</I> window looks the same as the main menu bar in Electric.<BR><BR>\n");
        sb.append("Use any entry in this menu bar to see the manual page that explains that menu entry.\n");
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private void loadPointers() {
        String fileName;
        String line;
        if (preferenceMap != null) {
            return;
        }
        menuMap = new HashMap();
        HashMap<String, String> menuMapCheck = null;
        preferenceMap = new HashMap();
        if (Main.getDebug()) {
            menuMapCheck = new HashMap<String, String>();
        }
        URL url = ManualViewer.class.getResource("helphtml/toc.txt");
        InputStream stream = TextUtils.getURLStream(url, null);
        InputStreamReader is = new InputStreamReader(stream);
        while ((line = this.getLine(is)) != null) {
            String pageLine;
            int indent;
            if (line.length() == 0) continue;
            for (indent = 0; indent < line.length() && line.charAt(indent) == ' '; ++indent) {
            }
            int titleStart = indent;
            int titleEnd = line.indexOf(61, titleStart);
            if (titleEnd < 0) continue;
            fileName = line.substring(titleEnd + 1).trim();
            URL pageURL = (class$com$sun$electric$tool$user$help$ManualViewer == null ? ManualViewer.class$("com.sun.electric.tool.user.help.ManualViewer") : class$com$sun$electric$tool$user$help$ManualViewer).getResource("helphtml/" + fileName + ".html");
            if (pageURL == null) {
                System.out.println("NULL URL to " + fileName);
                continue;
            }
            InputStream pageStream = TextUtils.getURLStream(pageURL, null);
            InputStreamReader pageIS = new InputStreamReader(pageStream);
            while ((pageLine = this.getLine(pageIS)) != null) {
                String already;
                int endPt;
                if (pageLine.startsWith("<!-- COMMAND ")) {
                    int backslashPos;
                    endPt = pageLine.indexOf("-->");
                    if (endPt < 0) {
                        System.out.println("No end comment on line: " + pageLine);
                        continue;
                    }
                    String commandName = pageLine.substring(13, endPt).trim();
                    while ((backslashPos = commandName.indexOf(92)) >= 0) {
                        commandName = commandName.substring(0, backslashPos) + commandName.substring(backslashPos + 1);
                    }
                    already = (String)menuMap.get(commandName);
                    if (already != null && Main.getDebug()) {
                        System.out.println("ERROR: command " + commandName + " is keyed to both " + already + " and " + fileName);
                    }
                    menuMap.put(commandName, fileName);
                    if (menuMapCheck == null) continue;
                    menuMapCheck.put(commandName, fileName);
                    continue;
                }
                if (!pageLine.startsWith("<!-- PREFERENCE ")) continue;
                endPt = pageLine.indexOf("-->");
                if (endPt < 0) {
                    System.out.println("No end comment on line: " + pageLine);
                    continue;
                }
                String preferenceName = pageLine.substring(16, endPt).trim();
                already = (String)preferenceMap.get(preferenceName);
                if (already != null && Main.getDebug()) {
                    System.out.println("ERROR: command " + preferenceName + " is keyed to both " + already + " and " + fileName);
                }
                preferenceMap.put(preferenceName, fileName);
            }
            try {
                pageStream.close();
            }
            catch (IOException e) {
                System.out.println("Error closing file");
            }
        }
        if (menuMapCheck != null) {
            TopLevel top = TopLevel.getCurrentJFrame();
            MenuBar menuBar = top.getTheMenuBar();
            for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                MenuBar.Menu menu = (MenuBar.Menu)menuBar.getMenu(i);
                this.checkMenu(menu, menu.getText() + "/", menuMapCheck);
            }
            Iterator it = menuMapCheck.keySet().iterator();
            while (it.hasNext()) {
                String commandName = (String)it.next();
                fileName = (String)menuMapCheck.get(commandName);
                System.out.println("Command " + commandName + " was mentioned in file " + fileName + " but does not exist");
            }
            menuMapCheck = null;
        }
    }

    private void checkMenu(MenuBar.Menu menu, String cumulative, HashMap menuMapCheck) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem == null) continue;
            if (menuItem instanceof JMenu) {
                MenuBar.Menu subMenu = (MenuBar.Menu)menuItem;
                this.checkMenu((MenuBar.Menu)menuItem, cumulative + subMenu.getText() + "/", menuMapCheck);
                continue;
            }
            String commandName = cumulative + menuItem.getText();
            String fileName = (String)menuMap.get(commandName);
            if (fileName == null && Main.getDebug()) {
                if (commandName.startsWith("Russell/") || commandName.startsWith("JonG/") || commandName.startsWith("Gilda/") || commandName.startsWith("Dima/")) continue;
                System.out.println("No help for " + commandName);
                continue;
            }
            if (menuMapCheck == null) continue;
            menuMapCheck.remove(commandName);
        }
    }

    private void addMenu(MenuBar.Menu menu, JMenu helpMenu, String cumulative) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem == null) {
                helpMenu.addSeparator();
                continue;
            }
            if (menuItem instanceof JMenu) {
                MenuBar.Menu subMenu = (MenuBar.Menu)menuItem;
                JMenu helpSubMenu = new JMenu(subMenu.getText());
                helpMenu.add(helpSubMenu);
                this.addMenu((MenuBar.Menu)menuItem, helpSubMenu, cumulative + subMenu.getText() + "/");
                continue;
            }
            JMenuItem helpMenuItem = new JMenuItem(menuItem.getText());
            helpMenu.add(helpMenuItem);
            String commandName = cumulative + menuItem.getText();
            String fileName = (String)menuMap.get(commandName);
            helpMenuItem.addActionListener(new HelpMenuActionListener(this, fileName));
        }
    }

    private String getLine(InputStreamReader is) {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch = -1;
            try {
                ch = is.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (ch == -1) {
                return null;
            }
            if (ch == 10 || ch == 13) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private void loadPage(int index) {
        String line;
        this.history.add(new Integer(index));
        this.currentIndex = index;
        lastPageVisited = index;
        PageInfo pi = (PageInfo)this.pageSequence.get(index);
        if (pi.url == null) {
            return;
        }
        InputStream stream = TextUtils.getURLStream(pi.url, null);
        InputStreamReader is = new InputStreamReader(stream);
        StringBuffer sb = new StringBuffer();
        sb.append("<BASE href=\"" + pi.url.toString() + "\">");
        int lastIndex = index - 1;
        if (lastIndex < 0) {
            lastIndex = this.pageSequence.size() - 1;
        }
        PageInfo lastPi = (PageInfo)this.pageSequence.get(lastIndex);
        String lastFileName = lastPi.fileName;
        int nextIndex = index + 1;
        if (nextIndex >= this.pageSequence.size()) {
            nextIndex = 0;
        }
        PageInfo nextPi = (PageInfo)this.pageSequence.get(nextIndex);
        String nextFileName = nextPi.fileName;
        while ((line = this.getLine(is)) != null) {
            if (line.startsWith("<!-- HEADER ")) {
                int endPt = line.indexOf("-->");
                if (endPt < 0) {
                    System.out.println("No end comment on line: " + line);
                    continue;
                }
                String pageName = line.substring(12, endPt).trim();
                sb.append("<HTML><HEAD><TITLE>Using Electric " + pageName + "\"</TITLE></HEAD>\n");
                sb.append("<BODY>\n");
                sb.append("<CENTER><TABLE WIDTH=\"90%\" BORDER=0><TR>\n");
                sb.append("<TD><CENTER><A HREF=\"" + lastFileName + ".html#" + lastFileName + ".html\"><IMG SRC=\"iconplug.png\" ALT=\"plug\" BORDER=0></A></CENTER></TD>\n");
                sb.append("<TD><CENTER><H1>" + pageName + "</H1></CENTER></TD>\n");
                sb.append("<TD><CENTER><A HREF=\"" + nextFileName + ".html#" + nextFileName + ".html\"><IMG SRC=\"iconplug.png\" ALT=\"plug\" BORDER=0></A></CENTER></TD></TR></TABLE></CENTER>\n");
                sb.append("<HR>\n");
                sb.append("<BR>\n");
                continue;
            }
            if (line.equals("<!-- TRAILER -->")) {
                sb.append("</BODY>\n");
                sb.append("</HTML>\n");
                continue;
            }
            sb.append(line);
            sb.append("\n");
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing file");
        }
        this.editorPane.setText(sb.toString());
        this.editorPane.setCaretPosition(0);
    }

    private void back() {
        int len = this.history.size();
        if (len <= 1) {
            return;
        }
        Object lastPage = this.history.get(len - 2);
        this.history.remove(len - 1);
        if (lastPage instanceof Integer) {
            this.history.remove(len - 2);
            Integer lpi = (Integer)lastPage;
            this.loadPage(lpi);
            return;
        }
        if (lastPage instanceof String) {
            this.editorPane.setText((String)lastPage);
            this.editorPane.setCaretPosition(0);
        }
    }

    private void prev() {
        int index = this.currentIndex - 1;
        if (index < 0) {
            index = this.pageSequence.size() - 1;
        }
        this.loadPage(index);
    }

    private void next() {
        int index = this.currentIndex + 1;
        if (index >= this.pageSequence.size()) {
            index = 0;
        }
        this.loadPage(index);
    }

    private void search() {
        String ret = this.searchField.getText().trim();
        if (ret.length() == 0) {
            return;
        }
        Pattern pattern = Pattern.compile(ret, 2);
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("<CENTER><H1>Search Results for " + ret + "</H1></CENTER>\n");
        int numFound = 0;
        for (int index = 0; index < this.pageSequence.size(); ++index) {
            String line;
            PageInfo pi = (PageInfo)this.pageSequence.get(index);
            InputStream stream = TextUtils.getURLStream(pi.url, null);
            InputStreamReader is = new InputStreamReader(stream);
            StringBuffer sb = new StringBuffer();
            while ((line = this.getLine(is)) != null) {
                if (line.length() == 0 || line.equals("<!-- TRAILER -->") || line.startsWith("<!-- COMMAND ") || line.startsWith("<!-- NEED ")) continue;
                if (line.startsWith("<!-- HEADER ")) {
                    line = line.substring(12);
                }
                sb.append(line);
            }
            Matcher matcher = pattern.matcher(sb.toString());
            if (!matcher.find()) continue;
            sbResult.append("<B><A HREF=\"" + pi.fileName + ".html\">" + pi.fullChapterNumber + ": " + pi.title + "</A></B<BR>\n");
            ++numFound;
        }
        sbResult.append("<P><B>Found " + numFound + " entries</B>\n");
        String wholePage = sbResult.toString();
        this.history.add(wholePage);
        this.editorPane.setText(wholePage);
        this.editorPane.setCaretPosition(0);
    }

    private void manual1Page() {
        String manualFileName = OpenFile.chooseOutputFile(FileType.HTML, "Manual file", "electric.html");
        if (manualFileName == null) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(manualFileName)));
        }
        catch (IOException e) {
            System.out.println("Error creating " + manualFileName);
            return;
        }
        printWriter.println("<HTML><HEAD><TITLE>Using The Electric VLSI Design System</TITLE></HEAD>");
        printWriter.println("<BODY BGCOLOR=\"#FFFFFF\">");
        for (int index = 0; index < this.pageSequence.size(); ++index) {
            String line;
            PageInfo pi = (PageInfo)this.pageSequence.get(index);
            InputStream stream = TextUtils.getURLStream(pi.url, null);
            InputStreamReader is = new InputStreamReader(stream);
            int lastIndex = index - 1;
            if (lastIndex < 0) {
                lastIndex = this.pageSequence.size() - 1;
            }
            PageInfo lastPi = (PageInfo)this.pageSequence.get(lastIndex);
            String lastFileName = lastPi.fileName;
            int nextIndex = index + 1;
            if (nextIndex >= this.pageSequence.size()) {
                nextIndex = 0;
            }
            PageInfo nextPi = (PageInfo)this.pageSequence.get(nextIndex);
            String nextFileName = nextPi.fileName;
            while ((line = this.getLine(is)) != null) {
                if (line.length() == 0) continue;
                if (line.startsWith("<!-- HEADER ")) {
                    int endPt = line.indexOf("-->");
                    if (endPt < 0) {
                        System.out.println("No end comment on line: " + line);
                        continue;
                    }
                    String pageName = line.substring(12, endPt).trim();
                    if (pi.level < 2 || pi.newAtLevel) {
                        if (pi.chapterNumber > 0 && lastPi.chapterNumber < pi.chapterNumber) {
                            printWriter.println("<HR>");
                            printWriter.println("<CENTER><H1><A NAME=\"" + pi.fileName + "\">Chapter " + pi.chapterName + "</A></H1></CENTER>");
                        } else {
                            printWriter.println("<!-- PAGE BREAK --><A NAME=\"" + pi.fileName + "\"></A>");
                            printWriter.println("<CENTER><FONT SIZE=6><B>Chapter " + pi.chapterName + "</B></FONT></CENTER>");
                        }
                        printWriter.println("<CENTER><TABLE WIDTH=\"90%\" BORDER=0><TR>");
                        printWriter.println("<TD><CENTER><A HREF=\"" + lastFileName + ".html#" + lastFileName + ".html\"><IMG SRC=\"iconplug.png\" ALT=\"plug\" BORDER=0></A></CENTER></TD>");
                        printWriter.println("<TD><CENTER><H2>" + pageName + "</H2></CENTER></TD>");
                        printWriter.println("<TD><CENTER><A HREF=\"" + nextFileName + ".html#" + nextFileName + ".html\"><IMG SRC=\"iconplug.png\" ALT=\"plug\" BORDER=0></A></CENTER></TD></TR></TABLE></CENTER>");
                        printWriter.println("<HR>");
                        printWriter.println("<BR>");
                        continue;
                    }
                    printWriter.println("<H3>" + pageName + "</H3>");
                    continue;
                }
                if (line.equals("<!-- TRAILER -->")) continue;
                printWriter.println(line);
            }
        }
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    private void manualManyPages() {
        InputStreamReader is;
        InputStream stream;
        PageInfo pi;
        int index;
        String manualFileName = OpenFile.chooseOutputFile(FileType.HTML, "Manual file", "index.html");
        if (manualFileName == null) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(manualFileName)));
        }
        catch (IOException e) {
            System.out.println("Error creating " + manualFileName);
            return;
        }
        System.out.println("Writing 'index.html' and many files starting with 'mchap'");
        int lastChapterNumber = 0;
        StringBuffer chapterText = new StringBuffer();
        ArrayList<String> chapters = new ArrayList<String>();
        StringBuffer afterTOC = new StringBuffer();
        for (index = 0; index < this.pageSequence.size(); ++index) {
            pi = (PageInfo)this.pageSequence.get(index);
            if (pi.chapterNumber <= 0) {
                String line;
                stream = TextUtils.getURLStream(pi.url, null);
                is = new InputStreamReader(stream);
                while ((line = this.getLine(is)) != null) {
                    if (line.length() == 0 || line.startsWith("<!-- HEADER ") || line.startsWith("<!-- TRAILER ")) continue;
                    if (line.equals("<HR>")) break;
                    printWriter.println(line);
                }
                while ((line = this.getLine(is)) != null) {
                    if (line.length() == 0 || line.startsWith("<!-- HEADER ") || line.startsWith("<!-- TRAILER ")) continue;
                    afterTOC.append(line);
                }
                try {
                    is.close();
                }
                catch (IOException e) {}
                continue;
            }
            if (pi.chapterNumber != lastChapterNumber) {
                if (lastChapterNumber > 0) {
                    chapters.add(chapterText.toString());
                }
                lastChapterNumber = pi.chapterNumber;
                chapterText = new StringBuffer();
                chapterText.append("<B>Chapter " + pi.chapterName.toUpperCase() + "</B><BR>");
            }
            chapterText.append("<A HREF=\"m" + pi.fileName + ".html\">" + pi.fullChapterNumber + ": " + pi.title + "</A><BR>");
        }
        chapters.add(chapterText.toString());
        printWriter.println("<CENTER><H1>Table of Contents</H1></CENTER>");
        printWriter.println("<CENTER><TABLE BORDER=\"1\">");
        for (int i = 0; i < chapters.size(); i += 2) {
            String leftSide = (String)chapters.get(i);
            String rightSide = "";
            if (i + 1 < chapters.size()) {
                rightSide = (String)chapters.get(i + 1);
            }
            printWriter.println("<TR><TD VALIGN=TOP>" + leftSide + "</TD>");
            printWriter.println("<TD VALIGN=TOP>" + rightSide + "</TD></TR>");
        }
        printWriter.println("</TABLE></CENTER><HR>");
        printWriter.print(afterTOC.toString());
        printWriter.println("<CENTER><TABLE BORDER=\"0\"><TR>");
        printWriter.println("<TD><A HREF=\"mchap01-01.html\">Next</A></TD>");
        printWriter.println("<TD><A HREF=\"mchap01-01.html\"><IMG SRC=\"iconforearrow.png\" ALT=\"Next\" BORDER=\"0\"></A></TD>");
        printWriter.println("</TR></TABLE></CENTER>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
        for (index = 0; index < this.pageSequence.size(); ++index) {
            String line;
            pi = (PageInfo)this.pageSequence.get(index);
            if (pi.chapterNumber <= 0) continue;
            stream = TextUtils.getURLStream(pi.url, null);
            is = new InputStreamReader(stream);
            String pageFileName = manualFileName;
            int lastSep = pageFileName.lastIndexOf(92);
            if (lastSep >= 0) {
                pageFileName = pageFileName.substring(0, lastSep + 1);
            }
            pageFileName = pageFileName + "m" + pi.fileName + ".html";
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(pageFileName)));
            }
            catch (IOException e) {
                System.out.println("Error creating " + pageFileName);
                break;
            }
            int lastIndex = index - 1;
            if (lastIndex < 0) {
                lastIndex = this.pageSequence.size() - 1;
            }
            PageInfo lastPi = (PageInfo)this.pageSequence.get(lastIndex);
            String lastFileName = lastPi.fileName;
            lastFileName = lastFileName.equals("title") ? "index" : "m" + lastFileName;
            int nextIndex = index + 1;
            if (nextIndex >= this.pageSequence.size()) {
                nextIndex = 0;
            }
            PageInfo nextPi = (PageInfo)this.pageSequence.get(nextIndex);
            String nextFileName = nextPi.fileName;
            nextFileName = nextFileName.equals("title") ? "index" : "m" + nextFileName;
            while ((line = this.getLine(is)) != null) {
                if (line.length() == 0 || line.startsWith("<!-- NEED ")) continue;
                if (line.startsWith("<!-- HEADER ")) {
                    int endPt = line.indexOf("-->");
                    if (endPt < 0) {
                        System.out.println("No end comment on line: " + line);
                        continue;
                    }
                    String pageName = line.substring(12, endPt).trim();
                    printWriter.println("<A NAME=\"" + pi.fileName + "\"></A>");
                    printWriter.println("<CENTER><FONT SIZE=6><B>Chapter " + pi.chapterName + "</B></FONT></CENTER>");
                    printWriter.println("<CENTER><TABLE WIDTH=\"90%\" BORDER=0><TR>");
                    printWriter.println("<TD><CENTER><A HREF=\"" + lastFileName + ".html#" + lastFileName + ".html\"><IMG SRC=\"iconplug.png\" ALT=\"plug\" BORDER=0></A></CENTER></TD>");
                    printWriter.println("<TD><CENTER><H2>" + pageName + "</H2></CENTER></TD>");
                    printWriter.println("<TD><CENTER><A HREF=\"" + nextFileName + ".html#" + nextFileName + ".html\"><IMG SRC=\"iconplug.png\" ALT=\"plug\" BORDER=0></A></CENTER></TD></TR></TABLE></CENTER>");
                    printWriter.println("<HR>");
                    printWriter.println("<BR>");
                    continue;
                }
                if (line.equals("<!-- TRAILER -->")) {
                    printWriter.println("<P>");
                    printWriter.println("<HR>");
                    printWriter.println("<CENTER><TABLE BORDER=0><TR>");
                    printWriter.println("<TD><A HREF=\"" + lastFileName + ".html#" + lastFileName + ".html\"><IMG SRC=\"iconbackarrow.png\" ALT=\"Prev\" BORDER=0></A></TD>");
                    printWriter.println("<TD><A HREF=\"" + lastFileName + ".html#" + lastFileName + ".html\">Previous</A></TD>");
                    printWriter.println("<TD>&nbsp;&nbsp;&nbsp;</TD>");
                    printWriter.println("<TD><A HREF=\"index.html\"><IMG SRC=\"iconcontarrow.png\" ALT=\"Contents\" BORDER=0></A></TD>");
                    printWriter.println("<TD><A HREF=\"index.html\">Table of Contents</A></TD>");
                    printWriter.println("<TD>&nbsp;&nbsp;&nbsp;</TD>");
                    printWriter.println("<TD><A HREF=\"" + nextFileName + ".html#" + nextFileName + ".html\">Next</A></TD>");
                    printWriter.println("<TD><A HREF=\"" + nextFileName + ".html#" + nextFileName + ".html\"><IMG SRC=\"iconforearrow.png\" ALT=\"Next\" BORDER=0></A></TD>");
                    printWriter.println("</TR></TABLE></CENTER>");
                    continue;
                }
                printWriter.println(line);
            }
            printWriter.close();
        }
    }

    private void edit() {
        PageInfo pi = (PageInfo)this.pageSequence.get(this.currentIndex);
        EditHTML dialog = new EditHTML((Frame)TopLevel.getCurrentJFrame(), pi.url, this);
        dialog.setVisible(true);
    }

    private void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.rootNode = new DefaultMutableTreeNode("Manual");
        DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
        this.optionTree = new ManualTree(treeModel, this);
        TreeHandler handler = new TreeHandler(this);
        this.optionTree.addMouseListener(handler);
        JScrollPane scrolledTree = new JScrollPane(this.optionTree);
        JPanel leftHalf = new JPanel();
        leftHalf.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 4, 4, 4);
        leftHalf.add((Component)scrolledTree, gbc);
        JButton backButton = new JButton("Back");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 10;
        leftHalf.add((Component)backButton, gbc);
        backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualViewer.this.back();
            }
        });
        JButton menuButton = new JButton("Menu Help");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 10;
        leftHalf.add((Component)menuButton, gbc);
        menuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualViewer.this.loadMenuBar();
            }
        });
        JButton nextButton = new JButton("Next");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 10;
        leftHalf.add((Component)nextButton, gbc);
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualViewer.this.next();
            }
        });
        JButton prevButton = new JButton("Prev");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 10;
        leftHalf.add((Component)prevButton, gbc);
        prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualViewer.this.prev();
            }
        });
        JSeparator sep = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = 10;
        gbc.fill = 2;
        leftHalf.add((Component)sep, gbc);
        this.searchField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.anchor = 10;
        leftHalf.add((Component)this.searchField, gbc);
        JButton searchButton = new JButton("Find");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 10;
        leftHalf.add((Component)searchButton, gbc);
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualViewer.this.search();
            }
        });
        this.getRootPane().setDefaultButton(searchButton);
        if (Main.getDebug()) {
            JButton manualButton = new JButton("1-Page Man");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(0, 4, 4, 4);
            gbc.anchor = 10;
            leftHalf.add((Component)manualButton, gbc);
            manualButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ManualViewer.this.manual1Page();
                }
            });
            JButton manualMultiButton = new JButton("Many-Page Man");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(0, 4, 4, 4);
            gbc.anchor = 10;
            leftHalf.add((Component)manualMultiButton, gbc);
            manualMultiButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ManualViewer.this.manualManyPages();
                }
            });
            JButton editButton = new JButton("Edit Page");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            gbc.insets = new Insets(0, 4, 4, 4);
            leftHalf.add((Component)editButton, gbc);
            editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ManualViewer.this.edit();
                }
            });
        }
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.addHyperlinkListener(new Hyperactive(this));
        this.rightHalf = new JScrollPane(this.editorPane);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.rightHalf.setPreferredSize(new Dimension(screenSize.width / 2, screenSize.height * 3 / 4));
        this.rightHalf.setMinimumSize(new Dimension(screenSize.width / 4, screenSize.height / 3));
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(leftHalf);
        this.splitPane.setRightComponent(this.rightHalf);
        this.splitPane.setDividerLocation(200);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.splitPane, gbc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ManualViewer.this.closeDialog(evt);
            }
        });
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        theManual = null;
    }

    private static class TreeHandler
    implements MouseListener {
        private ManualViewer dialog;

        TreeHandler(ManualViewer dialog) {
            this.dialog = dialog;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            TreePath currentPath = this.dialog.optionTree.getPathForLocation(e.getX(), e.getY());
            if (currentPath == null) {
                return;
            }
            this.dialog.optionTree.setSelectionPath(currentPath);
            this.dialog.optionTree.expandPath(currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)currentPath.getLastPathComponent();
            Object obj = node.getUserObject();
            if (obj instanceof Integer) {
                int index = (Integer)obj;
                this.dialog.loadPage(index);
            }
        }
    }

    private static class ManualTree
    extends JTree {
        private ManualViewer dialog;

        private ManualTree(DefaultTreeModel treeModel, ManualViewer dialog) {
            super(treeModel);
            this.dialog = dialog;
            this.getSelectionModel().setSelectionMode(1);
            this.setRootVisible(true);
            this.setShowsRootHandles(true);
        }

        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
            if (nodeInfo instanceof Integer) {
                Integer index = (Integer)nodeInfo;
                PageInfo pi = (PageInfo)this.dialog.pageSequence.get(index);
                String ret = pi.title;
                if (pi.sectionNumber > 0) {
                    ret = pi.sectionNumber + ": " + ret;
                }
                return ret;
            }
            return nodeInfo.toString();
        }
    }

    private static class Hyperactive
    implements HyperlinkListener {
        private ManualViewer dialog;

        Hyperactive(ManualViewer dialog) {
            this.dialog = dialog;
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    URL desiredURL = e.getURL();
                    String desiredFile = desiredURL.getFile();
                    for (int i = 0; i < this.dialog.pageSequence.size(); ++i) {
                        PageInfo pi = (PageInfo)this.dialog.pageSequence.get(i);
                        if (!pi.url.getFile().equals(desiredFile)) continue;
                        this.dialog.loadPage(i);
                        return;
                    }
                    try {
                        pane.setPage(desiredURL);
                    }
                    catch (Throwable t) {
                        System.out.println("Cannot find URL " + e.getURL());
                    }
                }
            }
        }
    }

    private static class EditHTML
    extends EDialog {
        private JTextArea textArea;
        private URL file;
        private ManualViewer world;

        private EditHTML(Frame parent, URL file, ManualViewer world) {
            super(parent, false);
            this.file = file;
            this.world = world;
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Edit HTML");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    EditHTML.this.closeDialog(evt);
                }
            });
            this.textArea = new JTextArea();
            JScrollPane scrollPane = new JScrollPane(this.textArea);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)scrollPane, gridBagConstraints);
            try {
                URLConnection con = file.openConnection();
                int length = con.getContentLength();
                InputStream stream = con.getInputStream();
                InputStreamReader is = new InputStreamReader(stream);
                char[] buf = new char[length];
                is.read(buf, 0, length);
                stream.close();
                this.textArea.setText(new String(buf));
            }
            catch (IOException e) {
                System.out.println("Could not find file: " + file.getFile());
                return;
            }
            this.pack();
        }

        private void closeDialog(WindowEvent evt) {
            String fileName = this.file.getFile();
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                printWriter.print(this.textArea.getText());
                printWriter.close();
            }
            catch (IOException e) {
                System.out.println("Could not save file: " + fileName);
                return;
            }
            int binPos = fileName.indexOf("/bin/");
            if (binPos >= 0) {
                String otherFileName = fileName.substring(0, binPos) + "/srcj" + fileName.substring(binPos + 4);
                try {
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(otherFileName)));
                    printWriter.print(this.textArea.getText());
                    printWriter.close();
                    System.out.println("Also saved to " + otherFileName);
                }
                catch (IOException e) {
                    System.out.println("Could not also save file: " + otherFileName);
                    System.out.println("  but did save: " + fileName);
                    return;
                }
            }
            this.setVisible(false);
            this.dispose();
            this.world.loadPage(this.world.currentIndex);
        }
    }

    private static class HelpMenuActionListener
    implements ActionListener {
        private ManualViewer dialog;
        private String title;

        HelpMenuActionListener(ManualViewer dialog, String title) {
            this.dialog = dialog;
            this.title = title;
        }

        public void actionPerformed(ActionEvent e) {
            this.doHelpMenu(this.title);
        }

        private void doHelpMenu(String fileName) {
            if (fileName == null) {
                System.out.println("No help for this command");
                return;
            }
            for (int i = 0; i < this.dialog.pageSequence.size(); ++i) {
                PageInfo pi = (PageInfo)this.dialog.pageSequence.get(i);
                if (!pi.fileName.equals(fileName)) continue;
                this.dialog.loadPage(i);
                return;
            }
        }
    }

    private static class PageInfo {
        String title;
        String fileName;
        String chapterName;
        String fullChapterNumber;
        int chapterNumber;
        int sectionNumber;
        URL url;
        int level;
        boolean newAtLevel;

        private PageInfo() {
        }
    }
}

