/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Route
extends ArrayList {
    private RouteElementPort routeStart;
    private RouteElementPort routeEnd;
    private boolean routeReversed;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Route() {
        this.routeStart = null;
        this.routeEnd = null;
        this.routeReversed = false;
    }

    public Route(Collection c) {
        super(c);
        if (c instanceof Route) {
            Route r = (Route)c;
            this.routeStart = r.getStart();
            this.routeEnd = r.getEnd();
        } else {
            this.routeStart = null;
            this.routeEnd = null;
        }
    }

    public void setStart(RouteElementPort startRE) {
        if (!this.contains(startRE)) {
            this.add(startRE);
        }
        this.routeStart = startRE;
    }

    public RouteElementPort getStart() {
        return this.routeStart;
    }

    public void setEnd(RouteElementPort endRE) {
        if (!this.contains(endRE)) {
            this.add(endRE);
        }
        this.routeEnd = endRE;
    }

    public RouteElementPort getEnd() {
        return this.routeEnd;
    }

    public void reverseRoute() {
        RouteElementPort re = this.routeStart;
        this.routeStart = this.routeEnd;
        this.routeEnd = re;
        this.routeReversed = !this.routeReversed;
    }

    public boolean isRouteReversed() {
        return this.routeReversed;
    }

    public boolean replacePin(RouteElementPort pin, RouteElementPort replacement) {
        if (this.replaceBisectPin(pin, replacement)) {
            return true;
        }
        return this.replaceExistingRedundantPin(pin, replacement);
    }

    public boolean replaceBisectPin(RouteElementPort bisectPin, RouteElementPort replacement) {
        if (!bisectPin.isBisectArcPin()) {
            return false;
        }
        if (!$assertionsDisabled && !this.contains(bisectPin)) {
            throw new AssertionError();
        }
        boolean success = true;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            RouteElementArc reArc;
            RouteElement re = (RouteElement)it.next();
            if (!(re instanceof RouteElementArc) || (reArc = (RouteElementArc)re).replaceArcEnd(bisectPin, replacement)) continue;
            success = false;
        }
        return success;
    }

    public boolean replaceExistingRedundantPin(RouteElementPort pinRE, RouteElementPort replacementRE) {
        if (pinRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            return false;
        }
        PortInst pi = pinRE.getPortInst();
        NodeInst ni = pi.getNodeInst();
        if (ni.getProto().getFunction() != PrimitiveNode.Function.PIN) {
            return false;
        }
        if (pi.getExports().hasNext()) {
            return false;
        }
        ArrayList<RouteElementArc> newElements = new ArrayList<RouteElementArc>();
        Cell cell = replacementRE.getCell();
        boolean replace = true;
        Iterator it2 = pi.getConnections();
        if (!it2.hasNext() && !ni.getTrueCenter().equals(replacementRE.getLocation())) {
            return false;
        }
        Iterator it = pi.getConnections();
        while (it.hasNext()) {
            Connection conn = (Connection)it.next();
            if (replacementRE.getPortProto().connectsTo(conn.getArc().getProto())) {
                if (conn.getLocation().equals(replacementRE.getLocation())) {
                    ArcInst ai = conn.getArc();
                    int otherEnd = 1 - conn.getEndIndex();
                    RouteElementPort otherPort = RouteElementPort.existingPortInst(ai.getPortInst(otherEnd), ai.getPortInst(otherEnd).getPoly());
                    RouteElementArc newArc = RouteElementArc.newArc(cell, ai.getProto(), ai.getWidth(), otherPort, replacementRE, ai.getLocation(otherEnd), conn.getLocation(), ai.getName(), ai.getTextDescriptor(ArcInst.ARC_NAME_TD), ai);
                    RouteElementArc delArc = RouteElementArc.deleteArc(ai);
                    newElements.add(newArc);
                    newElements.add(delArc);
                    continue;
                }
                replace = false;
                break;
            }
            replace = false;
            break;
        }
        if (replace) {
            RouteElementPort delPort = RouteElementPort.deleteNode(ni);
            this.add(delPort);
            Iterator it3 = newElements.iterator();
            while (it3.hasNext()) {
                RouteElement e = (RouteElement)it3.next();
                this.add(e);
            }
        }
        return replace;
    }

    static {
        $assertionsDisabled = !Route.class.desiredAssertionStatus();
    }
}

