/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Resistor;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;

class OutlierRecord {
    private final Part[] parts;
    private final double deviation;

    private boolean hasSize(Part p) {
        return p instanceof Resistor || p instanceof Mos;
    }

    private double getWidth(Part p) {
        if (p instanceof Resistor) {
            return ((Resistor)p).getWidth();
        }
        return ((Mos)p).getWidth();
    }

    private double getLength(Part p) {
        if (p instanceof Resistor) {
            return ((Resistor)p).getLength();
        }
        return ((Mos)p).getLength();
    }

    private double[] computeAverageWidthLength(Circuit c) {
        double totLen = 0.0;
        double totWid = 0.0;
        Iterator<NetObject> it = c.getNetObjs();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            totLen += this.getLength(p);
            totWid += this.getWidth(p);
        }
        int numParts = c.numNetObjs();
        return new double[]{totWid / (double)numParts, totLen / (double)numParts};
    }

    private double computeWidthLengthDeviation(double avgWid, double avgLen, Part p) {
        double deltaW = (this.getWidth(p) - avgWid) / avgWid;
        double deltaL = (this.getLength(p) - avgLen) / avgLen;
        return Math.abs(deltaW) + Math.abs(deltaL);
    }

    private double computeWidthLengthMismatch(Part p1, Part p2) {
        double w1 = this.getWidth(p1);
        double l1 = this.getLength(p1);
        double w2 = this.getWidth(p2);
        double l2 = this.getLength(p2);
        double avgW = (w1 + w2) / 2.0;
        double avgL = (l1 + l2) / 2.0;
        return Math.abs((w1 - w2) / avgW) + Math.abs((l1 - l2) / avgL);
    }

    private Outlier findOutlier(Circuit c) {
        if (!this.hasSize((Part)c.getNetObjs().next())) {
            return new Outlier(null, 0.0);
        }
        double[] avgWidLen = this.computeAverageWidthLength(c);
        double avgWid = avgWidLen[0];
        double avgLen = avgWidLen[1];
        Part worstPart = null;
        double worstDeviation = 0.0;
        Iterator<NetObject> it = c.getNetObjs();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            double deviation = this.computeWidthLengthDeviation(avgWid, avgLen, p);
            if (!(deviation > worstDeviation)) continue;
            worstPart = p;
            worstDeviation = deviation;
        }
        return new Outlier(worstPart, worstDeviation);
    }

    private Part findClosestSizedPart(Circuit c, Part outlier) {
        Part bestPart = null;
        double bestMismatch = Double.MAX_VALUE;
        Iterator<NetObject> it = c.getNetObjs();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            double mismatch = this.computeWidthLengthMismatch(outlier, p);
            if (!(mismatch < bestMismatch)) continue;
            bestPart = p;
            bestMismatch = mismatch;
        }
        return bestPart;
    }

    public OutlierRecord(EquivRecord r) {
        this.parts = new Part[r.numCircuits()];
        Iterator<Circuit> it = r.getCircuits();
        Outlier outlier = this.findOutlier(it.next());
        this.deviation = outlier.deviation;
        this.parts[0] = outlier.part;
        if (this.deviation == 0.0) {
            return;
        }
        int cktNdx = 1;
        while (it.hasNext()) {
            Circuit c = it.next();
            this.parts[cktNdx] = this.findClosestSizedPart(c, outlier.part);
            ++cktNdx;
        }
    }

    public double deviation() {
        return this.deviation;
    }

    public EquivRecord getEquivRecord() {
        return this.parts[0].getParent().getParent();
    }

    public boolean isOutlier(Part p) {
        for (int i = 0; i < this.parts.length; ++i) {
            if (p != this.parts[i]) continue;
            return true;
        }
        return false;
    }

    private static class Outlier {
        public final Part part;
        public final double deviation;

        Outlier(Part p, double diff) {
            this.part = p;
            this.deviation = diff;
        }
    }
}

