/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;

public class RawSpiceOut
extends Simulate {
    RawSpiceOut() {
    }

    protected void readSimulationOutput(Stimuli sd, URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return;
        }
        RawSpiceOut.startProgressDialog("Raw Spice output", fileURL.getFile());
        this.readRawFile(cell, sd);
        RawSpiceOut.stopProgressDialog();
        this.closeInput();
    }

    private void readRawFile(Cell cell, Stimuli sd) throws IOException {
        String line;
        boolean first = true;
        sd.setCell(cell);
        AnalogAnalysis an = null;
        int numSignals = -1;
        int eventCount = -1;
        String[] signalNames = null;
        double[][] values = null;
        while ((line = this.getLineFromSimulator()) != null) {
            int i;
            int j;
            int tabPos;
            int i2;
            int colonPos;
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a RAWFILE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
            }
            if ((colonPos = line.indexOf(":")) < 0) continue;
            String preColon = line.substring(0, colonPos);
            String postColon = line.substring(colonPos + 1).trim();
            if (preColon.equals("Plotname")) {
                if (an != null) {
                    numSignals = -1;
                    eventCount = -1;
                    signalNames = null;
                    values = null;
                }
                if (postColon.startsWith("Transient Analysis")) {
                    an = new AnalogAnalysis(sd, AnalogAnalysis.ANALYSIS_TRANS, false);
                    continue;
                }
                if (postColon.startsWith("DC Analysis")) {
                    an = new AnalogAnalysis(sd, AnalogAnalysis.ANALYSIS_DC, false);
                    continue;
                }
                if (postColon.startsWith("AC Analysis")) {
                    an = new AnalogAnalysis(sd, AnalogAnalysis.ANALYSIS_AC, false);
                    continue;
                }
                System.out.println("ERROR: Unknown analysis: " + postColon);
                return;
            }
            if (preColon.equals("No. Variables")) {
                numSignals = TextUtils.atoi(postColon) - 1;
                continue;
            }
            if (preColon.equals("No. Points")) {
                eventCount = TextUtils.atoi(postColon);
                an.buildCommonTime(eventCount);
                continue;
            }
            if (preColon.equals("Variables")) {
                if (numSignals < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                signalNames = new String[numSignals];
                values = new double[numSignals][eventCount];
                for (i2 = 0; i2 <= numSignals; ++i2) {
                    int pos;
                    String name;
                    int spacePos;
                    if (postColon.length() > 0) {
                        line = postColon;
                        postColon = "";
                    } else {
                        line = this.getLineFromSimulator();
                        if (line == null) {
                            System.out.println("Error: end of file during signal names");
                            return;
                        }
                    }
                    line = line.trim();
                    int numberOnLine = TextUtils.atoi(line);
                    if (numberOnLine != i2) {
                        System.out.println("Warning: Variable " + i2 + " has number " + numberOnLine);
                    }
                    if ((spacePos = line.indexOf(" ")) < 0) {
                        spacePos = line.length();
                    }
                    if ((tabPos = line.indexOf("\t")) < 0) {
                        tabPos = line.length();
                    }
                    if ((spacePos = (name = line.substring(pos = Math.min(spacePos, tabPos)).trim()).indexOf(" ")) < 0) {
                        spacePos = name.length();
                    }
                    if ((tabPos = name.indexOf("\t")) < 0) {
                        tabPos = name.length();
                    }
                    pos = Math.min(spacePos, tabPos);
                    name = name.substring(0, pos);
                    if (i2 == 0) {
                        if (name.equals("time") || an.getAnalysisType() != AnalogAnalysis.ANALYSIS_TRANS) continue;
                        System.out.println("Warning: the first variable should be time, is '" + name + "'");
                        continue;
                    }
                    signalNames[i2 - 1] = name;
                }
                continue;
            }
            if (preColon.equals("Values")) {
                if (numSignals < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                if (eventCount < 0) {
                    System.out.println("Missing point count in file");
                    return;
                }
                for (j = 0; j < eventCount; ++j) {
                    i = -1;
                    block3: while (i <= numSignals) {
                        line = this.getLineFromSimulator();
                        if (line == null) {
                            System.out.println("Error: end of file during data points (read " + j + " out of " + eventCount);
                            return;
                        }
                        if ((line = line.trim()).length() == 0) continue;
                        int charPos = 0;
                        while (charPos <= line.length()) {
                            tabPos = line.indexOf("\t", charPos);
                            if (tabPos < 0) {
                                tabPos = line.length();
                            }
                            String field = line.substring(charPos, tabPos);
                            for (charPos = tabPos + 1; charPos < line.length() && line.charAt(charPos) == '\t'; ++charPos) {
                            }
                            if (i < 0) {
                                int lineNumber = TextUtils.atoi(field);
                                if (lineNumber != j) {
                                    System.out.println("Warning: event " + j + " has wrong event number: " + lineNumber);
                                }
                            } else {
                                double val = TextUtils.atof(field);
                                if (i == 0) {
                                    an.setCommonTime(j, val);
                                } else {
                                    values[i - 1][j] = val;
                                }
                            }
                            if (++i <= numSignals) continue;
                            continue block3;
                        }
                    }
                }
                for (i2 = 0; i2 < numSignals; ++i2) {
                    an.addSignal(signalNames[i2], null, values[i2]);
                }
                continue;
            }
            if (!preColon.equals("Binary")) continue;
            if (numSignals < 0) {
                System.out.println("Missing variable count in file");
                return;
            }
            if (eventCount < 0) {
                System.out.println("Missing point count in file");
                return;
            }
            for (j = 0; j < eventCount; ++j) {
                an.setCommonTime(j, this.dataInputStream.readDouble());
                for (i = 0; i < numSignals; ++i) {
                    values[i][j] = this.dataInputStream.readDouble();
                }
            }
        }
    }
}

