/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BusParameters
extends EDialog {
    public static final Variable.Key BUS_VARIABLES = Variable.newKey("LIB_Bus_Variables");
    public static final Variable.Key NODE_BUS_TEMPLATE = Variable.newKey("NODE_Bus_Template");
    public static final Variable.Key ARC_BUS_TEMPLATE = Variable.newKey("ARC_Bus_Template");
    public static final Variable.Key EXPORT_BUS_TEMPLATE = Variable.newKey("EXPORT_Bus_Template");
    private JList parametersList;
    private DefaultListModel parametersModel;
    Map<Library, String[]> libParameters;
    private JButton deleteVariable;
    private JButton done;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JComboBox libraryPopup;
    private JButton newVariable;
    private JButton update;
    private JTextField value;
    private JScrollPane variablesPane;

    public static void showBusParametersDialog() {
        BusParameters dialog = new BusParameters(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    public static void makeBusParameter() {
        EditWindow wnd = EditWindow.getCurrent();
        Highlight h = wnd.getHighlighter().getOneHighlight();
        if (h == null) {
            Job.getUserInterface().showErrorMessage("Select a node, arc, or export name first", "Nothing Selected");
            return;
        }
        ElectricObject owner = h.getElectricObject();
        if (owner == null || !(owner instanceof NodeInst) && !(owner instanceof ArcInst) && !(owner instanceof Export)) {
            Job.getUserInterface().showErrorMessage("Select a node, arc, or export name first", "Incorrect Selection");
            return;
        }
        if (owner instanceof ArcInst && h.getVarKey() != ArcInst.ARC_NAME) {
            Job.getUserInterface().showErrorMessage("Must select the arc's name", "Incorrect Selection");
            return;
        }
        if (owner instanceof NodeInst && h.getVarKey() != NodeInst.NODE_NAME) {
            Job.getUserInterface().showErrorMessage("Must select the node's name", "Incorrect Selection");
            return;
        }
        new AddTemplate(owner);
    }

    public static void updateBusParametersInt() {
        BusParameters foo = new BusParameters(null);
        foo.setVisible(false);
        new UpdateAllParameters(foo.libParameters, true);
    }

    public static void updateCellBusParameterInt(Cell cell, Library lib, EditingPreferences ep) {
        HashMap<Library, String[]> libParam = new HashMap<Library, String[]>();
        BusParameters.initializeLibParameters(libParam, null);
        BusParameters.updateCellParameters(cell, lib, libParam, ep);
    }

    public static String replaceBusParameterInt(String varString) {
        HashMap<Library, String[]> libParam = new HashMap<Library, String[]>();
        BusParameters.initializeLibParameters(libParam, null);
        return BusParameters.replaceVariableInString(varString, null, libParam);
    }

    public static void addTemplateWithString(ElectricObject owner, String suffix) {
        new AddTemplate(owner, true, suffix);
    }

    private static Library initializeLibParameters(Map<Library, String[]> libParam, JComboBox libPopup) {
        Library bestLib = null;
        int mostParameters = 0;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden()) continue;
            if (libPopup != null) {
                libPopup.addItem(lib.getName());
            }
            Variable var = lib.getVar(BUS_VARIABLES);
            String[] parameterList = new String[]{};
            if (var != null) {
                parameterList = (String[])var.getObject();
            }
            libParam.put(lib, parameterList);
            if (parameterList.length <= mostParameters) continue;
            bestLib = lib;
            mostParameters = parameterList.length;
        }
        Library curLib = Library.getCurrent();
        String[] parameterList = libParam.get(curLib);
        if (parameterList != null && parameterList.length > 0 || bestLib == null) {
            bestLib = curLib;
        }
        return bestLib;
    }

    private BusParameters(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.parametersModel = new DefaultListModel();
        this.parametersList = new JList(this.parametersModel);
        this.parametersList.setSelectionMode(0);
        this.variablesPane.setViewportView(this.parametersList);
        this.value.getDocument().addDocumentListener(new BusParametersDocumentListener(this));
        this.libParameters = new HashMap<Library, String[]>();
        Library bestLib = BusParameters.initializeLibParameters(this.libParameters, this.libraryPopup);
        this.parametersList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BusParameters.this.variablesSelected();
            }
        });
        this.libraryPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BusParameters.this.libraryChanged();
            }
        });
        this.libraryPopup.setSelectedItem(bestLib.getName());
        this.pack();
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void libraryChanged() {
        this.parametersModel.clear();
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        String[] parameterList = this.libParameters.get(lib);
        boolean gotSome = false;
        for (int i = 0; i < parameterList.length; ++i) {
            String variable = parameterList[i];
            int equalPos = variable.indexOf(61);
            if (equalPos < 0) continue;
            this.parametersModel.addElement(variable.substring(0, equalPos));
            gotSome = true;
        }
        if (gotSome) {
            this.parametersList.setSelectedIndex(0);
            this.variablesSelected();
        }
    }

    private void variablesSelected() {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        String[] parameterList = this.libParameters.get(lib);
        int selectedIndex = this.parametersList.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= parameterList.length) {
            return;
        }
        String varSelected = parameterList[selectedIndex];
        int equalPos = varSelected.indexOf(61);
        if (equalPos < 0) {
            return;
        }
        this.value.setText(varSelected.substring(equalPos + 1));
    }

    private void valueChanged() {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        String[] parameterList = this.libParameters.get(lib);
        int selectedIndex = this.parametersList.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= parameterList.length) {
            return;
        }
        String parSelected = parameterList[selectedIndex];
        int equalPos = parSelected.indexOf(61);
        if (equalPos < 0) {
            return;
        }
        parameterList[selectedIndex] = parSelected.substring(0, equalPos + 1) + this.value.getText();
        new UpdateLibrary(lib, parameterList);
    }

    private static void updateCellParameters(Cell cell, Library lib, Map<Library, String[]> libParameters, EditingPreferences ep) {
        String arcName;
        String newVarString;
        Variable var;
        Iterator<NodeInst> nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            var = ni.getVar(NODE_BUS_TEMPLATE);
            if (var == null) continue;
            newVarString = BusParameters.updateVariable(var, lib, libParameters);
            arcName = ni.getName();
            if (arcName.equalsIgnoreCase(newVarString)) continue;
            ni.setName(newVarString);
        }
        Iterator<ArcInst> aIt = cell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            var = ai.getVar(ARC_BUS_TEMPLATE);
            if (var == null) continue;
            newVarString = BusParameters.updateVariable(var, lib, libParameters);
            arcName = ai.getName();
            if (arcName.equalsIgnoreCase(newVarString)) continue;
            ai.setName(newVarString, ep);
        }
        Iterator<Export> eIt = cell.getExports();
        while (eIt.hasNext()) {
            Export e = eIt.next();
            var = e.getVar(EXPORT_BUS_TEMPLATE);
            if (var == null) continue;
            newVarString = BusParameters.updateVariable(var, lib, libParameters);
            String exportName = e.getName();
            if (exportName.equalsIgnoreCase(newVarString)) continue;
            e.rename(newVarString);
        }
    }

    private static String replaceVariableInString(String var, Library lib, Map<Library, String[]> libParameters) {
        int dollarPos;
        String varString = var;
        while ((dollarPos = varString.indexOf("$(")) >= 0) {
            int closePos = varString.indexOf(41, dollarPos);
            if (closePos < 0) {
                System.out.println("ERROR: Bus parameter '" + varString + "' is missing the close parenthesis");
                break;
            }
            String varName = varString.substring(dollarPos + 2, closePos);
            String[] paramList = libParameters.get(lib);
            String paramValue = null;
            if (paramList != null) {
                paramValue = BusParameters.findParameterValue(paramList, varName);
            }
            if (paramValue == null) {
                Library aLib;
                Iterator<Library> it = Library.getLibraries();
                while (it.hasNext() && ((aLib = it.next()) == lib || aLib.isHidden() || (paramValue = BusParameters.findParameterValue(paramList = libParameters.get(aLib), varName)) == null)) {
                }
                if (paramValue == null) {
                    System.out.println("ERROR: Bus parameter '" + varName + "' is not defined");
                    break;
                }
            }
            varString = varString.substring(0, dollarPos) + paramValue + varString.substring(closePos + 1);
        }
        return varString;
    }

    private static String updateVariable(Variable var, Library lib, Map<Library, String[]> libParameters) {
        String varString = (String)var.getObject();
        varString = BusParameters.replaceVariableInString(varString, lib, libParameters);
        for (int i = 0; i < varString.length(); ++i) {
            int start;
            char op = varString.charAt(i);
            if (op != '+' && op != '-' && op != '*' && op != '/') continue;
            for (start = i; start > 0 && TextUtils.isDigit(varString.charAt(start - 1)); --start) {
            }
            int end = i;
            while (end + 1 < varString.length() && TextUtils.isDigit(varString.charAt(end + 1))) {
                ++end;
            }
            if (start >= i || end <= i) continue;
            int startVal = TextUtils.atoi(varString.substring(start));
            int endVal = TextUtils.atoi(varString.substring(i + 1));
            int res = 0;
            if (op == '+') {
                res = startVal + endVal;
            } else if (op == '-') {
                res = startVal - endVal;
            } else if (op == '*') {
                res = startVal * endVal;
            } else if (op == '/' && endVal != 0) {
                res = startVal / endVal;
            }
            String newString = Integer.toString(res);
            varString = varString.substring(0, start) + newString + varString.substring(end + 1);
            i = start + newString.length() - 1;
        }
        return varString;
    }

    private static String findParameterValue(String[] parameterList, String varName) {
        for (int i = 0; i < parameterList.length; ++i) {
            String param2 = parameterList[i];
            int equalPos = param2.indexOf(61);
            if (equalPos < 0 || !varName.equalsIgnoreCase(param2.substring(0, equalPos))) continue;
            return param2.substring(equalPos + 1);
        }
        return null;
    }

    private void initComponents() {
        this.done = new JButton();
        this.jLabel1 = new JLabel();
        this.libraryPopup = new JComboBox();
        this.variablesPane = new JScrollPane();
        this.jLabel2 = new JLabel();
        this.value = new JTextField();
        this.update = new JButton();
        this.deleteVariable = new JButton();
        this.newVariable = new JButton();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Bus Parameters");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BusParameters.this.closeDialog(evt);
            }
        });
        this.getAccessibleContext().setAccessibleName("Bus Parameters");
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BusParameters.this.doneActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.jLabel1.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.libraryPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.variablesPane, gridBagConstraints);
        this.jLabel2.setText("Parameters:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.value.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.value, gridBagConstraints);
        this.update.setText("Update All Templates");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BusParameters.this.updateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.update, gridBagConstraints);
        this.deleteVariable.setText("Delete Parameter");
        this.deleteVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BusParameters.this.deleteVariableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.deleteVariable, gridBagConstraints);
        this.newVariable.setText("New Parameter");
        this.newVariable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BusParameters.this.newVariableActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.newVariable, gridBagConstraints);
        this.jLabel3.setText("Parameter Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.pack();
    }

    private void newVariableActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        String[] parameterList = this.libParameters.get(lib);
        String newParName = Job.getUserInterface().askForInput("New Bus Parameter Name:", "Create New Bus Parameter", "");
        if (newParName == null) {
            return;
        }
        int insertAfter = -1;
        for (int i = 0; i < parameterList.length; ++i) {
            int equalPos = parameterList[i].indexOf(61);
            if (equalPos < 0) continue;
            String varName = parameterList[i].substring(0, equalPos);
            if (varName.equalsIgnoreCase(newParName)) {
                Job.getUserInterface().showErrorMessage("That bus parameter name already exists", "Duplicate Name");
                return;
            }
            if (varName.compareToIgnoreCase(newParName) >= 0) continue;
            insertAfter = i;
        }
        String[] newParameterList = new String[parameterList.length + 1];
        int j = 0;
        for (int i = 0; i < parameterList.length; ++i) {
            if (i == insertAfter + 1) {
                newParameterList[j++] = newParName + "=1";
            }
            newParameterList[j++] = parameterList[i];
        }
        if (parameterList.length == insertAfter + 1) {
            newParameterList[j++] = newParName + "=1";
        }
        this.libParameters.put(lib, newParameterList);
        new UpdateLibrary(lib, newParameterList);
        this.libraryChanged();
    }

    private void deleteVariableActionPerformed(ActionEvent evt) {
        String libName = (String)this.libraryPopup.getSelectedItem();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return;
        }
        String[] parameterList = this.libParameters.get(lib);
        int selectedIndex = this.parametersList.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= parameterList.length) {
            return;
        }
        String[] newParameterList = new String[parameterList.length - 1];
        int j = 0;
        for (int i = 0; i < parameterList.length; ++i) {
            if (i == selectedIndex) continue;
            newParameterList[j++] = parameterList[i];
        }
        this.libParameters.put(lib, newParameterList);
        new UpdateLibrary(lib, newParameterList);
        this.libraryChanged();
    }

    private void updateActionPerformed(ActionEvent evt) {
        new UpdateAllParameters(this.libParameters);
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class AddTemplate
    extends Job {
        private ElectricObject owner;
        private String templateString;

        private AddTemplate(ElectricObject owner) {
            super("Create Bus Parameter", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.owner = owner;
            this.templateString = "";
            this.startJob();
        }

        private AddTemplate(ElectricObject owner, boolean doItNow, String initValue) {
            super("Create Bus Parameter", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.owner = owner;
            this.templateString = initValue;
            if (doItNow) {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.owner instanceof NodeInst) {
                NodeInst ni = (NodeInst)this.owner;
                TextDescriptor td = ni.getTextDescriptor(NodeInst.NODE_NAME);
                double relSize = 1.0;
                if (!td.getSize().isAbsolute()) {
                    relSize = td.getSize().getSize();
                }
                td = td.withOff(td.getXOff(), td.getYOff() - relSize * 1.5).withRelSize(relSize / 2.0).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                if (!this.templateString.equals("")) {
                    ni.newVar(NODE_BUS_TEMPLATE, (Object)(ni.getName() + this.templateString), td);
                } else {
                    ni.newVar(NODE_BUS_TEMPLATE, (Object)ni.getName(), td);
                }
            } else if (this.owner instanceof ArcInst) {
                ArcInst ai = (ArcInst)this.owner;
                TextDescriptor td = ai.getTextDescriptor(ArcInst.ARC_NAME);
                double relSize = 1.0;
                if (!td.getSize().isAbsolute()) {
                    relSize = td.getSize().getSize();
                }
                td = td.withOff(td.getXOff(), td.getYOff() - relSize * 1.5).withRelSize(relSize / 2.0).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                if (!this.templateString.equals("")) {
                    ai.newVar(ARC_BUS_TEMPLATE, (Object)(ai.getName() + this.templateString), td);
                } else {
                    ai.newVar(ARC_BUS_TEMPLATE, (Object)ai.getName(), td);
                }
            } else {
                Export e = (Export)this.owner;
                TextDescriptor td = e.getTextDescriptor(Export.EXPORT_NAME);
                double relSize = 1.0;
                if (!td.getSize().isAbsolute()) {
                    relSize = td.getSize().getSize();
                }
                td = td.withOff(td.getXOff(), td.getYOff() - relSize * 1.5).withRelSize(relSize / 2.0).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                if (!this.templateString.equals("")) {
                    e.newVar(EXPORT_BUS_TEMPLATE, (Object)(e.getName() + this.templateString), td);
                } else {
                    e.newVar(EXPORT_BUS_TEMPLATE, (Object)e.getName(), td);
                }
            }
            return true;
        }
    }

    private static class UpdateAllParameters
    extends Job {
        private Map<Library, String[]> libParameters;

        private UpdateAllParameters(Map<Library, String[]> libParameters) {
            super("Update All Bus Parameters", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.libParameters = libParameters;
            this.startJob();
        }

        private UpdateAllParameters(Map<Library, String[]> libParameters, boolean doItNow) {
            super("Update All Bus Parameters", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.libParameters = libParameters;
            if (doItNow) {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                if (lib.isHidden()) continue;
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    BusParameters.updateCellParameters(cell, lib, this.libParameters, this.getEditingPreferences());
                }
            }
            return true;
        }
    }

    private static class UpdateLibrary
    extends Job {
        private Library lib;
        private String[] parameterList;

        private UpdateLibrary(Library lib, String[] parameterList) {
            super("Update Bus Parameters", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.parameterList = parameterList;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.lib.newVar(BUS_VARIABLES, (Object)this.parameterList, this.getEditingPreferences());
            return true;
        }
    }

    private static class BusParametersDocumentListener
    implements DocumentListener {
        BusParameters dialog;

        BusParametersDocumentListener(BusParameters dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.valueChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.valueChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.valueChanged();
        }
    }
}

