/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.CurrentReadable;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.PowerChannel;

public class IndirectSet {
    public static final int MAX_VOLTS_STEPS = 100;
    public static final float MAX_CURRENT_OVERSHOOT = 5.0f;
    public static final float EXCESS_RESOLUTION = 0.01f;
    public float volts;
    public float amps;
    public boolean achievedCurrent = false;
    private float setAmps;
    private float ampsLow = -3.4028235E38f;
    private float voltsLow = 0.0f;
    private float ampsHigh = Float.MAX_VALUE;
    private float voltsHigh;
    private float ampsHot = 0.0f;
    private float voltsHot = 0.0f;
    private float ampsWarm = -3.4028235E38f;
    private float voltsWarm = 0.0f;
    private float voltsPerAmp;
    private float oldVoltsPerAmp = 0.0f;
    private float voltsResolution;
    private float oldVolts;

    public IndirectSet(CurrentReadable dial, float setAmps, float ampsError, PowerChannel knob, float initVolts, float maxVolts) {
        this.setAmps = setAmps;
        this.volts = initVolts;
        this.voltsHigh = maxVolts;
        float maxVoltsStep = Math.abs(0.2f * initVolts);
        float ampsMax = 5.0f * setAmps;
        float ampsResolution = 0.01f * ampsError;
        this.voltsResolution = knob.getVoltageResolution();
        for (int ind = 0; ind < 100; ++ind) {
            this.volts = (float)Math.round(this.volts / this.voltsResolution) * this.voltsResolution;
            knob.setVoltageWait(this.volts);
            this.amps = dial.readCurrent(ampsMax, ampsResolution);
            System.out.println(ind + ": " + this.volts + " V, " + this.amps + " A");
            float ampsDiff = Math.abs(this.amps - setAmps);
            if (ampsDiff <= ampsError) {
                this.achievedCurrent = true;
                return;
            }
            if (this.updateBounds(knob)) {
                this.achievedCurrent = true;
                return;
            }
            this.updateClosePairs(setAmps, ampsDiff);
            if (!this.updateVoltsPerAmp(ind)) {
                return;
            }
            this.computeNextVolts(maxVoltsStep);
            if (this.volts < this.voltsLow || this.volts > this.voltsHigh) {
                System.err.println("Warning: volts=" + this.volts + " outside bounds " + this.voltsLow + ".." + this.voltsHigh);
                this.volts = 0.5f * (this.voltsLow + this.voltsHigh);
            }
            System.out.println(ind + ": " + this.getState() + "\n");
            if (!(this.volts <= 0.0f) && !(this.volts > maxVolts)) continue;
            Infrastructure.nonfatal("Voltage not converging, reached " + this.volts + "V");
            return;
        }
        Infrastructure.nonfatal("Voltage did not converge in 100 steps");
    }

    public String getState() {
        String state = this.volts + " V, " + this.amps + " A; old=" + this.oldVolts + " V";
        state = state + "\n  low: " + this.voltsLow + " V, " + this.ampsLow + " A;";
        state = state + " high: " + this.voltsHigh + "V, " + this.ampsHigh + " A;";
        state = state + "\n  hot: " + this.voltsHot + "V, " + this.ampsHot + " A;";
        state = state + " warm: " + this.voltsWarm + "V, " + this.ampsWarm + " A;";
        state = state + "\n  voltsPerAmp: " + this.voltsPerAmp;
        state = state + "V, oldVoltsPerAmp: " + this.oldVoltsPerAmp;
        return state;
    }

    private void computeNextVolts(float maxVoltsStep) {
        float voltsStep = (this.setAmps - this.amps) * this.voltsPerAmp;
        if (Math.abs(voltsStep) > maxVoltsStep) {
            voltsStep = voltsStep >= 0.0f ? maxVoltsStep : -maxVoltsStep;
        }
        this.oldVolts = this.volts;
        this.volts += voltsStep;
        this.volts = (float)Math.round(this.volts / this.voltsResolution) * this.voltsResolution;
        if (this.volts == this.oldVolts) {
            this.volts = voltsStep > 0.0f ? (this.volts += this.voltsResolution) : (this.volts -= this.voltsResolution);
        }
    }

    private boolean updateVoltsPerAmp(int ind) {
        boolean status = true;
        this.voltsPerAmp = (this.voltsHot - this.voltsWarm) / (this.ampsHot - this.ampsWarm);
        if (ind > 1 && this.voltsPerAmp > 0.0f && this.oldVoltsPerAmp < 0.0f || this.voltsPerAmp < 0.0f && this.oldVoltsPerAmp > 0.0f) {
            Infrastructure.nonfatal("voltsPerAmp (dV/dI) =" + this.voltsPerAmp + ", was " + this.oldVoltsPerAmp);
            status = false;
        }
        this.oldVoltsPerAmp = this.voltsPerAmp;
        return status;
    }

    private void updateClosePairs(float setAmps, float ampsDiff) {
        if (ampsDiff < Math.abs(this.ampsHot - setAmps) || this.ampsHot == 0.0f && this.voltsHot == 0.0f) {
            this.ampsWarm = this.ampsHot;
            this.voltsWarm = this.voltsHot;
            this.ampsHot = this.amps;
            this.voltsHot = this.volts;
        } else if (ampsDiff < Math.abs(this.ampsWarm - setAmps)) {
            this.ampsWarm = this.amps;
            this.voltsWarm = this.volts;
        }
    }

    private boolean updateBounds(PowerChannel knob) {
        if (this.amps <= this.setAmps && this.amps > this.ampsLow) {
            this.ampsLow = this.amps;
            this.voltsLow = this.volts;
        }
        if (this.amps > this.setAmps && this.amps < this.ampsHigh) {
            this.ampsHigh = this.amps;
            this.voltsHigh = this.volts;
        }
        if (Math.abs(this.voltsHigh - this.voltsLow) <= 1.001f * this.voltsResolution) {
            if (Math.abs(this.ampsLow - this.setAmps) < Math.abs(this.ampsHigh - this.setAmps)) {
                this.volts = this.voltsLow;
                this.amps = this.ampsLow;
            } else {
                this.volts = this.voltsHigh;
                this.amps = this.ampsHigh;
            }
            knob.setVoltageWait(this.volts);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

