/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected1.metric;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected1.metric.AbstractMetric;
import java.awt.geom.Point2D;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public class MSTMetric
extends AbstractMetric {
    @Override
    public String getMetricName() {
        return "MST Metric";
    }

    @Override
    public double compute() {
        return this.compute(this.getPositionsOfPorts(this.allNetworks));
    }

    private List<Point2D.Double[]> getPositionsOfPorts(List<PlacementFrame.PlacementNetwork> placementNets) {
        LinkedList<Point2D.Double[]> posOfPorts = new LinkedList<Point2D.Double[]>();
        int numberOfPorts = 0;
        for (int i = 0; i < placementNets.size(); ++i) {
            PlacementFrame.PlacementNetwork net = placementNets.get(i);
            if (net == null) continue;
            numberOfPorts = net.getPortsOnNet().size();
            Point2D.Double[] allPositionsOfNet = new Point2D.Double[numberOfPorts];
            for (int j = 0; j < numberOfPorts; ++j) {
                Point2D.Double absPosOf;
                allPositionsOfNet[j] = absPosOf = this.getAbsolutePositionOf(net.getPortsOnNet().get(j));
            }
            posOfPorts.add(allPositionsOfNet);
        }
        return posOfPorts;
    }

    private Point2D.Double getAbsolutePositionOf(PlacementFrame.PlacementPort placementPort) {
        return new Point2D.Double(placementPort.getRotatedOffX() + placementPort.getPlacementNode().getPlacementX(), placementPort.getRotatedOffY() + placementPort.getPlacementNode().getPlacementY());
    }

    public double compute(List<Point2D.Double[]> positionsOfNetworks) {
        double result = 0.0;
        for (int i = 0; i < positionsOfNetworks.size(); ++i) {
            result += this.compute(positionsOfNetworks.get(i));
        }
        return result;
    }

    public double compute(Point2D.Double[] positionsOfPorts) {
        double result = 0.0;
        LinkComparator linkComp = new LinkComparator(positionsOfPorts);
        PriorityQueue<Link> allLinks = new PriorityQueue<Link>(positionsOfPorts.length, linkComp);
        for (int i = 0; i < positionsOfPorts.length; ++i) {
            for (int j = i + 1; j < positionsOfPorts.length; ++j) {
                allLinks.add(new Link(i, j, positionsOfPorts));
            }
        }
        UnionFind uF = new UnionFind(positionsOfPorts.length);
        int numberOfPlacedLinks = 0;
        while (numberOfPlacedLinks < positionsOfPorts.length - 1) {
            Link currentLink = allLinks.poll();
            int srcSet = uF.find(currentLink.src);
            int destSet = uF.find(currentLink.dest);
            if (srcSet == 0 && destSet == 0) {
                uF.union(uF.makeSet(currentLink.src), uF.makeSet(currentLink.dest));
                result += linkComp.getDistance(currentLink);
                ++numberOfPlacedLinks;
                continue;
            }
            if (srcSet == 0 && destSet != 0) {
                uF.union(destSet, uF.makeSet(currentLink.src));
                result += linkComp.getDistance(currentLink);
                ++numberOfPlacedLinks;
                continue;
            }
            if (srcSet != 0 && destSet == 0) {
                uF.union(srcSet, uF.makeSet(currentLink.dest));
                result += linkComp.getDistance(currentLink);
                ++numberOfPlacedLinks;
                continue;
            }
            if (srcSet == destSet) continue;
            uF.union(srcSet, destSet);
            result += linkComp.getDistance(currentLink);
            ++numberOfPlacedLinks;
        }
        return result;
    }

    private class LinkComparator
    implements Comparator<Link> {
        Point2D.Double[] list;

        LinkComparator(Point2D.Double[] list) {
            this.list = list;
        }

        @Override
        public int compare(Link arg0, Link arg1) {
            int result = Double.compare(this.getDistance(arg0), this.getDistance(arg1));
            return result;
        }

        public double getDistance(Link arg0) {
            double deltaX = Math.abs(this.list[arg0.src].getX() - this.list[arg0.dest].getX());
            double deltaY = Math.abs(this.list[arg0.src].getY() - this.list[arg0.dest].getY());
            return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        }
    }

    private class Link {
        int src;
        int dest;

        Link(int src, int dest, Point2D.Double[] list) {
            this.src = src;
            this.dest = dest;
        }
    }

    private class UnionFind {
        int[] nodes;

        UnionFind(int length) {
            this.nodes = new int[length];
        }

        int find(int src) {
            if (this.nodes[src] < 0) {
                return src;
            }
            if (this.nodes[src] == 0) {
                return 0;
            }
            int temp = this.nodes[src];
            while (this.nodes[temp] > 0) {
                temp = this.nodes[temp];
            }
            return temp;
        }

        int union(int set1, int set2) {
            if (this.nodes[set1] < this.nodes[set2]) {
                int n = set1;
                this.nodes[n] = this.nodes[n] + this.nodes[set2];
                this.nodes[set2] = set1;
                return set1;
            }
            int n = set2;
            this.nodes[n] = this.nodes[n] + this.nodes[set1];
            this.nodes[set1] = set2;
            return set2;
        }

        int makeSet(int node1) {
            this.nodes[node1] = -1;
            return node1;
        }
    }
}

