/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.text.Path;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class require
extends Syntax {
    public static final require require = new require();
    static Hashtable featureMap;
    private static final String SLIB_PREFIX = "gnu.kawa.slib.";

    static void map(String featureName, String className) {
        featureMap.put(featureName, className);
    }

    public static String mapFeature(String featureName) {
        return (String)featureMap.get(featureName);
    }

    public static Object find(String typeName) {
        return ModuleManager.getInstance().findWithClassName(typeName).getInstance();
    }

    @Override
    public boolean scanForDefinitions(Pair st, Vector forms, ScopeExp defs, Translator tr) {
        ModuleInfo minfo;
        Pair p;
        if (tr.getState() == 1) {
            tr.setState(2);
            tr.pendingForm = st;
            return true;
        }
        Pair args = (Pair)st.getCdr();
        Object name = args.getCar();
        Type type = null;
        if (name instanceof Pair && tr.matches((p = (Pair)name).getCar(), "quote")) {
            name = p.getCdr();
            if (!(name instanceof Pair) || (p = (Pair)name).getCdr() != LList.Empty || !(p.getCar() instanceof Symbol)) {
                tr.error('e', "invalid quoted symbol for 'require'");
                return false;
            }
            name = kawa.standard.require.mapFeature(p.getCar().toString());
            if (name == null) {
                tr.error('e', "unknown feature name '" + p.getCar() + "' for 'require'");
                return false;
            }
            type = ClassType.make((String)name);
        } else {
            if (name instanceof CharSequence) {
                String sourceName = name.toString();
                ModuleInfo info = kawa.standard.require.lookupModuleFromSourcePath(sourceName, defs);
                if (info == null) {
                    tr.error('e', "malformed URL: " + sourceName);
                    return false;
                }
                return kawa.standard.require.importDefinitions(null, info, null, forms, defs, tr);
            }
            if (name instanceof Symbol && !tr.selfEvaluatingSymbol(name) && (type = tr.getLanguage().getTypeFor(tr.rewrite(name, false))) instanceof ClassType && args.getCdr() instanceof Pair && (name = ((Pair)args.getCdr()).getCar()) instanceof CharSequence) {
                String sourceName = name.toString();
                ModuleInfo info = kawa.standard.require.lookupModuleFromSourcePath(sourceName, defs);
                if (info == null) {
                    tr.error('e', "malformed URL: " + sourceName);
                    return false;
                }
                return kawa.standard.require.importDefinitions(type.getName(), info, null, forms, defs, tr);
            }
        }
        if (!(type instanceof ClassType)) {
            tr.error('e', "invalid specifier for 'require'");
            return false;
        }
        try {
            minfo = ModuleInfo.find((ClassType)type);
        }
        catch (Exception ex) {
            tr.error('e', "unknown class " + type.getName());
            return false;
        }
        kawa.standard.require.importDefinitions(null, minfo, null, forms, defs, tr);
        return true;
    }

    public static ModuleInfo lookupModuleFromSourcePath(String sourceName, ScopeExp defs) {
        ModuleManager manager = ModuleManager.getInstance();
        String baseName = defs.getFileName();
        if (baseName != null) {
            sourceName = Path.valueOf(baseName).resolve(sourceName).toString();
        }
        return manager.findWithSourcePath(sourceName);
    }

    public static boolean importDefinitions(String className, ModuleInfo info, Procedure renamer, Vector forms, ScopeExp defs, Compilation tr) {
        long now;
        ModuleManager manager = ModuleManager.getInstance();
        if ((info.getState() & 1) == 0 && info.getCompilation() == null && !info.checkCurrent(manager, now = System.currentTimeMillis())) {
            Compilation comp;
            SourceMessages messages = tr.getMessages();
            Language language = Language.getDefaultLanguage();
            try {
                InPort fstream = InPort.openFile(info.getSourceAbsPath());
                info.clearClass();
                info.setClassName(className);
                int options = 8;
                if (tr.immediate) {
                    options |= 1;
                }
                comp = language.parse(fstream, messages, options, info);
            }
            catch (FileNotFoundException ex) {
                tr.error('e', "not found: " + ex.getMessage());
                return false;
            }
            catch (IOException ex) {
                tr.error('e', "caught " + ex);
                return false;
            }
            catch (SyntaxException ex) {
                if (ex.getMessages() != messages) {
                    throw new RuntimeException("confussing syntax error: " + ex);
                }
                return false;
            }
            info.setClassName(comp.getModule().classFor(comp).getName());
        }
        if (tr.minfo != null && tr.getState() < 4) {
            tr.minfo.addDependency(info);
            if (!info.loadEager(12) && info.getState() < 6) {
                tr.pushPendingImport(info, defs, forms.size());
                return true;
            }
        }
        ClassType type = info.getClassType();
        String tname = type.getName();
        boolean sharedModule = tr.sharedModuleDefs();
        boolean isRunnable = info.getState() < 6 ? info.getCompilation().makeRunnable() : type.isSubtype(Compilation.typeRunnable);
        Declaration decl = null;
        ClassType thisType = ClassType.make("kawa.standard.require");
        Expression[] args = new Expression[]{new QuoteExp((Object)tname)};
        Expression dofind = Invoke.makeInvokeStatic(thisType, "find", args);
        Field instanceField = null;
        Language language = tr.getLanguage();
        dofind.setLine(tr);
        int formsStart = forms.size();
        ModuleExp mod = info.setupModuleExp();
        Vector<Declaration> declPairs = new Vector<Declaration>();
        for (Declaration fdecl = mod.firstDecl(); fdecl != null; fdecl = fdecl.nextDecl()) {
            Declaration adecl;
            String fname;
            boolean isStatic;
            if (fdecl.isPrivate()) continue;
            Symbol aname = (Symbol)fdecl.getSymbol();
            if (renamer != null) {
                Object mapped;
                try {
                    mapped = renamer.apply1(aname);
                }
                catch (Throwable ex) {
                    mapped = ex;
                }
                if (mapped == null) continue;
                if (!(mapped instanceof Symbol)) {
                    tr.error('e', "internal error - import name mapper returned non-symbol: " + mapped.getClass().getName());
                    continue;
                }
                aname = (Symbol)mapped;
            }
            if (!(isStatic = fdecl.getFlag(2048L)) && decl == null) {
                String iname = tname.replace('.', '$') + "$instance";
                decl = new Declaration((Object)SimpleSymbol.valueOf(iname), type);
                decl.setPrivate(true);
                decl.setFlag(0x40004000L);
                defs.addDeclaration(decl);
                decl.noteValue(dofind);
                SetExp sexp = new SetExp(decl, dofind);
                sexp.setLine(tr);
                sexp.setDefining(true);
                forms.addElement(sexp);
                formsStart = forms.size();
                decl.setFlag(0x20000000L);
                if (isRunnable) {
                    decl.setSimple(false);
                }
                decl.setFlag(8192L);
            }
            if (fdecl.field != null && (fname = fdecl.field.getName()).equals("$instance")) {
                instanceField = fdecl.field;
                continue;
            }
            boolean isImportedInstance = fdecl.field != null && fdecl.field.getName().endsWith("$instance");
            Declaration old = defs.lookup(aname, language, language.getNamespaceOf(fdecl));
            if (isImportedInstance) {
                if (old != null) continue;
                adecl = defs.addDeclaration(aname);
                adecl.setFlag(0x40004000L);
                adecl.setType(fdecl.getType());
                adecl.setFlag(8192L);
            } else {
                if (old != null && !old.getFlag(512L) && Declaration.followAliases(old) == Declaration.followAliases(fdecl)) continue;
                if (old != null && old.getFlag(66048L)) {
                    old.setFlag(false, 66048L);
                    adecl = old;
                } else {
                    adecl = defs.addDeclaration(aname);
                    if (old != null) {
                        ScopeExp.duplicateDeclarationError(old, adecl, tr);
                    }
                }
                adecl.setAlias(true);
                adecl.setIndirectBinding(true);
            }
            adecl.setLocation(tr);
            ReferenceExp fref = new ReferenceExp(fdecl);
            fref.setContextDecl(decl);
            if (!isImportedInstance) {
                fref.setDontDereference(true);
                if (!sharedModule) {
                    adecl.setPrivate(true);
                }
            }
            adecl.setFlag(16384L);
            if (fdecl.getFlag(32768L)) {
                adecl.setFlag(32768L);
            }
            if (fdecl.isProcedureDecl()) {
                adecl.setProcedureDecl(true);
            }
            if (isStatic) {
                adecl.setFlag(2048L);
            }
            SetExp sexp = new SetExp(adecl, (Expression)fref);
            adecl.setFlag(0x20000000L);
            sexp.setDefining(true);
            if (isImportedInstance) {
                forms.insertElementAt(sexp, formsStart);
                ++formsStart;
            } else {
                forms.addElement(sexp);
            }
            declPairs.add(adecl);
            declPairs.add(fdecl);
            adecl.noteValue(fref);
            adecl.setFlag(131072L);
            tr.push(adecl);
        }
        int ndecls = declPairs.size();
        for (int i = 0; i < ndecls; i += 2) {
            Declaration adecl = (Declaration)declPairs.elementAt(i);
            Declaration fdecl = (Declaration)declPairs.elementAt(i + 1);
            Expression fval = fdecl.getValue();
            if (!fdecl.isIndirectBinding() || !(fval instanceof ReferenceExp)) continue;
            ReferenceExp aref = (ReferenceExp)adecl.getValue();
            Declaration xdecl = ((ReferenceExp)fval).getBinding();
            aref.setBinding(xdecl);
            if (!xdecl.needsContext()) continue;
            String iname = xdecl.field.getDeclaringClass().getName().replace('.', '$') + "$instance";
            Declaration cdecl = defs.lookup(SimpleSymbol.valueOf(iname));
            cdecl.setFlag(1024L);
            aref.setContextDecl(cdecl);
        }
        if (isRunnable) {
            Method run = Compilation.typeRunnable.getDeclaredMethod("run", 0);
            if (decl != null) {
                dofind = new ReferenceExp(decl);
            } else if (instanceField != null) {
                args = new Expression[]{new QuoteExp(type), new QuoteExp((Object)"$instance")};
                dofind = new ApplyExp(SlotGet.staticField, args);
            }
            dofind = new ApplyExp(run, new Expression[]{dofind});
            dofind.setLine(tr);
            forms.addElement(dofind);
        }
        return true;
    }

    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        return null;
    }

    static {
        require.setName("require");
        featureMap = new Hashtable();
        kawa.standard.require.map("generic-write", "gnu.kawa.slib.genwrite");
        kawa.standard.require.map("pretty-print", "gnu.kawa.slib.pp");
        kawa.standard.require.map("pprint-file", "gnu.kawa.slib.ppfile");
        kawa.standard.require.map("printf", "gnu.kawa.slib.printf");
        kawa.standard.require.map("xml", "gnu.kawa.slib.XML");
        kawa.standard.require.map("readtable", "gnu.kawa.slib.readtable");
        kawa.standard.require.map("srfi-10", "gnu.kawa.slib.readtable");
        kawa.standard.require.map("http", "gnu.kawa.servlet.HTTP");
        kawa.standard.require.map("servlets", "gnu.kawa.servlet.servlets");
        kawa.standard.require.map("srfi-1", "gnu.kawa.slib.srfi1");
        kawa.standard.require.map("list-lib", "gnu.kawa.slib.srfi1");
        kawa.standard.require.map("srfi-2", "gnu.kawa.slib.srfi2");
        kawa.standard.require.map("and-let*", "gnu.kawa.slib.srfi2");
        kawa.standard.require.map("srfi-13", "gnu.kawa.slib.srfi13");
        kawa.standard.require.map("string-lib", "gnu.kawa.slib.srfi13");
        kawa.standard.require.map("srfi-34", "gnu.kawa.slib.srfi34");
        kawa.standard.require.map("srfi-35", "gnu.kawa.slib.conditions");
        kawa.standard.require.map("condition", "gnu.kawa.slib.conditions");
        kawa.standard.require.map("conditions", "gnu.kawa.slib.conditions");
        kawa.standard.require.map("srfi-37", "gnu.kawa.slib.srfi37");
        kawa.standard.require.map("args-fold", "gnu.kawa.slib.srfi37");
        kawa.standard.require.map("srfi-64", "gnu.kawa.slib.testing");
        kawa.standard.require.map("testing", "gnu.kawa.slib.testing");
        kawa.standard.require.map("srfi-69", "gnu.kawa.slib.srfi69");
        kawa.standard.require.map("hash-table", "gnu.kawa.slib.srfi69");
        kawa.standard.require.map("basic-hash-tables", "gnu.kawa.slib.srfi69");
        kawa.standard.require.map("srfi-95", "kawa.lib.srfi95");
        kawa.standard.require.map("sorting-and-merging", "kawa.lib.srfi95");
        kawa.standard.require.map("regex", "kawa.lib.kawa.regex");
        kawa.standard.require.map("pregexp", "gnu.kawa.slib.pregexp");
        kawa.standard.require.map("gui", "gnu.kawa.slib.gui");
        kawa.standard.require.map("swing-gui", "gnu.kawa.slib.swing");
        kawa.standard.require.map("android-defs", "gnu.kawa.android.defs");
        kawa.standard.require.map("syntax-utils", "gnu.kawa.slib.syntaxutils");
    }
}

